/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyIntersector {
    private static final PolicyIntersector INSTANCE = new PolicyIntersector();
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyIntersector.class);

    private PolicyIntersector() {
    }

    public static PolicyIntersector createPolicyIntersector() {
        return INSTANCE;
    }

    public Policy intersect(Collection<Policy> policies) {
        if (policies == null || policies.isEmpty()) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0056_NEITHER_NULL_NOR_EMPTY_POLICY_COLLECTION_EXPECTED()));
        }
        if (policies.size() == 1) {
            return policies.iterator().next();
        }
        boolean found = false;
        boolean allPoliciesEmpty = true;
        for (Policy tested : policies) {
            if (tested.isEmpty()) {
                found = true;
            } else {
                if (tested.isNull()) {
                    found = true;
                }
                allPoliciesEmpty = false;
            }
            if (!found || allPoliciesEmpty) continue;
            return Policy.createNullPolicy();
        }
        if (allPoliciesEmpty) {
            return Policy.createEmptyPolicy();
        }
        Iterator<Policy> policyIterator = policies.iterator();
        LinkedList<AssertionSet> finalAlternatives = new LinkedList<AssertionSet>(policyIterator.next().getContent());
        LinkedList<AssertionSet> testedAlternatives = new LinkedList<AssertionSet>();
        ArrayList<AssertionSet> alternativesToMerge = new ArrayList<AssertionSet>(2);
        while (policyIterator.hasNext()) {
            AssertionSet testedAlternative;
            Collection<AssertionSet> currentAlternatives = policyIterator.next().getContent();
            testedAlternatives.clear();
            testedAlternatives.addAll(finalAlternatives);
            finalAlternatives.clear();
            while ((testedAlternative = (AssertionSet)testedAlternatives.poll()) != null) {
                for (AssertionSet currentAlternative : currentAlternatives) {
                    if (!testedAlternative.isCompatibleWith(currentAlternative)) continue;
                    alternativesToMerge.add(testedAlternative);
                    alternativesToMerge.add(currentAlternative);
                    finalAlternatives.add(AssertionSet.createMergedAssertionSet(alternativesToMerge));
                    alternativesToMerge.clear();
                }
            }
        }
        return Policy.createPolicy(finalAlternatives);
    }

    public Policy intersect(Policy policyA, Policy policyB) {
        return this.intersect(Arrays.asList(policyA, policyB));
    }
}

