/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverXPointer
extends ResourceResolverSpi {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$utils$resolver$implementations$ResolverXPointer == null ? (class$com$sun$org$apache$xml$internal$security$utils$resolver$implementations$ResolverXPointer = ResolverXPointer.class$("com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverXPointer")) : class$com$sun$org$apache$xml$internal$security$utils$resolver$implementations$ResolverXPointer).getName());
    private static final String XP = "#xpointer(id(";
    private static final int XP_LENGTH = "#xpointer(id(".length();
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$utils$resolver$implementations$ResolverXPointer;

    public XMLSignatureInput engineResolve(Attr attr, String string2) throws ResourceResolverException {
        Object object;
        Node node = null;
        Document document = attr.getOwnerElement().getOwnerDocument();
        String string3 = attr.getNodeValue();
        if (ResolverXPointer.isXPointerSlash(string3)) {
            node = document;
        } else if (ResolverXPointer.isXPointerId(string3) && (node = IdResolver.getElementById(document, (String)(object = ResolverXPointer.getXPointerId(string3)))) == null) {
            Object[] objectArray = new Object[]{object};
            throw new ResourceResolverException("signature.Verification.MissingID", objectArray, attr, string2);
        }
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        if (string2 != null && string2.length() > 0) {
            ((XMLSignatureInput)object).setSourceURI(string2.concat(attr.getNodeValue()));
        } else {
            ((XMLSignatureInput)object).setSourceURI(attr.getNodeValue());
        }
        return object;
    }

    public boolean engineCanResolve(Attr attr, String string2) {
        if (attr == null) {
            return false;
        }
        String string3 = attr.getNodeValue();
        return ResolverXPointer.isXPointerSlash(string3) || ResolverXPointer.isXPointerId(string3);
    }

    private static boolean isXPointerSlash(String string2) {
        return string2.equals("#xpointer(/)");
    }

    private static boolean isXPointerId(String string2) {
        if (string2.startsWith(XP) && string2.endsWith("))")) {
            String string3 = string2.substring(XP_LENGTH, string2.length() - 2);
            int n = string3.length() - 1;
            if (string3.charAt(0) == '\"' && string3.charAt(n) == '\"' || string3.charAt(0) == '\'' && string3.charAt(n) == '\'') {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Id=" + string3.substring(1, n));
                }
                return true;
            }
        }
        return false;
    }

    private static String getXPointerId(String string2) {
        if (string2.startsWith(XP) && string2.endsWith("))")) {
            String string3 = string2.substring(XP_LENGTH, string2.length() - 2);
            int n = string3.length() - 1;
            if (string3.charAt(0) == '\"' && string3.charAt(n) == '\"' || string3.charAt(0) == '\'' && string3.charAt(n) == '\'') {
                return string3.substring(1, n);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

