/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.AggregateCollectionChangeRecord;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.RelationalMapping;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.DeleteAllQuery;
import oracle.toplink.essentials.queryframework.DeleteObjectQuery;
import oracle.toplink.essentials.queryframework.InsertObjectQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.essentials.queryframework.UpdateObjectQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateCollectionMapping
extends CollectionMapping
implements RelationalMapping {
    protected transient Vector<DatabaseField> targetForeignKeyFields;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Map<DatabaseField, DatabaseField> targetForeignKeyToSourceKeys = new HashMap<DatabaseField, DatabaseField>(5);

    public AggregateCollectionMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetForeignKeyFields = NonSynchronizedVector.newInstance(1);
        this.deleteAllQuery = new DeleteAllQuery();
        this.setCascadeAll(true);
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addTargetForeignKeyFieldName(String targetForeignKey, String sourceKey) {
        this.getTargetForeignKeyFields().addElement(new DatabaseField(targetForeignKey));
        this.getSourceKeyFields().addElement(new DatabaseField(sourceKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (attributeValue == null) {
            return containerPolicy.containerInstance(1);
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object object = attributeValue;
        synchronized (object) {
            Object valuesIterator = containerPolicy.iteratorFor(attributeValue);
            while (containerPolicy.hasNext(valuesIterator)) {
                Object cloneValue = this.buildElementBackupClone(containerPolicy.next(valuesIterator, unitOfWork), unitOfWork);
                containerPolicy.addInto(cloneValue, clonedAttributeValue, unitOfWork);
            }
        }
        return clonedAttributeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (attributeValue == null) {
            return containerPolicy.containerInstance(1);
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object temporaryCollection = null;
        Object object = attributeValue;
        synchronized (object) {
            temporaryCollection = containerPolicy.cloneFor(attributeValue);
        }
        Object valuesIterator = containerPolicy.iteratorFor(temporaryCollection);
        while (containerPolicy.hasNext(valuesIterator)) {
            Object originalElement = containerPolicy.next(valuesIterator, unitOfWork);
            if (unitOfWork.isOriginalNewObject(original)) {
                unitOfWork.addNewAggregate(originalElement);
            }
            Object cloneValue = this.buildElementClone(originalElement, unitOfWork, isExisting);
            containerPolicy.addInto(cloneValue, clonedAttributeValue, unitOfWork);
        }
        return clonedAttributeValue;
    }

    protected Object buildElementBackupClone(Object element, UnitOfWorkImpl unitOfWork) {
        if (unitOfWork.isClassReadOnly(element.getClass())) {
            return element;
        }
        ClassDescriptor aggregateDescriptor = this.getReferenceDescriptor(element.getClass(), unitOfWork);
        Object clonedElement = aggregateDescriptor.getObjectBuilder().buildBackupClone(element, unitOfWork);
        return clonedElement;
    }

    @Override
    protected Object buildElementClone(Object element, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        if (unitOfWork.isClassReadOnly(element.getClass())) {
            return element;
        }
        ClassDescriptor aggregateDescriptor = this.getReferenceDescriptor(element.getClass(), unitOfWork);
        Object clonedElement = aggregateDescriptor.getObjectBuilder().instantiateWorkingCopyClone(element, unitOfWork);
        aggregateDescriptor.getObjectBuilder().populateAttributesForClone(element, clonedElement, unitOfWork, null);
        unitOfWork.getCloneToOriginals().put(clonedElement, element);
        return clonedElement;
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return;
        }
        ObjectBuilder builder = null;
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object nextObject = cp.next(cloneIter, uow);
            if (nextObject == null || visitedObjects.contains(nextObject)) continue;
            visitedObjects.put(nextObject, nextObject);
            builder = this.getReferenceDescriptor(nextObject.getClass(), uow).getObjectBuilder();
            builder.cascadeRegisterNewForCreate(nextObject, uow, visitedObjects);
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null) {
            return;
        }
        ObjectBuilder builder = null;
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object nextObject = cp.next(cloneIter, uow);
            if (nextObject == null || visitedObjects.contains(nextObject)) continue;
            visitedObjects.put(nextObject, nextObject);
            builder = this.getReferenceDescriptor(nextObject.getClass(), uow).getObjectBuilder();
            builder.cascadePerformRemove(nextObject, uow, visitedObjects);
        }
    }

    @Override
    public Object clone() {
        AggregateCollectionMapping mappingObject = (AggregateCollectionMapping)super.clone();
        mappingObject.setTargetForeignKeyToSourceKeys(new HashMap<DatabaseField, DatabaseField>(this.getTargetForeignKeyToSourceKeys()));
        return mappingObject;
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            ContainerPolicy cp = this.getContainerPolicy();
            Object backupCollection = null;
            Object cloneCollection = null;
            cloneCollection = this.getRealCollectionAttributeValueFromObject(clone, session);
            backupCollection = this.getRealCollectionAttributeValueFromObject(backUp, session);
            if (cp.sizeFor(backupCollection) != cp.sizeFor(cloneCollection)) {
                return this.convertToChangeRecord(cloneCollection, owner, session);
            }
            Object cloneIterator = cp.iteratorFor(cloneCollection);
            Object backUpIterator = cp.iteratorFor(backupCollection);
            boolean change = false;
            UnitOfWorkChangeSet uowComparisonChangeSet = new UnitOfWorkChangeSet();
            while (cp.hasNext(cloneIterator)) {
                Object cloneObject = cp.next(cloneIterator, session);
                if (cloneObject == null) {
                    change = true;
                    break;
                }
                Object backUpObject = null;
                if (!cp.hasNext(backUpIterator)) {
                    change = true;
                    break;
                }
                backUpObject = cp.next(backUpIterator, session);
                if (cloneObject.getClass().equals(backUpObject.getClass())) {
                    ObjectBuilder builder = this.getReferenceDescriptor(cloneObject.getClass(), session).getObjectBuilder();
                    ObjectChangeSet initialChanges = builder.createObjectChangeSet(cloneObject, uowComparisonChangeSet, owner.isNew(), session);
                    ObjectChangeSet changes = builder.compareForChange(cloneObject, backUpObject, uowComparisonChangeSet, session);
                    if (changes == null) continue;
                    change = true;
                    break;
                }
                change = true;
                break;
            }
            if (change || cp.hasNext(backUpIterator)) {
                return this.convertToChangeRecord(cloneCollection, owner, session);
            }
            return null;
        }
        return this.convertToChangeRecord(this.getRealCollectionAttributeValueFromObject(clone, session), owner, session);
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstCollection = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondCollection = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(firstCollection) != containerPolicy.sizeFor(secondCollection)) {
            return false;
        }
        if (containerPolicy.sizeFor(firstCollection) == 0) {
            return true;
        }
        Object iterFirst = containerPolicy.iteratorFor(firstCollection);
        block0: while (containerPolicy.hasNext(iterFirst)) {
            Object firstAggregateObject = containerPolicy.next(iterFirst, session);
            Object iterSecond = containerPolicy.iteratorFor(secondCollection);
            do {
                Object secondAggregateObject = containerPolicy.next(iterSecond, session);
                if (this.getReferenceDescriptor().getObjectBuilder().compareObjects(firstAggregateObject, secondAggregateObject, session)) continue block0;
            } while (containerPolicy.hasNext(iterSecond));
            return false;
        }
        return true;
    }

    protected ChangeRecord convertToChangeRecord(Object cloneCollection, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneIter = cp.iteratorFor(cloneCollection);
        Vector<ObjectChangeSet> collectionChanges = new Vector<ObjectChangeSet>(2);
        while (cp.hasNext(cloneIter)) {
            Object aggregateObject = cp.next(cloneIter, session);
            if (aggregateObject == null) continue;
            ObjectChangeSet changes = this.getReferenceDescriptor(aggregateObject.getClass(), session).getObjectBuilder().compareForChange(aggregateObject, null, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
            collectionChanges.addElement(changes);
        }
        AggregateCollectionChangeRecord changeRecord = new AggregateCollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setChangedValues(collectionChanges);
        return changeRecord;
    }

    protected void deleteAll(WriteObjectQuery query) throws DatabaseException {
        Object attribute;
        Vector referenceObjects = null;
        if (this.usesIndirection() && ((attribute = this.getAttributeAccessor().getAttributeValueFromObject(query.getObject())) == null || !((ValueHolderInterface)attribute).isInstantiated())) {
            referenceObjects = new Vector(0);
        }
        if (referenceObjects == null) {
            referenceObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        }
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(query.getSession().getSessionForClass(this.getReferenceClass()), query.getTranslationRow(), this.getContainerPolicy().vectorFor(referenceObjects, query.getSession()));
    }

    protected void executeEvent(int eventCode, ObjectLevelModifyQuery query) {
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor(query.getObject().getClass(), query.getSession());
        if (referenceDescriptor.getEventManager().hasAnyEventListeners()) {
            referenceDescriptor.getEventManager().executeEvent(new DescriptorEvent(eventCode, query));
        }
    }

    protected Vector extractKeyFromTargetRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getTargetForeignKeyFields().size());
        for (int index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            DatabaseField targetField = this.getTargetForeignKeyFields().elementAt(index);
            DatabaseField sourceField = this.getSourceKeyFields().elementAt(index);
            Object value = row.get(targetField);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(sourceField));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldEnum = this.getSourceKeyFields().elements();
        while (fieldEnum.hasMoreElements()) {
            DatabaseField field = fieldEnum.nextElement();
            Object value = row.get(field);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(field));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    public AbstractRecord getAggregateRow(ObjectLevelModifyQuery query, Object object) {
        Vector referenceObjectKeys = this.getReferenceObjectKeys(query);
        DatabaseRecord aggregateRow = new DatabaseRecord();
        Vector<DatabaseField> keys = this.getTargetForeignKeyFields();
        for (int keyIndex = 0; keyIndex < keys.size(); ++keyIndex) {
            ((AbstractRecord)aggregateRow).put((Object)keys.elementAt(keyIndex), referenceObjectKeys.elementAt(keyIndex));
        }
        this.getReferenceDescriptor(object.getClass(), query.getSession()).getObjectBuilder().buildRow(aggregateRow, object, query.getSession());
        return aggregateRow;
    }

    protected Expression getDeleteAllCriteria(AbstractSession session) {
        Expression criteria = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField targetForeignKey : this.getTargetForeignKeyToSourceKeys().keySet()) {
            DatabaseField sourceKey = this.getTargetForeignKeyToSourceKeys().get(targetForeignKey);
            Expression expression = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            criteria = expression.and(criteria);
        }
        return criteria;
    }

    public ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.getReferenceDescriptor().getJavaClass().equals(theClass)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor subclassDescriptor = session.getDescriptor(theClass);
        if (subclassDescriptor == null) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subclassDescriptor;
    }

    public Vector getReferenceObjectKeys(ObjectLevelModifyQuery query) throws DatabaseException, OptimisticLockException {
        Vector<Object> referenceObjectKeys = new Vector<Object>(this.getSourceKeyFields().size());
        AbstractRecord translationRow = query.getTranslationRow();
        Enumeration<DatabaseField> sourcekeys = this.getSourceKeyFields().elements();
        while (sourcekeys.hasMoreElements()) {
            DatabaseField sourceKey = sourcekeys.nextElement();
            Object referenceKey = null;
            referenceKey = translationRow != null && translationRow.containsKey(sourceKey) ? translationRow.get(sourceKey) : this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(query.getObject(), sourceKey, query.getSession());
            referenceObjectKeys.addElement(referenceKey);
        }
        return referenceObjectKeys;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Vector getTargetForeignKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetForeignKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetForeignKeyToSourceKeys() {
        return this.targetForeignKeyToSourceKeys;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (!this.getReferenceDescriptor().isAggregateCollectionDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregateCollection(this.getReferenceClass().getName(), this));
        }
        if (this.shouldInitializeSelectionCriteria()) {
            if (this.isSourceKeySpecified()) {
                this.initializeTargetForeignKeyToSourceKeys(session);
            } else {
                this.initializeTargetForeignKeyToSourceKeysWithDefaults(session);
            }
            this.initializeSelectionCriteria(session);
        }
        this.getSelectionQuery().setShouldMaintainCache(false);
        this.initializeDeleteAllQuery(session);
    }

    public void initializeChildInheritance(ClassDescriptor parentDescriptor, AbstractSession session) throws DescriptorException {
        if (parentDescriptor.getInheritancePolicy().hasChildren()) {
            Vector childDescriptors = parentDescriptor.getInheritancePolicy().getChildDescriptors();
            NonSynchronizedVector cloneChildDescriptors = NonSynchronizedVector.newInstance();
            Enumeration enumtr = childDescriptors.elements();
            while (enumtr.hasMoreElements()) {
                ClassDescriptor clonedChildDescriptor = (ClassDescriptor)((ClassDescriptor)enumtr.nextElement()).clone();
                if (!clonedChildDescriptor.isAggregateCollectionDescriptor()) {
                    session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(clonedChildDescriptor.getJavaClass().getName(), this));
                }
                clonedChildDescriptor.getInheritancePolicy().setParentDescriptor(parentDescriptor);
                clonedChildDescriptor.preInitialize(session);
                clonedChildDescriptor.initialize(session);
                ((Vector)cloneChildDescriptors).addElement(clonedChildDescriptor);
                this.initializeChildInheritance(clonedChildDescriptor, session);
            }
            parentDescriptor.getInheritancePolicy().setChildDescriptors(cloneChildDescriptors);
        }
    }

    protected void initializeDeleteAllQuery(AbstractSession session) {
        DeleteAllQuery query = (DeleteAllQuery)this.getDeleteAllQuery();
        query.setReferenceClass(this.getReferenceClass());
        query.setShouldMaintainCache(false);
        if (!this.hasCustomDeleteAllQuery()) {
            if (this.getSelectionCriteria() == null) {
                query.setSelectionCriteria(this.getDeleteAllCriteria(session));
            } else {
                query.setSelectionCriteria(this.getSelectionCriteria());
            }
        }
    }

    public void initializeParentInheritance(ClassDescriptor parentDescriptor, ClassDescriptor childDescriptor, AbstractSession session) throws DescriptorException {
        ClassDescriptor clonedParentDescriptor;
        if (!parentDescriptor.isAggregateCollectionDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregateCollection(parentDescriptor.getJavaClass().getName(), this));
        }
        if ((clonedParentDescriptor = (ClassDescriptor)parentDescriptor.clone()).getInheritancePolicy().isChildDescriptor()) {
            ClassDescriptor parentToParentDescriptor = session.getDescriptor(clonedParentDescriptor.getJavaClass());
            this.initializeParentInheritance(parentToParentDescriptor, parentDescriptor, session);
        }
        NonSynchronizedVector childern = NonSynchronizedVector.newInstance(1);
        ((Vector)childern).addElement(childDescriptor);
        clonedParentDescriptor.getInheritancePolicy().setChildDescriptors(childern);
        clonedParentDescriptor.preInitialize(session);
        clonedParentDescriptor.initialize(session);
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField targetForeignKey : this.getTargetForeignKeyToSourceKeys().keySet()) {
            DatabaseField sourceKey = this.getTargetForeignKeyToSourceKeys().get(targetForeignKey);
            Expression expression = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            Expression criteria = expression.and(this.getSelectionCriteria());
            this.setSelectionCriteria(criteria);
        }
    }

    protected void initializeTargetForeignKeyToSourceKeys(AbstractSession session) throws DescriptorException {
        if (this.getTargetForeignKeyFields().isEmpty()) {
            throw DescriptorException.noTargetForeignKeysSpecified(this);
        }
        Enumeration<DatabaseField> keys = this.getTargetForeignKeyFields().elements();
        while (keys.hasMoreElements()) {
            DatabaseField foreignKeyfield = keys.nextElement();
            this.getReferenceDescriptor().buildField(foreignKeyfield);
        }
        keys = this.getSourceKeyFields().elements();
        while (keys.hasMoreElements()) {
            DatabaseField sourceKeyfield = keys.nextElement();
            this.getDescriptor().buildField(sourceKeyfield);
        }
        if (this.getTargetForeignKeyFields().size() != this.getSourceKeyFields().size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        Enumeration<DatabaseField> targetForeignKeysEnum = this.getTargetForeignKeyFields().elements();
        Enumeration<DatabaseField> sourceKeysEnum = this.getSourceKeyFields().elements();
        while (targetForeignKeysEnum.hasMoreElements()) {
            this.getTargetForeignKeyToSourceKeys().put(targetForeignKeysEnum.nextElement(), sourceKeysEnum.nextElement());
        }
    }

    protected void initializeTargetForeignKeyToSourceKeysWithDefaults(AbstractSession session) throws DescriptorException {
        if (this.getTargetForeignKeyFields().isEmpty()) {
            throw DescriptorException.noTargetForeignKeysSpecified(this);
        }
        List<DatabaseField> sourceKeys = this.getDescriptor().getPrimaryKeyFields();
        this.setSourceKeyFields(NonSynchronizedVector.newInstance(sourceKeys));
        Enumeration<DatabaseField> keys = this.getTargetForeignKeyFields().elements();
        while (keys.hasMoreElements()) {
            DatabaseField foreignKeyfield = keys.nextElement();
            this.getReferenceDescriptor().buildField(foreignKeyfield);
        }
        if (this.getTargetForeignKeyFields().size() != sourceKeys.size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (int index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            this.getTargetForeignKeyToSourceKeys().put(this.getTargetForeignKeyFields().get(index), sourceKeys.get(index));
        }
    }

    @Override
    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        if (element != null) {
            iterator.iterateForAggregateMapping(element, this, iterator.getSession().getDescriptor(element));
        }
    }

    @Override
    public boolean isAggregateCollectionMapping() {
        return true;
    }

    @Override
    public boolean isPrivateOwned() {
        return true;
    }

    protected boolean isSourceKeySpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        if (!this.isAttributeValueInstantiated(target)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        AbstractSession session = mergeManager.getSession();
        Object valueOfTarget = null;
        Object sourceAggregate = null;
        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
            ClassDescriptor descriptor = this.getDescriptor();
            AbstractRecord parentRow = descriptor.getObjectBuilder().extractPrimaryKeyRowFromObject(target, session);
            Object result = this.getIndirectionPolicy().valueFromQuery(this.getSelectionQuery(), parentRow, session);
            this.setAttributeValueInObject(target, result);
            return;
        }
        Vector aggregateObjects = ((AggregateCollectionChangeRecord)changeRecord).getChangedValues();
        valueOfTarget = containerPolicy.containerInstance();
        ObjectChangeSet objectChanges = null;
        for (int i = 0; i < aggregateObjects.size(); ++i) {
            objectChanges = (ObjectChangeSet)aggregateObjects.elementAt(i);
            Class localClassType = objectChanges.getClassType(session);
            sourceAggregate = objectChanges.getUnitOfWorkClone();
            Object targetAggregate = ((UnitOfWorkImpl)mergeManager.getSession()).getCloneToOriginals().get(sourceAggregate);
            if (targetAggregate == null) {
                targetAggregate = this.getReferenceDescriptor(localClassType, session).getObjectBuilder().buildNewInstance();
            }
            this.getReferenceDescriptor(localClassType, session).getObjectBuilder().mergeChangesIntoObject(targetAggregate, objectChanges, sourceAggregate, mergeManager);
            containerPolicy.addInto(targetAggregate, valueOfTarget, session);
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiated(source)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        Object valueOfTarget = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
        Object sourceValuesIterator = containerPolicy.iteratorFor(valueOfSource);
        while (containerPolicy.hasNext(sourceValuesIterator)) {
            Object sourceValue = containerPolicy.next(sourceValuesIterator, mergeManager.getSession());
            Object originalValue = this.getReferenceDescriptor(sourceValue.getClass(), mergeManager.getSession()).getObjectBuilder().buildNewInstance();
            this.getReferenceDescriptor(sourceValue.getClass(), mergeManager.getSession()).getObjectBuilder().mergeIntoObject(originalValue, true, sourceValue, mergeManager);
            containerPolicy.addInto(originalValue, valueOfTarget, mergeManager.getSession());
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery query, Object objectAdded, ObjectChangeSet changeSet) throws DatabaseException, OptimisticLockException {
        InsertObjectQuery insertQuery = this.getAndPrepareModifyQueryForInsert(query, objectAdded);
        query.getSession().executeQuery((DatabaseQuery)insertQuery, insertQuery.getTranslationRow());
    }

    @Override
    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery query, Object objectDeleted) throws DatabaseException, OptimisticLockException {
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        this.prepareModifyQueryForDelete(query, deleteQuery, objectDeleted);
        query.getSession().executeQuery((DatabaseQuery)deleteQuery, deleteQuery.getTranslationRow());
    }

    @Override
    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery query, Object object, Hashtable backupCloneKeyedCache, CacheKey cachedKey) throws DatabaseException, OptimisticLockException {
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        Object backupclone = backupCloneKeyedCache.get(cachedKey);
        updateQuery.setBackupClone(backupclone);
        this.prepareModifyQueryForUpdate(query, updateQuery, object);
        query.getSession().executeQuery((DatabaseQuery)updateQuery, updateQuery.getTranslationRow());
    }

    @Override
    public void postInitialize(AbstractSession session) throws DescriptorException {
        super.postInitialize(session);
        this.getReferenceDescriptor().postInitialize(session);
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            InsertObjectQuery insertQuery = this.getAndPrepareModifyQueryForInsert(query, object);
            query.getSession().executeQuery((DatabaseQuery)insertQuery, insertQuery.getTranslationRow());
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeQuery) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.isAttributeValueInstantiated(writeQuery.getObject())) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(writeQuery.getObject(), writeQuery.getSession());
        Object currentObjectsInDB = this.readPrivateOwnedForObject(writeQuery);
        if (currentObjectsInDB == null) {
            currentObjectsInDB = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(currentObjectsInDB, objects, writeQuery);
    }

    @Override
    public void preDelete(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        if (this.getReferenceDescriptor().hasDependencyOnParts() || this.getReferenceDescriptor().usesOptimisticLocking() || this.getReferenceDescriptor().hasInheritance() && this.getReferenceDescriptor().getInheritancePolicy().shouldReadSubclasses() || this.getReferenceDescriptor().hasMultipleTables()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object iter = containerPolicy.iteratorFor(objects);
            while (containerPolicy.hasNext(iter)) {
                Object object = containerPolicy.next(iter, query.getSession());
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                this.prepareModifyQueryForDelete(query, deleteQuery, object);
                query.getSession().executeQuery((DatabaseQuery)deleteQuery, deleteQuery.getTranslationRow());
            }
            if (!query.getSession().isUnitOfWork()) {
                this.verifyDeleteForUpdate(query);
            }
        } else {
            this.deleteAll(query);
        }
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            InsertObjectQuery insertQuery = this.getAndPrepareModifyQueryForInsert(query, object);
            this.executeEvent(0, insertQuery);
            this.executeEvent(4, insertQuery);
            this.getReferenceDescriptor().getQueryManager().preInsert(insertQuery);
        }
    }

    protected InsertObjectQuery getInsertObjectQuery(AbstractSession session, ClassDescriptor desc) {
        InsertObjectQuery insertQuery = desc.getQueryManager().getInsertQuery();
        if (insertQuery == null) {
            insertQuery = new InsertObjectQuery();
            desc.getQueryManager().setInsertQuery(insertQuery);
        }
        if (insertQuery.getModifyRow() == null) {
            DatabaseRecord modifyRow = new DatabaseRecord();
            for (int i = 0; i < this.getTargetForeignKeyFields().size(); ++i) {
                DatabaseField field = this.getTargetForeignKeyFields().elementAt(i);
                modifyRow.put(field, (Object)null);
            }
            desc.getObjectBuilder().buildTemplateInsertRow(session, modifyRow);
            insertQuery.setModifyRow(modifyRow);
        }
        return insertQuery;
    }

    public InsertObjectQuery getAndPrepareModifyQueryForInsert(ObjectLevelModifyQuery originalQuery, Object object) {
        AbstractSession session = originalQuery.getSession();
        ClassDescriptor objReferenceDescriptor = this.getReferenceDescriptor(object.getClass(), session);
        InsertObjectQuery insertQueryFromDescriptor = this.getInsertObjectQuery(session, objReferenceDescriptor);
        insertQueryFromDescriptor.checkPrepare(session, insertQueryFromDescriptor.getModifyRow());
        InsertObjectQuery insertQuery = (InsertObjectQuery)insertQueryFromDescriptor.clone();
        insertQuery.setObject(object);
        DatabaseRecord targetForeignKeyRow = new DatabaseRecord();
        Vector referenceObjectKeys = this.getReferenceObjectKeys(originalQuery);
        for (int keyIndex = 0; keyIndex < this.getTargetForeignKeyFields().size(); ++keyIndex) {
            targetForeignKeyRow.put(this.getTargetForeignKeyFields().elementAt(keyIndex), referenceObjectKeys.elementAt(keyIndex));
        }
        insertQuery.setModifyRow(targetForeignKeyRow);
        insertQuery.setTranslationRow(targetForeignKeyRow);
        insertQuery.setSession(session);
        insertQuery.setCascadePolicy(originalQuery.getCascadePolicy());
        insertQuery.dontMaintainCache();
        if (session.isUnitOfWork()) {
            Object backupAttributeValue = this.getReferenceDescriptor(object.getClass(), session).getObjectBuilder().buildNewInstance();
            insertQuery.setBackupClone(backupAttributeValue);
        }
        return insertQuery;
    }

    public void prepareModifyQueryForDelete(ObjectLevelModifyQuery originalQuery, ObjectLevelModifyQuery modifyQuery, Object object) {
        AbstractRecord aggregateRow = this.getAggregateRow(originalQuery, object);
        modifyQuery.setObject(object);
        modifyQuery.setPrimaryKey(this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(aggregateRow, originalQuery.getSession()));
        modifyQuery.setModifyRow(aggregateRow);
        modifyQuery.setTranslationRow(aggregateRow);
        modifyQuery.setSession(originalQuery.getSession());
        if (originalQuery.shouldCascadeOnlyDependentParts()) {
            modifyQuery.setCascadePolicy(5);
        } else {
            modifyQuery.setCascadePolicy(originalQuery.getCascadePolicy());
        }
        modifyQuery.dontMaintainCache();
    }

    public void prepareModifyQueryForUpdate(ObjectLevelModifyQuery originalQuery, ObjectLevelModifyQuery modifyQuery, Object object) {
        AbstractRecord aggregateRow = this.getAggregateRow(originalQuery, object);
        modifyQuery.setObject(object);
        modifyQuery.setPrimaryKey(this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(aggregateRow, originalQuery.getSession()));
        modifyQuery.setTranslationRow(aggregateRow);
        modifyQuery.setSession(originalQuery.getSession());
        modifyQuery.setCascadePolicy(originalQuery.getCascadePolicy());
        modifyQuery.dontMaintainCache();
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    public void setTargetForeignKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetForeignKeyFields(fields);
    }

    public void setTargetForeignKeyFields(Vector<DatabaseField> targetForeignKeyFields) {
        this.targetForeignKeyFields = targetForeignKeyFields;
    }

    protected void setTargetForeignKeyToSourceKeys(Map<DatabaseField, DatabaseField> targetForeignKeyToSourceKeys) {
        this.targetForeignKeyToSourceKeys = targetForeignKeyToSourceKeys;
    }

    @Override
    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        return !this.isReadOnly();
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        AggregateCollectionChangeRecord collectionChangeRecord = (AggregateCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            Object cloneObject = ((UnitOfWorkChangeSet)changeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(changeSet);
            Object cloneCollection = this.getRealAttributeValueFromObject(cloneObject, session);
            collectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(cloneCollection, changeSet, session);
            changeSet.addChange(collectionChangeRecord);
        } else {
            collectionChangeRecord.getChangedValues().add(changeSetToAdd);
        }
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        AggregateCollectionChangeRecord collectionChangeRecord = (AggregateCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            Object cloneObject = ((UnitOfWorkChangeSet)changeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(changeSet);
            Object cloneCollection = this.getRealAttributeValueFromObject(cloneObject, session);
            collectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(cloneCollection, changeSet, session);
            changeSet.addChange(collectionChangeRecord);
        } else {
            collectionChangeRecord.getChangedValues().remove(changeSetToRemove);
        }
    }

    @Override
    protected Object valueFromRowInternal(AbstractRecord row, JoinedAttributeManager joinManager, AbstractSession executionSession) throws DatabaseException {
        row = (AbstractRecord)row.clone();
        int i = 0;
        Enumeration<DatabaseField> sourceKeys = this.getSourceKeyFields().elements();
        while (sourceKeys.hasMoreElements()) {
            DatabaseField sourceKey = sourceKeys.nextElement();
            Object value = null;
            int index = row.getFields().indexOf(sourceKey);
            if (index == -1) {
                value = joinManager.getBaseQuery().getTranslationRow().get(sourceKey);
                row.add(sourceKey, value);
            } else {
                value = row.getValues().elementAt(index);
            }
            row.add(this.getTargetForeignKeyFields().elementAt(i), value);
            ++i;
        }
        return super.valueFromRowInternal(row, joinManager, executionSession);
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        AbstractRecord row = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, session);
        Object value = session.executeQuery((DatabaseQuery)this.getSelectionQuery(), row);
        return this.getContainerPolicy().isEmpty(value);
    }

    protected void verifyDeleteForUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objects = this.readPrivateOwnedForObject(query);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            query.getSession().deleteObject(cp.next(iter, query.getSession()));
        }
    }

    @Override
    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "addToCollectionChangeRecord");
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isChangeTrackingSupported() {
        return false;
    }

    @Override
    public void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "removeFromCollectionChangeRecord");
    }
}

