/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.helper;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ConcurrencyException;
import oracle.toplink.essentials.internal.helper.DeferredLockManager;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.logging.AbstractSessionLog;

public class ConcurrencyManager
implements Serializable {
    protected int numberOfReaders = 0;
    protected int depth = 0;
    protected int numberOfWritersWaiting = 0;
    protected transient Thread activeThread;
    public static Hashtable deferredLockManagers;
    protected boolean lockedByMergeManager;
    protected CacheKey ownerCacheKey;

    public ConcurrencyManager() {
    }

    public ConcurrencyManager(CacheKey cacheKey) {
        this();
        this.ownerCacheKey = cacheKey;
    }

    public synchronized void acquire() throws ConcurrencyException {
        this.acquire(false);
    }

    public synchronized void acquire(boolean forMerge) throws ConcurrencyException {
        while (this.getActiveThread() != Thread.currentThread() && (this.getActiveThread() != null || this.getNumberOfReaders() != 0)) {
            try {
                this.setNumberOfWritersWaiting(this.getNumberOfWritersWaiting() + 1);
                this.wait();
                this.setNumberOfWritersWaiting(this.getNumberOfWritersWaiting() - 1);
            }
            catch (InterruptedException exception) {
                throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
            }
        }
        if (this.getActiveThread() == null) {
            this.setActiveThread(Thread.currentThread());
        }
        this.setIsLockedByMergeManager(forMerge);
        this.setDepth(this.getDepth() + 1);
    }

    public synchronized boolean acquireNoWait() throws ConcurrencyException {
        if (!this.isAcquired() || this.getActiveThread() == Thread.currentThread()) {
            this.acquire(false);
            return true;
        }
        return false;
    }

    public synchronized boolean acquireNoWait(boolean forMerge) throws ConcurrencyException {
        if (!this.isAcquired() || this.getActiveThread() == Thread.currentThread()) {
            this.acquire(forMerge);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDeferredLock() throws ConcurrencyException {
        Thread currentThread = Thread.currentThread();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        if (lockManager == null) {
            lockManager = new DeferredLockManager();
            this.putDeferredLock(currentThread, lockManager);
        }
        lockManager.incrementDepth();
        ConcurrencyManager concurrencyManager = this;
        synchronized (concurrencyManager) {
            while (this.getNumberOfReaders() != 0) {
                try {
                    this.setNumberOfWritersWaiting(this.getNumberOfWritersWaiting() + 1);
                    this.wait();
                    this.setNumberOfWritersWaiting(this.getNumberOfWritersWaiting() - 1);
                }
                catch (InterruptedException exception) {
                    throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
                }
            }
            if (this.getActiveThread() == currentThread || !this.isAcquired()) {
                lockManager.addActiveLock(this);
                this.acquire();
            } else {
                lockManager.addDeferredLock(this);
                Object[] params = new Object[]{this.getOwnerCacheKey().getObject(), currentThread.getName()};
                AbstractSessionLog.getLog().log(2, "acquiring_deferred_lock", params, true);
            }
        }
    }

    public void checkReadLock() throws ConcurrencyException {
        if (this.getActiveThread() == null) {
            return;
        }
        this.acquireReadLock();
        this.releaseReadLock();
    }

    public synchronized void acquireReadLock() throws ConcurrencyException {
        while (this.getActiveThread() != Thread.currentThread() && this.getActiveThread() != null) {
            try {
                this.wait();
            }
            catch (InterruptedException exception) {
                throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
            }
        }
        this.setNumberOfReaders(this.getNumberOfReaders() + 1);
    }

    public synchronized boolean acquireReadLockNoWait() {
        if (!this.isAcquired()) {
            this.acquireReadLock();
            return true;
        }
        return false;
    }

    public Thread getActiveThread() {
        return this.activeThread;
    }

    public static synchronized DeferredLockManager getDeferredLockManager(Thread thread) {
        return (DeferredLockManager)ConcurrencyManager.getDeferredLockManagers().get(thread);
    }

    protected static Hashtable getDeferredLockManagers() {
        if (deferredLockManagers == null) {
            deferredLockManagers = new Hashtable(50);
        }
        return deferredLockManagers;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getNumberOfReaders() {
        return this.numberOfReaders;
    }

    public int getNumberOfWritersWaiting() {
        return this.numberOfWritersWaiting;
    }

    public CacheKey getOwnerCacheKey() {
        return this.ownerCacheKey;
    }

    public boolean isAcquired() {
        return this.depth > 0;
    }

    public boolean isLockedByMergeManager() {
        return this.lockedByMergeManager;
    }

    public static synchronized boolean isBuildObjectOnThreadComplete(Thread thread, IdentityHashtable recursiveSet) {
        if (recursiveSet.containsKey(thread)) {
            return true;
        }
        recursiveSet.put(thread, thread);
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(thread);
        if (lockManager == null) {
            return true;
        }
        Vector deferredLocks = lockManager.getDeferredLocks();
        Enumeration deferredLocksEnum = deferredLocks.elements();
        while (deferredLocksEnum.hasMoreElements()) {
            ConcurrencyManager deferedLock = (ConcurrencyManager)deferredLocksEnum.nextElement();
            Thread activeThread = null;
            if (!deferedLock.isAcquired() || (activeThread = deferedLock.getActiveThread()) == null) continue;
            DeferredLockManager currentLockManager = ConcurrencyManager.getDeferredLockManager(activeThread);
            if (currentLockManager == null) {
                return false;
            }
            if (currentLockManager.isThreadComplete()) {
                activeThread = deferedLock.getActiveThread();
                if (activeThread == null || ConcurrencyManager.isBuildObjectOnThreadComplete(activeThread, recursiveSet)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isNested() {
        return this.depth > 1;
    }

    public synchronized void putDeferredLock(Thread thread, DeferredLockManager lockManager) {
        ConcurrencyManager.getDeferredLockManagers().put(thread, lockManager);
    }

    public synchronized void release() throws ConcurrencyException {
        if (this.getDepth() == 0) {
            throw ConcurrencyException.signalAttemptedBeforeWait();
        }
        this.setDepth(this.getDepth() - 1);
        if (this.getDepth() == 0) {
            this.setActiveThread(null);
            this.setIsLockedByMergeManager(false);
            this.notifyAll();
        }
    }

    public void releaseDeferredLock() throws ConcurrencyException {
        Thread currentThread = Thread.currentThread();
        DeferredLockManager lockManager = ConcurrencyManager.getDeferredLockManager(currentThread);
        if (lockManager == null) {
            return;
        }
        int depth = lockManager.getThreadDepth();
        if (depth > 1) {
            lockManager.decrementDepth();
            return;
        }
        if (!lockManager.hasDeferredLock()) {
            lockManager.releaseActiveLocksOnThread();
            ConcurrencyManager.removeDeferredLockManager(currentThread);
            return;
        }
        lockManager.setIsThreadComplete(true);
        while (true) {
            IdentityHashtable recursiveSet;
            if (ConcurrencyManager.isBuildObjectOnThreadComplete(currentThread, recursiveSet = new IdentityHashtable())) {
                lockManager.releaseActiveLocksOnThread();
                ConcurrencyManager.removeDeferredLockManager(currentThread);
                Object[] params = new Object[]{currentThread.getName()};
                AbstractSessionLog.getLog().log(2, "deferred_locks_released", params, true);
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ignoreAndContinue) {
            }
        }
    }

    public synchronized void releaseReadLock() throws ConcurrencyException {
        if (this.getNumberOfReaders() == 0) {
            throw ConcurrencyException.signalAttemptedBeforeWait();
        }
        this.setNumberOfReaders(this.getNumberOfReaders() - 1);
        if (this.getNumberOfReaders() == 0) {
            this.notifyAll();
        }
    }

    public static synchronized DeferredLockManager removeDeferredLockManager(Thread thread) {
        return (DeferredLockManager)ConcurrencyManager.getDeferredLockManagers().remove(thread);
    }

    public void setActiveThread(Thread activeThread) {
        this.activeThread = activeThread;
    }

    protected void setDepth(int depth) {
        this.depth = depth;
    }

    public void setIsLockedByMergeManager(boolean state) {
        this.lockedByMergeManager = state;
    }

    protected void setNumberOfReaders(int numberOfReaders) {
        this.numberOfReaders = numberOfReaders;
    }

    protected void setNumberOfWritersWaiting(int numberOfWritersWaiting) {
        this.numberOfWritersWaiting = numberOfWritersWaiting;
    }

    public String toString() {
        Object[] args = new Object[]{new Integer(this.getDepth())};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("nest_level", args);
    }
}

