/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.io.IOException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class VersionCommand
extends S1ASCommand {
    private static final String VERBOSE = "verbose";
    private static final String FULL_VERSION_ATTR = "applicationServerFullVersion";
    private static final String SHORT_VERSION_ATTR = "applicationServerVersion";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        String objectName = this.getObjectName();
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            String attribute = this.getBooleanOption(VERBOSE) ? FULL_VERSION_ATTR : SHORT_VERSION_ATTR;
            Object returnValue = mbsc.getAttribute(new ObjectName(objectName), attribute);
            CLILogger.getInstance().printMessage(this.getLocalizedString("Version", new Object[]{returnValue}));
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (IOException ioe) {
            this.displayVersionLocally();
        }
        catch (CommandValidationException cve) {
            this.displayVersionLocally();
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
    }

    private void displayVersionLocally() {
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("UnableToCommunicateWithAdminServer"));
        if (this.getBooleanOption(VERBOSE)) {
            CLILogger.getInstance().printMessage(this.getLocalizedString("Version", new Object[]{Version.getFullVersion()}));
        } else {
            CLILogger.getInstance().printMessage(this.getLocalizedString("Version", new Object[]{Version.getVersion()}));
        }
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
    }

    private void printDebug(MBeanServerConnection mbsc, String objectName) throws Exception {
        CLILogger.getInstance().printDebugMessage("********** getMBeanInfo **********");
        MBeanInfo mbinfo = mbsc.getMBeanInfo(new ObjectName(objectName));
        CLILogger.getInstance().printDebugMessage("Description = " + mbinfo.getDescription());
        CLILogger.getInstance().printDebugMessage("Classname = " + mbinfo.getClassName());
        MBeanOperationInfo[] mboinfo = mbinfo.getOperations();
        for (int ii = 0; ii < mboinfo.length; ++ii) {
            CLILogger.getInstance().printDebugMessage("(" + ii + ") Description = " + mboinfo[ii].getDescription());
            CLILogger.getInstance().printDebugMessage("(" + ii + ") Name = " + mboinfo[ii].getName());
            CLILogger.getInstance().printDebugMessage("****** TYPE *****");
            MBeanParameterInfo[] mbpi = mboinfo[ii].getSignature();
            for (int kk = 0; kk < mbpi.length; ++kk) {
                CLILogger.getInstance().printDebugMessage("type = " + mbpi[kk].getType());
            }
            CLILogger.getInstance().printDebugMessage("returnType = " + mboinfo[ii].getReturnType());
        }
    }

    protected String getUser() throws CommandValidationException {
        String userValue = this.getOption("user");
        if (userValue == null) {
            userValue = this.getUserFromASADMINPASS();
            if (userValue == null) {
                userValue = this.getValuesFromASADMINPREFS("user");
            }
            if (userValue != null) {
                CLILogger.getInstance().printDebugMessage("user value read from .asadminprefs");
            }
        }
        return userValue;
    }

    protected String getPassword() throws CommandValidationException, CommandException {
        return this.getPassword("password", "AdminPasswordPrompt", "AdminPasswordConfirmationPrompt", true, true, false, false, null, null, false, false, false, true);
    }
}

