/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.IIOPListenerConfig;
import com.sun.appserv.management.config.IIOPServiceConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.SystemPropertiesAccess;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.ee.admin.PortReplacedException;
import com.sun.enterprise.tools.admingui.handlers.ConfigurationHandlers;
import com.sun.enterprise.tools.admingui.handlers.NodeAgentHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.component.dataprovider.MultipleListDataProvider;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.TableRowGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.faces.model.SelectItem;
import javax.management.ObjectName;

public class StandAloneInstanceHandlers {
    public static void getStandaloneInstances(HandlerContext handlerCtx) {
        Iterator iter = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().values().iterator();
        ArrayList result = new ArrayList();
        if (iter != null) {
            while (iter.hasNext()) {
                StandaloneServerConfig server = (StandaloneServerConfig)iter.next();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = server.getName();
                String config = server.getReferencedConfigName();
                String node = server.getReferencedNodeAgentName();
                String weight = server.getLBWeight();
                String status = JMXUtil.getStatusForDisplay("com.sun.appserv:type=server,name=" + name + ",category=config");
                oneRow.put("name", name == null ? " " : name);
                oneRow.put("selected", false);
                oneRow.put("config", config == null ? " " : config);
                oneRow.put("node", node == null ? " " : node);
                oneRow.put("weight", weight == null ? " " : weight);
                oneRow.put("status", status == null ? " " : status);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getNodeAgentsForDropdown(HandlerContext handlerCtx) {
        Map nodeAgentMap = AMXUtil.getDomainConfig().getNodeAgentConfigMap();
        String[] nodeAgents = nodeAgentMap == null ? null : nodeAgentMap.keySet().toArray(new String[nodeAgentMap.size()]);
        SelectItem[] agents = ConfigurationHandlers.getOptions(nodeAgents);
        handlerCtx.setOutputValue("NodeAgents", (Object)agents);
    }

    public static void getConfigsForDropdown(HandlerContext handlerCtx) {
        Map configMap = AMXUtil.getDomainConfig().getConfigConfigMap();
        String[] values = configMap == null ? null : configMap.keySet().toArray(new String[configMap.size()]);
        ArrayList<String> newConfigs = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equals("server-config")) continue;
            newConfigs.add(values[i]);
        }
        String[] configNames = newConfigs.toArray(new String[0]);
        SelectItem[] configs = ConfigurationHandlers.getOptions(configNames);
        handlerCtx.setOutputValue("Configs", (Object)configs);
    }

    public static void createStandaloneInstance(HandlerContext handlerCtx) {
        block6: {
            String name = (String)handlerCtx.getInputValue("Name");
            String nodeAgent = (String)handlerCtx.getInputValue("NodeAgent");
            String configName = (String)handlerCtx.getInputValue("Config");
            String copyFlag = (String)handlerCtx.getInputValue("CopyConfig");
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.util.Properties"};
            boolean configCopied = false;
            try {
                if ("copy".equals(copyFlag)) {
                    configCopied = true;
                    HashMap<String, String> configMap = new HashMap<String, String>();
                    if ("default-config".equals(configName)) {
                        AMXUtil.getDomainConfig().createConfigConfig(name + "-config", configMap);
                    } else {
                        configMap.put("SrcConfigKey", configName);
                        AMXUtil.getDomainConfig().createConfigConfig(name + "-config", configMap);
                    }
                }
                if (configCopied) {
                    configName = name + "-config";
                }
                Object[] params = new Object[]{nodeAgent, name, configName, null, null};
                JMXUtil.getMBeanServer().invoke(new ObjectName("com.sun.appserv:type=servers,category=config"), "createServerInstance", params, signature);
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof PortReplacedException) break block6;
                GuiUtil.handleException(handlerCtx, ex);
            }
        }
    }

    public static void deleteStandaloneInstance(HandlerContext handlerCtx) {
        List obj;
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                AMXUtil.getDomainConfig().removeStandaloneServerConfig(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void stopSelectedInstance(HandlerContext handlerCtx) {
        List obj;
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                JMXUtil.stopServerInstance(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void startSelectedInstance(HandlerContext handlerCtx) {
        List obj;
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                JMXUtil.startServerInstance(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void startServerInstance(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        try {
            JMXUtil.startServerInstance(instanceName);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void stopServerInstance(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        try {
            JMXUtil.stopServerInstance(instanceName);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void isAdminServer(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        try {
            boolean isAdmin = false;
            if ("server".equals(instanceName)) {
                isAdmin = true;
            }
            handlerCtx.setOutputValue("isAdminServer", (Object)isAdmin);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveStandaloneInstanceWeight(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        try {
            MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
            List data = dp.getLists();
            ListIterator li = data.listIterator();
            while (li.hasNext()) {
                List inner = (List)li.next();
                ListIterator innerli = inner.listIterator();
                boolean foundError = false;
                while (innerli.hasNext()) {
                    Map instance = (Map)innerli.next();
                    String name = (String)instance.get("name");
                    String weight = (String)instance.get("weight");
                    if (weight != null && !weight.trim().equals("")) {
                        ((StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(name)).setLBWeight(weight);
                    } else {
                        foundError = true;
                    }
                    if (!foundError) {
                        GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.saveSuccessful"), null);
                        continue;
                    }
                    GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.EmptyWeight"), null);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getStandaloneInstanceGeneralAttributes(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        Boolean isAdminServer = (Boolean)handlerCtx.getInputValue("isAdminServer");
        try {
            StandaloneServerConfig server = (StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(instanceName);
            J2EEServer j2eeServer = (J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(instanceName);
            String config = server.getReferencedConfigName();
            String version = j2eeServer.getserverVersion();
            String sts = null;
            String node = null;
            if (!isAdminServer.booleanValue()) {
                node = server.getReferencedNodeAgentName();
                sts = NodeAgentHandlers.getNodeAgentStatus(node);
            }
            StandAloneInstanceHandlers.getInstanceGeneralAttributes(handlerCtx, instanceName, config, version, node, sts);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getInstanceGeneralAttributes(HandlerContext handlerCtx, String instanceName, String config, String version, String node, String sts) {
        String port;
        HTTPServiceConfig service = AMXUtil.getConfig(config).getHTTPServiceConfig();
        Map listeners = service.getHTTPListenerConfigMap();
        StringBuffer ports = new StringBuffer();
        for (String key : listeners.keySet()) {
            String port2 = ((HTTPListenerConfig)listeners.get(key)).getPort();
            if (port2.startsWith("$")) {
                port2 = StandAloneInstanceHandlers.resolveToken(port2.substring(2, port2.length() - 1), config, instanceName);
            }
            ports.append("," + port2);
        }
        ports.deleteCharAt(0);
        handlerCtx.setOutputValue("httpPorts", (Object)ports.toString());
        IIOPServiceConfig iiopService = AMXUtil.getConfig(config).getIIOPServiceConfig();
        Map iiopListeners = iiopService.getIIOPListenerConfigMap();
        StringBuffer iports = new StringBuffer();
        for (String key : iiopListeners.keySet()) {
            String iport = ((IIOPListenerConfig)iiopListeners.get(key)).getPort();
            if (iport.startsWith("$")) {
                iport = StandAloneInstanceHandlers.resolveToken(iport.substring(2, iport.length() - 1), config, instanceName);
            }
            iports.append("," + iport);
        }
        iports.deleteCharAt(0);
        handlerCtx.setOutputValue("iiopPorts", (Object)iports.toString());
        Object debugPort = JMXUtil.getAttribute("com.sun.appserv:j2eeType=J2EEServer,name=" + instanceName + ",category=runtime", "debugPort");
        String msg = GuiUtil.getMessage("inst.notEnabled");
        if (debugPort != null && !(port = debugPort.toString()).equals("0")) {
            msg = GuiUtil.getMessage("inst.debugEnabled") + debugPort.toString();
        }
        String configDir = (String)JMXUtil.invoke("com.sun.appserv:type=domain,category=config", "getConfigDir", null, null);
        handlerCtx.setOutputValue("configDir", (Object)configDir);
        handlerCtx.setOutputValue("nodeAgent", (Object)node);
        handlerCtx.setOutputValue("config", (Object)config);
        handlerCtx.setOutputValue("version", (Object)version);
        String status = JMXUtil.getStatusForDisplay("com.sun.appserv:type=server,name=" + instanceName + ",category=config");
        handlerCtx.setOutputValue("status", (Object)status);
        handlerCtx.setOutputValue("nodeAgentStatus", (Object)sts);
        handlerCtx.setOutputValue("debugPort", (Object)msg);
        RuntimeStatus rsts = JMXUtil.getRuntimeStatus(instanceName);
        int state = JMXUtil.getRuntimeStatusCode(rsts);
        handlerCtx.setOutputValue("running", (Object)(state == 0 ? 1 : 0));
    }

    private static String resolveToken(String pn, String configName, String instanceName) {
        if (AMXUtil.isEE()) {
            SystemPropertiesAccess sprops = (SystemPropertiesAccess)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(instanceName);
            if (sprops == null) {
                sprops = (SystemPropertiesAccess)AMXUtil.getDomainConfig().getClusteredServerConfigMap().get(instanceName);
            }
            if (sprops != null && sprops.existsSystemProperty(pn)) {
                return sprops.getSystemPropertyValue(pn);
            }
        }
        ConfigConfig config = AMXUtil.getConfig(configName);
        return config.getSystemPropertyValue(pn);
    }

    public static void saveStandaloneInstanceConfigProps(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        try {
            MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
            List data = dp.getLists();
            ListIterator li = data.listIterator();
            while (li.hasNext()) {
                List inner = (List)li.next();
                ListIterator innerli = inner.listIterator();
                boolean foundError = false;
                while (innerli.hasNext()) {
                    Map instance = (Map)innerli.next();
                    String name = (String)instance.get("name");
                    String override = (String)instance.get("override");
                    if (override != null && !override.trim().equals("")) {
                        ((StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(instanceName)).setSystemPropertyValue(name, override);
                    } else {
                        foundError = true;
                    }
                    if (!foundError) {
                        GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.saveSuccessful"), null);
                        continue;
                    }
                    GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.EmptyOverrideValue"), null);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveStandaloneInstanceProperties(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        StandaloneServerConfig serverConfig = (StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(instanceName);
        ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
        Map addProps = (Map)handlerCtx.getInputValue("AddProps");
        String[] remove = removeProps.toArray(new String[removeProps.size()]);
        for (int i = 0; i < remove.length; ++i) {
            serverConfig.removeProperty(remove[i]);
        }
        if (addProps != null) {
            for (Object key : addProps.keySet()) {
                String addvalue = (String)addProps.get(key);
                serverConfig.setPropertyValue((String)key, addvalue);
            }
        }
    }

    public static void getStandaloneInstanceConfigProperties(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        try {
            StandaloneServerConfig serverConfig = (StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(instanceName);
            ConfigConfig defaultConfig = (ConfigConfig)AMXUtil.getDomainConfig().getConfigConfigMap().get("default-config");
            String[] propNames = serverConfig.getSystemPropertyNames();
            ArrayList result = new ArrayList();
            for (int i = 0; i < propNames.length; ++i) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                String name = propNames[i];
                String propValue = serverConfig.getSystemPropertyValue(propNames[i]);
                String defaultValue = defaultConfig.getSystemPropertyValue(propNames[i]);
                oneRow.put("name", propNames[i]);
                oneRow.put("default", defaultValue);
                oneRow.put("override", propValue);
                result.add(oneRow);
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getStandaloneInstanceProperties(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        StandaloneServerConfig serverConfig = (StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(instanceName);
        Map props = serverConfig.getProperties();
        handlerCtx.setOutputValue("Properties", (Object)props);
    }
}

