/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.EJBContainerConfig;
import com.sun.appserv.management.config.EJBTimerServiceConfig;
import com.sun.appserv.management.config.MDBContainerConfig;
import com.sun.appserv.management.config.ManagerPropertiesConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.SessionConfig;
import com.sun.appserv.management.config.SessionManagerConfig;
import com.sun.appserv.management.config.SessionPropertiesConfig;
import com.sun.appserv.management.config.StorePropertiesConfig;
import com.sun.appserv.management.config.WebContainerConfig;
import com.sun.enterprise.tools.admingui.handlers.ConfigurationHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.faces.model.SelectItem;
import javax.management.Attribute;
import javax.management.AttributeList;

public class ContainerHandlers {
    public static void getEjbSettings(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("cName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        EJBContainerConfig ejbContainer = config.getEJBContainerConfig();
        String sessionStore = ejbContainer.getSessionStore();
        String commitOpt = ejbContainer.getCommitOption();
        String minSize = ejbContainer.getSteadyPoolSize();
        String maxSize = ejbContainer.getMaxPoolSize();
        String poolResize = ejbContainer.getPoolResizeQuantity();
        String timeout = ejbContainer.getPoolIdleTimeoutInSeconds();
        String maxCache = ejbContainer.getMaxCacheSize();
        String cacheResize = ejbContainer.getCacheResizeQuantity();
        String removalTimeout = ejbContainer.getRemovalTimeoutInSeconds();
        String removalPolicy = ejbContainer.getVictimSelectionPolicy();
        String cacheIdle = ejbContainer.getCacheIdleTimeoutInSeconds();
        Map props = ejbContainer.getProperties();
        handlerCtx.setOutputValue("SessionStore", (Object)sessionStore);
        handlerCtx.setOutputValue("CommitOption", (Object)commitOpt);
        handlerCtx.setOutputValue("MinSize", (Object)minSize);
        handlerCtx.setOutputValue("MaxSize", (Object)maxSize);
        handlerCtx.setOutputValue("PoolResize", (Object)poolResize);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
        handlerCtx.setOutputValue("MaxCache", (Object)maxCache);
        handlerCtx.setOutputValue("CacheResize", (Object)cacheResize);
        handlerCtx.setOutputValue("RemTimout", (Object)removalTimeout);
        handlerCtx.setOutputValue("RemPolicy", (Object)removalPolicy);
        handlerCtx.setOutputValue("CacheIdle", (Object)cacheIdle);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void getDefaultEjbSettings(HandlerContext handlerCtx) {
        Map attrMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-EJBContainerConfig");
        handlerCtx.setOutputValue("SessionStore", attrMap.get("session-store"));
        handlerCtx.setOutputValue("CommitOption", attrMap.get("commit-option"));
        handlerCtx.setOutputValue("MinSize", attrMap.get("steady-pool-size"));
        handlerCtx.setOutputValue("MaxSize", attrMap.get("max-pool-size"));
        handlerCtx.setOutputValue("PoolResize", attrMap.get("pool-resize-quantity"));
        handlerCtx.setOutputValue("Timeout", attrMap.get("pool-idle-timeout-in-seconds"));
        handlerCtx.setOutputValue("MaxCache", attrMap.get("max-cache-size"));
        handlerCtx.setOutputValue("CacheResize", attrMap.get("cache-resize-quantity"));
        handlerCtx.setOutputValue("RemTimout", attrMap.get("removal-timeout-in-seconds"));
        handlerCtx.setOutputValue("RemPolicy", attrMap.get("victim-selection-policy"));
        handlerCtx.setOutputValue("CacheIdle", attrMap.get("cache-idle-timeout-in-seconds"));
    }

    public static void getRemovalPolicies(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("cName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        EJBContainerConfig ejbContainer = config.getEJBContainerConfig();
        String[] policyLabels = new String[]{"Not Recently Used (nru)", "First In First Out (fifo)", "Least Recently Used (lru)"};
        String[] policyItems = new String[]{"nru", "fifo", "lru"};
        SelectItem[] options = ConfigurationHandlers.getOptions(policyItems, policyLabels);
        handlerCtx.setOutputValue("Policies", (Object)options);
    }

    public static void saveEjbSettings(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("cName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        EJBContainerConfig ejbContainer = config.getEJBContainerConfig();
        try {
            ejbContainer.setSessionStore((String)handlerCtx.getInputValue("SessionStore"));
            ejbContainer.setCommitOption((String)handlerCtx.getInputValue("CommitOption"));
            ejbContainer.setSteadyPoolSize((String)handlerCtx.getInputValue("MinSize"));
            ejbContainer.setMaxPoolSize((String)handlerCtx.getInputValue("MaxSize"));
            ejbContainer.setPoolResizeQuantity((String)handlerCtx.getInputValue("PoolResize"));
            ejbContainer.setPoolIdleTimeoutInSeconds((String)handlerCtx.getInputValue("Timeout"));
            ejbContainer.setMaxCacheSize((String)handlerCtx.getInputValue("MaxCache"));
            ejbContainer.setCacheResizeQuantity((String)handlerCtx.getInputValue("CacheResize"));
            ejbContainer.setRemovalTimeoutInSeconds((String)handlerCtx.getInputValue("RemTimout"));
            ejbContainer.setVictimSelectionPolicy((String)handlerCtx.getInputValue("RemPolicy"));
            ejbContainer.setCacheIdleTimeoutInSeconds((String)handlerCtx.getInputValue("CacheIdle"));
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)ejbContainer);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getEjbMdbSettings(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        MDBContainerConfig mdbConfig = config.getMDBContainerConfig();
        String minSize = mdbConfig.getSteadyPoolSize();
        String maxSize = mdbConfig.getMaxPoolSize();
        String poolResize = mdbConfig.getPoolResizeQuantity();
        String timeout = mdbConfig.getIdleTimeoutInSeconds();
        Map props = mdbConfig.getProperties();
        handlerCtx.setOutputValue("MinSize", (Object)minSize);
        handlerCtx.setOutputValue("MaxSize", (Object)maxSize);
        handlerCtx.setOutputValue("PoolResize", (Object)poolResize);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void getDefaultEjbMdbSettings(HandlerContext handlerCtx) {
        Map attrMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-MDBContainerConfig");
        handlerCtx.setOutputValue("MinSize", attrMap.get("steady-pool-size"));
        handlerCtx.setOutputValue("MaxSize", attrMap.get("max-pool-size"));
        handlerCtx.setOutputValue("PoolResize", attrMap.get("pool-resize-quantity"));
        handlerCtx.setOutputValue("Timeout", attrMap.get("idle-timeout-in-seconds"));
    }

    public static void saveEjbMdbSettings(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        try {
            MDBContainerConfig mdbConfig = config.getMDBContainerConfig();
            mdbConfig.setSteadyPoolSize((String)handlerCtx.getInputValue("MinSize"));
            mdbConfig.setMaxPoolSize((String)handlerCtx.getInputValue("MaxSize"));
            mdbConfig.setPoolResizeQuantity((String)handlerCtx.getInputValue("PoolResize"));
            mdbConfig.setIdleTimeoutInSeconds((String)handlerCtx.getInputValue("Timeout"));
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)mdbConfig);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getEjbTimerSettings(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        EJBTimerServiceConfig ejbTimerSrv = config.getEJBContainerConfig().getEJBTimerServiceConfig();
        String minDelivery = ejbTimerSrv.getMinimumDeliveryIntervalInMillis();
        String maxRedelivery = ejbTimerSrv.getMaxRedeliveries();
        String redeliveryIntr = ejbTimerSrv.getRedeliveryIntervalInternalInMillis();
        String timerDatasource = ejbTimerSrv.getTimerDatasource();
        handlerCtx.setOutputValue("MinDelivery", (Object)minDelivery);
        handlerCtx.setOutputValue("MaxRedelivery", (Object)maxRedelivery);
        handlerCtx.setOutputValue("RedeliveryIntr", (Object)redeliveryIntr);
        handlerCtx.setOutputValue("TimerDatasource", (Object)timerDatasource);
    }

    public static void getDefaultEjbTimerServiceValues(HandlerContext handlerCtx) {
        Map attrMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-EJBTimerServiceConfig");
        handlerCtx.setOutputValue("MinDelivery", attrMap.get("minimum-delivery-interval-in-millis"));
        handlerCtx.setOutputValue("MaxRedelivery", attrMap.get("max-redeliveries"));
        handlerCtx.setOutputValue("RedeliveryIntr", attrMap.get("redelivery-interval-internal-in-millis"));
        handlerCtx.setOutputValue("TimerDatasource", attrMap.get("timer-datasource"));
    }

    public static void saveEjbTimerServiceValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        try {
            EJBTimerServiceConfig ejbTimerSrv = config.getEJBContainerConfig().getEJBTimerServiceConfig();
            ejbTimerSrv.setMinimumDeliveryIntervalInMillis((String)handlerCtx.getInputValue("MinDelivery"));
            ejbTimerSrv.setMaxRedeliveries((String)handlerCtx.getInputValue("MaxRedelivery"));
            ejbTimerSrv.setRedeliveryIntervalInternalInMillis((String)handlerCtx.getInputValue("RedeliveryIntr"));
            ejbTimerSrv.setTimerDatasource((String)handlerCtx.getInputValue("TimerDatasource"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getWebContainerGeneralProps(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        WebContainerConfig webConfig = config.getWebContainerConfig();
        Map props = webConfig.getProperties();
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void getWebSessionProps(HandlerContext handlerCtx) {
        SessionPropertiesConfig ssPropConfig;
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        SessionConfig sessionConfig = config.getWebContainerConfig().getSessionConfig();
        Map props = new HashMap();
        if (sessionConfig != null && (ssPropConfig = sessionConfig.getSessionPropertiesConfig()) != null) {
            String sessTimeout = ssPropConfig.getTimeoutInSeconds();
            handlerCtx.setOutputValue("SessionTimeout", (Object)sessTimeout);
            props = ssPropConfig.getProperties();
        }
        handlerCtx.setOutputValue("Properties", props);
    }

    public static void saveWebContainerGeneralProps(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        WebContainerConfig webConfig = config.getWebContainerConfig();
        AMXUtil.editProperties(handlerCtx, (PropertiesAccess)webConfig);
    }

    public static void saveWebSessionValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        SessionConfig sessionConfig = config.getWebContainerConfig().getSessionConfig();
        try {
            String sessTimeout = (String)handlerCtx.getInputValue("SessionTimeout");
            if (sessionConfig != null && sessionConfig.getSessionPropertiesConfig() != null) {
                sessionConfig.getSessionPropertiesConfig().setTimeoutInSeconds(sessTimeout);
            } else {
                String objName = "com.sun.appserv:type=configs,category=config";
                String opername = "createSessionProperties";
                String[] signature = new String[]{"javax.management.AttributeList", "java.util.Properties", "java.lang.String"};
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("timeout-in-seconds", sessTimeout));
                Properties props = new Properties();
                Object[] params = new Object[]{attrList, props, configName};
                JMXUtil.invoke(objName, opername, params, signature);
                sessionConfig = config.getWebContainerConfig().getSessionConfig();
            }
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)sessionConfig.getSessionPropertiesConfig());
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getWebManagerProps(HandlerContext handlerCtx) {
        ManagerPropertiesConfig mgrPropConfig;
        SessionManagerConfig sessMgrConfig;
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        SessionConfig sessionConfig = config.getWebContainerConfig().getSessionConfig();
        Map props = new HashMap();
        if (sessionConfig != null && (sessMgrConfig = sessionConfig.getSessionManagerConfig()) != null && (mgrPropConfig = sessMgrConfig.getManagerPropertiesConfig()) != null) {
            String reapInterval = mgrPropConfig.getReapIntervalInSeconds();
            String maxSessions = mgrPropConfig.getMaxSessions();
            String sessFileName = mgrPropConfig.getSessionFileName();
            String sessionIdGen = mgrPropConfig.getSessionIdGeneratorClassname();
            props = mgrPropConfig.getProperties();
            handlerCtx.setOutputValue("ReapInterval", (Object)reapInterval);
            handlerCtx.setOutputValue("MaxSessions", (Object)maxSessions);
            handlerCtx.setOutputValue("SessFileName", (Object)sessFileName);
            handlerCtx.setOutputValue("SessionIdGen", (Object)sessionIdGen);
        }
        handlerCtx.setOutputValue("Properties", props);
    }

    public static void saveWebManagerProps(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        SessionConfig sessionConfig = config.getWebContainerConfig().getSessionConfig();
        try {
            String reapInterval = (String)handlerCtx.getInputValue("ReapInterval");
            String maxSessions = (String)handlerCtx.getInputValue("MaxSessions");
            String sessFileName = (String)handlerCtx.getInputValue("SessFileName");
            String sessionIdgen = (String)handlerCtx.getInputValue("SessionIdGen");
            if (sessionConfig != null && sessionConfig.getSessionManagerConfig() != null && sessionConfig.getSessionManagerConfig().getManagerPropertiesConfig() != null) {
                ManagerPropertiesConfig mgrPropConfig = sessionConfig.getSessionManagerConfig().getManagerPropertiesConfig();
                mgrPropConfig.setReapIntervalInSeconds(reapInterval);
                mgrPropConfig.setMaxSessions(maxSessions);
                mgrPropConfig.setSessionFileName(sessFileName);
                mgrPropConfig.setSessionIdGeneratorClassname(sessionIdgen);
                AMXUtil.editProperties(handlerCtx, (PropertiesAccess)mgrPropConfig);
            } else {
                String objName = "com.sun.appserv:type=configs,category=config";
                String opername = "createManagerProperties";
                String[] signature = new String[]{"javax.management.AttributeList", "java.util.Properties", "java.lang.String"};
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("reap-interval-in-seconds", reapInterval));
                attrList.add(new Attribute("max-sessions", maxSessions));
                attrList.add(new Attribute("session-file-name", sessFileName));
                attrList.add(new Attribute("session-id-generator-classname", sessionIdgen));
                Properties props = new Properties();
                Object[] params = new Object[]{attrList, props, configName};
                JMXUtil.invoke(objName, opername, params, signature);
                sessionConfig = config.getWebContainerConfig().getSessionConfig();
                ManagerPropertiesConfig mgrPropConfig = sessionConfig.getSessionManagerConfig().getManagerPropertiesConfig();
                AMXUtil.editProperties(handlerCtx, (PropertiesAccess)mgrPropConfig);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getWebStoreProps(HandlerContext handlerCtx) {
        StorePropertiesConfig storePropConfig;
        SessionManagerConfig sessMgrConfig;
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        SessionConfig sessionConfig = config.getWebContainerConfig().getSessionConfig();
        Map props = new HashMap();
        if (sessionConfig != null && (sessMgrConfig = sessionConfig.getSessionManagerConfig()) != null && (storePropConfig = sessMgrConfig.getStorePropertiesConfig()) != null) {
            String reapInterval = storePropConfig.getReapIntervalInSeconds();
            String directory = storePropConfig.getDirectory();
            props = storePropConfig.getProperties();
            handlerCtx.setOutputValue("ReapInterval", (Object)reapInterval);
            handlerCtx.setOutputValue("Directory", (Object)directory);
        }
        handlerCtx.setOutputValue("Properties", props);
    }

    public static void saveWebStoreProps(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        SessionConfig sessionConfig = config.getWebContainerConfig().getSessionConfig();
        try {
            String reapInterval = (String)handlerCtx.getInputValue("ReapInterval");
            String directory = (String)handlerCtx.getInputValue("Directory");
            if (sessionConfig != null && sessionConfig.getSessionManagerConfig() != null && sessionConfig.getSessionManagerConfig().getStorePropertiesConfig() != null) {
                StorePropertiesConfig storePropConfig = sessionConfig.getSessionManagerConfig().getStorePropertiesConfig();
                storePropConfig.setReapIntervalInSeconds(reapInterval);
                storePropConfig.setDirectory(directory);
                AMXUtil.editProperties(handlerCtx, (PropertiesAccess)storePropConfig);
            } else {
                String objName = "com.sun.appserv:type=configs,category=config";
                String opername = "createStoreProperties";
                String[] signature = new String[]{"javax.management.AttributeList", "java.util.Properties", "java.lang.String"};
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("reap-interval-in-seconds", reapInterval));
                attrList.add(new Attribute("directory", directory));
                Properties props = new Properties();
                Object[] params = new Object[]{attrList, props, configName};
                JMXUtil.invoke(objName, opername, params, signature);
                sessionConfig = config.getWebContainerConfig().getSessionConfig();
                StorePropertiesConfig storePropConfig = sessionConfig.getSessionManagerConfig().getStorePropertiesConfig();
                AMXUtil.editProperties(handlerCtx, (PropertiesAccess)storePropConfig);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }
}

