/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.j2ee.J2EECluster;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.ee.admin.PortReplacedException;
import com.sun.enterprise.tools.admingui.handlers.NodeAgentHandlers;
import com.sun.enterprise.tools.admingui.handlers.StandAloneInstanceHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.component.dataprovider.MultipleListDataProvider;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.TableRowGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.management.ObjectName;

public class ClusterHandlers {
    public static void createCluster(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("Name");
        String configName = (String)handlerCtx.getInputValue("Config");
        String copyFlag = (String)handlerCtx.getInputValue("CopyConfig");
        List instances = (List)handlerCtx.getInputValue("Instances");
        boolean clusterCreated = false;
        boolean configCreated = false;
        try {
            if (AMXUtil.getConfig(clusterName + "-config") != null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.cluster.creationError", new Object[]{clusterName}));
                return;
            }
            if (instances == null || instances.isEmpty()) {
                ClusterHandlers.createClusterConfig(copyFlag, configName, clusterName);
                clusterCreated = true;
            } else {
                ListIterator li = instances.listIterator();
                while (li.hasNext()) {
                    Map server = (Map)li.next();
                    String instanceName = (String)server.get("name");
                    String nodeAgent = (String)server.get("node");
                    String weight = (String)server.get("weight");
                    if (instanceName != null && !instanceName.trim().equals("")) {
                        if (nodeAgent != null && !nodeAgent.trim().equals("")) {
                            if (!clusterCreated) {
                                ClusterHandlers.createClusterConfig(copyFlag, configName, clusterName);
                                clusterCreated = true;
                            }
                            ClusterHandlers.createInstance(nodeAgent, instanceName, clusterName);
                        } else {
                            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.requiredMsgNodeAgent"));
                        }
                        if (weight == null || weight.trim().equals("")) continue;
                        ((ClusteredServerConfig)AMXUtil.getDomainConfig().getClusteredServerConfigMap().get(instanceName)).setLBWeight(weight);
                        continue;
                    }
                    if (clusterCreated) continue;
                    ClusterHandlers.createClusterConfig(copyFlag, configName, clusterName);
                    clusterCreated = true;
                }
            }
        }
        catch (Exception ex) {
            if (clusterCreated) {
                GuiUtil.prepareException(handlerCtx, ex);
            }
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void createClusterConfig(String copyFlag, String configName, String clusterName) {
        boolean configCopied = false;
        if ("copy".equals(copyFlag)) {
            configCopied = true;
            HashMap<String, String> configMap = new HashMap<String, String>();
            if ("default-config".equals(configName)) {
                AMXUtil.getDomainConfig().createConfigConfig(clusterName + "-config", configMap);
            } else {
                configMap.put("SrcConfigKey", configName);
                AMXUtil.getDomainConfig().createConfigConfig(clusterName + "-config", configMap);
            }
            configName = clusterName + "-config";
        }
        AMXUtil.getDomainConfig().createClusterConfig(clusterName, configName, new HashMap());
    }

    public static void createClusterInstance(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        String clusterName = (String)handlerCtx.getInputValue("ClusterName");
        String nodeAgent = (String)handlerCtx.getInputValue("NodeAgent");
        try {
            ClusterHandlers.createInstance(nodeAgent, instanceName, clusterName);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void createInstance(String nodeAgent, String instanceName, String clusterName) {
        block2: {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.util.Properties"};
            Object[] params = new Object[]{nodeAgent, instanceName, null, clusterName, null};
            try {
                JMXUtil.getMBeanServer().invoke(new ObjectName("com.sun.appserv:type=servers,category=config"), "createServerInstance", params, signature);
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof PortReplacedException) break block2;
                throw new RuntimeException(ex);
            }
        }
    }

    public static void getClusterTableList(HandlerContext handlerCtx) {
        ArrayList data = new ArrayList();
        Map props = (Map)handlerCtx.getInputValue("Properties");
        if (props != null) {
            for (String key : props.keySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                Object value = props.get(key);
                String valString = value == null ? "" : value.toString();
                oneRow.put("name", key);
                oneRow.put("weight", " ");
                oneRow.put("node", " ");
                oneRow.put("selected", false);
                data.add(oneRow);
            }
        }
        ArrayList list = new ArrayList();
        list.add(data);
        handlerCtx.setOutputValue("TableList", list);
    }

    public static void getClustersforTable(HandlerContext handlerCtx) {
        ArrayList result = new ArrayList();
        try {
            Map clusterMap = AMXUtil.getDomainConfig().getClusterConfigMap();
            for (String key : clusterMap.keySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = ((ClusterConfig)clusterMap.get(key)).getName();
                String config = ((ClusterConfig)clusterMap.get(key)).getReferencedConfigName();
                Map cservers = ((ClusterConfig)clusterMap.get(key)).getClusteredServerConfigMap();
                oneRow.put("name", name == null ? " " : name);
                oneRow.put("config", config == null ? " " : config);
                oneRow.put("selected", false);
                result.add(oneRow);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("hasCluster", (Object)(result.size() > 0 ? 1 : 0));
    }

    public static void getClusteredInstances(HandlerContext handlerCtx) {
        String cluster = (String)handlerCtx.getInputValue("ClusterName");
        ArrayList result = new ArrayList();
        try {
            Map serverMap;
            if (cluster != null && (serverMap = ((ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(cluster)).getClusteredServerConfigMap()) != null) {
                for (String key : serverMap.keySet()) {
                    HashMap<String, String> oneRow = new HashMap<String, String>();
                    String name = ((ClusteredServerConfig)serverMap.get(key)).getName();
                    oneRow.put("name", name);
                    oneRow.put("image", AMXUtil.getStatusForDisplay((AMX)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(name), true));
                    result.add(oneRow);
                }
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getClusteredInstancesStatus(HandlerContext handlerCtx) {
        List instances = (List)handlerCtx.getInputValue("Instances");
        int stoppedCount = 0;
        int failedCount = 0;
        int stoppingCount = 0;
        int startingCount = 0;
        int runningCount = 0;
        int restartCount = 0;
        if (instances != null) {
            List instanceMap = instances;
            for (Map oneRow : instanceMap) {
                String name = (String)oneRow.get("name");
                RuntimeStatus rsts = JMXUtil.getRuntimeStatus(name);
                int statusCode = JMXUtil.getRuntimeStatusCode(rsts);
                switch (statusCode) {
                    case 0: {
                        boolean restart = rsts.isRestartNeeded();
                        if (restart) {
                            ++restartCount;
                            break;
                        }
                        ++runningCount;
                        break;
                    }
                    case 8: {
                        ++failedCount;
                        break;
                    }
                    case 1: {
                        ++startingCount;
                        break;
                    }
                    case 3: {
                        ++stoppedCount;
                        break;
                    }
                    case 2: {
                        ++stoppingCount;
                    }
                }
            }
        }
        handlerCtx.setOutputValue("Stopped", (Object)(stoppedCount == 0 ? " " : AMXUtil.getStatusImage(3) + "&nbsp;" + stoppedCount + "&nbsp;" + GuiUtil.getMessage("common.stoppedState") + "<br>"));
        handlerCtx.setOutputValue("Stopping", (Object)(stoppingCount == 0 ? " " : AMXUtil.getStatusImage(2) + "&nbsp;" + stoppingCount + "&nbsp;" + GuiUtil.getMessage("common.stoppingState") + "<br>"));
        handlerCtx.setOutputValue("Starting", (Object)(startingCount == 0 ? " " : AMXUtil.getStatusImage(0) + "&nbsp;" + startingCount + "&nbsp;" + GuiUtil.getMessage("common.startingState") + "<br>"));
        handlerCtx.setOutputValue("Failed", (Object)(failedCount == 0 ? " " : AMXUtil.getStatusImage(4) + "&nbsp;" + failedCount + "&nbsp;" + GuiUtil.getMessage("common.failedState")));
        handlerCtx.setOutputValue("Running", (Object)(runningCount == 0 ? " " : AMXUtil.getStatusImage(1) + "&nbsp;" + runningCount + "&nbsp;" + GuiUtil.getMessage("common.runningState") + "<br>"));
        handlerCtx.setOutputValue("Restart", (Object)(restartCount == 0 ? " " : GuiUtil.getMessage("common.restartRequiredImage") + "&nbsp;" + restartCount + "&nbsp;" + GuiUtil.getMessage("common.restartState") + "<br>"));
    }

    public static void clusterAction(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        Boolean start = (Boolean)handlerCtx.getInputValue("start");
        try {
            JMXUtil.clusterAction(clusterName, start);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void selectedClustersAction(HandlerContext handlerCtx) {
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        Boolean start = (Boolean)handlerCtx.getInputValue("start");
        List selectedRows = obj;
        try {
            for (Map oneRow : selectedRows) {
                String clusterName = (String)oneRow.get("name");
                JMXUtil.clusterAction(clusterName, start);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void clusterInstanceAction(HandlerContext handlerCtx) {
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        Boolean start = (Boolean)handlerCtx.getInputValue("start");
        try {
            Map instancesMap = ((ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(clusterName)).getClusteredServerConfigMap();
            if (instancesMap.size() == obj.size()) {
                JMXUtil.clusterAction(clusterName, start);
                return;
            }
            List selectedRows = obj;
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                if (start.booleanValue()) {
                    JMXUtil.startServerInstance(name);
                    continue;
                }
                JMXUtil.stopServerInstance(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deleteSelectedClusters(HandlerContext handlerCtx) {
        List obj;
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                Map serverMap;
                String name = (String)oneRow.get("name");
                boolean running = true;
                J2EECluster j2eeCluster = (J2EECluster)AMXUtil.getJ2EEDomain().getJ2EEClusterMap().get(name);
                if (j2eeCluster.getstate() == 1) {
                    j2eeCluster.stop();
                }
                if ((serverMap = ((ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(name)).getClusteredServerConfigMap()) != null) {
                    for (String key : serverMap.keySet()) {
                        HashMap server = new HashMap();
                        String serverName = ((ClusteredServerConfig)serverMap.get(key)).getName();
                        JMXUtil.invoke("com.sun.appserv:type=servers,category=config", "deleteServerInstance", new Object[]{serverName}, new String[]{"java.lang.String"});
                    }
                }
                AMXUtil.getDomainConfig().removeClusterConfig(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deleteSelectedInstances(HandlerContext handlerCtx) {
        List obj;
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                boolean running = true;
                J2EEServer j2eeServer = (J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(name);
                if (j2eeServer.getstate() == 1) {
                    j2eeServer.stop();
                }
                AMXUtil.getDomainConfig().removeClusteredServerConfig(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getClusterGeneralAttributes(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("ClusterName");
        try {
            ClusterConfig cluster = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(clusterName);
            String address = cluster.getHeartbeatAddress();
            String port = cluster.getHeartbeatPort();
            boolean hbenabled = cluster.getHeartbeatEnabled();
            String config = cluster.getReferencedConfigName();
            handlerCtx.setOutputValue("HbAddress", (Object)address);
            handlerCtx.setOutputValue("HbPort", (Object)port);
            handlerCtx.setOutputValue("HbEnabled", (Object)hbenabled);
            handlerCtx.setOutputValue("Config", (Object)config);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveClusterGeneralAttributes(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        try {
            ClusterConfig cluster = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(clusterName);
            cluster.setHeartbeatEnabled(((Boolean)handlerCtx.getInputValue("HbEnabled")).booleanValue());
            cluster.setHeartbeatPort((String)handlerCtx.getInputValue("HbPort"));
            cluster.setHeartbeatAddress((String)handlerCtx.getInputValue("HbAddress"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getClusteredInstancesStatusCount(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("ClusterName");
        int stopped = 0;
        int running = 0;
        Map serverMap = ((ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(clusterName)).getClusteredServerConfigMap();
        if (serverMap != null) {
            for (String key : serverMap.keySet()) {
                String serverName = ((ClusteredServerConfig)serverMap.get(key)).getName();
                RuntimeStatus rsts = JMXUtil.getRuntimeStatus(serverName);
                int statusCode = JMXUtil.getRuntimeStatusCode(rsts);
                if (statusCode == 2 || statusCode == 3 || statusCode == 8) {
                    ++stopped;
                }
                if (statusCode != 0 && statusCode != 1) continue;
                ++running;
            }
        }
        handlerCtx.setOutputValue("NumStopped", (Object)(stopped + " " + GuiUtil.getMessage("cluster.numStopped")));
        handlerCtx.setOutputValue("NumRunning", (Object)(running + " " + GuiUtil.getMessage("cluster.numRunning")));
        handlerCtx.setOutputValue("disableEjb", (Object)(stopped <= 0 ? 1 : 0));
        handlerCtx.setOutputValue("disableStart", (Object)(stopped <= 0 ? 1 : 0));
        handlerCtx.setOutputValue("disableStop", (Object)(running <= 0 ? 1 : 0));
    }

    public static void getListOfClusteredInstances(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("ClusterName");
        try {
            Map lbMap;
            ClusterConfig clusterConfig = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(clusterName);
            Map serverMap = ((ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(clusterName)).getClusteredServerConfigMap();
            ArrayList result = new ArrayList();
            if (serverMap != null) {
                for (String key : serverMap.keySet()) {
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    String serverName = key;
                    String config = ((ClusteredServerConfig)serverMap.get(key)).getReferencedConfigName();
                    String node = ((ClusteredServerConfig)serverMap.get(key)).getReferencedNodeAgentName();
                    String weight = ((ClusteredServerConfig)serverMap.get(key)).getLBWeight();
                    String state = AMXUtil.getStatusForDisplay((AMX)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(serverName), true);
                    oneRow.put("name", serverName);
                    oneRow.put("selected", false);
                    oneRow.put("config", config == null ? " " : config);
                    oneRow.put("node", node == null ? " " : node);
                    oneRow.put("weight", weight == null ? " " : weight);
                    oneRow.put("status", state == null ? " " : state);
                    ServerRefConfig serverRef = (ServerRefConfig)clusterConfig.getServerRefConfigMap().get(key);
                    int timeout = serverRef.getDisableTimeoutInMinutes();
                    oneRow.put("timeout", "" + timeout);
                    oneRow.put("lbStatus", "" + serverRef.getLBEnabled());
                    result.add(oneRow);
                }
            }
            handlerCtx.setOutputValue("hasLB", (Object)(!(lbMap = AMXUtil.getLBConfigHelper().getLoadBalancers(clusterName, true)).isEmpty() ? 1 : 0));
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveClusteredInstanceWeight(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        try {
            MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
            List data = dp.getLists();
            ListIterator li = data.listIterator();
            while (li.hasNext()) {
                List inner = (List)li.next();
                ListIterator innerli = inner.listIterator();
                boolean foundError = false;
                while (innerli.hasNext()) {
                    Map instance = (Map)innerli.next();
                    String name = (String)instance.get("name");
                    String weight = (String)instance.get("weight");
                    if (weight != null && !weight.trim().equals("")) {
                        ((ClusteredServerConfig)AMXUtil.getDomainConfig().getClusteredServerConfigMap().get(name)).setLBWeight(weight);
                    } else {
                        foundError = true;
                    }
                    if (!foundError) {
                        GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.saveSuccessful"), null);
                        continue;
                    }
                    GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.EmptyWeight"), null);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveServerRefDisableTimeout(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        ClusterConfig clusterConfig = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(clusterName);
        try {
            MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
            List data = dp.getLists();
            Iterator i$ = data.iterator();
            while (i$.hasNext()) {
                List inner;
                List innerMap = inner = (List)i$.next();
                for (Map oneRow : innerMap) {
                    String serverName = (String)oneRow.get("name");
                    ServerRefConfig ref = (ServerRefConfig)clusterConfig.getServerRefConfigMap().get(serverName);
                    String timeout = (String)oneRow.get("timeout");
                    if (GuiUtil.isEmpty(timeout)) {
                        timeout = ref.getDefaultValue("DisableTimeoutInMinutes");
                    }
                    ref.setDisableTimeoutInMinutes(Integer.parseInt(timeout));
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void changeServerRefLB(HandlerContext handlerCtx) {
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        ClusterConfig clusterConfig = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(clusterName);
        try {
            for (Map oneRow : selectedRows) {
                String serverName = (String)oneRow.get("name");
                ServerRefConfig ref = (ServerRefConfig)clusterConfig.getServerRefConfigMap().get(serverName);
                ref.setLBEnabled(enabled);
            }
        }
        catch (Exception ex) {
            GuiUtil.prepareException(handlerCtx, ex);
        }
    }

    public static void getClusterInstanceGeneralAttributes(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        try {
            ClusteredServerConfig server = (ClusteredServerConfig)AMXUtil.getDomainConfig().getClusteredServerConfigMap().get(instanceName);
            J2EEServer j2eeServer = (J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(instanceName);
            String config = server.getReferencedConfigName();
            String version = j2eeServer.getserverVersion();
            String node = null;
            node = server.getReferencedNodeAgentName();
            String sts = NodeAgentHandlers.getNodeAgentStatus(node);
            StandAloneInstanceHandlers.getInstanceGeneralAttributes(handlerCtx, instanceName, config, version, node, sts);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getClusterInstanceConfigProperties(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        try {
            ClusteredServerConfig serverConfig = (ClusteredServerConfig)AMXUtil.getDomainConfig().getClusteredServerConfigMap().get(instanceName);
            ConfigConfig defaultConfig = (ConfigConfig)AMXUtil.getDomainConfig().getConfigConfigMap().get("default-config");
            String[] propNames = serverConfig.getSystemPropertyNames();
            ArrayList result = new ArrayList();
            for (int i = 0; i < propNames.length; ++i) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                String name = propNames[i];
                String propValue = serverConfig.getSystemPropertyValue(propNames[i]);
                String defaultValue = defaultConfig.getSystemPropertyValue(propNames[i]);
                oneRow.put("name", propNames[i]);
                oneRow.put("default", defaultValue);
                oneRow.put("override", propValue);
                result.add(oneRow);
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getClusterInstanceProperties(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        ClusteredServerConfig serverConfig = (ClusteredServerConfig)AMXUtil.getDomainConfig().getClusteredServerConfigMap().get(instanceName);
        Map props = serverConfig.getProperties();
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void saveClusterInstanceProperties(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        ClusteredServerConfig serverConfig = (ClusteredServerConfig)AMXUtil.getDomainConfig().getClusteredServerConfigMap().get(instanceName);
        ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
        Map addProps = (Map)handlerCtx.getInputValue("AddProps");
        String[] remove = removeProps.toArray(new String[removeProps.size()]);
        for (int i = 0; i < remove.length; ++i) {
            serverConfig.removeProperty(remove[i]);
        }
        if (addProps != null) {
            for (Object key : addProps.keySet()) {
                String addvalue = (String)addProps.get(key);
                serverConfig.setPropertyValue((String)key, addvalue);
            }
        }
    }

    public static void saveClusteredInstanceConfigProps(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        try {
            MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
            List data = dp.getLists();
            ListIterator li = data.listIterator();
            while (li.hasNext()) {
                List inner = (List)li.next();
                ListIterator innerli = inner.listIterator();
                boolean foundError = false;
                while (innerli.hasNext()) {
                    Map instance = (Map)innerli.next();
                    String name = (String)instance.get("name");
                    String override = (String)instance.get("override");
                    if (override != null && !override.trim().equals("")) {
                        ((ClusteredServerConfig)AMXUtil.getDomainConfig().getClusteredServerConfigMap().get(instanceName)).setSystemPropertyValue(name, override);
                    } else {
                        foundError = true;
                    }
                    if (!foundError) {
                        GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.saveSuccessful"), null);
                        continue;
                    }
                    GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.EmptyOverrideValue"), null);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getInstancesOfCluster(HandlerContext handlerCtx) {
        String cluster = (String)handlerCtx.getInputValue("clusterName");
        Boolean state = (Boolean)handlerCtx.getInputValue("state");
        Boolean addEmpty = (Boolean)handlerCtx.getInputValue("addEmpty");
        ArrayList<String> result = new ArrayList<String>();
        try {
            Map serverMap = ((ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(cluster)).getClusteredServerConfigMap();
            for (String key : serverMap.keySet()) {
                String name = ((ClusteredServerConfig)serverMap.get(key)).getName();
                RuntimeStatus rsts = JMXUtil.getRuntimeStatus(name);
                int statusCode = JMXUtil.getRuntimeStatusCode(rsts);
                if (state == null) {
                    result.add(name);
                    continue;
                }
                if (statusCode == 0) {
                    if (!state.booleanValue()) continue;
                    result.add(name);
                    continue;
                }
                if (state.booleanValue()) continue;
                result.add(name);
            }
            handlerCtx.setOutputValue("result", result);
            handlerCtx.setOutputValue("hasResult", (Object)(!result.isEmpty() ? 1 : 0));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void migrateEjbTimer(HandlerContext handlerCtx) {
        String source = (String)handlerCtx.getInputValue("source");
        String dest = (String)handlerCtx.getInputValue("dest");
        if (dest == null) {
            dest = "";
        }
        String objName = "com.sun.appserv:type=ejb-timer-management,category=config";
        String methodName = "migrateTimers";
        Object[] params = new Object[]{source, dest};
        String[] types = new String[]{"java.lang.String", "java.lang.String"};
        try {
            JMXUtil.invoke(objName, methodName, params, types);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }
}

