/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassField;
import com.sun.jdo.api.persistence.enhancer.classfile.Descriptor;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import com.sun.jdo.api.persistence.enhancer.impl.ClassAction;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.impl.FieldTypeInfo;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.Support;

final class FieldAction
extends Support
implements VMConstants {
    private ClassField theField;
    private ClassAction ca;
    private final Environment env;
    private boolean fieldIsPrimaryKey;
    private boolean fieldIsMutableSCO;
    private boolean fieldIsPersistent;
    private int nFieldArrayDims;
    private String fieldClassName;
    private FieldTypeInfo fieldTypeInfo;

    FieldAction(ClassAction ca, ClassField field, Environment env) {
        this.ca = ca;
        this.theField = field;
        this.env = env;
    }

    String typeDescriptor() {
        return this.theField.signature().asString();
    }

    String typeName() {
        String typeDesc = this.typeDescriptor();
        if (typeDesc.charAt(0) == 'L') {
            return typeDesc.substring(1, typeDesc.length() - 1);
        }
        return typeDesc;
    }

    boolean isPrimaryKey() {
        return this.fieldIsPrimaryKey;
    }

    boolean isMutableSCO() {
        return this.fieldIsMutableSCO;
    }

    boolean isPersistent() {
        return this.fieldIsPersistent;
    }

    String fieldName() {
        return this.theField.name().asString();
    }

    boolean isSynthetic() {
        return this.theField.attributes().findAttribute("Synthetic") != null;
    }

    String createMethod() {
        return this.fieldTypeInfo.fieldCreateMethod;
    }

    String createMethodSig() {
        return this.fieldTypeInfo.fieldCreateMethodSig;
    }

    String setMethod() {
        return this.fieldTypeInfo.fieldSetMethod;
    }

    String setMethodSig() {
        return this.fieldTypeInfo.fieldSetMethodSig;
    }

    int setMethodArg() {
        return this.fieldTypeInfo.fieldSetArgType;
    }

    String getMethod() {
        return this.fieldTypeInfo.fieldGetMethod;
    }

    String getMethodSig() {
        return this.fieldTypeInfo.fieldGetMethodSig;
    }

    int getMethodReturn() {
        return this.fieldTypeInfo.fieldGetReturnType;
    }

    String fieldClassName() {
        return this.fieldClassName;
    }

    int nDims() {
        return this.nFieldArrayDims;
    }

    void check() {
        String sig = this.theField.signature().asString();
        this.fieldTypeInfo = FieldTypeInfo.determineFieldType(sig, this.env);
        String className = this.ca.className();
        String userClass = this.ca.userClassName();
        String fieldName = this.theField.name().asString();
        String fullFieldName = this.userFieldName();
        JDOMetaData jdoMetaData = this.env.getJDOMetaData();
        boolean fieldShouldBePersistent = jdoMetaData.isPersistentField(className, fieldName);
        this.fieldIsPrimaryKey = jdoMetaData.isPrimaryKeyField(className, fieldName);
        this.fieldIsMutableSCO = jdoMetaData.isMutableSecondClassObjectType(this.typeName());
        this.nFieldArrayDims = 0;
        while (sig.charAt(this.nFieldArrayDims) == '[') {
            ++this.nFieldArrayDims;
        }
        if (sig.charAt(this.nFieldArrayDims) == 'L') {
            this.fieldClassName = sig.substring(this.nFieldArrayDims + 1, sig.length() - 1);
        }
        if (!fieldShouldBePersistent) {
            return;
        }
        FieldAction.affirm(!this.theField.isStatic(), "The field " + fullFieldName + " is a static field which cannot be made persistent.");
        FieldAction.affirm(!this.theField.isFinal(), "The field " + fullFieldName + " is a final field which cannot be made persistent.");
        FieldAction.affirm(this.fieldClassName == null || jdoMetaData.isSecondClassObjectType(this.fieldClassName) || jdoMetaData.isPersistenceCapableClass(this.fieldClassName), "The field " + fullFieldName + " cannot be made persistent because of a non-primitive, " + " non-sco, or non-pc target type " + this.fieldClassName);
        this.fieldIsPersistent = true;
    }

    String userFieldName() {
        return this.ca.userClassName() + "." + this.theField.name().asString();
    }

    private String userSig(String vmSig) {
        return Descriptor.userFieldSig(vmSig);
    }
}

