/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnReadEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.PrintStream;

public class InsnTableSwitch
extends Insn {
    private int lowOp;
    private InsnTarget defaultOp;
    private InsnTarget[] targetsOp;

    public int nStackArgs() {
        return 1;
    }

    public int nStackResults() {
        return 0;
    }

    public String argTypes() {
        return "I";
    }

    public String resultTypes() {
        return "";
    }

    public boolean branches() {
        return true;
    }

    public void markTargets() {
        this.defaultOp.setBranchTarget();
        for (int i = 0; i < this.targetsOp.length; ++i) {
            this.targetsOp[i].setBranchTarget();
        }
    }

    public int lowCase() {
        return this.lowOp;
    }

    public InsnTarget defaultTarget() {
        return this.defaultOp;
    }

    public InsnTarget[] switchTargets() {
        return this.targetsOp;
    }

    public InsnTableSwitch(int lowOp, InsnTarget defaultOp, InsnTarget[] targetsOp) {
        this(lowOp, defaultOp, targetsOp, -1);
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println(this.offset() + "  opc_tableswitch  ");
        for (int i = 0; i < this.targetsOp.length; ++i) {
            int index = i + this.lowOp;
            if (this.targetsOp[i].offset() == this.defaultOp.offset()) continue;
            ClassPrint.spaces(out, indent + 2);
            out.println(index + " -> " + this.targetsOp[i].offset());
        }
        ClassPrint.spaces(out, indent + 2);
        out.println("default -> " + this.defaultOp.offset());
    }

    int store(byte[] buf, int index) {
        buf[index++] = (byte)this.opcode();
        index = index + 3 & 0xFFFFFFFC;
        index = InsnTableSwitch.storeInt(buf, index, this.defaultOp.offset() - this.offset());
        index = InsnTableSwitch.storeInt(buf, index, this.lowOp);
        index = InsnTableSwitch.storeInt(buf, index, this.lowOp + this.targetsOp.length - 1);
        for (int i = 0; i < this.targetsOp.length; ++i) {
            index = InsnTableSwitch.storeInt(buf, index, this.targetsOp[i].offset() - this.offset());
        }
        return index;
    }

    int size() {
        int basic = (this.offset() + 4 & 0xFFFFFFFC) - this.offset() + 12;
        return basic + this.targetsOp.length * 4;
    }

    InsnTableSwitch(int lowOp, InsnTarget defaultOp, InsnTarget[] targetsOp, int offset) {
        super(170, offset);
        this.lowOp = lowOp;
        this.defaultOp = defaultOp;
        this.targetsOp = targetsOp;
        if (defaultOp == null || targetsOp == null) {
            throw new InsnError("attempt to create an opc_tableswitch with invalid operands");
        }
    }

    static InsnTableSwitch read(InsnReadEnv insnEnv, int myPC) {
        int thisPC = myPC + 1;
        for (int pads = (thisPC + 3 & 0xFFFFFFFC) - thisPC; pads > 0; --pads) {
            insnEnv.getByte();
        }
        InsnTarget defaultTarget = insnEnv.getTarget(insnEnv.getInt() + myPC);
        int low = insnEnv.getInt();
        int high = insnEnv.getInt();
        InsnTarget[] offsets = new InsnTarget[high - low + 1];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = insnEnv.getTarget(insnEnv.getInt() + myPC);
        }
        return new InsnTableSwitch(low, defaultTarget, offsets, myPC);
    }
}

