/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class AnnotatedMethodAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "filter.annotatedMethod";
    public static final short expectedAttrVersion = 1;
    public static final short generatedFlag = 1;
    public static final short annotatedFlag = 2;
    public static final short modifiedFlag = 4;
    private short attrVersion;
    private short annotationFlags;
    private InsnTarget[] annotationRanges;

    public short getVersion() {
        return this.attrVersion;
    }

    public void setVersion(short version) {
        this.attrVersion = version;
    }

    public short getFlags() {
        return this.annotationFlags;
    }

    public void setFlags(short flags) {
        this.annotationFlags = flags;
    }

    public InsnTarget[] getAnnotationRanges() {
        return this.annotationRanges;
    }

    public void setAnnotationRanges(InsnTarget[] ranges) {
        this.annotationRanges = ranges;
    }

    public AnnotatedMethodAttribute(ConstUtf8 nameAttr, short version, short annFlags, InsnTarget[] annRanges) {
        super(nameAttr);
        this.attrVersion = version;
        this.annotationFlags = annFlags;
        this.annotationRanges = annRanges;
    }

    static AnnotatedMethodAttribute read(ConstUtf8 attrName, DataInputStream data, CodeEnv env) throws IOException {
        short version = data.readShort();
        short annFlags = data.readShort();
        int nRanges = data.readShort();
        InsnTarget[] ranges = new InsnTarget[nRanges * 2];
        for (int i = 0; i < nRanges; ++i) {
            ranges[i * 2] = env.getTarget(data.readShort());
            ranges[i * 2 + 1] = env.getTarget(data.readShort());
        }
        return new AnnotatedMethodAttribute(attrName, version, annFlags, ranges);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        if (this.annotationRanges == null) {
            out.writeShort(2);
        } else {
            out.writeShort(4 + 2 * this.annotationRanges.length);
        }
        out.writeShort(this.attrVersion);
        out.writeShort(this.annotationFlags);
        if (this.annotationRanges == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.annotationRanges.length / 2);
            for (int i = 0; i < this.annotationRanges.length; ++i) {
                out.writeShort(this.annotationRanges[i].offset());
            }
        }
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("version: " + this.attrVersion);
        out.println(" flags: " + this.annotationFlags);
        if (this.annotationRanges != null) {
            out.println("Annotations: ");
            for (int i = 0; i < this.annotationRanges.length / 2; ++i) {
                ClassPrint.spaces(out, indent + 2);
                out.println(this.annotationRanges[i * 2] + " to " + this.annotationRanges[i * 2 + 1]);
            }
        }
    }
}

