/*
 * EnvironmentFactory.java
 *
 * Created on December 15, 2003, 10:33 PM
 */

package com.sun.enterprise.config.backup.pluggable;

import com.sun.enterprise.config.backup.BackupAbortException;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.utils.LocalStringsHelper;
import java.util.logging.Logger;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.pluggable.impl.DefaultBackupEnvironment;
import com.sun.enterprise.config.backup.pluggable.impl.DefaultActiveAssistance;
import com.sun.enterprise.config.backup.pluggable.impl.OfflineBackupSynchronizer;
import com.sun.enterprise.config.backup.pluggable.impl.OnlineBackupSynchronizer;
import com.sun.enterprise.config.backup.pluggable.impl.ZipStorage;
import com.sun.enterprise.config.backup.pluggable.impl.DirectoryStorage;
import com.sun.enterprise.config.backup.BackupStorageMonitor;
import com.sun.enterprise.config.backup.HistoryManager;
import com.sun.enterprise.config.backup.EnvironmentConstants;
import com.sun.enterprise.config.backup.utils.SystemPropsHelper;
/**
 * provides a basic implementation of factory. Users can
 * extend this class and implement required methods and set their
 * class in environment variable ENVIRONMENT_FACTORY_CLASS. The
 * statis create method in this class reads the variable and
 * instantiates the class. Note that the implemented factory
 * needs a no arg constructor.
 *
 * @author  sridatta
 */
public class EnvironmentFactory 
        implements StatusConstants, EnvironmentConstants {
    
 
    private static EnvironmentFactory _ENV = null;
    private static BackupEnvironment _BE = null;
    private static ActiveAssistance _AA = null;
   
    public static synchronized EnvironmentFactory getEnvironmentFactory() {
        if(_ENV == null) {
           _ENV = createEnvironmentFactory();
        } 
        return _ENV; 
    }
    
    private static EnvironmentFactory createEnvironmentFactory() {
                                            
        String factoryClassName = SystemPropsHelper.getProperty(ENVIRONMENT_FACTORY_CLASS);
        
        Class factoryClass;
        try {
            if(factoryClassName!= null && !"".equals(factoryClassName)) {
                factoryClass = Class.forName(factoryClassName);
            } else {
                factoryClass = EnvironmentFactory.class;
            }
        }catch(Exception e) {
            throw new BackupAbortException(
                    "error_loading_environment_factory_class",
                    LocalStringsHelper.
                        getString("error_loading_environment_factory_class"),
                    e);
        }
        LoggerHelper.fine("EnvironmentFactory.getEnvironmentFactory():" +
                    "Factory Class is " + factoryClass);
        
        EnvironmentFactory result = null;
        try {
            result = (EnvironmentFactory) factoryClass.newInstance();
        } catch(Exception e) {
            throw new BackupAbortException(
                "error_creating_environment_factory", 
                LocalStringsHelper.
                        getString("error_creating_environment_factory"),
                e);
        }
        
        return result;
    }
    
    public synchronized BackupEnvironment getBackupEnvironment() {
        
        if(_BE == null)
            _BE = createBackupEnvironment();
        
        return _BE;
    }
        
    public synchronized ActiveAssistance getActiveAssistance() {
        if(_AA == null)
            _AA = createActiveAssistance();
        
        return _AA;
    }
        
     private BackupStorage getBackupStorage(String type)  {
        
         if(STORAGE_TYPE_ZIP.equals(type)) return new ZipStorage();
         if(STORAGE_TYPE_DIRECTORY.equals(type)) return new DirectoryStorage();
         
         throw new BackupAbortException(
            "unsupported_storage_type",
            LocalStringsHelper.getString("unsupported_storage_type", type));
     }
     
    public BackupStorage getBackupStorage() {
                                    
        String storageType = getBackupEnvironment().getBackupStorageType();
        return getBackupStorage(storageType);
    }
     
    protected BackupEnvironment createBackupEnvironment() {
        return new DefaultBackupEnvironment();
    }
    
    protected ActiveAssistance createActiveAssistance() {
        return new DefaultActiveAssistance();
    }
    
        
    public BackupSynchronizer getBackupSynchronizer() {
                                    
        String type = getBackupEnvironment().getExecutionType();                                    
        
        if(type == TYPE_OFFLINE) return getOfflineBackupSynchronizer();
        
        if(type == TYPE_ONLINE) return getOnlineBackupSynchronizer();
       
        throw new BackupAbortException(
            "error_wrong_execution_type",
            LocalStringsHelper.getString("error_wrong_execution_type",type));
    }
    
    protected BackupSynchronizer getOfflineBackupSynchronizer() {
        return new OfflineBackupSynchronizer();
    }
    
    protected BackupSynchronizer getOnlineBackupSynchronizer() {
        return new OnlineBackupSynchronizer();
    }
}
