#!/usr/bin/env python
# -*- coding: utf-8 -*-
# License:: GPL
# Author:: Alberto Milone (aka tseliot) (mailto:albertomilone@alice.it)
# Website:: http://albertomilone.com

from Envy import objects
from Envy import main
from Envy import classes
from Envy import idcardlist
from Envy import xparse
from Envy import ui
from subprocess import Popen, PIPE
import sys
import vte
import re
import os
from os import path
import tempfile
import time
import urllib


try:
    import pygtk
    pygtk.require('2.0')
except:
    pass

import gtk
import gtk.glade
    
from Envynggtk import SimpleGladeApp
from Envynggtk.SimpleGladeApp import SimpleGladeApp
from Envynggtk import gtkfilechooser#CHANGE ME

import gettext, locale

from gettext import gettext as _


#website = 'http://albertomilone.com/wordpress'
#def gotoUrl(d, link, data):
        #webbrowser.open(website)

#gtk.about_dialog_set_url_hook(gotoUrl, None)

def aptcheck():
    """
    Check if any apt processes are running
    """
    p1 = Popen(['ps', '-U', 'root', '-o', 'comm'], stdout=PIPE)
    p = p1.communicate()[0]
    running = False
    pslist = p.split('\n')
    for process in pslist:
        if process.strip() in ["dpkg", "apt-get","synaptic","update-manager", "adept", "adept-notifier"]:
            running = True
            #print process
            break
    return running


class EnvyMain(SimpleGladeApp):
    def __init__(self):
        #Set the Glade file
        try:
            SimpleGladeApp.__init__(self, "envyng-gtkui/EnvyNG.glade")  
        except RuntimeError:
            SimpleGladeApp.__init__(self, "/usr/share/envyng-gtk/envyng-gtkui/EnvyNG.glade")
        
        self.gtkdetails = {}
        #Get the Main Window, and connect the destroy event
        #self.window = self.wTree.get_widget('MainWindow')
        self.window_main.realize()
        
#        if (self.window):
#            self.window_main.connect('destroy', gtk.main_quit)
#        
#        self.window_main.set_position(gtk.WIN_POS_CENTER)
        
        variables = classes.Vars()
        self.atilatest = variables.atimanlatest
        self.atinewlegacy = variables.atimannewlegacy
        self.atilegacy = variables.atimanlegacy
        self.nvbeta = variables.nvmanbeta
        self.nvlatest = variables.nvmanlatest
        self.nvnewlegacy = variables.nvmannewlegacy
        self.nvlegacy = variables.nvmanlegacy
        
        
        self.gtkdeps = ['python-gtk2', 'python-glade2', 'python-vte', 
        'gksu', 'synaptic']
        
        '''
        Translations
        '''
        
        self.translation = ui.AbstractUI()
        
        self.build_checkbutton.set_label(self.translation.string_download_packages)
        self.save_checkbutton.set_label(self.translation.string_save_packages)
        self.main_label.set_label(self.translation.string_main_label)
        self.options_label.set_label(self.translation.string_options_label)
        
        self.set_message(self.error_dialog, gtk.MESSAGE_ERROR, self.translation.string_vte_error_msg)
        self.set_message(self.complete_dialog, gtk.MESSAGE_INFO, self.translation.string_operation_complete)
        self.set_message(self.apt_dialog, gtk.MESSAGE_ERROR, self.translation.string_apt_in_use)
        
        self.vte_wait_label.set_label(self.translation.string_vte_tmp_msg)
        self.set_message(self.deperror_dialog, gtk.MESSAGE_ERROR, self.translation.string_error_title)
        
        self.set_message(self.restart_dialog, gtk.MESSAGE_INFO, self.translation.string_operation_complete_restart)
        
        self.set_message(self.initdep_dialog, gtk.MESSAGE_QUESTION, self.translation.string_missing_deps)
        self.initdep_dialog.format_secondary_text(self.translation.string_install_deps)
        
        self.set_message(self.path_dialog, gtk.MESSAGE_ERROR, self.translation.string_directory_error_title)
        self.path_dialog.format_secondary_text(self.translation.string_invalid_path)
        
        '''
        Set the artists and translators names
        '''
        
        self.about_dialog.set_artists(self.translation.string_artists_names)
        self.about_dialog.set_translator_credits('\n'.join(self.translation.string_translators_names))
        
        self.about_dialog.set_name("EnvyNG")
        self.about_dialog.set_version(objects.envyver())
        
        
        #self.about_dialog.set_website(website)
        
        
        
        '''
        restartdialog -> restart_dialog
        errordialog -> error_dialog
        completedialog -> complete_dialog
        aptdialog -> apt_dialog
        initdepdialog -> initdep_dialog
        depnobutton -> depno_button
        depyesbutton -> depyes_button
        connectiondialog -> connection_dialog
        '''
        
        
        self.atiVersions = {'latest': self.atilatest,  'middle': self.atinewlegacy, 'oldest': self.atilegacy,  'beta': None}
        self.nvidiaVersions = {'latest': self.nvlatest,  'middle': self.nvnewlegacy, 'oldest': self.nvlegacy,  'beta': self.nvbeta}
        self.driverMap = {'ATI': self.atiVersions, 'NVIDIA': self.nvidiaVersions}
        
        self.radioFlavours = {'latest': self.latest_radiobutton,
                                  'middle': self.middle_radiobutton,
                                  'oldest': self.oldest_radiobutton,
                                  'beta': self.beta_radiobutton}
        
        
        self.actionsList = ['automatic', 'manual', 'uninstall']
        self.driverFlavours = ['latest', 'middle', 'oldest', 'beta']
        self.curAction = self.actionsList[0]
        self.curFlavour = None
        
        self.driversList = ['ATI', 'NVIDIA']
        self.curDriver = self.driversList[0]
        
        
        self.savePackages = 0#do not save the packages by default
        self.buildOnly = 0#install the packages by default
        
        self.setLabels()

        #Here are some variables that can be reused later
        self.cDriver = 0
        self.sDriver = "Driver"
        
        
        ati =  gtk.CellRendererText()
        nvidia = gtk.CellRendererText()
        
        #Add all of the List Columns to the driverView
        mycells = [1, 'ati']
        celle = [2, 'nvidia']
        self.AddDriverListColumn(self.sDriver, self.cDriver)

        
        #Create the listStore Model to use with the driverView
        self.driverList = gtk.ListStore(str)
        self.driverList.append(['ATI'])
        self.driverList.append(['NVIDIA'])
        #Attach the model to the treeView
        self.treeview1.set_model(self.driverList)
        
        
        self.term = vte.Terminal()
        self.termfork = self.term.fork_command
        self.child = self.term.feed_child
        
        
        self.term.show()
        self.terminal_window.hide()
        
        self.scrolled_window.add_with_viewport(self.term)
        
        
        
        self.osdetect()
        self.depcheck()
        
        
        
        #self.window_main.show()
    
    def set_message(self, dialog, dlgtype, message):
        '''
        This method sucks
        Why isn't message_format public???
        '''
        dialog.__init__(parent=self.window_main, flags=0, type=dlgtype, buttons=gtk.BUTTONS_NONE, message_format=message)
        
    
    def AddDriverListColumn(self, title, columnId):
        """This function adds a column to the list view.
        First it create the gtk.TreeViewColumn and then set
        some needed properties"""
                        
        column = gtk.TreeViewColumn(title, gtk.CellRendererText(), text=columnId)
        column.set_resizable(True)      
        column.set_sort_column_id(columnId)
        self.treeview1.append_column(column)
    
    def on_treeview1_cursor_changed(self, widget):
        print 'Driver',  self.driversList[self.treeview1.get_cursor()[0][0]], 'is selected'
        self.curDriver = self.driversList[self.treeview1.get_cursor()[0][0]]
        self.setLabels()
        
    
    def on_exitbutton_clicked(self, widget):
        gtk.main_quit()
    
    def on_applybutton_clicked(self, widget):
        print "Applybutton clicked"
        print "Selected action is %s" %(self.curAction)
        print "Selected driver is %s" %(self.curDriver)
        if self.curAction == 'manual':
            print "Selected flavour is %s" %(self.curFlavour)
        print "Save packages is %i" %(self.savePackages)
        print "Build only is %i" %(self.buildOnly)
        print ''
        self.applyChanges()
        
    def on_window_main_delete_event(self, window, event):
        """Interpretate a closing of the main window as a cancel event"""
        self.on_exitbutton_clicked(None)
    
    def on_save_checkbutton_toggled(self, widget):
        self.savePackages = self.save_checkbutton.get_active()
        self.save_table.set_sensitive(self.save_checkbutton.get_active())
    
    def on_build_checkbutton_toggled(self, widget):
        self.buildOnly = self.build_checkbutton.get_active()
        
    def on_savebutton_clicked(self, widget):
        '''
        set the path from the filechooser in the GtkTextView
        '''
        newpath = gtkfilechooser.MyFilechooser()
        textbuffer = self.export_textview.get_buffer()
        textbuffer.set_text(newpath.result)
        self.export_textview.set_buffer(textbuffer)
    
    def on_automatic_button_toggled(self, widget):
        self.curAction = 'automatic'
        self.curFlavour = None
    
    def on_manual_button_toggled(self, widget):
        self.driver_frame.set_sensitive(self.manual_button.get_active())
        self.curAction = 'manual'
        self.curFlavour = 'latest'
        self.latest_radiobutton.set_active(1)
    
    def on_uninstall_button_toggled(self, widget):
        self.curAction = 'uninstall'
        self.curFlavour = None
    
    def on_latest_radiobutton_toggled(self, widget):
        self.curFlavour = 'latest'
    
    def on_middle_radiobutton_toggled(self, widget):
        self.curFlavour = 'middle'
    
    def on_oldest_radiobutton_toggled(self, widget):
        self.curFlavour = 'oldest'
    
    def on_beta_radiobutton_toggled(self, widget):
        self.curFlavour = 'beta'
        
    def on_save_checkbutton_toggled(self, widget):
        self.savePackages = self.save_checkbutton.get_active()
        self.build_checkbutton.set_active(0)
        self.buildOnly = 0
        self.save_table.set_sensitive(self.save_checkbutton.get_active())
        print "savePackages",  self.savePackages
    
    def on_build_checkbutton_toggled(self, widget):
        self.buildOnly = self.build_checkbutton.get_active()
        print "buildOnly",  self.buildOnly
    
    def getPath(self,  data=None):
        '''
        Get self.savePath from the TextView
        '''
        text = self.export_textview.get_buffer()
        start, end = text.get_bounds()
        self.savePath = text.get_text(start, end)
        print 'My savePath is ' + self.savePath
    
    def depTryNot(self, data=None):
        #self.sessioncheck()
        testme = classes.Shutilities()
        self.missingpkgs = testme.envydeps(self.gtkdeps)
        if self.missingpkgs != None:#missing dependencies
            self.deperror()
        else:
            self.window_main.show()

        
    def depTry(self, data=None):
        self.sessioncheck()
        testme = classes.Shutilities()
        self.missingpkgs = testme.envydeps(self.gtkdeps)
        if self.missingpkgs != None:#missing dependencies
            self.deperror()
        else:
            self.window_main.show()
    
    def setLabels(self, data=None):
        self.automatic_button.set_label(self.translation.string_auto_install %(self.curDriver))
        self.manual_button.set_label(self.translation.string_man_install %(self.curDriver))
        self.uninstall_button.set_label(self.translation.string_uninstall %(self.curDriver))
        for flavour in self.driverMap[self.curDriver]:
            if self.driverMap[self.curDriver][flavour] == None:
                self.radioFlavours[flavour].hide()
            else:
                self.radioFlavours[flavour].set_label(self.driverMap[self.curDriver][flavour])
                self.radioFlavours[flavour].show()
    
    def on_about_button_clicked(self, data=None):
        self.about_dialog.show()
    
    def on_about_dialog_response(self, dialog, response, *args):
        # system-defined GtkDialog responses are always negative, in which    
        # case we want to hide it
        if response < 0:
            self.about_dialog.hide()#dialog.hide()
            self.about_dialog.emit_stop_by_name('response')
    
    def on_term_button_clicked(self, data=None):
        self.terminal_window.hide()
    
    #def on_complete_dialog_response(self, data=None):
        #self.complete_dialog.hide()
    
    def completedial(self, widget=None, data=None):
        self.complete_dialog.show()
        response5 = self.complete_dialog.run()
        self.complete_dialog.set_default_response(gtk.RESPONSE_OK)
        if response5 == gtk.RESPONSE_OK:
            self.complete_dialog.hide()#destroy()
    
    def on_apt_dialog_response(self,  data=None):
        self.apt_dialog.hide()
        sys.exit(1)
    
    def on_deperror_dialog_response(self,  data=None,  widget=None):
        self.deperror_dialog.hide()
        sys.exit(1)
    
    def on_deperror_dialog_delete_event(self, window, event):
        """Interpretate a closing of the deperr_dialog as a cancel event"""
        self.on_deperror_dialog_response(None)
    
    def deperror(self, data=None):
        #pkgs = classes.Shutilities()
        #errpkgs = pkgs.envydeps(self.gtkdeps)
        #errpkgs = ['pacchetto1', 'pacchetto2', 'pacchetto3']
        error = (self.translation.string_connection_error)
        self.deperror_dialog.set_title(self.translation.string_error_title)
        self.deperror_dialog.format_secondary_text(error)
        self.deperror_dialog.show()
    
    def on_error_dialog_response(self,  data=None,  widget=None):
        self.error_dialog.hide()
    
    def restart(self, widget=None, data=None):
        self.restart_dialog.show()
        response2 = self.restart_dialog.run()
        self.restart_dialog.set_default_response(gtk.RESPONSE_YES)
        if response2 == gtk.RESPONSE_YES:
            self.restart_dialog.hide()#destroy()
            self.systemrestart()
        elif response2 == gtk.RESPONSE_NO:
            self.restart_dialog.hide()#destroy()
    
    def systemrestart(self, data=None):
        os.system('sudo reboot')
        sys.exit()
    
    
    def on_path_dialog_response(self,  data=None,  widget=None):
        self.path_dialog.hide()
    
    #def on_restart_dialog_response(self,  data=None,  widget=None):
        #self.restart_dialog.hide()
        #self.systemrestart()
    
    def initdepStart(self,  data=None, widget=None):#,  widget
        self.initdep_dialog.show()
        response = self.initdep_dialog.run()
        self.initdep_dialog.set_default_response(gtk.RESPONSE_YES)
        if response == gtk.RESPONSE_YES:
            self.initdep_dialog.hide()
            self.depTry()
            #print 'Yes'
        elif response == gtk.RESPONSE_NO:
            self.initdep_dialog.hide()
            self.depTryNot()
            #print 'No'
    

    def depcheck(self, data=None):
        testme = classes.Shutilities()
        #self.missingpkgs = testme.envydeps(self.gtkdeps)
        #if self.missingpkgs != None:#missing dependencies
        print 'TESTING CONNECTION'
        if classes.connectionCheck():
            print 'Connection is available'
            self.window_main.show()
            self.checkLatest()
            #self.initdepStart()
        else:
            print 'ERROR: Connection is not available'
            self.window_main.hide()
            self.deperror()
        #else:
            #self.window_main.show()

    '''
    BEGIN WORK IN PROGRESS
    '''
    
    def applyChanges(self):
        self.drv = self.curDriver.lower()
        self.ver = self.curFlavour
        self.save = self.savePackages
        self.build = self.buildOnly
        #vte terminal
        self.completetxt = []
        self.logtxtfile = '/var/log/envy-installer.log'
        self.r = 0
        self.logged = ''
        #self.terminal_window.reset(full=True, clear_history=True)
        self.term.reset(full=True, clear_history=True)
        
        self.termfork('bash')
        
        '''
        Installation Process
        '''
        self.canStart = 1
        
        if self.curAction == 'automatic':
            if self.save == 1:#Save the packages
                '''
                self.savePath may exist even when self.save=0
                '''
                self.getPath()#get self.savePath
                '''
                Automatic selection
                4 arguments
                '''
                if not os.path.isdir(self.savePath):
                    self.canStart = 0
                    self.path_dialog.show()
                else:
                    command = 'python pulse.py %s %i %i %s \n' % (self.drv, self.save, self.build, self.savePath)
                #print 'python pulse.py %s %i %i %s \n' % (self.drv, self.save, self.build, self.savePath)
            else:#Do not Save the packages
                '''
                Automatic selection
                1 argument
                '''
                command = 'python pulse.py %s \n' % (self.drv)
                #print 'python pulse.py %s \n' % (self.drv)
        
        elif self.curAction == 'manual':
            if self.save == 1:#Save the packages
                '''
                self.savePath may exist even when self.save=0
                '''
                self.getPath()#get self.savePath
                '''
                Manual selection
                5 arguments
                '''
                if not os.path.isdir(self.savePath):
                    self.canStart = 0
                    self.path_dialog.show()
                else:
                    command = 'python pulse.py %s %s %i %i %s \n' % (self.drv, self.ver, self.save, self.build, self.savePath)
                #print 'python pulse.py %s %s %i %i %s \n' % (self.drv, self.ver, self.save, self.build, self.savePath)
            
            else:#Do not Save the packages
                '''
                Manual selection
                2 arguments
                '''
                command = 'python pulse.py %s %s \n' % (self.drv, self.ver)
                #print 'python pulse.py %s %s \n' % (self.drv, self.ver)
        
        elif self.curAction == 'uninstall':
            command = 'python pulse.py %s %s \n' % (self.drv, 'uninstall')
            #print 'python pulse.py %s %s \n' % (self.drv, 'uninstall')
        
        if self.canStart == 1:
            self.child(command)
            
            self.term.connect("cursor-moved", self.log_output)
            self.term.connect("eof", self.child_done)
            self.term.show()
            self.terminal_window.show()
        
        
    def errorCheck(self, data=None):
        self.terminal_window.hide()
        try:
            if self.error == 'error':#if there is an error
                self.error_dialog.show()
                #self.selfcleaner()
            elif self.error == 'noerror':
                try:
                    if self.ver == 'uninstall':
                        self.completedial()
                        #self.selfcleaner()
                    else:
                        if self.build == 0:
                            #self.xorg()
                            self.completedial()
                            self.restart()
                            #self.selfcleaner()
                        else:
                            self.completedial()
                except AttributeError:
                    if self.build == 0:
                        #self.xorg()
                        self.completedial()
                        self.restart()
                        #self.selfcleaner()
                    else:
                        self.completedial()
        except AttributeError:#if no error is reported
            if self.build == 0:
                #self.xorg()
                self.restart()
                #self.selfcleaner()
            else:
                self.completedial()
            pass
        
    def child_done(self):
        self.error = 'noerror'
        self.errorCheck()
    
    def log_output(self,term):
        column,row = self.term.get_cursor_position()
        if self.r != row:
            off = row-self.r
            text = self.term.get_text_range(row-off,0,row-1,-1,self.capture_text)
            self.r=row
            text = text.strip()
            if "\n" not in text or text[-1] != "\n":
                text += "\n"
            ##self.logged += text
            self.completetxt.append(text)
            a = self.logged
            error = re.compile('.*EnvyNG ERROR.*\n')
            success = re.compile('.*EnvyNG:.*Operation.*Complete.*')
            for line in self.completetxt:#self.logged:
                m1 = error.match(line)
                m2 = success.match(line)
            if m1:
                self.error = 'error'
                sep = ''#write a logfile
                logtext = sep.join(self.completetxt)
                logfile = open(self.logtxtfile, 'w')
                logfile.write(logtext)
                logfile.close()
                self.errorCheck()
            if m2:
                self.error = 'noerror'
                sep = ''#write a logfile
                logtext = sep.join(self.completetxt)
                logfile = open(self.logtxtfile, 'w')
                logfile.write(logtext)
                logfile.close()
                self.errorCheck()
        

    def capture_text(self,text,text2,text3,text4):
        return True
    
    def gnomeGeneric(self, data=None):
        self.cmd = ["sudo", "/usr/sbin/synaptic", "--hide-main-window",  \
        "--non-interactive", "--parent-window-id", self.window_main.window.xid]
        self.cmd.append("--progress-str")
        self.cmd.append('%s' % (self.translation.string_synaptic_temp_msg))
        self.cmd.append("--finish-str")
        self.cmd.append('%s' % (self.translation.string_synaptic_finish_msg))
        
    
    def gnomeRefresh(self, data=None):
        self.cmd.append("--update-at-startup")
        commd = classes.Shutilities()
        commd.cmdoutput(' '.join(self.cmd))
        
        
    def gnomeInstall(self, data=None):
        f = tempfile.NamedTemporaryFile()
        for pkg in self.missingpkgs:
            f.write("%s\tinstall\n" % pkg)
        self.cmd.append("--set-selections-file")
        self.cmd.append("%s" % f.name)
        f.flush()
        commd = classes.Shutilities()
        commd.cmdoutput(' '.join(self.cmd))
        f.close()
    
    
    def gnomeInstallPkg(self, packages, data=None):
        cmd = ["sudo", "/usr/sbin/synaptic", "--hide-main-window",  \
        "--non-interactive", "--parent-window-id", self.window_main.window.xid]
        cmd.append("--progress-str")
        cmd.append('%s' % (self.translation.string_synaptic_temp_msg))
        cmd.append("--finish-str")
        cmd.append('%s' % (self.translation.string_synaptic_finish_msg))

        f = tempfile.NamedTemporaryFile()
        for pkg in packages:
            f.write("%s\tinstall\n" % pkg)
        cmd.append("--set-selections-file")
        cmd.append("%s" % f.name)
        f.flush()
        commd = classes.Shutilities()
        commd.cmdoutput(' '.join(cmd))
        f.close()
    
        
    def kderefresh(self, data=None):
        '''
        dependency > make sure adept-batch is installed
        
        it uses apt-get like syntax
        
        adept_batch install, adept_batch remove
        '''
        commd = classes.Shutilities()
        commd.cmdoutput('kdesu /usr/bin/adept_batch update')
        
    def kdeinstall(self, data=None):
        commd = classes.Shutilities()
        commd.cmdoutput('kdesu /usr/bin/adept_batch install ' + \
        ' '.join(self.missingpkgs))
        
    def sessioncheck(self, data=None):
        '''
        FIX ME
        '''
        session = os.popen('ps -e | grep gnome-panel')
        if len(session.readlines()) > 0:
            if os.path.isfile('/usr/sbin/synaptic') == True:
                self.session = 'gnome'
            elif os.path.isfile('/usr/bin/adept_batch') == True:
                self.session = 'kde'
            else: sys.exit(1)
        else:
            if os.path.isfile('/usr/bin/adept_batch') == True:
                self.session = 'kde'
            elif os.path.isfile('/usr/sbin/synaptic') == True:
                self.session = 'gnome'
            else:
                print 'Neither Synaptic nor Adept were detected'
                
        if self.session == 'gnome':
            self.gnomeGeneric()
            self.gnomeRefresh()
            print self.cmd
            self.cmd = self.cmd[0:-1]
            self.gnomeInstall()
            
        #elif self.session == 'kde' and os.path.isfile('/usr/bin/adept_batch') == True:
            #self.kderefresh()
            #self.kdeinstall()
    
    def osdetect(self, data=None):
        getver = classes.Specsdetect()
        #getver.init()
        getver.codename()
        self.osver = getver.details['osname']
    
    def checkLatest(self, data=None):
        variables = classes.Vars(1)
        self.atilatest = variables.atimanlatest
        self.atinewlegacy = variables.atimannewlegacy
        self.atilegacy = variables.atimanlegacy
        self.nvbeta = variables.nvmanbeta
        self.nvlatest = variables.nvmanlatest
        self.nvnewlegacy = variables.nvmannewlegacy
        self.nvlegacy = variables.nvmanlegacy
        
        self.atiVersions = {'latest': self.atilatest,  'middle': self.atinewlegacy, 'oldest': self.atilegacy,  'beta': None}
        self.nvidiaVersions = {'latest': self.nvlatest,  'middle': self.nvnewlegacy, 'oldest': self.nvlegacy,  'beta': self.nvbeta}
        self.driverMap = {'ATI': self.atiVersions, 'NVIDIA': self.nvidiaVersions}
        self.setLabels()
    
    




def main():
    gtk.main()
    return 0

if __name__ == '__main__':
    #gettext.textdomain("envy")
    #gtk.glade.textdomain("envy")
    os.chdir('/usr/share/envy')
    EnvyMain()
    main()
