# -*- coding: utf-8 -*-
# License:: GPL
# Author:: Alberto Milone (aka tseliot) (mailto:albertomilone@alice.it)
# Website:: http://albertomilone.com

import os, sys
import re
from xorgconfig import *
import xorgconfig2

file = '/etc/X11/xorg.conf'

class EnvyParser:
    def __init__(self):
        self.file = file#'/etc/X11/xorg.conf'
        if not os.path.isfile(self.file):#NO XORG.conf FOUND
            print '\nENVYNG PARSER: No xorg.conf found.\n'
            print 'Creating a new xorg.conf'
            a = open(self.file, 'w')
            a.write('')
            a.close()
            
        self.config = readConfig(self.file)
        self.section_module = self.config.getSections('Module')
        self.section_device = self.config.getSections('Device')
        self.section_screen = self.config.getSections('Screen')
        self.section_monitor = self.config.getSections('Monitor')
        self.section_extensions = self.config.getSections('Extensions')
        self.section_serverlayout = self.config.getSections('ServerLayout')
        self.section_serverflags = self.config.getSections('ServerFlags')
        
        self.sectdict = {
        'modules': 'Module',
        'devices': 'Device',
        'screens': 'Screen',
        'monitors': 'Monitor',
        'extensions': 'Extensions',
        'serverlayouts': 'ServerLayout',
        'serverflags': 'ServerFlags',
        }
        
        self.sections = {
        'Module': self.section_module,
        'Device': self.section_device,
        'Screen': self.section_screen,
        'Monitor': self.section_monitor,
        'Extensions': self.section_extensions,
        'ServerLayout': self.section_serverlayout,
        "ServerFlags": self.section_serverflags
        }
        
        
    
    def checksection(self, section):
        #print 'Section', section
        categname = self.sectdict[section]#section name 
        categ = self.sections[categname]#section
        
        if len(categ) == 0:
            module = self.config.makeSection(None, ['Section', categname])
            self.config.append(module)
            self.writeto()
            self.__init__()
    
    def writeto(self):
        '''
        Write the new settings and reinitialise the class
        self.writeto()
        '''
        self.config.writeConfig(self.file)
        self.__init__()
        
    def addmodule(self, mod):
        if len(self.section_module) > 0:
            module = self.section_module[0]
        else:
            module = self.config.makeSection(None, ['Section', 'Module'])
            self.config.append(module)
            self.writeto()
            self.__init__()
            self.addmodule(mod)
            
        module.removeModule(mod)
        module.addModule(mod)
        self.writeto()
    
    def rmmodule(self, mod):
        if len(self.section_module) > 0:
            module = self.section_module[0]
        else:
            module = self.config.makeSection(None, ['Section', 'Module'])
            self.config.append(module)
            self.writeto()
            self.__init__()
            self.rmmodule(mod)
            
        module.removeModule(mod)
        self.writeto()
        
    def rmoption(self, section, myoption):
        categname = self.sectdict[section]#section name 
        categ = self.sections[categname]#section
        
        self.checksection(section)
        
        it = 0
        while it < len(categ):
            categ[it].option.removeOptionByName(myoption)
            it += 1
        
        self.writeto()
    
    def addoption(self, section, myoption, value=''):
        '''
        example
        self.addoption('devices', 'AddARGBGLXVisuals', 'True')
        
        if you don't pass the value:
        self.addoption('devices', 'AddARGBGLXVisuals')
        then the option is added without a value.
        '''
        
        categname = self.sectdict[section]#section name 
        categ = self.sections[categname]#section
        
        self.checksection(section)
        
        try:
            it = 0
            while it < len(categ):
                sect = categ[it]
                sect.option.append( sect.option.makeLine(None,[myoption, value]) )
                it += 1
        except NameError, e:
            print e
            pass
        
        self.writeto()
        
    def customoption(self, section, option, value=''):
        '''
        sets an option to whatever you want
        e.g. self.customoption('extensions', 'Composite', 'Enable')
        '''
        
        self.checksection(section)
        
        self.rmoption(section, option)
        self.addoption(section, option, value)
        
    def enableoption(self, section, option):
        '''
        sets the desired option to "True"
        '''
        self.rmoption(section, option)
        self.addoption(section, option, 'True')
        
    def disableoption(self, section, option):
        '''
        sets the desired option to "False"
        '''
        self.rmoption(section, option)
        self.addoption(section, option, 'False')
        
    
    def setdriver(self, new):
        '''
        USAGE:
        pass it the driver you wish to set as an argument.
        Example
        self.setdriver('nvidia')
        '''
        self.checksection('devices')
        
        drvlst = ['fbdev', 'vga', 'vesa', 'radeon', 'ati', 'fglrx', 'nv', 'nvidia', 'radeonhd', 'nouveau']
        
        it = 0
        while it < len(self.section_device):
            sect = self.section_device[it]
            #if sect.driver in drvlst:
            sect.driver = new
            it += 1
        self.writeto()

    def drivercheck(self):
        '''
        this method is used when the driver is uninstalled
        as in envy --uninstall-all
        if the driver was set to nvidia, it is set to nv
        if the driver was set to fglrx, it is set to vesa
        '''
        #self.file = '/etc/X11/xorg.conf'
        self.checksection('devices')
        
        driver = None
        drvlst = ['fglrx', 'nvidia']
        
        it = 0
        while it < len(self.section_device):
            sect = self.section_device[it]
            if sect.driver == 'fglrx':
                sect.driver = 'vesa'
                print 'ENVYNG: setting the driver to ' + sect.driver
            elif sect.driver == 'nvidia':
                sect.driver = 'nv'
                print 'ENVYNG: setting the driver to ' + sect.driver
            it += 1
        self.writeto()

    def enablecomposite(self):
        self.customoption('extensions', 'Composite', 'Enable')

    def disablecomposite(self):
        self.customoption('extensions', 'Composite', 'Disable')
        
    def addargbglxvisuals(self):
        self.rmoption('devices', 'AddARGBGLXVisuals')
        self.rmoption('screens', 'AddARGBGLXVisuals')
        self.enableoption('screens', 'AddARGBGLXVisuals')

    def videooverlayon(self):
        self.rmoption('devices', 'VideoOverlay')
        self.customoption('devices', 'VideoOverlay', 'on')
    
    def opengloverlayoff(self):
        self.rmoption('devices', 'OpenGLOverlay')
        self.customoption('devices', 'OpenGLOverlay', 'off')
        
    def usedisplaydevicedfp(self):
        self.rmoption('screens', 'UseDisplayDevice')
        self.customoption('screens', 'UseDisplayDevice', 'DFP')
    
    def removealloptions(self):
        self.rmoption('extensions', 'Composite')
        self.rmoption('screens', 'AddARGBGLXVisuals')
        self.rmoption('screens', 'UseDisplayDevice')
        self.rmoption('devices', 'VideoOverlay')
        self.rmoption('devices', 'OpenGLOverlay')

def defaultdepth():
    '''
    Doesn't use Guidance
    '''
    a = xorgconfig2.Parser(file, file)
    a.addOption('"Screen"', 'Defaultdepth', '24')
    a.writeFile()

'''
Examples:
a.addoption('devices', 'AddARGB', 'True')
a.rmoption('screens', 'AddARGB')
a.customoption('screens', 'UseDisplayDevice', 'DFP')
a.customoption('extensions', 'Composite', 'Disable')
a.setdriver('nvidia')
'''

'''
    #HOW TO USE GUIDANCE
    ###############################################################################
    ## General usage
    #
    ## Print the options in a section
    #for option in device_options:
    #    # option is of type OptionLine.
    #    print option._row[0],
    #    if len(option._row)>=2:
    #        print "=>",option._row[1]
    #
    ## Get the driver
    #device_driver = section_device[0].driver
    #
    ## Set the driver
    #section_device[0].driver = 'nvidia'
    #
    ## Add an option to one section (0)
    #options = section_device[0].option
    #options.append( options.makeLine("Comment text",["AddARGBGLXVisuals" "True"]) )
    #
    ## Remove an Option from one section (0)
    #options.removeOptionByName("AddARGBGLXVisuals")
    #################################################################################
    
    #################################################################################
    #READY-TO-USE CODE    
    
    from xorgconfig import *
    config = readConfig("/etc/X11/xorg.conf")

    section_device = config.getSections("Device")
    
    #NOTE: there may be more than one section device
    device_options = section_device[0].option
    device_driver = section_device[0].driver
    
    
    #to add an option to each section "Device"
    it = 0
    while it < len(section_device):
        options = section_device[it].option
        options.append( options.makeLine("Comment text",["AddARGBGLXVisuals" "True"]) )
        it += 1
    
    #to remove an option from each section "Device"
    it = 0
    while it < len(section_device):
        section_device[it].option.removeOptionByName("AddARGBGLXVisuals")
        it += 1
    
    #to change the driver
    drvlst = ['fbdev', 'vga', 'vesa', 'radeon', 'ati', 'fglrx', 'nv', 'nvidia', 'radeonhd', 'nouveau']
    
    it = 0
    while it < len(section_device):
        if section_device[it].driver in drvlst:
            section_device[it].driver = 'nvidia'
        it += 1
    
    #then write your settings to a file
    config.writeConfig("/etc/X11/xorg.conf")
    ###################################################################################################
    
'''

''' Code I might use later
##        module.removeModule('GLcore')
##        module.removeModule('glx')
##        module.removeModule('dbe')
##
##        # Mandriva
##        #module.removeModule("/usr/X11R6/lib/modules/extensions/libglx.so")
##
##        if driver=='nvidia':
##            module.addModule("glx")
##
##        elif self.gfxcard_model.getProprietaryDriver()!='fglrx':
##            module.addModule('glx')
##            module.addModule('GLcore')
##
##        #module.removeModule("/usr/X11R6/lib/modules/extensions/libglx.a")
##        if driver=='fglrx':
##            module.addModule("glx")
##            module.addModule("dbe")
##        #elif driver!='nvidia':
##        #    module.addModule("/usr/X11R6/lib/modules/extensions/libglx.a")
##
##        # DRI
##        module.removeModule('dri')
##        if self.gfxcard_model.getDriGlx():
##            module.addModule('dri')
##
##        module.removeModule('v4l')
##        if not (self.gfxcard_model.getDriGlx() and self.gfxcard_model.getDriver()=='r128'):
##            module.addModule('v4l')
'''


if __name__ == '__main__':
    #print 'Envy Parser:\n'
    a = EnvyParser()
    #a.customoption('extensions', 'Composite', 'Enable')
    #a.enableoption('devices', 'NoLogo')
    #a.addargbglxvisuals()
    a.disablecomposite()
    #a.videooverlayon()
    #a.usedisplaydevicedfp()
    #a.addmodule('glx')
    #a.rmmodule('glx')
    #a.addoption('devices', 'NoLogo', "false")
    #a.rmoption('devices', 'NoLogo')
    #a.setdriver('radeon')

