/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __DATA_H__
#define __DATA_H__

/*#include <crtdbg.h>*/
#include <assert.h>
#include "compat_defs.h"

typedef struct tagCompressHeader
{
	Bool16 bCompressed;
	Word8 cRepeater;
	Word8 reserved;
	Word32 wCount;
} CompressHeader;

class DATA {
public:
	Handle Type;
	Word32 Size;
	char * lpData;

public:
	DATA();
	virtual ~DATA();

	Bool32  SetData(Handle type, void * lpData, Word32 Size);
	Word32  GetData(Handle type, void * lpData, Word32 Size);
	inline Bool32  GetDataPtr(Handle type, void ** lpdata){ Bool32 rc = FALSE; _ASSERT(lpdata); if(type == Type ){ *lpdata=lpData; rc = TRUE; } return rc;}

	inline Handle GetType(){ return Type;};
	inline Handle SetType(Handle dwType) { Handle old = Type; Type = dwType; return old;};

	DATA & operator = (DATA & data);
	Bool32 operator == (DATA & data);

public:
	virtual Word32 Convert(Handle type,void * lpdata, Word32 size) = 0;

	Bool32 Save(Handle to);
	Bool32 Restore(Handle from);
	Bool32 SaveCompress(Handle to);
	Bool32 RestoreCompress(Handle from);
	};


#endif
