/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

# ifndef __CTI_LIST_H_
# define __CTI_LIST_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"
#include "ctidefines.h"
#include "ctiimage.h"
#include "ctimemory.h"

#include "ctiimageheader.h"

class CTIImageList
{
private:
	CTIImageHeader           mhFirst;
	CTIImageHeader           mhLast;
public:
	Bool32 DeleteImage(const char * lpName);
	Bool32 GetImage(const char *lpName, PHandle phDIB);
	Bool32 AddImage(const char *lpName, Handle hDIB, Word32 wFlag);
	Bool32           FindHandle(Handle hImage);
	CTIImageList();
	~CTIImageList();

private:
	CTIImageHeader * Begin(void) { return &mhFirst; };
	CTIImageHeader * End(void)   { return &mhLast; };
	CTIImageHeader * FindImage(const char *lpName, CTIImageHeader ** Prev = NULL);

public:
	Bool32 EnableMask(const char *pName, PChar8 pType, Bool32 Type);
	Bool32 GetImageReadMask(const char *lpName, PPCTIMask ppMask, PBool32 pEnMask);
	Bool32 GetImageWriteMask(const char *lpNmae, PPCTIMask ppWMask, PBool32 pEnMask);
	Bool32 SetImageReadMask(const char *lpName, PCTIMask pAMask);
	Bool32 SetImageWriteMask(const char *lpName, PCTIMask pWMask);

};
# endif    //__CTI_LIST_H_
//////////////////////////////////////////////////////////////////////////////////////////////////////////
// end of file
