/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "cs" locale.
 */
public class LocalizedNamesImpl_cs extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "CZ",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "VI",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AU",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BY",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BR",
        "VG",
        "IO",
        "BN",
        "BG",
        "BF",
        "BI",
        "EA",
        "CP",
        "CK",
        "TD",
        "ME",
        "CZ",
        "CN",
        "DK",
        "CD",
        "DG",
        "DM",
        "DO",
        "DJ",
        "EG",
        "EC",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "FO",
        "FK",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GF",
        "TF",
        "PF",
        "GA",
        "GM",
        "GH",
        "GI",
        "GD",
        "GL",
        "GE",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HN",
        "HK",
        "CL",
        "HR",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IT",
        "IL",
        "JM",
        "JP",
        "YE",
        "JE",
        "ZA",
        "GS",
        "KR",
        "JO",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "QA",
        "KZ",
        "KE",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CR",
        "CU",
        "KW",
        "CY",
        "KG",
        "LS",
        "LB",
        "LR",
        "LY",
        "LA",
        "LI",
        "LT",
        "LV",
        "LU",
        "MO",
        "MK",
        "MG",
        "HU",
        "MV",
        "MY",
        "MW",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MU",
        "MR",
        "YT",
        "UM",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "DE",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "AN",
        "NL",
        "NF",
        "NO",
        "NC",
        "NZ",
        "OM",
        "BV",
        "IM",
        "TC",
        "HM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "CI",
        "PL",
        "PR",
        "PT",
        "AT",
        "RE",
        "GQ",
        "RO",
        "RU",
        "RW",
        "GR",
        "WS",
        "SM",
        "SA",
        "SN",
        "KP",
        "MP",
        "SC",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "AE",
        "US",
        "RS",
        "CS",
        "LK",
        "CF",
        "SD",
        "SR",
        "SJ",
        "SH",
        "LC",
        "BL",
        "KN",
        "MF",
        "PM",
        "VA",
        "ST",
        "VC",
        "SZ",
        "SY",
        "SB",
        "ES",
        "SE",
        "CH",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "UY",
        "UZ",
        "CX",
        "VU",
        "GB",
        "VE",
        "VN",
        "QO",
        "TL",
        "WF",
        "ZM",
        "EH",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Svět");
    namesMap.put("002", "Afrika");
    namesMap.put("005", "Jižní Amerika");
    namesMap.put("009", "Oceánie");
    namesMap.put("011", "Západní Afrika");
    namesMap.put("013", "Střední Amerika");
    namesMap.put("014", "Východní Afrika");
    namesMap.put("015", "Severní Afrika");
    namesMap.put("017", "Střední Afrika");
    namesMap.put("018", "Jižní Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Severní Amerika");
    namesMap.put("029", "Karibik");
    namesMap.put("030", "Východní Asie");
    namesMap.put("034", "Jižní Asie");
    namesMap.put("035", "Jihovýchodní Asie");
    namesMap.put("039", "Jižní Evropa");
    namesMap.put("053", "Austrálie a Nový Zéland");
    namesMap.put("054", "Melanésie");
    namesMap.put("057", "Mikronésie");
    namesMap.put("061", "Polynésie");
    namesMap.put("062", "Jižní a centrální Asie");
    namesMap.put("142", "Asie");
    namesMap.put("143", "Střední Asie");
    namesMap.put("145", "Západní Asie");
    namesMap.put("150", "Evropa");
    namesMap.put("151", "Východní Evropa");
    namesMap.put("154", "Severní Evropa");
    namesMap.put("155", "Západní Evropa");
    namesMap.put("172", "Společenství nezávislých států");
    namesMap.put("200", "Československo");
    namesMap.put("419", "Latinská Amerika a Karibské moře");
    namesMap.put("830", "Normanské ostrovy");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Spojené arabské emiráty");
    namesMap.put("AF", "Afghánistán");
    namesMap.put("AG", "Antigua a Barbuda");
    namesMap.put("AI", "Anguila");
    namesMap.put("AL", "Albánie");
    namesMap.put("AM", "Arménie");
    namesMap.put("AN", "Nizozemské Antily");
    namesMap.put("AQ", "Antarktida");
    namesMap.put("AS", "Americká Samoa");
    namesMap.put("AT", "Rakousko");
    namesMap.put("AU", "Austrálie");
    namesMap.put("AX", "Alandy");
    namesMap.put("AZ", "Ázerbájdžán");
    namesMap.put("BA", "Bosna a Hercegovina");
    namesMap.put("BD", "Bangladéš");
    namesMap.put("BE", "Belgie");
    namesMap.put("BG", "Bulharsko");
    namesMap.put("BH", "Bahrajn");
    namesMap.put("BL", "Svatý Bartoloměj");
    namesMap.put("BM", "Bermudy");
    namesMap.put("BN", "Brunej Darussalam");
    namesMap.put("BO", "Bolívie");
    namesMap.put("BR", "Brazílie");
    namesMap.put("BS", "Bahamy");
    namesMap.put("BT", "Bhútán");
    namesMap.put("BV", "Ostrov Bouvet");
    namesMap.put("BY", "Bělorusko");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokosové ostrovy");
    namesMap.put("CD", "Demokratická republika Kongo");
    namesMap.put("CF", "Středoafrická republika");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Švýcarsko");
    namesMap.put("CI", "Pobřeží slonoviny");
    namesMap.put("CK", "Cookovy ostrovy");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Čína");
    namesMap.put("CO", "Kolumbie");
    namesMap.put("CP", "Clipperton");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CS", "Srbsko a Černá Hora");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kapverdy");
    namesMap.put("CX", "Vánoční ostrovy");
    namesMap.put("CY", "Kypr");
    namesMap.put("CZ", "Česká republika");
    namesMap.put("DE", "Německo");
    namesMap.put("DJ", "Džibuti");
    namesMap.put("DK", "Dánsko");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikánská republika");
    namesMap.put("DZ", "Alžírsko");
    namesMap.put("EA", "Ceuta a Melilla");
    namesMap.put("EC", "Ekvádor");
    namesMap.put("EE", "Estonsko");
    namesMap.put("EH", "Západní Sahara");
    namesMap.put("ES", "Španělsko");
    namesMap.put("ET", "Etiopie");
    namesMap.put("EU", "Evropská unie");
    namesMap.put("FI", "Finsko");
    namesMap.put("FJ", "Fidži");
    namesMap.put("FK", "Falklandské ostrovy");
    namesMap.put("FM", "Mikronézie");
    namesMap.put("FO", "Faerské ostrovy");
    namesMap.put("FR", "Francie");
    namesMap.put("GB", "Velká Británie");
    namesMap.put("GE", "Gruzie");
    namesMap.put("GF", "Francouzská Guyana");
    namesMap.put("GL", "Grónsko");
    namesMap.put("GM", "Gambie");
    namesMap.put("GQ", "Rovníková Guinea");
    namesMap.put("GR", "Řecko");
    namesMap.put("GS", "Jižní Georgie a Jižní Sandwichovy ostrovy");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "Ostrovy Heard a McDonald");
    namesMap.put("HR", "Chorvatsko");
    namesMap.put("HU", "Maďarsko");
    namesMap.put("IC", "Kanárské ostrovy");
    namesMap.put("ID", "Indonésie");
    namesMap.put("IE", "Irsko");
    namesMap.put("IL", "Izrael");
    namesMap.put("IM", "Ostrov Man");
    namesMap.put("IN", "Indie");
    namesMap.put("IO", "Britské území v Indickém oceánu");
    namesMap.put("IQ", "Irák");
    namesMap.put("IR", "Írán");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Itálie");
    namesMap.put("JM", "Jamajka");
    namesMap.put("JO", "Jordánsko");
    namesMap.put("JP", "Japonsko");
    namesMap.put("KE", "Keňa");
    namesMap.put("KG", "Kyrgyzstán");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KM", "Komory");
    namesMap.put("KN", "Svatý Kitts a Nevis");
    namesMap.put("KP", "Severní Korea");
    namesMap.put("KR", "Jižní Korea");
    namesMap.put("KW", "Kuvajt");
    namesMap.put("KY", "Kajmanské ostrovy");
    namesMap.put("KZ", "Kazachstán");
    namesMap.put("LA", "Lidově demokratická republika Laos");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "Svatá Lucie");
    namesMap.put("LI", "Lichtenštejnsko");
    namesMap.put("LK", "Srí Lanka");
    namesMap.put("LR", "Libérie");
    namesMap.put("LT", "Litva");
    namesMap.put("LU", "Lucembursko");
    namesMap.put("LV", "Lotyšsko");
    namesMap.put("LY", "Libye");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavsko, republika");
    namesMap.put("ME", "Černá Hora");
    namesMap.put("MF", "Svatý Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshallovy ostrovy");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MN", "Mongolsko");
    namesMap.put("MO", "Macao");
    namesMap.put("MP", "Severní Mariany");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Mauritánie");
    namesMap.put("MU", "Mauricius");
    namesMap.put("MV", "Maladivy");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MY", "Malajsie");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NA", "Namibie");
    namesMap.put("NC", "Nová Kaledonie");
    namesMap.put("NF", "Norfolk");
    namesMap.put("NG", "Nigérie");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Nizozemsko");
    namesMap.put("NO", "Norsko");
    namesMap.put("NP", "Nepál");
    namesMap.put("NZ", "Nový Zéland");
    namesMap.put("OM", "Omán");
    namesMap.put("PF", "Francouzská Polynésie");
    namesMap.put("PG", "Papua-Nová Guinea");
    namesMap.put("PH", "Filipíny");
    namesMap.put("PK", "Pákistán");
    namesMap.put("PL", "Polsko");
    namesMap.put("PM", "Svatý Pierre a Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Portoriko");
    namesMap.put("PS", "Palestinian Territory");
    namesMap.put("PT", "Portugalsko");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Vnější Oceánie");
    namesMap.put("RO", "Rumunsko");
    namesMap.put("RS", "Srbsko");
    namesMap.put("RU", "Rusko");
    namesMap.put("SA", "Saúdská Arábie");
    namesMap.put("SB", "Šalamounovy ostrovy");
    namesMap.put("SC", "Seychely");
    namesMap.put("SD", "Súdán");
    namesMap.put("SE", "Švédsko");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Svatá Helena");
    namesMap.put("SI", "Slovinsko");
    namesMap.put("SJ", "Svalbard a Jan Mayen");
    namesMap.put("SK", "Slovensko");
    namesMap.put("SO", "Somálsko");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Svatý Tomáš");
    namesMap.put("SY", "Sýrie");
    namesMap.put("SZ", "Svazijsko");
    namesMap.put("TC", "Ostrovy Caicos a Turks");
    namesMap.put("TD", "Čad");
    namesMap.put("TF", "Francouzská jižní teritoria");
    namesMap.put("TH", "Thajsko");
    namesMap.put("TJ", "Tádžikistán");
    namesMap.put("TL", "Východní Timor");
    namesMap.put("TM", "Turkmenistán");
    namesMap.put("TN", "Tunisko");
    namesMap.put("TR", "Turecko");
    namesMap.put("TT", "Trinidad a Tobago");
    namesMap.put("TW", "Tchaj-wan");
    namesMap.put("TZ", "Tanzanie");
    namesMap.put("UA", "Ukrajina");
    namesMap.put("UM", "Menší odlehlé ostrovy USA");
    namesMap.put("US", "Spojené státy");
    namesMap.put("UZ", "Uzbekistán");
    namesMap.put("VA", "Svatý stolec");
    namesMap.put("VC", "Svatý Vincent a Grenadiny");
    namesMap.put("VG", "Britské Panenské ostrovy");
    namesMap.put("VI", "Americké Panenské ostrovy");
    namesMap.put("WF", "Wallis a Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Jihoafrická republika");
    namesMap.put("ZM", "Zambie");
    namesMap.put("ZZ", "Neznámá nebo neplatná oblast");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Svět",
        "002": "Afrika",
        "005": "Jižní Amerika",
        "009": "Oceánie",
        "011": "Západní Afrika",
        "013": "Střední Amerika",
        "014": "Východní Afrika",
        "015": "Severní Afrika",
        "017": "Střední Afrika",
        "018": "Jižní Afrika",
        "019": "Amerika",
        "021": "Severní Amerika",
        "029": "Karibik",
        "030": "Východní Asie",
        "034": "Jižní Asie",
        "035": "Jihovýchodní Asie",
        "039": "Jižní Evropa",
        "053": "Austrálie a Nový Zéland",
        "054": "Melanésie",
        "057": "Mikronésie",
        "061": "Polynésie",
        "062": "Jižní a centrální Asie",
        "142": "Asie",
        "143": "Střední Asie",
        "145": "Západní Asie",
        "150": "Evropa",
        "151": "Východní Evropa",
        "154": "Severní Evropa",
        "155": "Západní Evropa",
        "172": "Společenství nezávislých států",
        "200": "Československo",
        "419": "Latinská Amerika a Karibské moře",
        "830": "Normanské ostrovy",
        "AC": "Ascension",
        "AE": "Spojené arabské emiráty",
        "AF": "Afghánistán",
        "AG": "Antigua a Barbuda",
        "AI": "Anguila",
        "AL": "Albánie",
        "AM": "Arménie",
        "AN": "Nizozemské Antily",
        "AQ": "Antarktida",
        "AS": "Americká Samoa",
        "AT": "Rakousko",
        "AU": "Austrálie",
        "AX": "Alandy",
        "AZ": "Ázerbájdžán",
        "BA": "Bosna a Hercegovina",
        "BD": "Bangladéš",
        "BE": "Belgie",
        "BG": "Bulharsko",
        "BH": "Bahrajn",
        "BL": "Svatý Bartoloměj",
        "BM": "Bermudy",
        "BN": "Brunej Darussalam",
        "BO": "Bolívie",
        "BR": "Brazílie",
        "BS": "Bahamy",
        "BT": "Bhútán",
        "BV": "Ostrov Bouvet",
        "BY": "Bělorusko",
        "CA": "Kanada",
        "CC": "Kokosové ostrovy",
        "CD": "Demokratická republika Kongo",
        "CF": "Středoafrická republika",
        "CG": "Kongo",
        "CH": "Švýcarsko",
        "CI": "Pobřeží slonoviny",
        "CK": "Cookovy ostrovy",
        "CM": "Kamerun",
        "CN": "Čína",
        "CO": "Kolumbie",
        "CP": "Clipperton",
        "CR": "Kostarika",
        "CS": "Srbsko a Černá Hora",
        "CU": "Kuba",
        "CV": "Kapverdy",
        "CX": "Vánoční ostrovy",
        "CY": "Kypr",
        "CZ": "Česká republika",
        "DE": "Německo",
        "DJ": "Džibuti",
        "DK": "Dánsko",
        "DM": "Dominika",
        "DO": "Dominikánská republika",
        "DZ": "Alžírsko",
        "EA": "Ceuta a Melilla",
        "EC": "Ekvádor",
        "EE": "Estonsko",
        "EH": "Západní Sahara",
        "ES": "Španělsko",
        "ET": "Etiopie",
        "EU": "Evropská unie",
        "FI": "Finsko",
        "FJ": "Fidži",
        "FK": "Falklandské ostrovy",
        "FM": "Mikronézie",
        "FO": "Faerské ostrovy",
        "FR": "Francie",
        "GB": "Velká Británie",
        "GE": "Gruzie",
        "GF": "Francouzská Guyana",
        "GL": "Grónsko",
        "GM": "Gambie",
        "GQ": "Rovníková Guinea",
        "GR": "Řecko",
        "GS": "Jižní Georgie a Jižní Sandwichovy ostrovy",
        "HK": "Hongkong",
        "HM": "Ostrovy Heard a McDonald",
        "HR": "Chorvatsko",
        "HU": "Maďarsko",
        "IC": "Kanárské ostrovy",
        "ID": "Indonésie",
        "IE": "Irsko",
        "IL": "Izrael",
        "IM": "Ostrov Man",
        "IN": "Indie",
        "IO": "Britské území v Indickém oceánu",
        "IQ": "Irák",
        "IR": "Írán",
        "IS": "Island",
        "IT": "Itálie",
        "JM": "Jamajka",
        "JO": "Jordánsko",
        "JP": "Japonsko",
        "KE": "Keňa",
        "KG": "Kyrgyzstán",
        "KH": "Kambodža",
        "KM": "Komory",
        "KN": "Svatý Kitts a Nevis",
        "KP": "Severní Korea",
        "KR": "Jižní Korea",
        "KW": "Kuvajt",
        "KY": "Kajmanské ostrovy",
        "KZ": "Kazachstán",
        "LA": "Lidově demokratická republika Laos",
        "LB": "Libanon",
        "LC": "Svatá Lucie",
        "LI": "Lichtenštejnsko",
        "LK": "Srí Lanka",
        "LR": "Libérie",
        "LT": "Litva",
        "LU": "Lucembursko",
        "LV": "Lotyšsko",
        "LY": "Libye",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Moldavsko, republika",
        "ME": "Černá Hora",
        "MF": "Svatý Martin",
        "MG": "Madagaskar",
        "MH": "Marshallovy ostrovy",
        "MK": "Macedonia",
        "MM": "Myanmar",
        "MN": "Mongolsko",
        "MO": "Macao",
        "MP": "Severní Mariany",
        "MQ": "Martinik",
        "MR": "Mauritánie",
        "MU": "Mauricius",
        "MV": "Maladivy",
        "MX": "Mexiko",
        "MY": "Malajsie",
        "MZ": "Mosambik",
        "NA": "Namibie",
        "NC": "Nová Kaledonie",
        "NF": "Norfolk",
        "NG": "Nigérie",
        "NI": "Nikaragua",
        "NL": "Nizozemsko",
        "NO": "Norsko",
        "NP": "Nepál",
        "NZ": "Nový Zéland",
        "OM": "Omán",
        "PF": "Francouzská Polynésie",
        "PG": "Papua-Nová Guinea",
        "PH": "Filipíny",
        "PK": "Pákistán",
        "PL": "Polsko",
        "PM": "Svatý Pierre a Miquelon",
        "PN": "Pitcairn",
        "PR": "Portoriko",
        "PS": "Palestinian Territory",
        "PT": "Portugalsko",
        "QA": "Katar",
        "QO": "Vnější Oceánie",
        "RO": "Rumunsko",
        "RS": "Srbsko",
        "RU": "Rusko",
        "SA": "Saúdská Arábie",
        "SB": "Šalamounovy ostrovy",
        "SC": "Seychely",
        "SD": "Súdán",
        "SE": "Švédsko",
        "SG": "Singapur",
        "SH": "Svatá Helena",
        "SI": "Slovinsko",
        "SJ": "Svalbard a Jan Mayen",
        "SK": "Slovensko",
        "SO": "Somálsko",
        "SR": "Surinam",
        "ST": "Svatý Tomáš",
        "SY": "Sýrie",
        "SZ": "Svazijsko",
        "TC": "Ostrovy Caicos a Turks",
        "TD": "Čad",
        "TF": "Francouzská jižní teritoria",
        "TH": "Thajsko",
        "TJ": "Tádžikistán",
        "TL": "Východní Timor",
        "TM": "Turkmenistán",
        "TN": "Tunisko",
        "TR": "Turecko",
        "TT": "Trinidad a Tobago",
        "TW": "Tchaj-wan",
        "TZ": "Tanzanie",
        "UA": "Ukrajina",
        "UM": "Menší odlehlé ostrovy USA",
        "US": "Spojené státy",
        "UZ": "Uzbekistán",
        "VA": "Svatý stolec",
        "VC": "Svatý Vincent a Grenadiny",
        "VG": "Britské Panenské ostrovy",
        "VI": "Americké Panenské ostrovy",
        "WF": "Wallis a Futuna",
        "YE": "Jemen",
        "ZA": "Jihoafrická republika",
        "ZM": "Zambie",
        "ZZ": "Neznámá nebo neplatná oblast"
    };
  }-*/;
}
