/**************************************************************************
* Generic, native, relational database
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef TABLECORE_H
#define TABLECORE_H

#include "tabledata.h"

namespace RDB
{

class TableCore
{
public:
    TableCore( TableData* data, uint dims );
    ~TableCore();

public:
    void insert( Row* row );

    Row* find( uint dim, int key ) const;
    Row* find( uint dim, int key, uint otherDim, int otherKey ) const;

    void remove( uint dim, int key );
    void remove( uint dim, int key, uint otherDim, int otherKey );

    void removeAll( uint dim, int key );

    void clear();

private:
    void freeAllBuckets();

    void removeBucket( TableData::Bucket* bucket );

private:
    TableData* m_data;
    uint m_dims;
};

}

#endif
