#!/usr/bin/python
#
#  Authored by Chris Jones <chris.e.jones@gmail.com>
#  Modified by Francesco Fumanti <francesco.fumanti@gmx.net>
#
#  Copyright (C) 2006, 2007, 2008 Chris Jones
#  Copyright (C) 2010 Francesco Fumanti
#
# ------------------------------------------------------------------
#
# This file is part of the python-virtkey library.
#
# python-virtkey is free software: you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# python-virtkey is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with python-virtkey.  If not, see
# <http://www.gnu.org/licenses/>.
#
# ------------------------------------------------------------------
#
# python-virtkey is a python extension for emulating keypresses and
# getting the keyboard geometry from the xserver.
#
# It uses ideas from Fontconfig, libvirtkeys.c, keysym2ucs.c and
# dasher.
#
from distutils.core import setup
from distutils.extension import Extension

import commands

# From http://code.activestate.com/recipes/502261-python-distutils-pkg-config/
def pkgconfig(*packages, **kw):
    flag_map = {'-I': 'include_dirs', '-L': 'library_dirs', '-l': 'libraries'}
    for token in commands.getoutput("pkg-config --libs --cflags %s" % ' '.join(packages)).split():
        if flag_map.has_key(token[:2]):
            kw.setdefault(flag_map.get(token[:2]), []).append(token[2:])
        else: # throw others to extra_link_args
            kw.setdefault('extra_link_args', []).append(token)
    for k, v in kw.iteritems(): # remove duplicated
        kw[k] = list(set(v))
    return kw

setup(
    name="python-virtkey",
    version="0.60.0",
    author = 'Chris Jones',
    author_email = 'chris.e.jones@gmail.com',
    maintainer = 'Ubuntu Core Developers',
    maintainer_email = 'ubuntu-devel-discuss@lists.ubuntu.com',
    url = 'https://launchpad.net/python-virtkey/',
    license = 'LGPL',
    description = 'python extension for emulating keypresses and getting keyboard layout',
    ext_modules=[
        Extension("virtkey", ["src/python-virtkey.c","src/ucs2keysym.c"],
            **pkgconfig('glib-2.0', 'gdk-2.0', 'x11', 'xtst'))]
)
