/*****************************************************************************
 *
 * grail - Gesture Recognition And Instantiation Library
 *
 * Copyright (C) 2010-2012 Canonical Ltd.
 *
 * This library is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#include <grail.h>
#include "grail-inserter.h"
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <malloc.h>
#include <errno.h>
#include <stdlib.h>

#ifndef GRAIL_NO_LEGACY_ABI

void GRAIL_PUBLIC grail_filter_abs_events(struct grail *ge, int usage)
{
	struct grail_impl *x = ge->impl;
	x->filter_abs = usage;
}

int GRAIL_PUBLIC grail_get_contacts(const struct grail *ge,
				    struct grail_contact *touch, int max_touch)
{
	const struct utouch_frame *frame = ge->impl->touch;
	int i;
	if (frame->num_active < max_touch)
		max_touch = frame->num_active;
	for (i = 0; i < max_touch; i++) {
		struct grail_contact *t = &touch[i];
		const struct utouch_contact *ct = frame->active[i];
		t->id = ct->id;
		t->tool_type = ct->tool_type;
		t->pos.x = ct->x;
		t->pos.y = ct->y;
		t->touch_major = ct->touch_major;
		t->touch_minor = ct->touch_minor;
		t->width_major = ct->width_major;
		t->width_minor = ct->width_minor;
		t->angle = ct->orientation;
		t->pressure = ct->pressure;
	}
	return max_touch;
}

#endif
