/*****************************************************************************
 *
 * grail - Gesture Recognition And Instantiation Library
 *
 * Copyright (C) 2010-2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef GRAIL_EVBUF_H
#define GRAIL_EVBUF_H

#define DIM_EVENTS 4096

struct evbuf {
	int head;
	int tail;
	struct input_event buffer[DIM_EVENTS];
};

static inline void evbuf_clear(struct evbuf *evbuf)
{
	evbuf->head = evbuf->tail = 0;
}

static inline int evbuf_empty(const struct evbuf *evbuf)
{
	return evbuf->head == evbuf->tail;
}

static inline void evbuf_put(struct evbuf *evbuf,
			     const struct input_event *ev)
{
	evbuf->buffer[evbuf->head++] = *ev;
	evbuf->head &= DIM_EVENTS - 1;
}

static inline void evbuf_get(struct evbuf *evbuf,
			     struct input_event *ev)
{
	*ev = evbuf->buffer[evbuf->tail++];
	evbuf->tail &= DIM_EVENTS - 1;
}

#endif
