/*****************************************************************************
 *
 * utouch-frame - Touch Frame Library
 *
 * Copyright (C) 2010-2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Henrik Rydberg <rydberg@bitmath.org>
 *
 ****************************************************************************/

static void report_device_caps(utouch_frame_handle fh)
{
	const struct utouch_surface *s = utouch_frame_get_surface(fh);

	fprintf(stderr, "device props:\n");
	if (s->needs_pointer)
		fprintf(stderr, "\tpointer\n");
	if (s->is_direct)
		fprintf(stderr, "\tdirect\n");
	if (s->is_buttonpad)
		fprintf(stderr, "\tbuttonpad\n");
	if (s->is_semi_mt)
		fprintf(stderr, "\tsemi_mt\n");
	fprintf(stderr, "device mt events:\n");
	if (s->use_touch_major)
		fprintf(stderr, "\ttouch_major\n");
	if (s->use_touch_minor)
		fprintf(stderr, "\ttouch_minor\n");
	if (s->use_width_major)
		fprintf(stderr, "\twidth_major\n");
	if (s->use_width_minor)
		fprintf(stderr, "\twidth_minor\n");
	if (s->use_orientation)
		fprintf(stderr, "\torientation\n");
	if (s->use_pressure)
		fprintf(stderr, "\tpressure\n");
	if (s->use_distance)
		fprintf(stderr, "\tdistance\n");
}

static void report_frame(const struct utouch_frame *frame)
{
	int i;

	for (i = 0; i < frame->num_active; i++) {
		const struct utouch_contact *t = frame->active[i];

		fprintf(stderr, "touch %d\n", i);
		fprintf(stderr, "  slot:         %d\n", t->slot);
		fprintf(stderr, "  id:           %d\n", t->id);
		fprintf(stderr, "  tool_type:    %d\n", t->tool_type);
		fprintf(stderr, "  x:            %f\n", t->x);
		fprintf(stderr, "  y:            %f\n", t->y);
		fprintf(stderr, "  touch_major:  %f\n", t->touch_major);
		fprintf(stderr, "  touch_minor:  %f\n", t->touch_minor);
		fprintf(stderr, "  width_major:  %f\n", t->width_major);
		fprintf(stderr, "  width_minor:  %f\n", t->width_minor);
		fprintf(stderr, "  angle:        %f\n", t->orientation);
		fprintf(stderr, "  pressure:     %f\n", t->pressure);
		fprintf(stderr, "  distance:     %f\n", t->distance);
		fprintf(stderr, "  vx:           %f\n", t->vx);
		fprintf(stderr, "  vy:           %f\n", t->vy);
	}

	fprintf(stderr, "sync %d %ld %d %d %d\n",
		frame->num_active,
		frame->time,
		frame->sequence_id,
		frame->revision,
		frame->slot_revision);
}
