# -*- coding: utf-8 -*-

# Author: Diego Sarmentero <diego.sarmentero@gmail.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the Loading Overlay."""

from ubuntuone.controlpanel.gui.qt import loadingoverlay as gui
from ubuntuone.controlpanel.gui.qt.tests import BaseTestCase


class LoadingOverlayTestCase(BaseTestCase):
    """Test the qt control panel."""

    innerclass_ui = gui.loadingoverlay_ui
    innerclass_name = "Ui_Form"
    class_ui = gui.LoadingOverlay

    def assert_status_correct(self):
        """Test if the necessary variables for the animation exists"""
        self.ui.show()
        self.assertTrue(self.ui.counter is not None)
        self.assertTrue(self.ui.orientation is not None)
