# -*- coding: utf-8 -*-
#
# Authors: Natalia B. Bidart <natalia.bidart@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Platform independent tests for the XDG constants."""

import os

from twisted.trial.unittest import TestCase

from ubuntu_sso import xdg_base_directory
from ubuntuone.platform.xdg_base_directory import ubuntuone_log_dir


class TestBaseDirectory(TestCase):
    """Tests for the BaseDirectory module."""

    def test_ubuntuone_log_dir(self):
        """The ubuntuone_log_dir is correct."""
        expected = os.path.join(xdg_base_directory.xdg_cache_home,
                                'ubuntuone', 'log')
        self.assertEqual(expected, ubuntuone_log_dir)
        self.assertTrue(os.path.exists(expected))
