# ubuntuone.platform.windows - windows platform imports
#
# Author: Lucio Torre <lucio.torre@canonical.com>
#         Manuel de la Pena <manuel@canonical.com>
#
# Copyright 2010-11 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Windows import for ubuntuone-client

This module has to have all windows specific modules and provide the api
required to support the windows platform.
"""

platform = "win32"

from ubuntuone.platform.windows.vm_helper import (
    get_udf_path_name,
    get_udf_path,
    get_share_path,
    VMMetadataUpgraderMixIn,
    create_shares_link
)


from ubuntuone.platform.windows.os_helper import (
    access,
    allow_writes,
    listdir,
    make_dir,
    open_file,
    path_exists,
    remove_dir,
    remove_file,
    rename,
    make_link,
    set_dir_readonly,
    set_dir_readwrite,
    set_no_rights,
    set_file_readonly,
    set_file_readwrite,
    stat_path,
)

from ubuntuone.platform.windows import event_logging
from ubuntuone.platform.windows.logger import setup_filesystem_logging, get_filesystem_logger
from ubuntuone.platform.windows.filesystem_notifications import (
    FilesystemMonitor)
from ubuntuone.platform.windows.notification import Notification
