/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __SYNCDAEMON_INTERFACE_H__
#define __SYNCDAEMON_INTERFACE_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_INTERFACE                (syncdaemon_interface_get_type ())
#define SYNCDAEMON_INTERFACE(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_INTERFACE, SyncdaemonInterface))
#define SYNCDAEMON_IS_INTERFACE(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_INTERFACE))
#define SYNCDAEMON_INTERFACE_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_INTERFACE, SyncdaemonInterfaceClass))
#define SYNCDAEMON_IS_INTERFACE_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_INTERFACE))
#define SYNCDAEMON_INTERFACE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_INTERFACE, SyncdaemonInterfaceClass))

typedef struct _SyncdaemonInterfacePrivate SyncdaemonInterfacePrivate;

typedef struct {
	GObject parent;
	SyncdaemonInterfacePrivate *priv;
} SyncdaemonInterface;

typedef struct {
	GObjectClass parent_class;
} SyncdaemonInterfaceClass;

GType    syncdaemon_interface_get_type (void);

GObject *syncdaemon_interface_setup_proxy (SyncdaemonInterface *interface,
					   const gchar *unique_bus_name,
					   const gchar *object_path,
					   const gchar *interface_name);
GObject *syncdaemon_interface_get_proxy_object (SyncdaemonInterface *interface);

G_END_DECLS

#endif
