/* libsyncdaemon-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Syncdaemon", lower_case_cprefix = "syncdaemon_", gir_namespace = "Syncdaemon", gir_version = "1.0")]
namespace Syncdaemon {
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class Authentication : GLib.Object {
		public Syncdaemon.AuthenticationPrivate priv;
		[CCode (has_construct_function = false)]
		public Authentication ();
		public void clear_token ();
		public bool has_credentials ();
		public void login_or_register ();
		public virtual signal void authorization_cancelled ();
		public virtual signal void credentials_found (GLib.Object auth);
		public virtual signal void error (string auth);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class ConfigInterface : Syncdaemon.Interface {
		public Syncdaemon.ConfigInterfacePrivate priv;
		[CCode (has_construct_function = false)]
		public ConfigInterface (Syncdaemon.Daemon daemon);
		public bool get_bandwidth_throttling ();
		public bool get_files_sync ();
		public void get_throttling_limits (int download, int upload);
		public bool get_udf_autosubscribe ();
		public void set_bandwidth_throttling (bool enabled);
		public void set_files_sync (bool enabled);
		public void set_throttling_limits (int download, int upload);
		public void set_udf_autosubscribe (bool enabled);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class Credentials : GLib.Object {
		public Syncdaemon.CredentialsPrivate priv;
		[CCode (has_construct_function = false)]
		public Credentials ();
		[CCode (has_construct_function = false)]
		public Credentials.from_hash_table (GLib.HashTable<weak void*,weak void*> hash);
		public unowned string get_consumer_key ();
		public unowned string get_consumer_secret ();
		public unowned string get_token ();
		public unowned string get_token_secret ();
		public void set_consumer_key (string consumer_key);
		public void set_consumer_secret (string consumer_secret);
		public void set_token (string token);
		public void set_token_secret (string token_secret);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class Daemon : GLib.Object {
		public Syncdaemon.DaemonPrivate priv;
		[CCode (has_construct_function = false)]
		public Daemon ();
		public bool connect ();
		public void create_folder (string path);
		public void create_share (string path, GLib.SList<weak void*> usernames, string name, bool allow_modifications);
		public void delete_folder (string path);
		public void delete_share (string path);
		public bool disconnect ();
		public bool get_bandwidth_throttling ();
		public bool get_files_sync ();
		public unowned string get_root_dir ();
		public void get_throttling_limits (int download, int upload);
		public bool get_udf_autosubscribe ();
		public bool has_network ();
		public bool is_folder_enabled (string path, bool is_root);
		public bool is_ready ();
		public bool publish_file (string path);
		public bool quit ();
		public void set_bandwidth_throttling (bool enabled);
		public void set_files_sync (bool enabled);
		public void set_throttling_limits (int download, int upload);
		public void set_udf_autosubscribe (bool enabled);
		public void subscribe_folder (string path);
		public bool unpublish_file (string path);
		public void unsubscribe_folder (string path);
		public virtual signal void connected ();
		public virtual signal void disconnected ();
		public virtual signal void download_file_progress (string daemon, GLib.Object path);
		public virtual signal void download_finished (string daemon, GLib.Object path);
		public virtual signal void download_started (string daemon);
		public virtual signal void error (string daemon, void* @signal);
		public virtual signal void event (void* daemon);
		public virtual signal void file_published (bool daemon, GLib.Object success);
		public virtual signal void file_unpublished (bool daemon, GLib.Object success);
		public virtual signal void folder_created (bool daemon, GLib.Object success);
		public virtual signal void folder_deleted (bool daemon, GLib.Object success);
		public virtual signal void folder_subscribed (bool daemon, GLib.Object success);
		public virtual signal void folder_unsubscribed (bool daemon, GLib.Object success);
		public virtual signal void quota_exceeded (void* daemon);
		public virtual signal void ready ();
		public virtual signal void share_created (bool daemon, GLib.Object success);
		public virtual signal void share_deleted (bool daemon, GLib.Object success);
		public virtual signal void status_changed (GLib.Object daemon);
		public virtual signal void upload_file_progress (string daemon, GLib.Object path);
		public virtual signal void upload_finished (string daemon, GLib.Object path);
		public virtual signal void upload_started (string daemon);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class EventsInterface : Syncdaemon.Interface {
		public Syncdaemon.EventsInterfacePrivate priv;
		[CCode (has_construct_function = false)]
		public EventsInterface (Syncdaemon.Daemon daemon);
		public void push_event (string event_name, string args);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class FileInfo : GLib.Object {
		public Syncdaemon.FileInfoPrivate priv;
		[CCode (has_construct_function = false)]
		public FileInfo ();
		[CCode (has_construct_function = false)]
		public FileInfo.from_hash_table (GLib.HashTable<weak void*,weak void*> hash);
		public bool get_is_public ();
		public unowned string get_node_id ();
		public unowned string get_path ();
		public unowned string get_public_url ();
		public unowned string get_volume_id ();
		public void set_is_public (bool is_public);
		public void set_node_id (string node_id);
		public void set_path (string path);
		public void set_public_url (string public_url);
		public void set_volume_id (string volume_id);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class FilesystemInterface : Syncdaemon.Interface {
		public Syncdaemon.FilesystemInterfacePrivate priv;
		[CCode (has_construct_function = false)]
		public FilesystemInterface (Syncdaemon.Daemon daemon);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class FolderInfo : GLib.Object {
		public Syncdaemon.FolderInfoPrivate priv;
		[CCode (has_construct_function = false)]
		public FolderInfo ();
		[CCode (has_construct_function = false)]
		public FolderInfo.from_hash_table (GLib.HashTable<weak void*,weak void*> hash);
		public unowned string get_path ();
		public bool get_subscribed ();
		public unowned string get_volume_id ();
		public void set_path (string path);
		public void set_subscribed (bool subscribed);
		public void set_volume_id (string volume_id);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class FoldersInterface : Syncdaemon.Interface {
		public Syncdaemon.FoldersInterfacePrivate priv;
		[CCode (has_construct_function = false)]
		public FoldersInterface (Syncdaemon.Daemon daemon);
		public void create (string path);
		public void @delete (string folder_id);
		public void refresh_volumes ();
		public void subscribe (string folder_id);
		public void unsubscribe (string folder_id);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class Interface : GLib.Object {
		public Syncdaemon.InterfacePrivate priv;
		[NoAccessorMethod]
		public Syncdaemon.Daemon daemon { get; set construct; }
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class Metadata : GLib.Object {
		public Syncdaemon.MetadataPrivate priv;
		[CCode (has_construct_function = false)]
		public Metadata ();
		[CCode (has_construct_function = false)]
		public Metadata.from_hash_table (GLib.HashTable<weak void*,weak void*> hash);
		public bool get_is_synced ();
		public unowned string get_local_hash ();
		public unowned string get_node_id ();
		public unowned string get_path ();
		public unowned string get_server_hash ();
		public unowned string get_share_id ();
		public void set_is_synced (bool is_synced);
		public void set_local_hash (string local_hash);
		public void set_node_id (string node_id);
		public void set_path (string path);
		public void set_server_hash (string server_hash);
		public void set_share_id (string share_id);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class PublicfilesInterface : Syncdaemon.Interface {
		public Syncdaemon.PublicfilesInterfacePrivate priv;
		[CCode (has_construct_function = false)]
		public PublicfilesInterface (Syncdaemon.Daemon daemon);
		public void change_public_access (string share_id, string node_id, bool is_public);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class ShareInfo : GLib.Object {
		public Syncdaemon.ShareInfoPrivate priv;
		[CCode (has_construct_function = false)]
		public ShareInfo ();
		[CCode (has_construct_function = false)]
		public ShareInfo.from_hash_table (GLib.HashTable<weak void*,weak void*> hash);
		public bool get_accepted ();
		public bool get_allow_modifications ();
		public unowned string get_name ();
		public unowned string get_node_id ();
		public unowned string get_path ();
		public Syncdaemon.ShareInfoType get_share_type ();
		public unowned string get_user_visible_name ();
		public unowned string get_username ();
		public unowned string get_volume_id ();
		public void set_accepted (bool accepted);
		public void set_allow_modifications (bool allow_modifications);
		public void set_name (string name);
		public void set_node_id (string node_id);
		public void set_path (string path);
		public void set_share_type (Syncdaemon.ShareInfoType type);
		public void set_user_visible_name (string user_visible_name);
		public void set_username (string username);
		public void set_volume_id (string volume_id);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class SharesInterface : Syncdaemon.Interface {
		public Syncdaemon.SharesInterfacePrivate priv;
		[CCode (has_construct_function = false)]
		public SharesInterface (Syncdaemon.Daemon daemon);
		public void accept (string share_id);
		public void create (string path, GLib.SList<weak void*> usernames, string name, bool allow_modifications);
		public void @delete (string path);
		public void refresh ();
		public void reject (string share_id);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class StatusInfo : GLib.Object {
		public Syncdaemon.StatusInfoPrivate priv;
		[CCode (has_construct_function = false)]
		public StatusInfo ();
		[CCode (has_construct_function = false)]
		public StatusInfo.from_hash_table (GLib.HashTable<weak void*,weak void*> hash);
		public bool get_connected ();
		public unowned string get_connection ();
		public unowned string get_description ();
		public unowned string get_name ();
		public bool get_online ();
		public unowned string get_queues ();
		public void set_connected (bool connected);
		public void set_connection (string connection);
		public void set_description (string description);
		public void set_name (string name);
		public void set_online (bool connected);
		public void set_queues (string queues);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class StatusInterface : Syncdaemon.Interface {
		public Syncdaemon.StatusInterfacePrivate priv;
		[CCode (has_construct_function = false)]
		public StatusInterface (Syncdaemon.Daemon daemon);
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public class TransferInfo : GLib.Object {
		public Syncdaemon.TransferInfoPrivate priv;
		[CCode (has_construct_function = false)]
		public TransferInfo (string path);
		[CCode (has_construct_function = false)]
		public TransferInfo.from_hash_table (GLib.HashTable<weak void*,weak void*> hash);
		public long get_bytes_transferred ();
		public unowned string get_node_id ();
		public unowned string get_path ();
		public unowned string get_share_id ();
		public long get_total_size ();
		public void set_bytes_transferred (long bytes);
		public void set_node_id (string node_id);
		public void set_path (string path);
		public void set_share_id (string share_id);
		public void set_total_size (long bytes);
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_AUTHENTICATION_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct AuthenticationPrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_CONFIG_INTERFACE_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct ConfigInterfacePrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_CREDENTIALS_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct CredentialsPrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_DAEMON_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct DaemonPrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_EVENTS_INTERFACE_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct EventsInterfacePrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_FILE_INFO_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct FileInfoPrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_FILESYSTEM_INTERFACE_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct FilesystemInterfacePrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_FOLDER_INFO_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct FolderInfoPrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_FOLDERS_INTERFACE_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct FoldersInterfacePrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_INTERFACE_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct InterfacePrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_METADATA_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct MetadataPrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_PUBLICFILES_INTERFACE_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct PublicfilesInterfacePrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_SHARE_INFO_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct ShareInfoPrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_SHARES_INTERFACE_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct SharesInterfacePrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_STATUS_INFO_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct StatusInfoPrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_STATUS_INTERFACE_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct StatusInterfacePrivate {
	}
	[CCode (type_id = "SYNCDAEMON_TYPE_TRANSFER_INFO_PRIVATE", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public struct TransferInfoPrivate {
	}
	[CCode (cprefix = "SYNCDAEMON_SHARE_INFO_TYPE_", cheader_filename = "libsyncdaemon/libsyncdaemon.h")]
	public enum ShareInfoType {
		UNKNOWN,
		SHARED,
		SHARE
	}
	[CCode (cheader_filename = "libsyncdaemon/libsyncdaemon.h", instance_pos = 3.9)]
	public delegate void GotMetadataFunc (Syncdaemon.FilesystemInterface @interface, bool success, Syncdaemon.Metadata metadata);
}
