/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibEList" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/libedataserver-ctypes.jsm");
Cu.import("resource://edsintegration/LibGLib.jsm");

XPCOMUtils.defineLazyGetter(this, "EList", function() {
  return ctypes.StructType("EList");
});

XPCOMUtils.defineLazyGetter(this, "EIterator", function() {
  return ctypes.StructType("EIterator");
});

XPCOMUtils.defineLazyGetter(this, "e_list_get_iterator", function() {
  var e_list_get_iterator =
    libedataserver.declare("e_list_get_iterator",
                           ctypes.default_abi,
                           EIterator.ptr,
                           EList.ptr);
  if (!e_list_get_iterator)
    throw "e_list_get_iterator is unavailable";

  return e_list_get_iterator;
});

XPCOMUtils.defineLazyGetter(this, "e_iterator_is_valid", function() {
  var e_iterator_is_valid =
    libedataserver.declare("e_iterator_is_valid",
                           ctypes.default_abi,
                           LibGLib.gboolean,
                           EIterator.ptr);
  if (!e_iterator_is_valid)
    throw "e_iterator_is_valid is unavailable";

  return e_iterator_is_valid;
});

XPCOMUtils.defineLazyGetter(this, "e_iterator_next", function() {
  var e_iterator_next =
    libedataserver.declare("e_iterator_next",
                           ctypes.default_abi,
                           LibGLib.gboolean,
                           EIterator.ptr);
  if (!e_iterator_next)
    throw "e_iterator_next is unavailable";

  return e_iterator_next;
});

XPCOMUtils.defineLazyGetter(this, "e_iterator_get", function() {
  var e_iterator_get =
    libedataserver.declare("e_iterator_get",
                           ctypes.default_abi,
                           LibGLib.gconstpointer,
                           EIterator.ptr);
  if (!e_iterator_get)
    throw "e_iterator_get is unavailable";

  return e_iterator_get;
});


var LibEList = {
  EList: EList,

  iterator: function LEL_iterator(aEList) {
    let iter = e_list_get_iterator(aEList);

    for (let i = iter; e_iterator_is_valid(i); e_iterator_next(i))
      yield e_iterator_get(i);

    yield null;
  }
}
