/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibEBookClient" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/LibGLib.jsm");

Cu.import("resource://edsintegration/libebook-ctypes.jsm");

Cu.import("resource://edsintegration/LibEBookQuery.jsm");
Cu.import("resource://edsintegration/LibESourceGroup.jsm");
Cu.import("resource://edsintegration/LibESourceList.jsm");
Cu.import("resource://edsintegration/LibESource.jsm");
Cu.import("resource://edsintegration/LibEBookClientView.jsm");
Cu.import("resource://edsintegration/LibEContact.jsm");
Cu.import("resource://edsintegration/LibEList.jsm");
Cu.import("resource://edsintegration/LibGCancellable.jsm");
Cu.import("resource://edsintegration/LibGAsyncResult.jsm");

XPCOMUtils.defineLazyGetter(this, "EBookClient", function() {
  return ctypes.StructType("EBookClient");
});

XPCOMUtils.defineLazyGetter(this, "e_book_add_contact", function() {
var e_book_add_contact =
  libebook.declare("e_book_add_contact",
                   ctypes.default_abi,
                   LibGLib.gboolean,
                   EBookClient.ptr,
                   LibEContact.EContact.ptr,
                   LibGLib.GError.ptr.ptr);
if (!e_book_add_contact)
  throw "e_book_add_contact is unavailable";

return e_book_add_contact;
});


XPCOMUtils.defineLazyGetter(this, "e_book_commit_contact", function() {
var e_book_commit_contact =
  libebook.declare("e_book_commit_contact",
                   ctypes.default_abi,
                   LibGLib.gboolean,
                   EBookClient.ptr,
                   LibEContact.EContact.ptr,
                   LibGLib.GError.ptr.ptr);
if (!e_book_commit_contact)
  throw "e_book_commit_contact is unavailable";

return e_book_commit_contact;
});

XPCOMUtils.defineLazyGetter(this, "e_book_client_add_contact_sync", function() {
  var e_book_client_add_contact_sync =
    libebook.declare("e_book_client_add_contact_sync",
                     ctypes.default_abi,
                     LibGLib.gboolean,
                     EBookClient.ptr,
                     LibEContact.EContact.ptr,
                     LibGLib.gchar.ptr.ptr,
                     LibGCancellable.GCancellable.ptr,
                     LibGLib.GError.ptr.ptr);
  if (!e_book_client_add_contact_sync)
    throw "e_book_client_add_contact_sync is unavailable";

  return e_book_client_add_contact_sync;
});


XPCOMUtils.defineLazyGetter(this, "e_book_client_new_system", function() {
  var e_book_client_new_system =
    libebook.declare("e_book_client_new_system",
                     ctypes.default_abi,
                     EBookClient.ptr,
                     LibGLib.GError.ptr.ptr);

    if (!e_book_client_new_system)
      throw "e_book_client_new_system is unavailable";

    return e_book_client_new_system;
});


XPCOMUtils.defineLazyGetter(this, "e_book_client_get_sources", function() {
  var e_book_client_get_sources =
    libebook.declare("e_book_client_get_sources",
                     ctypes.default_abi,
                     LibGLib.gboolean,
                     LibESourceList.ESourceList.ptr.ptr,
                     LibGLib.GError.ptr.ptr);
  if (!e_book_client_get_sources)
    throw "e_book_client_get_sources is unavailable";

  return e_book_client_get_sources;
});

XPCOMUtils.defineLazyGetter(this, "e_book_client_get_view", function() {
  var e_book_client_get_view =
    libebook.declare("e_book_client_get_view",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EBookClient.ptr,
                     LibGLib.gchar.ptr,
                     LibGCancellable.GCancellable.ptr,
                     LibGAsyncResult.GAsyncReadyCallback,
                     LibGLib.gpointer);

  if (!e_book_client_get_view)
    throw "e_book_client_get_view is unavailable";

  return e_book_client_get_view;
});

XPCOMUtils.defineLazyGetter(this, "e_book_client_get_view_finish", function() {
  var e_book_client_get_view_finish =
    libebook.declare("e_book_client_get_view_finish",
                     ctypes.default_abi,
                     LibGLib.gboolean,
                     EBookClient.ptr,
                     LibGAsyncResult.GAsyncResult.ptr,
                     LibEBookClientView.EBookClientView.ptr.ptr,
                     LibGLib.GError.ptr.ptr);

  if (!e_book_client_get_view_finish)
    throw "e_book_client_get_view_finish is unavailable";

  return e_book_client_get_view_finish;
});


XPCOMUtils.defineLazyGetter(this, "e_book_client_modify_contact", function() {
  var e_book_client_modify_contact =
    libebook.declare("e_book_client_modify_contact",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EBookClient.ptr,
                     LibEContact.EContact.ptr,
                     LibGCancellable.GCancellable.ptr,
                     LibGAsyncResult.GAsyncReadyCallback,
                     LibGLib.gpointer);

  if (!e_book_client_modify_contact)
    throw "e_book_client_modify_contact is unavailable";

  return e_book_client_modify_contact;
});


XPCOMUtils.defineLazyGetter(this, "e_book_client_modify_contact_finish", function() {
  var e_book_client_modify_contact_finish =
    libebook.declare("e_book_client_modify_contact_finish",
                     ctypes.default_abi,
                     LibGLib.gboolean,
                     EBookClient.ptr,
                     LibGAsyncResult.GAsyncResult.ptr,
                     LibGLib.GError.ptr.ptr);

  if (!e_book_client_modify_contact_finish)
    throw "e_book_client_modify_contact_finish is unavailable";

  return e_book_client_modify_contact_finish;
});


XPCOMUtils.defineLazyGetter(this, "e_book_client_modify_contact_sync", function() {
  var e_book_client_modify_contact_sync =
    libebook.declare("e_book_client_modify_contact_sync",
                     ctypes.default_abi,
                     LibGLib.gboolean,
                     EBookClient.ptr,
                     LibEContact.EContact.ptr,
                     LibGCancellable.GCancellable.ptr,
                     LibGLib.GError.ptr.ptr);

  if (!e_book_client_modify_contact_sync)
    throw "e_book_client_modify_contact_sync is unavailable";

  return e_book_client_modify_contact_sync;
});



XPCOMUtils.defineLazyGetter(this, "e_book_client_new", function() {
  var e_book_client_new =
    libebook.declare("e_book_client_new",
                     ctypes.default_abi,
                     EBookClient.ptr,
                     LibESource.ESource.ptr,
                     LibGLib.GError.ptr.ptr);
  if (!e_book_client_new)
    throw "e_book_client_new is unavailable";

  return e_book_client_new;
});


XPCOMUtils.defineLazyGetter(this, "e_book_client_remove_contact", function() {
  var e_book_client_remove_contact =
    libebook.declare("e_book_client_remove_contact",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EBookClient.ptr,
                     LibEContact.EContact.ptr,
                     LibGCancellable.GCancellable.ptr,
                     LibGAsyncResult.GAsyncReadyCallback,
                     LibGLib.gpointer);

  if (!e_book_client_remove_contact)
    throw "e_book_client_remove_contact is unavailable";

  return e_book_client_remove_contact;
});


XPCOMUtils.defineLazyGetter(this, "e_book_client_remove_contact_finish", function() {
  var e_book_client_remove_contact_finish =
    libebook.declare("e_book_client_remove_contact_finish",
                     ctypes.default_abi,
                     LibGLib.gboolean,
                     EBookClient.ptr,
                     LibGAsyncResult.GAsyncResult.ptr,
                     LibGLib.GError.ptr.ptr);

  if (!e_book_client_remove_contact_finish)
    throw "e_book_client_remove_contact_finish is unavailable";

  return e_book_client_remove_contact_finish;
});


var LibEBookClient = {
  _addressbooks_ptr: null,
  EBookClient: EBookClient,

  addContactSync: function LEB_addContact(aEBookClient, aEContact, aUidPtr,
                                          aCancellable, aErrPtr) {
    return e_book_client_add_contact_sync(aEBookClient, aEContact, aUidPtr,
                                          aCancellable, aErrPtr)
           == LibGLib.TRUE;
  },

  commit: function LEB_commit(aEBook, aEContact, aError) {
    return e_book_commit_contact(aEBook, aEContact, aError) == LibGLib.TRUE;
  },

  getSources: function LEBC_getSources(aListPtr, aErrPtr) {
    return e_book_client_get_sources(aListPtr, aErrPtr) == LibGLib.TRUE;
  },

  getView: function LEBC_getView(aEBookClient, aQuery, aCancellable,
                                 aCallback, aData) {
    return e_book_client_get_view(aEBookClient, aQuery, aCancellable,
                                  aCallback, aData);
  },

  getViewFinish: function LEBC_getViewFinish(aEBookClient, aResult,
                                             aBookClientViewPtr,
                                             aErrorPtr) {

    return e_book_client_get_view_finish(aEBookClient, aResult,
                                         aBookClientViewPtr,
                                         aErrorPtr) == LibGLib.TRUE;
  },

  modifyContact: function LEBC_modifyContact(aEBookClient, aEContact, aCancellable,
                                             aCallback, aData) {
    return e_book_client_modify_contact(aEBookClient, aEContact, aCancellable,
                                        aCallback, aData);
  },

  modifyContactFinish: function LEBC_modifyContactFinish(aEBookClient, aAsyncResult,
                                                         aErrPtr) {
    return e_book_client_modify_contact_finish(aEBookClient, aAsyncResult, aErrPtr)
           == LibGLib.TRUE;
  },

  modifyContactSync: function LEBC_modifyContactSync(aEBookClient, aEContact,
                                                     aCancellable,
                                                     aErrPtr) {
    return e_book_client_modify_contact_sync(aEBookClient, aEContact,
                                             aCancellable, aErrPtr)
           == LibGLib.TRUE;
  },

  newFromSource: function LEBC_newFromSource(aEsource, aErrorPtr) {
    let client = e_book_client_new(aEsource, aErrorPtr);
    if (!client)
      throw("Could not create EBookClient");
    return client;
  },

  newSystem: function LEBC_newSystem(aErrPtr) {
    return e_book_client_new_system(aErrPtr);
  },

  removeContact: function LEBC_removeContact(aEBookClient, aEContact, aCancellable,
                                             aCallback, aData) {
    return e_book_client_remove_contact(aEBookClient, aEContact, aCancellable,
                                        aCallback, aData);
  },

  removeContactFinish: function LEBC_removeContactFinish(aEBookClient, aAsyncResult,
                                                         aErrPtr) {
    return e_book_client_remove_contact_finish(aEBookClient, aAsyncResult,
                                               aErrPtr) == LibGLib.TRUE;
  }
}
