/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */


Components.utils.import("resource://gre/modules/Services.jsm");
Components.utils.import("resource://edsintegration/EDSPhotoHandlers.jsm");
Components.utils.import("resource://edsintegration/nsAbEDSCommon.jsm");
Components.utils.import("resource:///modules/iteratorUtils.jsm");
Components.utils.import("resource://edsintegration/EDSFieldMappers.jsm");
Components.utils.import("resource://edsintegration/nsAbEDSEmailAddress.jsm");
Components.utils.import("resource://edsintegration/nsAbEDSPhone.jsm");
Components.utils.import("resource://edsintegration/nsAbEDSIMAccount.jsm");

var EDSContactEditor = {
  MAX_EMAILS: 4,
  MAX_PHONES: 8,
  MAX_IM_ACCOUNTS: 4,
  NORMAL_ONLY_FIELDS: ["PrimaryEmailContainer",
                       "SecondaryEmailContainer",
                       "customFields",
                       "WebPage1Container",
                       "WebPage2Container",
                       "PreferDisplayNameContainer",
                       "PhoneNumbers",
                       "ScreenNameContainer",
                       "allowRemoteContent",
                      ],

  EDS_ONLY_FIELDS: ["telephoneTabButton",
                    "abTelephoneTab",
                    "IMTabButton",
                    "abIMTab",
                    "webAddressesTabButton",
                    "abWebAddressesTab",
                    "HomePOBox-Label",
                    "HomePOBox",
                    "SpouseContainer",
                    "ProfessionContainer",
                    "ManagerAssistantContainer",
                    "WorkPOBox-Label",
                    "WorkPOBox",
                    "OtherAddressContainer",
                    "EDSPhotoContainer",
                    "emailAddresses",
                   ],

  CARD_FIELDS: [
                 ["HomePOBox", "HomePOBox"],
                 ["HomePage", "HomePage"],
                 ["Blog", "Blog"],
                 ["Calendar", "Calendar"],
                 ["FreeBusy", "FreeBusy"],
                 ["VideoChat", "VideoChat"],
                 ["Spouse", "Spouse"],
                 ["Profession", "Profession"],
                 ["Manager", "Manager"],
                 ["Assistant", "Assistant"],
                 ["WorkPOBox", "WorkPOBox"],
                 ["WorkOffice", "WorkOffice"],
                 ["OtherAddress", "OtherAddress"],
                 ["OtherAddress2", "OtherAddress2"],
                 ["OtherCity", "OtherCity"],
                 ["OtherState", "OtherState"],
                 ["OtherZipCode", "OtherZipCode"],
                 ["OtherCountry", "OtherCountry"],
                 ["OtherPOBox", "OtherPOBox"],
               ],

  get bundle() {
    if (EDSContactEditor._bundle)
      return EDSContactEditor._bundle;

    EDSContactEditor._bundle = Services.strings.createBundle("chrome://edsintegration/locale/contactEditor.properties");
    return EDSContactEditor._bundle;
  },

  getString: function getString(aStringName) {
    try {
      return EDSContactEditor.bundle.GetStringFromName(aStringName);
    }
    catch (e) {
      Services.console.logStringMessage(e.message);
    }
    return "";
  },

  onLoad: function EDSCE_onLoad() {
    // RegisterLoadListener and RegisterSaveListener
    // are defined in abCardOverlay.js
    RegisterLoadListener(EDSContactEditor.onLoadCard);
  },

  onLoadCard: function EDSCE_onLoadCard(aCard, aDocument) {
    // If this isn't an EDS card...
    if (!(aCard instanceof Components.interfaces.nsIAbEDSCard)) {
      LOG("Opened a regular card - EDSContactEditor going inert.");
      // Not an nsIAbEDSCard, bail out...
      EDSContactEditor.goInert(aDocument);
      return;
    }
    EDSContactEditor.goActive(aDocument, aCard.parentDirectory);
    EDSContactEditor.populateEDSFields(aCard, aDocument);
  },

  onSaveCard: function EDSCE_onSaveCard(aCard, aDocument) {
    if (!(aCard instanceof Components.interfaces.nsIAbEDSCard)) {
      ERROR("Could not convert nsIAbCard to nsIAbEDSCard");
      return;
    }

    // Get basic string values
    for (var i = 0; i < EDSContactEditor.CARD_FIELDS.length; i++) {
      let field = aDocument.getElementById(EDSContactEditor.CARD_FIELDS[i][1]);
      aCard.setProperty(EDSContactEditor.CARD_FIELDS[i][0], field.value);
    }

    // Get email address values
    let newEmails = [];
    for (let i = 0; i < EDSContactEditor.MAX_EMAILS; i++) {
      let fieldKey = "emailField-" + (i + 1);
      let type = aDocument.getElementById(fieldKey + "-Type").value;
      let address = aDocument.getElementById(fieldKey).value;
      if (address) {
        let EDSEmail = new nsAbEDSEmailAddress();
        EDSEmail.type = type;
        EDSEmail.address = address;
        newEmails.push(EDSEmail);
      }
    }
    aCard.setEmailAddrs(newEmails.length, newEmails);

    // Get phone values
    let newPhones = [];
    for (let i = 0; i < EDSContactEditor.MAX_PHONES; i++) {
      let fieldKey = "telephoneField-" + (i + 1);
      let type = aDocument.getElementById(fieldKey + "-Type").value;
      let number = aDocument.getElementById(fieldKey).value;
      if (number) {
        let EDSPhone = new nsAbEDSPhone();
        EDSPhone.type = type;
        EDSPhone.number = number;
        newPhones.push(EDSPhone);
      }
    }
    aCard.setPhoneNumbers(newPhones.length, newPhones);

    // Get IM Account values
    let newIMAccounts = [];
    for (let i = 0; i < EDSContactEditor.MAX_IM_ACCOUNTS; i++) {
      let fieldKey = "IM-" + (i + 1);
      let type = aDocument.getElementById(fieldKey + "-Type").value;
      let username = aDocument.getElementById(fieldKey).value;
      if (username) {
        let EDSAcct = new nsAbEDSIMAccount();
        EDSAcct.type = type;
        EDSAcct.username = username;
        newIMAccounts.push(EDSAcct);
      }
    }
    aCard.setIMAccounts(newIMAccounts.length, newIMAccounts);

    try {
      aCard.commit();
    } catch(e) {
      ERROR("Could not properly save EDS card!", e);
      Services.prompt.alert(null, _("ProblemSavingContactDialogTitle"),
                            _("ProblemSavingContact", [e.message, e.fileName,
                                                       e.lineNumber]));
      throw("Exiting early.");
    }

    LOG("Done saving EDS Card.");
  },

  goInert: function EDSCE_goInert(aDocument) {
     LOG("EDSContactEditor going inert.");
     // Unregister save listener
     UnregisterSaveListener(EDSContactEditor.onSaveCard);
     // Unregister photo handlers
     EDSContactEditor.appearAsNormalCard(aDocument);
     registerPhotoHandler("eds", function(aCard, aImg) { return false;});
     registerPhotoHandler("generic", genericPhotoHandler);
     registerPhotoHandler("file", filePhotoHandler);
     registerPhotoHandler("web", webPhotoHandler);

     EDSContactEditor.cardFieldsDisabled(aDocument, false);
     aDocument.defaultView.sizeToContent();
  },

  goActive: function EDSCE_goActive(aDocument, aDirectory) {
    LOG("EDSContactEditor going active.");

    const EMAIL_DROPDOWNS = [
      "WORK",
      "HOME",
      "OTHER"
    ];

    const EMAIL_DROPDOWN_DEFAULTS = [0, 1, 2, 2];

    const PHONE_DROPDOWNS = [
      "E_CONTACT_PHONE_ASSISTANT",
      "E_CONTACT_PHONE_BUSINESS",
      "E_CONTACT_PHONE_BUSINESS_FAX",
      "E_CONTACT_PHONE_CALLBACK",
      "E_CONTACT_PHONE_CAR",
      "E_CONTACT_PHONE_COMPANY",
      "E_CONTACT_PHONE_HOME",
      "E_CONTACT_PHONE_HOME_FAX",
      "E_CONTACT_PHONE_ISDN",
      "E_CONTACT_PHONE_MOBILE",
      "E_CONTACT_PHONE_OTHER",
      "E_CONTACT_PHONE_OTHER_FAX",
      "E_CONTACT_PHONE_PAGER",
      "E_CONTACT_PHONE_PRIMARY",
      "E_CONTACT_PHONE_RADIO",
      "E_CONTACT_PHONE_TELEX",
      "E_CONTACT_PHONE_TTYTDD",
    ];
    const PHONE_DROPDOWN_DEFAULTS = [1, 6, 9, 2, 7, 12, 10, 10];

    const IM_DROPDOWNS = [
      "E_CONTACT_IM_AIM",
      "E_CONTACT_IM_JABBER",
      "E_CONTACT_IM_YAHOO",
      "E_CONTACT_IM_GADUGADU",
      "E_CONTACT_IM_MSN",
      "E_CONTACT_IM_ICQ",
      "E_CONTACT_IM_GROUPWISE",
      "E_CONTACT_IM_SKYPE",
    ];
    const IM_DROPDOWN_DEFAULTS = [0, 2, 4, 5];

    EDSContactEditor.appearAsEDSCard(aDocument);

    RegisterSaveListener(EDSContactEditor.onSaveCard);
    registerPhotoHandler("eds", EDSPhotoHandler);
    registerPhotoHandler("generic", EDSGenericPhotoHandler);
    registerPhotoHandler("file", EDSFilePhotoHandler);
    registerPhotoHandler("web", EDSWebPhotoHandler);

    EDSContactEditor.cardFieldsDisabled(aDocument, true);

    // First, your basic text input fields
    let supportedFields = aDirectory.getSupportedFields({});
    for (let fieldId in fixIterator(supportedFields)) {
      let tbFieldArray = EDSFieldMap.EDStoTB(fieldId);
      if (!tbFieldArray)
        continue;

      for (let i = 0; i < tbFieldArray.length; i++) {
        let field = tbFieldArray[i];
        let element = aDocument.querySelector('#' + field);
        if (element)
          element.disabled = false;
      }
    }

    // Then the email fields.

    // We want to clear out the PrimaryEmail field, because TB tries to
    // validate data in that field, and the user has no control of
    // it in this state.  Because TB auto-populates the PrimaryEmail
    // after the onLoadCard event, and checks it before the onSaveCard
    // event, here's a hack - any time the new email textboxes are
    // changed, we force a clearout of PrimaryEmail.
    let primaryEmail = aDocument.getElementById("PrimaryEmail");

    for (let i = 0; i < EDSContactEditor.MAX_EMAILS; i++) {
      let menulist = aDocument.getElementById("emailField-" + (i + 1) + "-Type");
      menulist.removeAllItems();

      for (let j = 0; j < EMAIL_DROPDOWNS.length; j++) {
        let value = EMAIL_DROPDOWNS[j];
        let label = EDSContactEditor.getString(EMAIL_DROPDOWNS[j]);
        menulist.appendItem(label, value, null);
      }
      if (menulist.itemCount > 0) {
        let emailField = aDocument.getElementById("emailField-" + (i+1));
        emailField.disabled = false;
        emailField.onchange = function(event) {
          primaryEmail.value = "";
        };
        menulist.disabled = false;
      }
      menulist.selectedIndex = EMAIL_DROPDOWN_DEFAULTS[i];
    }


    // Then the phone fields
    for (let i = 0; i < EDSContactEditor.MAX_PHONES; i++) {
      let menulist = aDocument.getElementById("telephoneField-" + (i + 1) + "-Type");
      menulist.removeAllItems();

      for (let j = 0; j < PHONE_DROPDOWNS.length; j++) {
        let value = PHONE_DROPDOWNS[j];
        if (supportedFields.indexOf(value) != -1) {
          let label = EDSContactEditor.getString(PHONE_DROPDOWNS[j]);
          menulist.appendItem(label, value, null);
        }
      }
      if (menulist.itemCount > 0) {
        aDocument.getElementById("telephoneField-" + (i + 1)).disabled = false;
        menulist.disabled = false;
      }
      if (menulist.itemCount >= PHONE_DROPDOWN_DEFAULTS[i])
        menulist.selectedIndex = PHONE_DROPDOWN_DEFAULTS[i];
    }

    // Then the IM fields
    for (let i = 0; i < EDSContactEditor.MAX_IM_ACCOUNTS; i++) {
      let menulist = aDocument.getElementById("IM-" + (i + 1) + "-Type");
      menulist.removeAllItems();

      for (let j = 0; j < IM_DROPDOWNS.length; j++) {
        let value = IM_DROPDOWNS[j];
        if (supportedFields.indexOf(value) != -1) {
          let label = EDSContactEditor.getString(IM_DROPDOWNS[j]);
          menulist.appendItem(label, value, null);
        }
      }
      if (menulist.itemCount > 0) {
        aDocument.getElementById("IM-" + (i + 1)).disabled = false;
        menulist.disabled = false;
      }
      if (menulist.itemCount >= IM_DROPDOWN_DEFAULTS[i])
        menulist.selectedIndex = IM_DROPDOWN_DEFAULTS[i];
    }

    // Then the photo fields
    if (supportedFields.indexOf("E_CONTACT_PHOTO") != -1) {
      let photoTab = aDocument.querySelector('#abPhotoTab');
      let photoFields = photoTab.querySelectorAll("textbox, menulist, radiogroup, button, fileField");
      for (let i = 0; i < photoFields.length; i++)
        photoFields[i].disabled = false;
    }


    aDocument.defaultView.sizeToContent();
    LOG("EDS Contact Editor is fully active.");
  },

  cardFieldsDisabled: function EDSCE_cardFieldsDisabled(aDocument, aDisabled) {
     let editCard = aDocument.querySelector("#editcard");
     let inputs = editCard.querySelectorAll("textbox, datepicker, menulist,"
                                             + "radiogroup, button, filefield");

     for (let i = 0; i < inputs.length; i++)
       inputs[i].disabled = aDisabled;
  },

  appearAsNormalCard: function EDSCE_appearAsNormalCard(aDocument) {
    EDSContactEditor.NORMAL_ONLY_FIELDS.forEach(function(aID) {
      aDocument.getElementById(aID).collapsed = false;
    });

    EDSContactEditor.EDS_ONLY_FIELDS.forEach(function(aID) {
      aDocument.getElementById(aID).collapsed = true;
    });
  },

  appearAsEDSCard: function EDSCE_appearAsEDSCard(aDocument) {
    EDSContactEditor.NORMAL_ONLY_FIELDS.forEach(function(aID) {
      aDocument.getElementById(aID).collapsed = true;
    });

    EDSContactEditor.EDS_ONLY_FIELDS.forEach(function(aID) {
      aDocument.getElementById(aID).collapsed = false;
    });

    EDSContactEditor.modifyDatePicker(aDocument, aDocument.getElementById("SpouseAnniversary"));
  },

  populateEDSFields: function EDSCE_PopulateEDSFields(aEDSCard, aDocument) {

    // Get the email addresses
    let emailAddrs = aEDSCard.getEmailAddrs({});
    for (var i = 0; i < emailAddrs.length; i++) {
      let EDSEmail = emailAddrs[i];
      let fieldKey = "emailField-" + (i + 1);
      let field = aDocument.getElementById(fieldKey);
      field.value = EDSEmail.address;
      let menuitem = aDocument.getElementById(fieldKey + "-Type");
      menuitem.value = EDSEmail.type;
    }

    // Get the phone numbers
    let phoneNumbers = aEDSCard.getPhoneNumbers({});
    for (var i = 0; i < phoneNumbers.length && i < EDSContactEditor.MAX_PHONES; i++) {
      let EDSPhone = phoneNumbers[i];
      let fieldKey = "telephoneField-" + (i + 1);
      let field = aDocument.getElementById(fieldKey);
      field.value = EDSPhone.number;
      let menuitem = aDocument.getElementById(fieldKey + "-Type");
      menuitem.value = EDSPhone.type;
    }

    // And the IM accounts
    let IMAccounts = aEDSCard.getIMAccounts({});
    for (var i = 0; i < IMAccounts.length && i < EDSContactEditor.MAX_IM_ACCOUNTS; i++) {
      let IMAccount = IMAccounts[i];
      let fieldKey = "IM-" + (i + 1);
      let field = aDocument.getElementById(fieldKey);
      field.value = IMAccount.username;
      let menuitem = aDocument.getElementById(fieldKey + "-Type");
      menuitem.value = IMAccount.type;
    }

    for (var i = 0; i < EDSContactEditor.CARD_FIELDS.length; i++) {
      let field = aDocument.getElementById(EDSContactEditor.CARD_FIELDS[i][1]);
      field.value = aEDSCard.getProperty(EDSContactEditor.CARD_FIELDS[i][0], "");
    }

    var anniversaryField = aDocument.getElementById("SpouseAnniversary");
    // get the month of the year (1 - 12)
    var month = aEDSCard.getProperty("AnniversaryMonth", null);
    if (month > 0 && month < 13)
      anniversaryField.month = month - 1;
    else
      anniversaryField.monthField.value = null;

    // get the date of the month (1 - 31)
    var date = aEDSCard.getProperty("AnniversaryDay", null);
    if (date > 0 && date < 32)
      anniversaryField.date = date;
    else
      anniversaryField.dateField.value = null;

    // If the photo type is eds-generic, then make the "Keep the current photo"
    // radio option invisible.
    if (aEDSCard.getProperty("PhotoType", "generic") == "generic")
      aDocument.getElementById("EDSPhotoType").collapsed = true;
  },

  modifyDatePicker: function EDSCE_ModifyDatePicker(aDocument, aDatepicker) {
    // collapse the year field and separator
    aDatepicker.yearField.parentNode.collapsed = true;
    if (aDatepicker.yearField == aDatepicker._fieldThree ||
        aDatepicker.yearField == aDatepicker._fieldTwo)
      aDatepicker._separatorSecond.collapsed = true;
    else
      aDatepicker._separatorFirst.collapsed = true;
    // collapse the spinner element
    aDocument.getAnonymousElementByAttribute(aDatepicker, "anonid", "buttons")
             .collapsed = true;
    // this modified constrain value function ignores values less than the minimum
    // to let the value be blank (null)
    // from: mozilla/toolkit/content/widgets/datetimepicker.xml#759
    aDatepicker._constrainValue = function newConstrainValue(aField, aValue, aNoWrap) {
      // if the value is less than one, make the field's value null
      if (aValue < 1) {
        aField.value = null;
        return null;
      }
      if (aNoWrap && aField == this.monthField)
        aValue--;
      // make sure the date is valid for the given month
      if (aField == this.dateField) {
        var currentMonth = this.month;
        var dt = new Date(this.year, currentMonth, aValue);
        return dt.getMonth() != currentMonth ? 1 : aValue;
      }
      var max = (aField == this.monthField) ? 11 : 9999;
      // make sure the value isn't too high
      if (aValue > max)
        return aNoWrap ? max : min;
      return aValue;
    }
    // sets the specified field to the given value, but allows blank fields
    // from: mozilla/toolkit/content/widgets/datetimepicker.xml#698
    aDatepicker._setFieldValue = function setValue(aField, aValue) {
      if (aField == this.yearField && aValue > 0 && aValue < 10000) {
        var oldDate = this._dateValue;
        this._dateValue.setFullYear(aValue);
        if (oldDate != this._dateValue) {
          this._dateValue.setDate(0);
          this._updateUI(this.dateField, this.date);
        }
      }
      // update the month if the value isn't null
      else if (aField == this.monthField && aValue != null) {
        var oldDate = this.date;
        this._dateValue.setMonth(aValue);
        if (oldDate != this.date)
          this._dateValue.setDate(0);
        this._updateUI(this.dateField, this.date);
        var date = this._dateValue.getDate();
        this.dateField.value = date < 10 && this.dateLeadingZero ? "0" + date : date;
        var month = this._dateValue.getMonth() + 1;
        this.monthField.value = month < 10 && this.monthLeadingZero ? "0" + month : month;
      }
      // update the date if the value isn't null
      else if (aField == this.dateField && aValue != null) {
        this._dateValue.setDate(aValue);
        this._updateUI(this.dateField, this.date);
        var date = this._dateValue.getDate();
        this.dateField.value = date < 10 && this.dateLeadingZero ? "0" + date : date;
        var month = this._dateValue.getMonth() + 1;
        this.monthField.value = month < 10 && this.monthLeadingZero ? "0" + month : month;
      }
      this.setAttribute("value", this.value);

      if (this.attachedControl)
        this.attachedControl._setValueNoSync(this._dateValue);
      // if the aField's value is null or 0, set both field's values to null
      if (!aField.value && aField != this.yearField) {
        this.dateField.value = null;
        this.monthField.value = null;
      }
      // make the field's value null if aValue is null and the field's value isn't
      if (aValue == null && aField.value != null)
        aField.value = null;
    }
  }
}

EDSContactEditor.onLoad();
