/*
 * Copyright(c) 2007 Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _FC_FCOE_H_
#define	_FC_FCOE_H_

/*
 * FCoE - Fibre Channel over Ethernet.
 */

/*
 * The FCoE ethertype eventually goes in net/if_ether.h.
 */
#ifndef ETH_P_FCOE
#define	ETH_P_FCOE	0x8906		/* FCOE ether type */
#endif

/*
 * FC_FCOE_OUI hasn't been standardized yet.   XXX TBD.
 */
#ifndef FC_FCOE_OUI
#define	FC_FCOE_OUI	0xfcfcfc	/* upper 24 bits of FCOE dest MAC TBD */
#endif

/*
 * The destination MAC address for the fabric login may get a different OUI.
 * This isn't standardized yet.
 */
#ifndef FC_FCOE_FLOGI_MAC
#define	FC_FCOE_FLOGI_MAC 0xfcfcfcfffffeULL	/* gateway MAC - TBD */
#endif

#define	FC_FCOE_VER	0			/* version */

/*
 * Ethernet Addresses based on FC S_ID and D_ID.
 * Generated by FC_FCOE_OUI | S_ID/D_ID
 */
#define	FC_FCOE_ENCAPS_ID(n)	(((u_int64_t) FC_FCOE_OUI << 24) | (n))
#define	FC_FCOE_DECAPS_ID(n)	((n) >> 24)

/*
 * FCoE frame header - 14 bytes
 *
 * This is the August 2007 version of the FCoE header as defined by T11.
 * This follows the VLAN header, which includes the ethertype.
 */
struct fcoe_hdr {
	net8_t		fcoe_ver;	/* version field - upper 4 bits */
	net8_t		fcoe_resvd[12];	/* reserved - send zero and ignore */
	net8_t		fcoe_sof;	/* start of frame per RFC 3643 */
};

#define FC_FCOE_DECAPS_VER(hp)	    ((hp)->fcoe_ver >> 4)
#define FC_FCOE_ENCAPS_VER(hp, ver) ((hp)->fcoe_ver = (ver) << 4)

/*
 * FCoE CRC & EOF - 8 bytes.
 */
struct fcoe_crc_eof {
	u_int32_t	fcoe_crc32;	/* CRC for FC packet */
	net8_t		fcoe_eof;	/* EOF from RFC 3643 */
	net8_t		fcoe_resvd[3];	/* reserved - send zero and ignore */
} __attribute__((packed));

/*
 * Store OUI + DID into MAC address field.
 */
static inline void fc_fcoe_set_mac(net8_t *mac, net24_t *did)
{
	mac[0] = (net8_t) (FC_FCOE_OUI >> 16);
	mac[1] = (net8_t) (FC_FCOE_OUI >> 8);
	mac[2] = (net8_t) FC_FCOE_OUI;
	*(net24_t *) &mac[3] = *did;
}

/*
 * VLAN header.  This is also defined in linux/if_vlan.h, but for kernels only.
 */
struct fcoe_vlan_hdr {
	net16_t		vlan_tag;	/* VLAN tag including priority */
	net16_t		vlan_ethertype;	/* encapsulated ethertype ETH_P_FCOE */
};

#ifndef ETH_P_8021Q
#define	ETH_P_8021Q	0x8100
#endif

#endif /* _FC_FCOE_H_ */
