#!/usr/bin/perl

use warnings;
use strict;
use Debian::Debhelper::Dh_Lib;

# Compress with LZMA to reduce package size, can be deactivated by exporting DEB_NO_LZMA=1
if ( (dpkg_architecture_value("DEB_HOST_ARCH") ne "armel") && (! defined $ENV{'DEB_NO_LZMA'} || ($ENV{'DEB_NO_LZMA'} ne "1")) ) {
    add_command_options("dh_builddeb", "-u", "-Zlzma");
} elsif (defined $ENV{'DEB_NO_COMPRESSION'} && ($ENV{'DEB_NO_COMPRESSION'} eq "1")) {
    add_command_options("dh_builddeb", "-u", "-Znone");
}

1;
