#!/usr/bin/python

__copyright__='''
Copyright:    (C) 2005 International Business Machines, Inc.
Author:       Alan Robertson <alanr@unix.sh>
Support:      linux-ha-dev@lists.tummy.com
License:      GNU General Public License (GPL)
'''

#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.


import sys
import re

#Numeric comparison sorting
def sorttestnum(lhs, rhs):
    return int(lhs) - int(rhs)


#
#	Compress sorted list of tests into runs (ranges) of sequential tests
#	So that (1,2,3,4) gets compressed down into (1,5)
#	We add one so we get the marker showing the beginning of the next test
#
#	
#
def testruns(list):
    if len(list) < 1:
        return None, None
    first=int(list.pop(0))
    last=first+1
    while len(list) >= 1 and list[0] == last:
        last=list.pop(0)+1
    return (int(first), int(last))
     
       

#
#	Scanning for particular tests...
#
class ExtractTests:
    def expandtestranges(self, testlist):
        outlist = []
        for j in range(len(testlist)):
            match = re.match("([0-9]+)[-:]([0-9]+)", testlist[j])
            if match:
                for k in range(int(match.groups()[0]),int(match.groups()[1])+1):
                    outlist.append(k)
            else:
                outlist.append(testlist[j])
        return outlist

    def __init__(self, filename, testlist):
        self.file = open(filename, "r")
        testlist = self.expandtestranges(testlist)
        testlist.sort(sorttestnum)
        self.testlist = testlist
        print "Extracting tests ", self.testlist
        self.regex=re.compile(" CTS: Running test .*(\[|\s)([0-9]+)")
        self.CTSregex=re.compile(" CTS: ")
        self.DEBUGregex=re.compile(" CTS: (BadNews|debug):")

    def __call__(self):
        first, last = testruns(self.testlist)
        curtest=0
        while 1:
            line = self.file.readline()
            lineprinted=None
            if line == None or line == "":
                break
            regexmatchobj=self.regex.search(line)
            if regexmatchobj:
                curtest= int(regexmatchobj.groups()[1])

            if curtest == 0:
                # Print the summary
                if self.CTSregex.search(line):
                   if not self.DEBUGregex.search(line):
                       sys.stdout.write(line)
                       lineprinted=1

            if curtest >= first and not lineprinted:
                sys.stdout.write(line)
            if curtest >= last:
                first, last = testruns(self.testlist)
                if first == None:
                    break

if len(sys.argv) < 3:
    print "Usage:", sys.argv[0] , "logfilename testnumber ..."
    sys.exit(1)
foo = ExtractTests (sys.argv[1], sys.argv[2:])
foo()
