/*
 * Copyright (c) 2000, 2006, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

 private:

  //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  //
  // Sparc load/store emission
  //
  // The sparc ld/st instructions cannot accomodate displacements > 13 bits long.
  // The following "pseudo" sparc instructions (load/store) make it easier to use the indexed addressing mode
  // by allowing 32 bit displacements:
  //
  //    When disp <= 13 bits long, a single load or store instruction is emitted with (disp + [d]).
  //    When disp >  13 bits long, code is emitted to set the displacement into the O7 register,
  //       and then a load or store is emitted with ([O7] + [d]).
  //

  // some load/store variants return the code_offset for proper positioning of debug info for null checks

  // load/store with 32 bit displacement
  int load(Register s, int disp, Register d, BasicType ld_type, CodeEmitInfo* info = NULL);
  void store(Register value, Register base, int offset, BasicType type, CodeEmitInfo *info = NULL);

  // loadf/storef with 32 bit displacement
  void load(Register s, int disp, FloatRegister d, BasicType ld_type, CodeEmitInfo* info = NULL);
  void store(FloatRegister d, Register s1, int disp, BasicType st_type, CodeEmitInfo* info = NULL);

  // convienence methods for calling load/store with an Address
  void load(const Address& a, Register d, BasicType ld_type, CodeEmitInfo* info = NULL, int offset = 0);
  void store(Register d, const Address& a, BasicType st_type, CodeEmitInfo* info = NULL, int offset = 0);
  void load(const Address& a, FloatRegister d, BasicType ld_type, CodeEmitInfo* info = NULL, int offset = 0);
  void store(FloatRegister d, const Address& a, BasicType st_type, CodeEmitInfo* info = NULL, int offset = 0);

  // convienence methods for calling load/store with an LIR_Address
  void load(LIR_Address* a, Register d, BasicType ld_type, CodeEmitInfo* info = NULL);
  void store(Register d, LIR_Address* a, BasicType st_type, CodeEmitInfo* info = NULL);
  void load(LIR_Address* a, FloatRegister d, BasicType ld_type, CodeEmitInfo* info = NULL);
  void store(FloatRegister d, LIR_Address* a, BasicType st_type, CodeEmitInfo* info = NULL);

  int store(LIR_Opr from_reg, Register base, int offset, BasicType type, bool unaligned = false);
  int store(LIR_Opr from_reg, Register base, Register disp, BasicType type);

  int load(Register base, int offset, LIR_Opr to_reg, BasicType type, bool unaligned = false);
  int load(Register base, Register disp, LIR_Opr to_reg, BasicType type);

  void monitorexit(LIR_Opr obj_opr, LIR_Opr lock_opr, Register hdr, int monitor_no);

  int shift_amount(BasicType t);

  static bool is_single_instruction(LIR_Op* op);

 public:
  void pack64( Register rs, Register rd );
  void unpack64( Register rd );

enum {
#ifdef _LP64
         call_stub_size = 68,
#else
         call_stub_size = 20,
#endif // _LP64
         exception_handler_size = DEBUG_ONLY(1*K) NOT_DEBUG(10*4),
         deopt_handler_size = DEBUG_ONLY(1*K) NOT_DEBUG(10*4) };
