/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_LIBRARY_P_H_
#define _OPENSHIVA_LIBRARY_P_H_

#include "Library.h"

#include <GTLCore/CompilationMessages.h>
#include <GTLCore/String.h>
#include <GTLCore/Value.h>

#include "Source.h"

#include <map>

namespace llvm {
  class Function;
  class Module;
}

namespace GTLCore {
  class ModuleData;
  namespace Metadata {
    class Group;
  }
}

namespace OpenShiva {
  class LibraryCompilation;
  /**
   * @internal
   * @ingroup OpenShiva
   * Private structure for a @ref Library
   */
  struct Library::Private {
    Private() : m_moduleData(0), libraryCompilation(0)
    {
    }
    void metadataToParameters( const GTLCore::Metadata::Group* );
    void initparameters();
    
    GTLCore::String name;
    Source source;
    bool compiled;
    llvm::Module* m_llvmModule;
    GTLCore::ModuleData* m_moduleData;
    int count_channels_generic;
    bool isKernel;
    bool isStandardLibrary;
    std::map< GTLCore::String, GTLCore::Value > parameters;
    GTLCore::CompilationMessages compilationErrors;
    LibraryCompilation* libraryCompilation;
  };
}

#endif
