/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLTest/Test.h"

#include "OpenCTL/Debug.h"
#include "GTLCore/Function.h"

using namespace GTLCore;

#include "OpenCTL/Module.h"
#include "GTLCore/Array.h"
#include "GTLCore/PixelDescription.h"
#include "GTLCore/String.h"
#include "GTLCore/Type.h"
#include "GTLCore/Value.h"

#include "TestProgram.h"
#include "TestFunction.h"
#include "TestModule.h"
#include "TestLexerNG.h"
#include "TestParserNG.h"
#include "TestTemplateLexer.h"
#include "TestRuntimeThreading.h"
#include "TestCompileThreading.h"

GTLTEST_MAIN_BEGIN(TestOpenCTL)
GTLTEST_MAIN_ADD_CASE(TestFunction)
GTLTEST_MAIN_ADD_CASE(TestProgram)
GTLTEST_MAIN_ADD_CASE(TestModule)
GTLTEST_MAIN_ADD_CASE(TestLexerNG)
GTLTEST_MAIN_ADD_CASE(TestParserNG)
GTLTEST_MAIN_ADD_CASE(TestTemplateLexer)
#ifdef GTLTEST_HAVE_THREAD
GTLTEST_MAIN_ADD_CASE(TestRuntimeThreading)
#endif
// GTLTEST_MAIN_ADD_CASE(TestCompileThreading)
GTLTEST_MAIN_END()
