/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_PIXBUF_CACHE_H_
#define _NL_PIXBUF_CACHE_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <gdk/gdk.h>

#define NL_TYPE_PIXBUF_CACHE (nl_pixbuf_cache_get_type ())

#define NL_PIXBUF_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_PIXBUF_CACHE, NlPixbufCache))

#define NL_PIXBUF_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_PIXBUF_CACHE, NlPixbufCacheClass))

#define NL_IS_PIXBUF_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_PIXBUF_CACHE))

#define NL_IS_PIXBUF_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_PIXBUF_CACHE))

#define NL_PIXBUF_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_PIXBUF_CACHE, NlPixbufCacheClass))

typedef struct _NlPixbufCache        NlPixbufCache;
typedef struct _NlPixbufCacheClass   NlPixbufCacheClass;
typedef struct _NlPixbufCachePrivate NlPixbufCachePrivate;
 
struct _NlPixbufCache
{
  GObject        parent;	

  NlPixbufCachePrivate *priv;
};

struct _NlPixbufCacheClass
{
  GObjectClass   parent_class;
};

GType                 nl_pixbuf_cache_get_type    (void) G_GNUC_CONST;

/*
 * Be sure to g_object_unref when your done with it
 */
NlPixbufCache * nl_pixbuf_cache_get_default (void);


/*
 * Where icon_name can be a:
 *  - actual icon name, like "gtk-apply"
 *  - a URI to a image file
 *  - a filepath to an image file
 *
 * size can be -1 to indicate you want the natural size of the icon (only
 * useful of icon_name is a filepath or URI
 *
 * The returned value should be freed with g_object_unref when your done with
 * it
 */
GdkPixbuf * nl_pixbuf_cache_icon_for_name (NlPixbufCache *cache,
                                                const gchar          *iconname,
                                                 guint                size);

GdkPixbuf * nl_pixbuf_cache_icon_for_gicon(NlPixbufCache *cache,
                                                 GIcon               *icon,
                                                 guint                size);

#endif /* _NL_PIXBUF_CACHE_H_ */

