/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include "nl-drag-dest.h"

#include "nl-drag-server.h"


G_DEFINE_TYPE (NlDragDest, nl_drag_dest, CLUTTER_TYPE_GROUP);

#define NL_DRAG_DEST_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj),\
  CLUTTER_TYPE_DRAG_DEST, \
  NlDragDestPrivate))

struct _NlDragDestPrivate
{
  gboolean success;
};

enum
{
  DROP,

  LAST_SIGNAL
};
static guint _dest_signals[LAST_SIGNAL] = {0};

void
nl_drag_dest_finish (NlDragDest *dest,
                     gboolean         success)
{
  g_return_if_fail (CLUTTER_IS_DRAG_DEST (dest));
  dest->priv->success = success;
}

void
nl_drag_dest_enable (NlDragDest *dest)
{
  nl_drag_server_add_drag_dest (nl_drag_server_get_default (),dest);
}

gboolean
nl_drag_dest_drop (NlDragDest *dest, gpointer data)
{
  g_signal_emit (dest, _dest_signals[DROP], 0, data);

  return dest->priv->success;
}


/* GObject stuff */
static void
nl_drag_dest_finalize (GObject *object)
{
  NlDragDestPrivate *priv;

  priv = NL_DRAG_DEST_GET_PRIVATE (object);

  G_OBJECT_CLASS (nl_drag_dest_parent_class)->finalize (object);
}

static void
nl_drag_dest_class_init (NlDragDestClass *klass)
{
  GObjectClass        *obj_class = G_OBJECT_CLASS (klass);

  obj_class->finalize = nl_drag_dest_finalize;

  _dest_signals[DROP] =
    g_signal_new ("drop",
                  G_OBJECT_CLASS_TYPE (obj_class),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (NlDragDestClass,
                                   drop),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__POINTER,
                  G_TYPE_NONE, 1, G_TYPE_POINTER);


  g_type_class_add_private (obj_class, sizeof (NlDragDestPrivate));
}

static void
nl_drag_dest_init (NlDragDest *drag_dest)
{
  NlDragDestPrivate *priv;

  priv = drag_dest->priv = NL_DRAG_DEST_GET_PRIVATE (drag_dest);
}
