var su_ds;
var channels;
var channel_count;

function su_get_element(id)
{
	return document.getElementById(id);
}

function init()
{
	su_ds = opener.su_ds;
	var su_host = opener.parent_window.su_host;
	channels = su_ds.getValue("$dyn_channels");
	
	channels.sort(function (a, b)
				{
					var namea = a.name.toLowerCase().replace(/\./g, "");
					var nameb = b.name.toLowerCase().replace(/\./g, "");
					if ( namea > nameb ) return 1;
					if ( namea < nameb ) return -1;
					return 0;
				});
	
	channel_count = channels.length;
	var col_count = 1;
	if (channel_count > 8)
		col_count = 2;
	else if (channel_count > 32)
		col_count = 3;
	
	var row_count = Math.round(channel_count / col_count);
	
	var columns = su_get_element("columns");
	var rows = su_get_element("rows");

	var el;
	
	for (i = 0; i < col_count; i++)
	{
		el = document.createElement("column");
		columns.appendChild(el);
	}
	
	for (i = 0; i < row_count; i++)
	{
		el = document.createElement("row");
		el.setAttribute("id", "row_" + i);
		rows.appendChild(el);
	}
	
	for (i = 0; i < channel_count; i++)
	{
		el = document.createElement("checkbox");
		el.setAttribute("id", "item_" + i);
		el.setAttribute("label", channels[i].name);
		var filename = channels[i].domain.replace(/\./g, "_") + ".ico";
		el.setAttribute("src", 
					su_ds.getResourceURLFromName("favicons", filename));
		if (su_host.mac || su_host.win)
			el.setAttribute("class", "su-iconic-favicon");
		else
			el.setAttribute("class", "su-iconic-favicon-alt");
		var row_el = su_get_element("row_" + (i % row_count));
		row_el.appendChild(el);
		el.checked = channels[i].show;
	}
}

function handle_accept()
{
	var i;
	var el;
	for (i = 0; i < channel_count; i++)
	{
		el = su_get_element("item_" + i);
		channels[i].show = el.checked;
		su_ds.updateRow(channels[i]);
	}
}

function handle_cancel()
{
	return true;
}

