using Gee;
using Unity;



int main(string[] args)
{
	int i = 0;
	var loop = new MainLoop();
	var time = new TimeoutSource(10);
	MusicPlayer test_player = null;

	time.set_callback(() => {
		const string desktop_file_name = "rhythmbox.desktop";
		test_player = new MusicPlayer(desktop_file_name);
		test_player.export();
		
		return false;	
	});
	time.attach(loop.get_context());

	var thread_timer = new TimeoutSource(100);
	thread_timer.set_callback(() => {
		set_blacklisted(test_player);
		if (++i < 100)
			return true;
		test_player.unexport();
		loop.quit();
		return false;
	});
	thread_timer.attach(loop.get_context());

    loop.run();
	
	return 0;
}

void* set_blacklisted(MusicPlayer test_player)
{
	int raw_blacklist = Random.int_range(0, 2);
	bool blacklist = (bool) raw_blacklist;	
	test_player.is_blacklisted = blacklist;
	return null;
}
