/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libmspub
 * Version: MPL 1.1 / GPLv2+ / LGPLv2+
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License or as specified alternatively below. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Major Contributor(s):
 * Copyright (C) 2012 Brennan Vincent <brennanv@email.arizona.edu>
 *
 * All Rights Reserved.
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPLv2+"), or
 * the GNU Lesser General Public License Version 2 or later (the "LGPLv2+"),
 * in which case the provisions of the GPLv2+ or the LGPLv2+ are applicable
 * instead of those above.
 */

#include <stddef.h> // for NULL
#include <math.h>

#include <libwpg/libwpg.h>

#include "ShapeType.h"
#include "PolygonUtils.h"
#include "libmspub_utils.h"
#include "MSPUBCollector.h"

#define CALCULATED_VALUE(val) (int(unsigned(val) | 0x80000000))

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

// FIXME: Do something better than the following workaround
#pragma GCC diagnostic ignored "-Wpragmas"
#pragma GCC diagnostic ignored "-Wuninitialized"
#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"

using namespace libmspub;

const Vertex LINE_VERTICES[] =
{
  {0, 0}, {21600, 21600}
};

const CustomShape CS_LINE(
  LINE_VERTICES, sizeof(LINE_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex WAVE_VERTICES[] =
{
  {CALCULATED_VALUE(7), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(15), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(24), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(25), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(27), CALCULATED_VALUE(28)}, {CALCULATED_VALUE(29), CALCULATED_VALUE(1)}
};

const unsigned short WAVE_SEGMENTS[] =
{
  0x4000, 0x2001, 0x0001, 0x2001, 0x6000, 0x8000
};

const Calculation WAVE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, 0x400}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, 0x402, 0, 10800}, {0x2001, 0x403, 2, 1}, {0x2003, 0x404, 0, 0}, {0x8000, 4320, 0, 0x405}, {0xa006, 0x403, 0, 0x405}, {0x4001, 15800, 0x400, 4460}, {0xa000, 0x400, 0, 0x408}, {0x6000, 0x400, 0x408, 0}, {0x8000, 21600, 0, 0x404}, {0x6006, 0x403, 0x40b, 21600}, {0xa000, 0x40c, 0, 0x407}, {0x2001, 0x405, 1, 2}, {0xa000, 0x407, 7200, 0x40e}, {0x6000, 0x40c, 0x40e, 7200}, {0x2001, 0x40d, 1, 2}, {0x6000, 0x407, 0x411, 0}, {0x8000, 21600, 0, 0x412}, {0x2001, 0x405, 1, 2}, {0x8000, 21600, 0, 0x414}, {0x2001, 0x400, 2, 1}, {0x8000, 21600, 0, 0x416}, {0x8000, 21600, 0, 0x407}, {0x8000, 21600, 0, 0x40f}, {0x6000, 0x401, 0x408, 0}, {0x8000, 21600, 0, 0x410}, {0xa000, 0x401, 0, 0x408}, {0x8000, 21600, 0, 0x40c}
};

const TextRectangle WAVE_TRS[] =
{
  { {CALCULATED_VALUE(5), CALCULATED_VALUE(22)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(23)} }
};

const int WAVE_DEFAULT_ADJUST[] =
{
  1400, 10800
};

const Vertex WAVE_GLUE_POINTS[] =
{
  {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0x14), 10800}, {CALCULATED_VALUE(0x13), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0x15), 10800}
};

const CustomShape CS_WAVE(
  WAVE_VERTICES, sizeof(WAVE_VERTICES) / sizeof(Vertex),
  WAVE_SEGMENTS, sizeof(WAVE_SEGMENTS) / sizeof(unsigned short),
  WAVE_CALC, sizeof(WAVE_CALC) / sizeof(Calculation),
  WAVE_DEFAULT_ADJUST, sizeof(WAVE_DEFAULT_ADJUST) / sizeof(int),
  WAVE_TRS, sizeof(WAVE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  WAVE_GLUE_POINTS, sizeof(WAVE_GLUE_POINTS) / sizeof(Vertex));

const Vertex FOLDED_CORNER_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0), 21600}, {0, 21600}, {CALCULATED_VALUE(0), 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(10), CALCULATED_VALUE(11)}, {21600, CALCULATED_VALUE(0)}
};

const unsigned short FOLDED_CORNER_SEGMENTS[] =
{
  0x4000, 0x0004, 0x6001, 0x8000, 0x4000, 0x0001, 0x2001, 0x6001, 0x8000
};

const Calculation FOLDED_CORNER_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, 0x400}, {0x2001, 0x0401, 8000, 10800}, {0x8000, 21600, 0, 0x0402}, {0x2001, 0x0401, 1, 2}, {0x2001, 0x0401, 1, 4}, {0x2001, 0x0401, 1, 7}, {0x2001, 0x0401, 1, 16}, {0x6000, 0x0403, 0x405, 0}, {0x6000, 0x0400, 0x406, 0}, {0x8000, 21600, 0, 0x404}, {0x6000, 0x400, 0x407, 0}
};

const TextRectangle FOLDED_CORNER_TRS[] =
{
  { {0, 0}, {21600, CALCULATED_VALUE(11)} }
};

const int FOLDED_CORNER_DEFAULT_ADJUST[] =
{
  18900
};

const Vertex FOLDED_CORNER_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FOLDED_CORNER(
  FOLDED_CORNER_VERTICES, sizeof(FOLDED_CORNER_VERTICES) / sizeof(Vertex),
  FOLDED_CORNER_SEGMENTS, sizeof(FOLDED_CORNER_SEGMENTS) / sizeof(unsigned short),
  FOLDED_CORNER_CALC, sizeof(FOLDED_CORNER_CALC) / sizeof(Calculation),
  FOLDED_CORNER_DEFAULT_ADJUST, sizeof(FOLDED_CORNER_DEFAULT_ADJUST) / sizeof(int),
  FOLDED_CORNER_TRS, sizeof(FOLDED_CORNER_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FOLDED_CORNER_GLUE_POINTS, sizeof(FOLDED_CORNER_GLUE_POINTS) / sizeof(Vertex));


const Vertex LEFT_ARROW_VERTICES[] =
{
  {21600, CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), 0}, {0, 10800}, {CALCULATED_VALUE(1), 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, CALCULATED_VALUE(2)}
};

const unsigned short LEFT_ARROW_SEGMENTS[] =
{
  0x4000, 0x0006, 0x6001, 0x8000
};

const Calculation LEFT_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 21600, 0, 0x401}, {0x6001, 0x403, 0x400, 10800}, {0x6000, 0x401, 0x404, 0}, {0x6001, 0x401, 0x400, 10800}, {0xa000, 0x401, 0, 0x406}
};

const TextRectangle LEFT_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(7), CALCULATED_VALUE(0)}, {21600, CALCULATED_VALUE(2)} }
};

const int LEFT_ARROW_DEFAULT_ADJUST[] =
{
  5400, 5400
};

const CustomShape CS_LEFT_ARROW(
  LEFT_ARROW_VERTICES, sizeof(LEFT_ARROW_VERTICES) / sizeof(Vertex),
  LEFT_ARROW_SEGMENTS, sizeof(LEFT_ARROW_SEGMENTS) / sizeof(unsigned short),
  LEFT_ARROW_CALC, sizeof(LEFT_ARROW_CALC) / sizeof(Calculation),
  LEFT_ARROW_DEFAULT_ADJUST, sizeof(LEFT_ARROW_DEFAULT_ADJUST) / sizeof(int),
  LEFT_ARROW_TRS, sizeof(LEFT_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex UP_DOWN_ARROW_VERTICES[] =
{
  {0, CALCULATED_VALUE(1)}, {10800, 0}, {21600, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {21600, CALCULATED_VALUE(3)}, {10800, 21600}, {0, CALCULATED_VALUE(3)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}
};

const unsigned short UP_DOWN_ARROW_SEGMENTS[] =
{
  0x4000, 0x0009, 0x6001, 0x8000
};

const Calculation UP_DOWN_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x6001, PROP_ADJUST_VAL_FIRST, 0x404, 10800}, {0x8000, 21600, 0, 0x405}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x6001, PROP_ADJUST_VAL_FIRST + 1, 0x407, 10800}, {0x8000, 21600, 0, 0x408}
};

const TextRectangle UP_DOWN_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(0), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(9)} }
};

const int UP_DOWN_ARROW_DEFAULT_ADJUST[] =
{
  5400, 4300
};

const CustomShape CS_UP_DOWN_ARROW(
  UP_DOWN_ARROW_VERTICES, sizeof(UP_DOWN_ARROW_VERTICES) / sizeof(Vertex),
  UP_DOWN_ARROW_SEGMENTS, sizeof(UP_DOWN_ARROW_SEGMENTS) / sizeof(unsigned short),
  UP_DOWN_ARROW_CALC, sizeof(UP_DOWN_ARROW_CALC) / sizeof(Calculation),
  UP_DOWN_ARROW_DEFAULT_ADJUST, sizeof(UP_DOWN_ARROW_DEFAULT_ADJUST) / sizeof(int),
  UP_DOWN_ARROW_TRS, sizeof(UP_DOWN_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex IRREGULAR_SEAL_1_VERTICES[] =
{
  {10901, 5905}, {8458, 2399}, {7417, 6425}, {476, 2399}, {4732, 7722}, {106, 8718}, {3828, 11880}, {243, 14689}, {5772, 14041}, {4868, 17719}, {7819, 15730}, {8590, 21600}, {10637, 15038}, {13349, 19840}, {14125, 14561}, {18248, 18195}, {16938, 13044}, {21600, 13393}, {17710, 10579}, {21198, 8242}, {16806, 7417}, {18482, 4560}, {14257, 5429}, {14623, 106}, {10901, 5905}
};

const TextRectangle IRREGULAR_SEAL_1_TRS[] =
{
  { {5400, 6570}, {14160, 15290} }
};

const Vertex IRREGULAR_SEAL_1_GLUE_POINTS[] =
{
  {9722, 1887}, {0, 12875}, {11614, 18844}, {21600, 6646}
};

const CustomShape CS_IRREGULAR_SEAL_1(
  IRREGULAR_SEAL_1_VERTICES, sizeof(IRREGULAR_SEAL_1_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  IRREGULAR_SEAL_1_TRS, sizeof(IRREGULAR_SEAL_1_TRS) / sizeof(TextRectangle),
  21600, 21600,
  IRREGULAR_SEAL_1_GLUE_POINTS, sizeof(IRREGULAR_SEAL_1_GLUE_POINTS) / sizeof(Vertex));

const Vertex LIGHTNING_BOLT_VERTICES[] =
{
  {8458, 0}, {0, 3923}, {7564, 8416}, {4993, 9720}, {12197, 13904}, {9987, 14934}, {21600, 21600}, {14768, 12911}, {16558, 12016}, {11030, 6840}, {12831, 6120}, {8458, 0}
};

const TextRectangle LIGHTNING_BOLT_TRS[] =
{
  { {8680, 7410}, {13970, 14190} }
};

const Vertex LIGHTNING_BOLT_GLUE_POINTS[] =
{
  {8458, 0}, {0, 3923}, {4993, 9720}, {9987, 14934}, {21600, 21600}, {16558, 12016}, {12831, 6120}
};

const CustomShape CS_LIGHTNING_BOLT(
  LIGHTNING_BOLT_VERTICES, sizeof(LIGHTNING_BOLT_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  LIGHTNING_BOLT_TRS, sizeof(LIGHTNING_BOLT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  LIGHTNING_BOLT_GLUE_POINTS, sizeof(LIGHTNING_BOLT_GLUE_POINTS) / sizeof(Vertex));

const Vertex IRREGULAR_SEAL_2_VERTICES[] =
{
  {11464, 4340}, {9722, 1887}, {8548, 6383}, {4503, 3626}, {5373, 7816}, {1174, 8270}, {3934, 11592}, {0, 12875}, {3329, 15372}, {1283, 17824}, {4804, 18239}, {4918, 21600}, {7525, 18125}, {8698, 19712}, {9871, 17371}, {11614, 18844}, {12178, 15937}, {14943, 17371}, {14640, 14348}, {18878, 15632}, {16382, 12311}, {18270, 11292}, {16986, 9404}, {21600, 6646}, {16382, 6533}, {18005, 3172}, {14524, 5778}, {14789, 0}, {11464, 4340}
};

const TextRectangle IRREGULAR_SEAL_2_TRS[] =
{
  { {5400, 6570}, {14160, 15290} }
};

const Vertex IRREGULAR_SEAL_2_GLUE_POINTS[] =
{
  {9722, 1887}, {0, 12875}, {11614, 18844}, {21600, 6646}
};

const CustomShape CS_IRREGULAR_SEAL_2(
  IRREGULAR_SEAL_2_VERTICES, sizeof(IRREGULAR_SEAL_2_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  IRREGULAR_SEAL_2_TRS, sizeof(IRREGULAR_SEAL_2_TRS) / sizeof(TextRectangle),
  21600, 21600,
  IRREGULAR_SEAL_2_GLUE_POINTS, sizeof(IRREGULAR_SEAL_2_GLUE_POINTS) / sizeof(Vertex));


const Vertex HEART_VERTICES[] =
{
  {10800, 21599}, {321, 6886}, {70, 6036}, {-9, 5766}, {-1, 5474}, {2, 5192}, {6, 4918}, {43, 4641}, {101, 4370}, {159, 4103}, {245, 3837}, {353, 3582}, {460, 3326}, {591, 3077}, {741, 2839}, {892, 2598}, {1066, 2369}, {1253, 2155}, {1443, 1938}, {1651, 1732}, {1874, 1543}, {2097, 1351}, {2337, 1174}, {2587, 1014}, {2839, 854}, {3106, 708}, {3380, 584}, {3656, 459}, {3945, 350}, {4237, 264}, {4533, 176}, {4838, 108}, {5144, 66}, {5454, 22}, {5771, 1}, {6086, 3}, {6407, 7}, {6731, 35}, {7048, 89}, {7374, 144}, {7700, 226}, {8015, 335}, {8344, 447}, {8667, 590}, {8972, 756}, {9297, 932}, {9613, 1135}, {9907, 1363}, {10224, 1609}, {10504, 1900}, {10802, 2169}, {11697, 1363}, {11971, 1116}, {12304, 934}, {12630, 756}, {12935, 590}, {13528, 450}, {13589, 335}, {13901, 226}, {14227, 144}, {14556, 89}, {14872, 35}, {15195, 7}, {15517, 3}, {15830, 0}, {16147, 22}, {16458, 66}, {16764, 109}, {17068, 177}, {17365, 264}, {17658, 349}, {17946, 458}, {18222, 584}, {18496, 708}, {18762, 854}, {19015, 1014}, {19264, 1172}, {19504, 1349}, {19730, 1543}, {19950, 1731}, {20158, 1937}, {20350, 2155}, {20536, 2369}, {20710, 2598}, {20861, 2839}, {21010, 3074}, {21143, 3323}, {21251, 3582}, {21357, 3835}, {21443, 4099}, {21502, 4370}, {21561, 4639}, {21595, 4916}, {21600, 5192}, {21606, 5474}, {21584, 5760}, {21532, 6036}, {21478, 6326}, {21366, 6603}, {21282, 6887}, {10802, 21602}
};

const unsigned short HEART_SEGMENTS[] =
{
  0x4000, 0x0002, 0x2010, 0x0001, 0x2010, 0x0001, 0x6001, 0x8000
};

const TextRectangle HEART_TRS[] =
{
  { {5080, 2540}, {16520, 13550} }
};

const Vertex HEART_GLUE_POINTS[] =
{
  {10800, 2180}, {3090, 10800}, {10800, 21600}, {18490, 10800}
};

const CustomShape CS_HEART(
  HEART_VERTICES, sizeof(HEART_VERTICES) / sizeof(Vertex),
  HEART_SEGMENTS, sizeof(HEART_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  HEART_TRS, sizeof(HEART_TRS) / sizeof(TextRectangle),
  21600, 21600,
  HEART_GLUE_POINTS, sizeof(HEART_GLUE_POINTS) / sizeof(Vertex));

const Vertex QUAD_ARROW_VERTICES[] =
{
  {0, 10800}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(0)}, {10800, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(1)}, {21600, 10800}, {CALCULATED_VALUE(5), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(5)}, {10800, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(3)}
};

const unsigned short QUAD_ARROW_SEGMENTS[] =
{
  0x4000, 0x0017, 0x6001, 0x8000
};

const Calculation QUAD_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 2}
};

const TextRectangle QUAD_ARROW_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int QUAD_ARROW_DEFAULT_ADJUST[] =
{
  6500, 8600, 4300
};

const CustomShape CS_QUAD_ARROW(
  QUAD_ARROW_VERTICES, sizeof(QUAD_ARROW_VERTICES) / sizeof(Vertex),
  QUAD_ARROW_SEGMENTS, sizeof(QUAD_ARROW_SEGMENTS) / sizeof(unsigned short),
  QUAD_ARROW_CALC, sizeof(QUAD_ARROW_CALC) / sizeof(Calculation),
  QUAD_ARROW_DEFAULT_ADJUST, sizeof(QUAD_ARROW_DEFAULT_ADJUST) / sizeof(int),
  QUAD_ARROW_TRS, sizeof(QUAD_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex BEVEL_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(0)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(0)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(0), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}
};

const unsigned short BEVEL_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000
};

const Calculation BEVEL_CALC[] =
{
  {0x2001, PROP_ADJUST_VAL_FIRST, 21599, 21600}, {0xa000, PROP_GEO_RIGHT, 0, 0x400}, {0xa000, PROP_GEO_BOTTOM, 0, 0x400}
};

const TextRectangle BEVEL_TRS[] =
{
  { {CALCULATED_VALUE(0), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)} }
};

const int BEVEL_DEFAULT_ADJUST[] =
{
  2700
};

const CustomShape CS_BEVEL(
  BEVEL_VERTICES, sizeof(BEVEL_VERTICES) / sizeof(Vertex),
  BEVEL_SEGMENTS, sizeof(BEVEL_SEGMENTS) / sizeof(unsigned short),
  BEVEL_CALC, sizeof(BEVEL_CALC) / sizeof(Calculation),
  BEVEL_DEFAULT_ADJUST, sizeof(BEVEL_DEFAULT_ADJUST) / sizeof(int),
  BEVEL_TRS, sizeof(BEVEL_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex LEFT_BRACKET_VERTICES[] =
{
  {21600, 0}, {10800, 0}, {0, CALCULATED_VALUE(3)}, {0, CALCULATED_VALUE(1)}, {0, CALCULATED_VALUE(2)}, {0, CALCULATED_VALUE(4)}, {10800, 21600}, {21600, 21600}
};

const unsigned short LEFT_BRACKET_SEGMENTS[] =
{
  0x4000, 0x2001, 0x0001, 0x2001, 0x8000
};

const Calculation LEFT_BRACKET_CALC[] =
{
  {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x6000, PROP_GEO_TOP, 0x400, 0}, {0xa000, PROP_GEO_BOTTOM, 0, 0x400}
};

const TextRectangle LEFT_BRACKET_TRS[] =
{
  { {6350, CALCULATED_VALUE(3)}, {21600, CALCULATED_VALUE(4)} }
};

const int LEFT_BRACKET_DEFAULT_ADJUST[] =
{
  1800
};

const Vertex LEFT_BRACKET_GLUE_POINTS[] =
{
  {21600, 0}, {0, 10800}, {21600, 21600}
};

const CustomShape CS_LEFT_BRACKET(
  LEFT_BRACKET_VERTICES, sizeof(LEFT_BRACKET_VERTICES) / sizeof(Vertex),
  LEFT_BRACKET_SEGMENTS, sizeof(LEFT_BRACKET_SEGMENTS) / sizeof(unsigned short),
  LEFT_BRACKET_CALC, sizeof(LEFT_BRACKET_CALC) / sizeof(Calculation),
  LEFT_BRACKET_DEFAULT_ADJUST, sizeof(LEFT_BRACKET_DEFAULT_ADJUST) / sizeof(int),
  LEFT_BRACKET_TRS, sizeof(LEFT_BRACKET_TRS) / sizeof(TextRectangle),
  21600, 21600,
  LEFT_BRACKET_GLUE_POINTS, sizeof(LEFT_BRACKET_GLUE_POINTS) / sizeof(Vertex));

const Vertex RIGHT_BRACKET_VERTICES[] =
{
  {0, 0}, {10800, 0}, {21600, CALCULATED_VALUE(3)}, {21600, CALCULATED_VALUE(1)}, {21600, CALCULATED_VALUE(2)}, {21600, CALCULATED_VALUE(4)}, {10800, 21600}, {0, 21600}
};

const unsigned short RIGHT_BRACKET_SEGMENTS[] =
{
  0x4000, 0x2001, 0x0001, 0x2001, 0x8000
};

const Calculation RIGHT_BRACKET_CALC[] =
{
  {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x6000, PROP_GEO_TOP, 0x400, 0}, {0xa000, PROP_GEO_BOTTOM, 0, 0x400}
};

const TextRectangle RIGHT_BRACKET_TRS[] =
{
  { {0, CALCULATED_VALUE(3)}, {15150, CALCULATED_VALUE(4)} }
};

const int RIGHT_BRACKET_DEFAULT_ADJUST[] =
{
  1800
};

const Vertex RIGHT_BRACKET_GLUE_POINTS[] =
{
  {0, 0}, {0, 21600}, {21600, 10800}
};

const CustomShape CS_RIGHT_BRACKET(
  RIGHT_BRACKET_VERTICES, sizeof(RIGHT_BRACKET_VERTICES) / sizeof(Vertex),
  RIGHT_BRACKET_SEGMENTS, sizeof(RIGHT_BRACKET_SEGMENTS) / sizeof(unsigned short),
  RIGHT_BRACKET_CALC, sizeof(RIGHT_BRACKET_CALC) / sizeof(Calculation),
  RIGHT_BRACKET_DEFAULT_ADJUST, sizeof(RIGHT_BRACKET_DEFAULT_ADJUST) / sizeof(int),
  RIGHT_BRACKET_TRS, sizeof(RIGHT_BRACKET_TRS) / sizeof(TextRectangle),
  21600, 21600,
  RIGHT_BRACKET_GLUE_POINTS, sizeof(RIGHT_BRACKET_GLUE_POINTS) / sizeof(Vertex));

const Vertex LEFT_BRACE_VERTICES[] =
{
  {21600, 0}, {16200, 0}, {10800, CALCULATED_VALUE(0)}, {10800, CALCULATED_VALUE(1)}, {10800, CALCULATED_VALUE(2)}, {10800, CALCULATED_VALUE(3)}, {5400, CALCULATED_VALUE(4)}, {0, CALCULATED_VALUE(4)}, {5400, CALCULATED_VALUE(4)}, {10800, CALCULATED_VALUE(5)}, {10800, CALCULATED_VALUE(6)}, {10800, CALCULATED_VALUE(7)}, {10800, CALCULATED_VALUE(8)}, {16200, 21600}, {21600, 21600}
};

const unsigned short LEFT_BRACE_SEGMENTS[] =
{
  0x4000, 0x2001, 0x0001, 0x2002, 0x0001, 0x2001, 0x8000
};

const Calculation LEFT_BRACE_CALC[] =
{
  {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0xa000, 0x404, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, 0x404, 0, 0x400}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x6000, 0x404, 0x400, 0}, {0x6000, 0x404, PROP_ADJUST_VAL_FIRST, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 21600, 0, 0x400}, {0x2001, PROP_ADJUST_VAL_FIRST, 10000, 31953}, {0x8000, 21600, 0, 0x409}
};

const TextRectangle LEFT_BRACE_TRS[] =
{
  { {13800, CALCULATED_VALUE(9)}, {21600, CALCULATED_VALUE(10)} }
};

const int LEFT_BRACE_DEFAULT_ADJUST[] =
{
  1800, 10800
};

const Vertex LEFT_BRACE_GLUE_POINTS[] =
{
  {21600, 0}, {0, 10800}, {21600, 21600}
};

const CustomShape CS_LEFT_BRACE(
  LEFT_BRACE_VERTICES, sizeof(LEFT_BRACE_VERTICES) / sizeof(Vertex),
  LEFT_BRACE_SEGMENTS, sizeof(LEFT_BRACE_SEGMENTS) / sizeof(unsigned short),
  LEFT_BRACE_CALC, sizeof(LEFT_BRACE_CALC) / sizeof(Calculation),
  LEFT_BRACE_DEFAULT_ADJUST, sizeof(LEFT_BRACE_DEFAULT_ADJUST) / sizeof(int),
  LEFT_BRACE_TRS, sizeof(LEFT_BRACE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  LEFT_BRACE_GLUE_POINTS, sizeof(LEFT_BRACE_GLUE_POINTS) / sizeof(Vertex));

const Vertex RIGHT_BRACE_VERTICES[] =
{
  {0, 0}, {5400, 0}, {10800, CALCULATED_VALUE(0)}, {10800, CALCULATED_VALUE(1)}, {10800, CALCULATED_VALUE(2)}, {10800, CALCULATED_VALUE(3)}, {16200, CALCULATED_VALUE(4)}, {21600, CALCULATED_VALUE(4)}, {16200, CALCULATED_VALUE(4)}, {10800, CALCULATED_VALUE(5)}, {10800, CALCULATED_VALUE(6)}, {10800, CALCULATED_VALUE(7)}, {10800, CALCULATED_VALUE(8)}, {5400, 21600}, {0, 21600}
};

const unsigned short RIGHT_BRACE_SEGMENTS[] =
{
  0x4000, 0x2001, 0x0001, 0x2002, 0x0001, 0x2001, 0x8000
};

const Calculation RIGHT_BRACE_CALC[] =
{
  {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0xa000, 0x404, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, 0x404, 0, 0x400}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x6000, 0x404, 0x400, 0}, {0x6000, 0x404, PROP_ADJUST_VAL_FIRST, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 21600, 0, 0x400}, {0x2001, PROP_ADJUST_VAL_FIRST, 10000, 31953}, {0x8000, 21600, 0, 0x409}
};

const TextRectangle RIGHT_BRACE_TRS[] =
{
  { {0, CALCULATED_VALUE(9)}, {7800, CALCULATED_VALUE(10)} }
};

const int RIGHT_BRACE_DEFAULT_ADJUST[] =
{
  1800, 10800
};

const Vertex RIGHT_BRACE_GLUE_POINTS[] =
{
  {0, 0}, {0, 21600}, {21600, 10800}
};

const CustomShape CS_RIGHT_BRACE(
  RIGHT_BRACE_VERTICES, sizeof(RIGHT_BRACE_VERTICES) / sizeof(Vertex),
  RIGHT_BRACE_SEGMENTS, sizeof(RIGHT_BRACE_SEGMENTS) / sizeof(unsigned short),
  RIGHT_BRACE_CALC, sizeof(RIGHT_BRACE_CALC) / sizeof(Calculation),
  RIGHT_BRACE_DEFAULT_ADJUST, sizeof(RIGHT_BRACE_DEFAULT_ADJUST) / sizeof(int),
  RIGHT_BRACE_TRS, sizeof(RIGHT_BRACE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  RIGHT_BRACE_GLUE_POINTS, sizeof(RIGHT_BRACE_GLUE_POINTS) / sizeof(Vertex));

const Vertex LEFT_UP_ARROW_VERTICES[] =
{
  {0, CALCULATED_VALUE(5)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(5), 0}, {21600, CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), 21600}
};

const unsigned short LEFT_UP_ARROW_SEGMENTS[] =
{
  0x4000, 0x000b, 0x6001, 0x8000
};

const Calculation LEFT_UP_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0403, 1, 2}, {0x6000, PROP_ADJUST_VAL_FIRST, 0x0404, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x6000, PROP_ADJUST_VAL_FIRST, 0x0406, 0}, {0x8000, 21600, 0, 0x406}, {0xa000, 0x408, 0, 0x406}
};

const TextRectangle LEFT_UP_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(2), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(1)} }, { {CALCULATED_VALUE(7), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(1)} }
};

const int LEFT_UP_ARROW_DEFAULT_ADJUST[] =
{
  9340, 18500, 6200
};

const CustomShape CS_LEFT_UP_ARROW(
  LEFT_UP_ARROW_VERTICES, sizeof(LEFT_UP_ARROW_VERTICES) / sizeof(Vertex),
  LEFT_UP_ARROW_SEGMENTS, sizeof(LEFT_UP_ARROW_SEGMENTS) / sizeof(unsigned short),
  LEFT_UP_ARROW_CALC, sizeof(LEFT_UP_ARROW_CALC) / sizeof(Calculation),
  LEFT_UP_ARROW_DEFAULT_ADJUST, sizeof(LEFT_UP_ARROW_DEFAULT_ADJUST) / sizeof(int),
  LEFT_UP_ARROW_TRS, sizeof(LEFT_UP_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex SMILEY_FACE_VERTICES[] =
{
  {10800, 10800}, {10800, 10800}, {0, 360}, {7305, 7515}, {1165, 1165}, {0, 360}, {14295, 7515}, {1165, 1165}, {0, 360}, {4870, CALCULATED_VALUE(1)}, {8680, CALCULATED_VALUE(2)}, {12920, CALCULATED_VALUE(2)}, {16730, CALCULATED_VALUE(1)}
};

const unsigned short SMILEY_FACE_SEGMENTS[] =
{
  0xa203, 0x6000, 0x8000, 0xa203, 0x6000, 0x8000, 0xa203, 0x6000, 0x8000, 0x4000, 0x2001, 0xaa00, 0x8000
};

const Calculation SMILEY_FACE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 15510}, {0x8000, 17520, 0, 0x400}, {0x4000, 15510, 0x400, 0}
};

const TextRectangle SMILEY_FACE_TRS[] =
{
  { {3163, 3163}, {18437, 18437} }
};

const int SMILEY_FACE_DEFAULT_ADJUST[] =
{
  17520
};

const Vertex SMILEY_FACE_GLUE_POINTS[] =
{
  {10800, 0}, {3163, 3163}, {0, 10800}, {3163, 18437}, {10800, 21600}, {18437, 18437}, {21600, 10800}, {18437, 3163}
};

const Vertex VERTICAL_SCROLL_VERTICES[] =
{
  {CALCULATED_VALUE(1), 21600}, {0, CALCULATED_VALUE(11)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(4), 0}, {CALCULATED_VALUE(2), 0}, {21600, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(5), 21600}, {CALCULATED_VALUE(6), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(1), 21600}, {0, CALCULATED_VALUE(11)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(9), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(4), 0}, {CALCULATED_VALUE(6), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(0)}
};

const unsigned short VERTICAL_SCROLL_SEGMENTS[] =
{
  0x4000, 0xa702, 0x0002, 0xa801, 0x0001, 0xa702, 0x0002, 0xa801, 0x6001, 0x8000, 0x4000, 0xa801, 0xa702, 0x6000, 0x8000, 0x4000, 0xa803, 0xa702, 0x6001, 0x8000, 0x4000, 0xa701, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation VERTICAL_SCROLL_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2001, 0x400, 1, 2}, {0xa000, PROP_GEO_RIGHT, 0, 0x401}, {0xa000, PROP_GEO_RIGHT, 0, 0x400}, {0x6000, 0x400, 0x401, 0}, {0xa000, PROP_GEO_RIGHT, 0, 0x404}, {0x2001, 0x400, 2, 1}, {0x2001, 0x401, 1, 2}, {0x6000, 0x400, 0x407, 0}, {0x6000, 0x401, 0x407, 0}, {0xa000, PROP_GEO_BOTTOM, 0, 0x409}, {0xa000, PROP_GEO_BOTTOM, 0, 0x401}, {0xa000, PROP_GEO_BOTTOM, 0, 0x400}, {0xa000, PROP_GEO_BOTTOM, 0, 0x404}
};

const TextRectangle VERTICAL_SCROLL_TRS[] =
{
  { {CALCULATED_VALUE(0), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(12)} }
};

const int VERTICAL_SCROLL_DEFAULT_ADJUST[] =
{
  2700
};

const Vertex HORIZONTAL_SCROLL_VERTICES[] =
{
  {0, CALCULATED_VALUE(4)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), 0}, {21600, CALCULATED_VALUE(1)}, {21600, CALCULATED_VALUE(13)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(1), 21600}, {0, CALCULATED_VALUE(11)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(9), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(6)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), 0}, {21600, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(6)}, {0, CALCULATED_VALUE(4)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(11)}
};

const unsigned short HORIZONTAL_SCROLL_SEGMENTS[] =
{
  0x4000, 0xa801, 0x0002, 0xa802, 0x0001, 0xa801, 0x0002, 0xa802, 0x6001, 0x8000, 0x4000, 0xa803, 0x6000, 0x8000, 0x4000, 0xa803, 0xa702, 0x6000, 0x8000, 0x4000, 0xa701, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation HORIZONTAL_SCROLL_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2001, 0x400, 1, 2}, {0xa000, PROP_GEO_RIGHT, 0, 0x401}, {0xa000, PROP_GEO_RIGHT, 0, 0x400}, {0x6000, 0x400, 0x401, 0}, {0xa000, PROP_GEO_RIGHT, 0, 0x404}, {0x2001, 0x400, 2, 1}, {0x2001, 0x401, 1, 2}, {0x6000, 0x400, 0x407, 0}, {0x6000, 0x401, 0x407, 0}, {0xa000, PROP_GEO_BOTTOM, 0, 0x409}, {0xa000, PROP_GEO_BOTTOM, 0, 0x401}, {0xa000, PROP_GEO_BOTTOM, 0, 0x400}, {0xa000, PROP_GEO_BOTTOM, 0, 0x404}
};

const TextRectangle HORIZONTAL_SCROLL_TRS[] =
{
  { {CALCULATED_VALUE(0), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(12)} }
};

const int HORIZONTAL_SCROLL_DEFAULT_ADJUST[] =
{
  2700
};

const Vertex CIRCULAR_ARROW_VERTICES[] =
{
  {CALCULATED_VALUE(0x03), CALCULATED_VALUE(0x03)}, {CALCULATED_VALUE(0x14), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0x13), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0x11), CALCULATED_VALUE(0x10)}, {0, 0}, {21600, 21600}, {CALCULATED_VALUE(0x09), CALCULATED_VALUE(0x08)}, {CALCULATED_VALUE(0x0B), CALCULATED_VALUE(0x0A)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(0x17)}, {CALCULATED_VALUE(0x2F), CALCULATED_VALUE(0x2E)}, {CALCULATED_VALUE(0x1D), CALCULATED_VALUE(0x1C)}
};

const unsigned short CIRCULAR_ARROW_SEGMENTS[] =
{
  0xa404, 0xa504, 0x0003, 0x6001, 0x8000
};

const Calculation CIRCULAR_ARROW_CALC[] =
{
  {0x2000, 0x0147, 0x0000, 0x0000}, {0x2000, 0x0148, 0x0000, 0x0000}, {0x2000, 0x0149, 0x0000, 0x0000}, {0x4000, 0x2A30, 0x0149, 0x0000}, {0x4009, 0x2A30, 0x0147, 0x0000}, {0x400A, 0x2A30, 0x0147, 0x0000}, {0x4009, 0x2A30, 0x0148, 0x0000}, {0x400A, 0x2A30, 0x0148, 0x0000}, {0x2000, 0x0404, 0x2A30, 0x0000}, {0x2000, 0x0405, 0x2A30, 0x0000}, {0x2000, 0x0406, 0x2A30, 0x0000}, {0x2000, 0x0407, 0x2A30, 0x0000}, {0x6009, 0x0403, 0x0147, 0x0000}, {0x600A, 0x0403, 0x0147, 0x0000}, {0x6009, 0x0403, 0x0148, 0x0000}, {0x600A, 0x0403, 0x0148, 0x0000}, {0x2000, 0x040C, 0x2A30, 0x0000}, {0x2000, 0x040D, 0x2A30, 0x0000}, {0x2000, 0x040E, 0x2A30, 0x0000}, {0x2000, 0x040F, 0x2A30, 0x0000}, {0x8000, 0x5460, 0x0000, 0x0403}, {0x4009, 0x34BC, 0x0148, 0x0000}, {0x400A, 0x34BC, 0x0148, 0x0000}, {0x2000, 0x0415, 0x2A30, 0x0000}, {0x2000, 0x0416, 0x2A30, 0x0000}, {0x2000, 0x0149, 0x0000, 0x0A8C}, {0x6009, 0x0419, 0x0148, 0x0000}, {0x600A, 0x0419, 0x0148, 0x0000}, {0x2000, 0x041A, 0x2A30, 0x0000}, {0x2000, 0x041B, 0x2A30, 0x0000}, {0xA000, 0x041D, 0x0000, 0x0418}, {0xA000, 0x041D, 0x0000, 0x0418}, {0x6001, 0x041E, 0x041F, 0x0001}, {0xA000, 0x041C, 0x0000, 0x0417}, {0xA000, 0x041C, 0x0000, 0x0417}, {0x6001, 0x0421, 0x0422, 0x0001}, {0x6000, 0x0420, 0x0423, 0x0000}, {0x200D, 0x0424, 0x0000, 0x0000}, {0x200E, 0x0148, 0x002D, 0x0000}, {0x6009, 0x0425, 0x0426, 0x0000}, {0x200E, 0x0148, 0x002D, 0x0000}, {0x600A, 0x0425, 0x0428, 0x0000}, {0x000E, 0x0000, 0x002D, 0x0000}, {0x6009, 0x0427, 0x042A, 0x0000}, {0x000E, 0x0000, 0x002D, 0x0000}, {0x6009, 0x0429, 0x042C, 0x0000}, {0x6000, 0x041C, 0x042B, 0x0000}, {0x6000, 0x041D, 0x042D, 0x0000}
};

const TextRectangle CIRCULAR_ARROW_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int CIRCULAR_ARROW_DEFAULT_ADJUST[] =
{
  180 << 16, 0, 5550
};

const CustomShape CS_CIRCULAR_ARROW(
  CIRCULAR_ARROW_VERTICES, sizeof(CIRCULAR_ARROW_VERTICES) / sizeof(Vertex),
  CIRCULAR_ARROW_SEGMENTS, sizeof(CIRCULAR_ARROW_SEGMENTS) / sizeof(unsigned short),
  CIRCULAR_ARROW_CALC, sizeof(CIRCULAR_ARROW_CALC) / sizeof(Calculation),
  CIRCULAR_ARROW_DEFAULT_ADJUST, sizeof(CIRCULAR_ARROW_DEFAULT_ADJUST) / sizeof(int),
  CIRCULAR_ARROW_TRS, sizeof(CIRCULAR_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0, 1 | 2);

const Vertex U_TURN_ARROW_VERTICES[] =
{
  {0, 21600}, {0, 8550}, {0, 3540}, {4370, 0}, {9270, 0}, {13890, 0}, {18570, 3230}, {18600, 8300}, {21600, 8300}, {15680, 14260}, {9700, 8300}, {12500, 8300}, {12320, 6380}, {10870, 5850}, {9320, 5850}, {7770, 5850}, {6040, 6410}, {6110, 8520}, {6110, 21600}
};

const unsigned short U_TURN_ARROW_SEGMENTS[] =
{
  0x4000, 0x0001, 0x2002, 0x0004, 0x2002, 0x0001, 0x6000, 0x8000
};

const TextRectangle U_TURN_ARROW_TRS[] =
{
  { {0, 8280}, {6110, 21600} }
};

const CustomShape CS_U_TURN_ARROW(
  U_TURN_ARROW_VERTICES, sizeof(U_TURN_ARROW_VERTICES) / sizeof(Vertex),
  U_TURN_ARROW_SEGMENTS, sizeof(U_TURN_ARROW_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  U_TURN_ARROW_TRS, sizeof(U_TURN_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex CURVED_RIGHT_ARROW_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(23), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(22), 0}, {0, CALCULATED_VALUE(4)}, {0, CALCULATED_VALUE(15)}, {CALCULATED_VALUE(23), CALCULATED_VALUE(1)}, {0, CALCULATED_VALUE(7)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(14)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(12)}, {0, 0}, {CALCULATED_VALUE(23), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(26), CALCULATED_VALUE(17)}, {0, CALCULATED_VALUE(15)}, {CALCULATED_VALUE(23), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(26), CALCULATED_VALUE(17)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(15)}, {0, 0}, {CALCULATED_VALUE(23), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(22), 0}, {0, CALCULATED_VALUE(4)}, {0, 0}, {CALCULATED_VALUE(23), CALCULATED_VALUE(3)}, {0, CALCULATED_VALUE(4)}, {CALCULATED_VALUE(26), CALCULATED_VALUE(17)}, {0, CALCULATED_VALUE(15)}, {CALCULATED_VALUE(23), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(26), CALCULATED_VALUE(17)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(15)}
};

const unsigned short CURVED_RIGHT_ARROW_SEGMENTS[] =
{
  0xa404, 0xA304, 0x0003, 0xa508, 0x6000, 0x8000, 0xa404, 0xa304, 0xa504, 0x6000, 0x8000
};

const Calculation CURVED_RIGHT_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0xa000, PROP_ADJUST_VAL_FIRST, 21600, PROP_ADJUST_VAL_FIRST + 1}, {0x2001, 0x403, 1, 2}, {0x6000, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0xe000, 0x405, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x406, 1, 2}, {0x4002, 21600, PROP_ADJUST_VAL_FIRST, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 2}, {0xa00f, 0x409, 21600, 0x404}, {0x6000, 0x404, 0x40a, 0}, {0x6000, 0x40b, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0x6000, 0x407, 0x40a, 0}, {0xa000, 0x40c, 21600, PROP_ADJUST_VAL_FIRST}, {0xa000, 0x405, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x40f, 1, 2}, {0x6002, 0x404, 0x407, 0}, {0x6000, PROP_ADJUST_VAL_FIRST, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0x2001, 0x412, 1, 2}, {0xa000, 0x411, 0, 0x413}, {0x0000, 21600, 0, 0}, {0x0000, 21600, 0, 0}, {0x0001, 21600, 2, 1}, {0xa000, 0x411, 0, 0x404}, {0x600f, 0x418, 0x404, 21600}, {0x8000, 21600, 0, 0x419}, {0x2000, 0x408, 128, 0}, {0x2001, 0x405, 1, 2}, {0x2000, 0x405, 0, 128}, {0xe000, PROP_ADJUST_VAL_FIRST, 0x411, 0x40c}, {0x600f, 0x414, 0x404, 21600}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x420, 1, 2}, {0x0001, 21600, 21600, 1}, {0x6001, 0x409, 0x409, 1}, {0xa000, 0x422, 0, 0x423}, {0x200d, 0x424, 0, 0}, {0x2000, 0x425, 21600, 0}, {0x8001, 21600, 21600, 0x426}, {0x2000, 0x427, 64, 0}, {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x600f, 0x421, 0x429, 21600}, {0x8000, 21600, 0, 0x42a}, {0x2000, 0x42b, 64, 0}, {0x2001, 0x404, 1, 2}, {0xa000, PROP_ADJUST_VAL_FIRST + 1, 0, 0x42d}, {0x0001, 21600, 2195, 16384}, {0x0001, 21600, 14189, 16384}
};

const TextRectangle CURVED_RIGHT_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(47), CALCULATED_VALUE(45)}, {CALCULATED_VALUE(48), CALCULATED_VALUE(46)} }
};

const int CURVED_RIGHT_ARROW_DEFAULT_ADJUST[] =
{
  12960, 19440, 14400
};

const Vertex CURVED_RIGHT_ARROW_GLUE_POINTS[] =
{
  {0, CALCULATED_VALUE(17)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(14)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(16)}
};

const CustomShape CS_CURVED_RIGHT_ARROW(
  CURVED_RIGHT_ARROW_VERTICES, sizeof(CURVED_RIGHT_ARROW_VERTICES) / sizeof(Vertex),
  CURVED_RIGHT_ARROW_SEGMENTS, sizeof(CURVED_RIGHT_ARROW_SEGMENTS) / sizeof(unsigned short),
  CURVED_RIGHT_ARROW_CALC, sizeof(CURVED_RIGHT_ARROW_CALC) / sizeof(Calculation),
  CURVED_RIGHT_ARROW_DEFAULT_ADJUST, sizeof(CURVED_RIGHT_ARROW_DEFAULT_ADJUST) / sizeof(int),
  CURVED_RIGHT_ARROW_TRS, sizeof(CURVED_RIGHT_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  CURVED_RIGHT_ARROW_GLUE_POINTS, sizeof(CURVED_RIGHT_ARROW_GLUE_POINTS) / sizeof(Vertex));

const Vertex CURVED_LEFT_ARROW_VERTICES[] =
{
  {CALCULATED_VALUE(22), 0}, {CALCULATED_VALUE(21), CALCULATED_VALUE(3)}, {0, 0}, {CALCULATED_VALUE(21), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(14)}, {CALCULATED_VALUE(21), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(21), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(13)}, {0, CALCULATED_VALUE(8)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(22), 0}, {CALCULATED_VALUE(21), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(24), CALCULATED_VALUE(16)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(14)}, {CALCULATED_VALUE(21), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(24), CALCULATED_VALUE(16)}, {0, CALCULATED_VALUE(14)}, {CALCULATED_VALUE(22), 0}, {CALCULATED_VALUE(21), CALCULATED_VALUE(3)}, {0, 0}, {CALCULATED_VALUE(21), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(14)}, {CALCULATED_VALUE(21), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(21), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(24), CALCULATED_VALUE(16)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(14)}, {CALCULATED_VALUE(21), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(24), CALCULATED_VALUE(16)}, {0, CALCULATED_VALUE(14)}
};

const unsigned short CURVED_LEFT_ARROW_SEGMENTS[] =
{
  0xa608, 0x0003, 0xa308, 0x6000, 0x8000, 0xa604, 0xa308, 0x6000, 0x8000
};

const Calculation CURVED_LEFT_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0xa000, PROP_ADJUST_VAL_FIRST, 21600, PROP_ADJUST_VAL_FIRST + 1}, {0x2001, 0x403, 1, 2}, {0x6000, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0xe000, 0x405, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x406, 1, 2}, {0x4002, 21600, PROP_ADJUST_VAL_FIRST, 0}, {0xa00f, PROP_ADJUST_VAL_FIRST + 2, 21600, 0x404}, {0x6000, 0x404, 0x409, 0}, {0x6000, 0x40a, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0x6000, 0x407, 0x409, 0}, {0xa000, 0x40b, 21600, PROP_ADJUST_VAL_FIRST}, {0xa000, 0x405, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x40e, 1, 2}, {0x6002, 0x404, 0x407, 0}, {0x6000, PROP_ADJUST_VAL_FIRST, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0x2001, 0x411, 1, 2}, {0xa000, 0x410, 0, 0x412}, {0x0000, 21600, 0, 0}, {0x0000, 21600, 0, 0}, {0x0000, 0, 0, 21600}, {0xa000, 0x410, 0, 0x404}, {0x600f, 0x417, 0x404, 21600}, {0x2000, 0x408, 128, 0}, {0x2001, 0x405, 1, 2}, {0x2000, 0x405, 0, 128}, {0xe000, PROP_ADJUST_VAL_FIRST, 0x410, 0x40b}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x41d, 1, 2}, {0x0001, 21600, 21600, 1}, {0x6001, PROP_ADJUST_VAL_FIRST + 2, PROP_ADJUST_VAL_FIRST + 2, 1}, {0xa000, 0x41f, 0, 0x420}, {0x200d, 0x421, 0, 0}, {0x2000, 0x422, 21600, 0}, {0x8001, 21600, 21600, 0x423}, {0x2000, 0x424, 64, 0}, {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x600f, 0x41e, 0x426, 21600}, {0x2000, 0x427, 0, 64}, {0x2001, 0x404, 1, 2}, {0xa000, PROP_ADJUST_VAL_FIRST + 1, 0, 0x429}, {0x0001, 21600, 2195, 16384}, {0x0001, 21600, 14189, 16384}
};

const TextRectangle CURVED_LEFT_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(43), CALCULATED_VALUE(41)}, {CALCULATED_VALUE(44), CALCULATED_VALUE(42)} }
};

const int CURVED_LEFT_ARROW_DEFAULT_ADJUST[] =
{
  12960, 19440, 7200
};

const Vertex CURVED_LEFT_ARROW_GLUE_POINTS[] =
{
  {0, CALCULATED_VALUE(15)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(11)}, {0, CALCULATED_VALUE(8)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(21), CALCULATED_VALUE(16)}
};


const Vertex CURVED_DOWN_ARROW_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(23)}, {0, CALCULATED_VALUE(22)}, {CALCULATED_VALUE(4), 0}, {CALCULATED_VALUE(15), 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(23)}, {CALCULATED_VALUE(7), 0}, {CALCULATED_VALUE(13), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(14), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(22)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(2)}, {0, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(23)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(17), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(15), 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(23)}, {CALCULATED_VALUE(17), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(15), CALCULATED_VALUE(22)}, {0, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(23)}, {0, CALCULATED_VALUE(22)}, {CALCULATED_VALUE(4), 0}, {0, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(23)}, {CALCULATED_VALUE(4), 0}, {CALCULATED_VALUE(17), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(15), 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(23)}, {CALCULATED_VALUE(17), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(15), CALCULATED_VALUE(22)}
};

const unsigned short CURVED_DOWN_ARROW_SEGMENTS[] =
{
  0xa604, 0xa504, 0x0003, 0xa308, 0x6000, 0x8000, 0xa604, 0xa504, 0xa304, 0x6000, 0x8000
};

const Calculation CURVED_DOWN_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0xa000, PROP_ADJUST_VAL_FIRST, 21600, PROP_ADJUST_VAL_FIRST + 1}, {0x2001, 0x403, 1, 2}, {0x6000, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0xe000, 0x405, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x406, 1, 2}, {0x4002, 21600, PROP_ADJUST_VAL_FIRST, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 2}, {0xa00f, 0x409, 21600, 0x404}, {0x6000, 0x404, 0x40a, 0}, {0x6000, 0x40b, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0x6000, 0x407, 0x40a, 0}, {0xa000, 0x40c, 21600, PROP_ADJUST_VAL_FIRST}, {0xa000, 0x405, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x40f, 1, 2}, {0x6002, 0x404, 0x407, 0}, {0x6000, PROP_ADJUST_VAL_FIRST, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0x2001, 0x412, 1, 2}, {0xa000, 0x411, 0, 0x413}, {0x0000, 21600, 0, 0}, {0x0000, 21600, 0, 0}, {0x0001, 21600, 2, 1}, {0xa000, 0x411, 0, 0x404}, {0x600f, 0x418, 0x404, 21600}, {0x8000, 21600, 0, 0x419}, {0x2000, 0x408, 128, 0}, {0x2001, 0x405, 1, 2}, {0x2000, 0x405, 0, 128}, {0xe000, PROP_ADJUST_VAL_FIRST, 0x411, 0x40c}, {0x600f, 0x414, 0x404, 21600}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x420, 1, 2}, {0x0001, 21600, 21600, 1}, {0x6001, 0x409, 0x409, 1}, {0xa000, 0x422, 0, 0x423}, {0x200d, 0x424, 0, 0}, {0x2000, 0x425, 21600, 0}, {0x8001, 21600, 21600, 0x426}, {0x2000, 0x427, 64, 0}, {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x600f, 0x421, 0x429, 21600}, {0x8000, 21600, 0, 0x42a}, {0x2000, 0x42b, 64, 0}, {0x2001, 0x404, 1, 2}, {0xa000, PROP_ADJUST_VAL_FIRST + 1, 0, 0x42d}, {0x0001, 21600, 2195, 16384}, {0x0001, 21600, 14189, 16384}
};

const TextRectangle CURVED_DOWN_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(45), CALCULATED_VALUE(47)}, {CALCULATED_VALUE(46), CALCULATED_VALUE(48)} }
};

const int CURVED_DOWN_ARROW_DEFAULT_ADJUST[] =
{
  12960, 19440, 14400
};

const Vertex CURVED_DOWN_ARROW_GLUE_POINTS[] =
{
  {CALCULATED_VALUE(17), 0}, {CALCULATED_VALUE(16), CALCULATED_VALUE(22)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(22)}, {CALCULATED_VALUE(14), CALCULATED_VALUE(2)}
};

const CustomShape CS_CURVED_DOWN_ARROW(
  CURVED_DOWN_ARROW_VERTICES, sizeof(CURVED_DOWN_ARROW_VERTICES) / sizeof(Vertex),
  CURVED_DOWN_ARROW_SEGMENTS, sizeof(CURVED_DOWN_ARROW_SEGMENTS) / sizeof(unsigned short),
  CURVED_DOWN_ARROW_CALC, sizeof(CURVED_DOWN_ARROW_CALC) / sizeof(Calculation),
  CURVED_DOWN_ARROW_DEFAULT_ADJUST, sizeof(CURVED_DOWN_ARROW_DEFAULT_ADJUST) / sizeof(int),
  CURVED_DOWN_ARROW_TRS, sizeof(CURVED_DOWN_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  CURVED_DOWN_ARROW_GLUE_POINTS, sizeof(CURVED_DOWN_ARROW_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_PREDEFINED_PROCESS_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {2540, 0}, {2540, 21600}, {21600 - 2540, 0}, {21600 - 2540, 21600}
};

const unsigned short FLOW_CHART_PREDEFINED_PROCESS_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6000, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const TextRectangle FLOW_CHART_PREDEFINED_PROCESS_TRS[] =
{
  { {2540, 0}, {21600 - 2540, 21600} }
};

const Vertex FLOW_CHART_INTERNAL_STORAGE_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {4230, 0}, {4230, 21600}, {0, 4230}, {21600, 4230}
};

const unsigned short FLOW_CHART_INTERNAL_STORAGE_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6000, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const TextRectangle FLOW_CHART_INTERNAL_STORAGE_TRS[] =
{
  { {4230, 4230}, {21600, 21600} }
};

const CustomShape CS_FLOW_CHART_INTERNAL_STORAGE(
  FLOW_CHART_INTERNAL_STORAGE_VERTICES, sizeof(FLOW_CHART_INTERNAL_STORAGE_VERTICES) / sizeof(Vertex),
  FLOW_CHART_INTERNAL_STORAGE_SEGMENTS, sizeof(FLOW_CHART_INTERNAL_STORAGE_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_INTERNAL_STORAGE_TRS, sizeof(FLOW_CHART_INTERNAL_STORAGE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex FLOW_CHART_DOCUMENT_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 17360}, {13050, 17220}, {13340, 20770}, {5620, 21600}, {2860, 21100}, {1850, 20700}, {0, 20120}
};

const unsigned short FLOW_CHART_DOCUMENT_SEGMENTS[] =
{
  0x4000, 0x0002, 0x2002, 0x6000, 0x8000
};

const TextRectangle FLOW_CHART_DOCUMENT_TRS[] =
{
  { {0, 0}, {21600, 17360} }
};

const Vertex FLOW_CHART_DOCUMENT_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 20320}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_DOCUMENT(
  FLOW_CHART_DOCUMENT_VERTICES, sizeof(FLOW_CHART_DOCUMENT_VERTICES) / sizeof(Vertex),
  FLOW_CHART_DOCUMENT_SEGMENTS, sizeof(FLOW_CHART_DOCUMENT_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_DOCUMENT_TRS, sizeof(FLOW_CHART_DOCUMENT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_DOCUMENT_GLUE_POINTS, sizeof(FLOW_CHART_DOCUMENT_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_MULTI_DOCUMENT_VERTICES[] =
{
  {0, 3600}, {1500, 3600}, {1500, 1800}, {3000, 1800}, {3000, 0}, {21600, 0}, {21600, 14409}, {21600 - 1500, 14409}, {21600 - 1500, 14409 + 1800}, {21600 - 3000, 14409 + 1800}, {21600 - 3000, 14409 + 3600}, {11610, 14293 + 3600}, {11472, 17239 + 3600}, {4833, 17928 + 3600}, {2450, 17513 + 3600}, {1591, 17181 + 3600}, {0, 16700 + 3600}, {1500, 3600}, {21600 - 3000, 3600}, {21600 - 3000, 14409 + 1800}, {3000, 1800}, {21600 - 1500, 1800}, {21600 - 1500, 14409}
};

const unsigned short FLOW_CHART_MULTI_DOCUMENT_SEGMENTS[] =
{
  0x4000, 0x000a, 0x2002, 0x6000, 0x8000, 0x4000, 0xaa00, 0x0002, 0x8000, 0x4000, 0xaa00, 0x0002, 0x8000
};

const TextRectangle FLOW_CHART_MULTI_DOCUMENT_TRS[] =
{
  { {0, 3600}, {21600 - 3600, 14409 + 3600} }
};

const Vertex FLOW_CHART_MULTI_DOCUMENT_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 19890}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_MULTI_DOCUMENT(
  FLOW_CHART_MULTI_DOCUMENT_VERTICES, sizeof(FLOW_CHART_MULTI_DOCUMENT_VERTICES) / sizeof(Vertex),
  FLOW_CHART_MULTI_DOCUMENT_SEGMENTS, sizeof(FLOW_CHART_MULTI_DOCUMENT_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_MULTI_DOCUMENT_TRS, sizeof(FLOW_CHART_MULTI_DOCUMENT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_MULTI_DOCUMENT_GLUE_POINTS, sizeof(FLOW_CHART_MULTI_DOCUMENT_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_TERMINATOR_VERTICES[] =
{
  {3470, 21600}, {0, 10800}, {3470, 0}, {18130, 0}, {21600, 10800}, {18130, 21600}
};

const unsigned short FLOW_CHART_TERMINATOR_SEGMENTS[] =
{
  0x4000, 0xa702, 0x0001, 0xa702, 0x6000, 0x8000
};

const TextRectangle FLOW_CHART_TERMINATOR_TRS[] =
{
  { {1060, 3180}, {20540, 18420} }
};

const Vertex FLOW_CHART_TERMINATOR_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_TERMINATOR(
  FLOW_CHART_TERMINATOR_VERTICES, sizeof(FLOW_CHART_TERMINATOR_VERTICES) / sizeof(Vertex),
  FLOW_CHART_TERMINATOR_SEGMENTS, sizeof(FLOW_CHART_TERMINATOR_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_TERMINATOR_TRS, sizeof(FLOW_CHART_TERMINATOR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_TERMINATOR_GLUE_POINTS, sizeof(FLOW_CHART_TERMINATOR_GLUE_POINTS) / sizeof(Vertex));

const CustomShape CS_FLOW_CHART_PREDEFINED_PROCESS(
  FLOW_CHART_PREDEFINED_PROCESS_VERTICES, sizeof(FLOW_CHART_PREDEFINED_PROCESS_VERTICES) / sizeof(Vertex),
  FLOW_CHART_PREDEFINED_PROCESS_SEGMENTS, sizeof(FLOW_CHART_PREDEFINED_PROCESS_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_PREDEFINED_PROCESS_TRS, sizeof(FLOW_CHART_PREDEFINED_PROCESS_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex FLOW_CHART_IO_VERTICES[] =
{
  {4230, 0}, {21600, 0}, {17370, 21600}, {0, 21600}, {4230, 0}
};

const TextRectangle FLOW_CHART_IO_TRS[] =
{
  { {4230, 0}, {17370, 21600} }
};

const Vertex FLOW_CHART_IO_GLUE_POINTS[] =
{
  {12960, 0}, {10800, 0}, {2160, 10800}, {8600, 21600}, {10800, 21600}, {19400, 10800}
};

const CustomShape CS_FLOW_CHART_IO(
  FLOW_CHART_IO_VERTICES, sizeof(FLOW_CHART_IO_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  FLOW_CHART_IO_TRS, sizeof(FLOW_CHART_IO_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_IO_GLUE_POINTS, sizeof(FLOW_CHART_IO_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_PROCESS_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}
};

const Vertex FLOW_CHART_PROCESS_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const Vertex FLOW_CHART_DECISION_VERTICES[] =
{
  {0, 10800}, {10800, 0}, {21600, 10800}, {10800, 21600}, {0, 10800}
};

const TextRectangle FLOW_CHART_DECISION_TRS[] =
{
  { {5400, 5400}, {16200, 16200} }
};

const Vertex FLOW_CHART_DECISION_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_DECISION(
  FLOW_CHART_DECISION_VERTICES, sizeof(FLOW_CHART_DECISION_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  FLOW_CHART_DECISION_TRS, sizeof(FLOW_CHART_DECISION_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_DECISION_GLUE_POINTS, sizeof(FLOW_CHART_DECISION_GLUE_POINTS) / sizeof(Vertex));

const CustomShape CS_FLOW_CHART_PROCESS(
  FLOW_CHART_PROCESS_VERTICES, sizeof(FLOW_CHART_PROCESS_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  NULL, 0,
  21600, 21600,
  FLOW_CHART_PROCESS_GLUE_POINTS, sizeof(FLOW_CHART_PROCESS_GLUE_POINTS) / sizeof(Vertex));

const Vertex CURVED_UP_ARROW_VERTICES[] =
{
  {0, CALCULATED_VALUE(22)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(21)}, {0, 0}, {CALCULATED_VALUE(4), CALCULATED_VALUE(21)}, {CALCULATED_VALUE(14), CALCULATED_VALUE(22)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(21)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(21)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(13), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(8), 0}, {CALCULATED_VALUE(11), CALCULATED_VALUE(2)}, {0, CALCULATED_VALUE(22)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(21)}, {CALCULATED_VALUE(10), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(14), CALCULATED_VALUE(22)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(21)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(14), 0}, {0, CALCULATED_VALUE(22)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(21)}, {0, 0}, {CALCULATED_VALUE(4), CALCULATED_VALUE(21)}, {CALCULATED_VALUE(14), CALCULATED_VALUE(22)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(21)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(21)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(14), CALCULATED_VALUE(22)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(21)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(14), 0}
};

const unsigned short CURVED_UP_ARROW_SEGMENTS[] =
{
  0xa408, 0x0003, 0xa508, 0x6000, 0x8000, 0xa404, 0xa508, 0xa504, 0x6000, 0x8000
};

const Calculation CURVED_UP_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0xa000, PROP_ADJUST_VAL_FIRST, 21600, PROP_ADJUST_VAL_FIRST + 1}, {0x2001, 0x403, 1, 2}, {0x6000, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0xe000, 0x405, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x406, 1, 2}, {0x4002, 21600, PROP_ADJUST_VAL_FIRST, 0}, {0xa00f, PROP_ADJUST_VAL_FIRST + 2, 21600, 0x404}, {0x6000, 0x404, 0x409, 0}, {0x6000, 0x40a, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0x6000, 0x407, 0x409, 0}, {0xa000, 0x40b, 21600, PROP_ADJUST_VAL_FIRST}, {0xa000, 0x405, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x40e, 1, 2}, {0x6002, 0x404, 0x407, 0}, {0x6000, PROP_ADJUST_VAL_FIRST, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0x2001, 0x411, 1, 2}, {0xa000, 0x410, 0, 0x412}, {0x0000, 21600, 0, 0}, {0x0000, 21600, 0, 0}, {0x0000, 0, 0, 21600}, {0xa000, 0x410, 0, 0x404}, {0x600f, 0x417, 0x404, 21600}, {0x2000, 0x408, 128, 0}, {0x2001, 0x405, 1, 2}, {0x2000, 0x405, 0, 128}, {0xe000, PROP_ADJUST_VAL_FIRST, 0x410, 0x40b}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x41d, 1, 2}, {0x0001, 21600, 21600, 1}, {0x6001, PROP_ADJUST_VAL_FIRST + 2, PROP_ADJUST_VAL_FIRST + 2, 1}, {0xa000, 0x41f, 0, 0x420}, {0x200d, 0x421, 0, 0}, {0x2000, 0x422, 21600, 0}, {0x8001, 21600, 21600, 0x423}, {0x2000, 0x424, 64, 0}, {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x600f, 0x41e, 0x426, 21600}, {0x2000, 0x427, 0, 64}, {0x2001, 0x404, 1, 2}, {0xa000, PROP_ADJUST_VAL_FIRST + 1, 0, 0x429}, {0x0001, 21600, 2195, 16384}, {0x0001, 21600, 14189, 16384}
};

const TextRectangle CURVED_UP_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(41), CALCULATED_VALUE(43)}, {CALCULATED_VALUE(42), CALCULATED_VALUE(44)} }
};

const int CURVED_UP_ARROW_DEFAULT_ADJUST[] =
{
  12960, 19440, 7200
};

const Vertex CURVED_UP_ARROW_GLUE_POINTS[] =
{
  {CALCULATED_VALUE(8), 0}, {CALCULATED_VALUE(11), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(15), 0}, {CALCULATED_VALUE(16), CALCULATED_VALUE(21)}, {CALCULATED_VALUE(13), CALCULATED_VALUE(2)}
};

const CustomShape CS_CURVED_UP_ARROW(
  CURVED_UP_ARROW_VERTICES, sizeof(CURVED_UP_ARROW_VERTICES) / sizeof(Vertex),
  CURVED_UP_ARROW_SEGMENTS, sizeof(CURVED_UP_ARROW_SEGMENTS) / sizeof(unsigned short),
  CURVED_UP_ARROW_CALC, sizeof(CURVED_UP_ARROW_CALC) / sizeof(Calculation),
  CURVED_UP_ARROW_DEFAULT_ADJUST, sizeof(CURVED_UP_ARROW_DEFAULT_ADJUST) / sizeof(int),
  CURVED_UP_ARROW_TRS, sizeof(CURVED_UP_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  CURVED_UP_ARROW_GLUE_POINTS, sizeof(CURVED_UP_ARROW_GLUE_POINTS) / sizeof(Vertex));

const CustomShape CS_CURVED_LEFT_ARROW(
  CURVED_LEFT_ARROW_VERTICES, sizeof(CURVED_LEFT_ARROW_VERTICES) / sizeof(Vertex),
  CURVED_LEFT_ARROW_SEGMENTS, sizeof(CURVED_LEFT_ARROW_SEGMENTS) / sizeof(unsigned short),
  CURVED_LEFT_ARROW_CALC, sizeof(CURVED_LEFT_ARROW_CALC) / sizeof(Calculation),
  CURVED_LEFT_ARROW_DEFAULT_ADJUST, sizeof(CURVED_LEFT_ARROW_DEFAULT_ADJUST) / sizeof(int),
  CURVED_LEFT_ARROW_TRS, sizeof(CURVED_LEFT_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  CURVED_LEFT_ARROW_GLUE_POINTS, sizeof(CURVED_LEFT_ARROW_GLUE_POINTS) / sizeof(Vertex));

const CustomShape CS_HORIZONTAL_SCROLL(
  HORIZONTAL_SCROLL_VERTICES, sizeof(HORIZONTAL_SCROLL_VERTICES) / sizeof(Vertex),
  HORIZONTAL_SCROLL_SEGMENTS, sizeof(HORIZONTAL_SCROLL_SEGMENTS) / sizeof(unsigned short),
  HORIZONTAL_SCROLL_CALC, sizeof(HORIZONTAL_SCROLL_CALC) / sizeof(Calculation),
  HORIZONTAL_SCROLL_DEFAULT_ADJUST, sizeof(HORIZONTAL_SCROLL_DEFAULT_ADJUST) / sizeof(int),
  HORIZONTAL_SCROLL_TRS, sizeof(HORIZONTAL_SCROLL_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const CustomShape CS_VERTICAL_SCROLL(
  VERTICAL_SCROLL_VERTICES, sizeof(VERTICAL_SCROLL_VERTICES) / sizeof(Vertex),
  VERTICAL_SCROLL_SEGMENTS, sizeof(VERTICAL_SCROLL_SEGMENTS) / sizeof(unsigned short),
  VERTICAL_SCROLL_CALC, sizeof(VERTICAL_SCROLL_CALC) / sizeof(Calculation),
  VERTICAL_SCROLL_DEFAULT_ADJUST, sizeof(VERTICAL_SCROLL_DEFAULT_ADJUST) / sizeof(int),
  VERTICAL_SCROLL_TRS, sizeof(VERTICAL_SCROLL_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const CustomShape CS_SMILEY_FACE(
  SMILEY_FACE_VERTICES, sizeof(SMILEY_FACE_VERTICES) / sizeof(Vertex),
  SMILEY_FACE_SEGMENTS, sizeof(SMILEY_FACE_SEGMENTS) / sizeof(unsigned short),
  SMILEY_FACE_CALC, sizeof(SMILEY_FACE_CALC) / sizeof(Calculation),
  SMILEY_FACE_DEFAULT_ADJUST, sizeof(SMILEY_FACE_DEFAULT_ADJUST) / sizeof(int),
  SMILEY_FACE_TRS, sizeof(SMILEY_FACE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  SMILEY_FACE_GLUE_POINTS, sizeof(SMILEY_FACE_GLUE_POINTS) / sizeof(Vertex));

const Vertex BLOCK_ARC_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {CALCULATED_VALUE(4), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(6), CALCULATED_VALUE(6)}, {CALCULATED_VALUE(9), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(10)}
};

const unsigned short BLOCK_ARC_SEGMENTS[] =
{
  0xA404, 0xa504, 0x6001, 0x8000
};

const Calculation BLOCK_ARC_CALC[] =
{
  {0x400a, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x4009, 10800, PROP_ADJUST_VAL_FIRST, 0},
  {0x2000, 0x400, 10800, 0},
  {0x2000, 0x401, 10800, 0}, {0x8000, 21600, 0, 0x402},
  {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST + 1},
  {0x4000, 10800, PROP_ADJUST_VAL_FIRST + 1, 0},
  {0x600a, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST, 0},
  {0x6009, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST, 0},
  {0x4000, 10800, 0x407, 0}, {0x4000, 10800, 0x408, 0}, {0x8000, 10800,0, 0x407}
};

const int BLOCK_ARC_DEFAULT_ADJUST[] =
{
  180 << 16, 5400
};

const CustomShape CS_BLOCK_ARC(
  BLOCK_ARC_VERTICES, sizeof(BLOCK_ARC_VERTICES) / sizeof(Vertex),
  BLOCK_ARC_SEGMENTS, sizeof(BLOCK_ARC_SEGMENTS) / sizeof(unsigned short),
  BLOCK_ARC_CALC, sizeof(BLOCK_ARC_CALC) / sizeof(Calculation),
  BLOCK_ARC_DEFAULT_ADJUST, sizeof(BLOCK_ARC_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  NULL, 0, 0x1);

const Vertex NOTCHED_RIGHT_ARROW_VERTICES[] =
{
  {0, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0), 0}, {21600, 10800}, {CALCULATED_VALUE(0), 21600}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}, {0, CALCULATED_VALUE(2)}, {CALCULATED_VALUE(5), 10800}, {0, CALCULATED_VALUE(1)}
};

const Calculation NOTCHED_RIGHT_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x6001, 0x403, 0x404, 10800}
};

const TextRectangle NOTCHED_RIGHT_ARROW_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int NOTCHED_RIGHT_ARROW_DEFAULT_ADJUST[] =
{
  16200, 5400
};

const CustomShape CS_NOTCHED_RIGHT_ARROW(
  NOTCHED_RIGHT_ARROW_VERTICES, sizeof(NOTCHED_RIGHT_ARROW_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NOTCHED_RIGHT_ARROW_CALC, sizeof(NOTCHED_RIGHT_ARROW_CALC) / sizeof(Calculation),
  NOTCHED_RIGHT_ARROW_DEFAULT_ADJUST, sizeof(NOTCHED_RIGHT_ARROW_DEFAULT_ADJUST) / sizeof(int),
  NOTCHED_RIGHT_ARROW_TRS, sizeof(NOTCHED_RIGHT_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex STRIPED_RIGHT_ARROW_VERTICES[] =
{
  {3375, CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), 0}, {21600, 10800}, {CALCULATED_VALUE(1), 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {3375, CALCULATED_VALUE(2)}, {0, CALCULATED_VALUE(0)}, {675, CALCULATED_VALUE(0)}, {675, CALCULATED_VALUE(2)}, {0, CALCULATED_VALUE(2)}, {1350, CALCULATED_VALUE(0)}, {2700, CALCULATED_VALUE(0)}, {2700, CALCULATED_VALUE(2)}, {1350, CALCULATED_VALUE(2)}
};

const unsigned short STRIPED_RIGHT_ARROW_SEGMENTS[] =
{
  0x4000, 0x0006, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000
};

const Calculation STRIPED_RIGHT_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 21600, 0, 0x401}, {0x6001, 0x403, 0x400, 10800}, {0x6000, 0x401, 0x404, 0}
};

const TextRectangle STRIPED_RIGHT_ARROW_TRS[] =
{
  { {3375, CALCULATED_VALUE(0)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(2)} }
};

const int STRIPED_RIGHT_ARROW_DEFAULT_ADJUST[] =
{
  16200, 5400
};

const CustomShape CS_STRIPED_RIGHT_ARROW(
  STRIPED_RIGHT_ARROW_VERTICES, sizeof(STRIPED_RIGHT_ARROW_VERTICES) / sizeof(Vertex),
  STRIPED_RIGHT_ARROW_SEGMENTS, sizeof(STRIPED_RIGHT_ARROW_SEGMENTS) / sizeof(unsigned short),
  STRIPED_RIGHT_ARROW_CALC, sizeof(STRIPED_RIGHT_ARROW_CALC) / sizeof(Calculation),
  STRIPED_RIGHT_ARROW_DEFAULT_ADJUST, sizeof(STRIPED_RIGHT_ARROW_DEFAULT_ADJUST) / sizeof(int),
  STRIPED_RIGHT_ARROW_TRS, sizeof(STRIPED_RIGHT_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex SEAL_24_VERTICES[] =
{
  {CALCULATED_VALUE(0x05), CALCULATED_VALUE(0x06)}, {CALCULATED_VALUE(0x07), CALCULATED_VALUE(0x08)}, {CALCULATED_VALUE(0x09), CALCULATED_VALUE(0x0a)}, {CALCULATED_VALUE(0x0b), CALCULATED_VALUE(0x0c)}, {CALCULATED_VALUE(0x0d), CALCULATED_VALUE(0x0e)}, {CALCULATED_VALUE(0x0f), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x11), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0x13), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0x15), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0x17), CALCULATED_VALUE(0x18)}, {CALCULATED_VALUE(0x19), CALCULATED_VALUE(0x1a)}, {CALCULATED_VALUE(0x1b), CALCULATED_VALUE(0x1c)}, {CALCULATED_VALUE(0x1d), CALCULATED_VALUE(0x1e)}, {CALCULATED_VALUE(0x1f), CALCULATED_VALUE(0x20)}, {CALCULATED_VALUE(0x21), CALCULATED_VALUE(0x22)}, {CALCULATED_VALUE(0x23), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x25), CALCULATED_VALUE(0x26)}, {CALCULATED_VALUE(0x27), CALCULATED_VALUE(0x28)}, {CALCULATED_VALUE(0x29), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(0x2b), CALCULATED_VALUE(0x2c)}, {CALCULATED_VALUE(0x2d), CALCULATED_VALUE(0x2e)}, {CALCULATED_VALUE(0x2f), CALCULATED_VALUE(0x30)}, {CALCULATED_VALUE(0x31), CALCULATED_VALUE(0x32)}, {CALCULATED_VALUE(0x33), CALCULATED_VALUE(0x34)}, {CALCULATED_VALUE(0x35), CALCULATED_VALUE(0x36)}, {CALCULATED_VALUE(0x37), CALCULATED_VALUE(0x38)}, {CALCULATED_VALUE(0x39), CALCULATED_VALUE(0x3a)}, {CALCULATED_VALUE(0x3b), CALCULATED_VALUE(0x3c)}, {CALCULATED_VALUE(0x3d), CALCULATED_VALUE(0x3e)}, {CALCULATED_VALUE(0x3f), CALCULATED_VALUE(0x40)}, {CALCULATED_VALUE(0x41), CALCULATED_VALUE(0x42)}, {CALCULATED_VALUE(0x43), CALCULATED_VALUE(0x44)}, {CALCULATED_VALUE(0x45), CALCULATED_VALUE(0x46)}, {CALCULATED_VALUE(0x47), CALCULATED_VALUE(0x48)}, {CALCULATED_VALUE(0x49), CALCULATED_VALUE(0x4a)}, {CALCULATED_VALUE(0x4b), CALCULATED_VALUE(0x4c)}, {CALCULATED_VALUE(0x4d), CALCULATED_VALUE(0x4e)}, {CALCULATED_VALUE(0x4f), CALCULATED_VALUE(0x50)}, {CALCULATED_VALUE(0x51), CALCULATED_VALUE(0x52)}, {CALCULATED_VALUE(0x53), CALCULATED_VALUE(0x54)}, {CALCULATED_VALUE(0x55), CALCULATED_VALUE(0x56)}, {CALCULATED_VALUE(0x57), CALCULATED_VALUE(0x58)}, {CALCULATED_VALUE(0x59), CALCULATED_VALUE(0x5a)}, {CALCULATED_VALUE(0x5b), CALCULATED_VALUE(0x5c)}, {CALCULATED_VALUE(0x5d), CALCULATED_VALUE(0x5e)}, {CALCULATED_VALUE(0x5f), CALCULATED_VALUE(0x60)}, {CALCULATED_VALUE(0x61), CALCULATED_VALUE(0x62)}, {CALCULATED_VALUE(0x63), CALCULATED_VALUE(0x64)}, {CALCULATED_VALUE(0x05), CALCULATED_VALUE(0x06)}
};

const Calculation SEAL_24_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2081, 0x400, 10800, 315}, {0x2082, 0x400, 10800, 315}, {0x2081, 0x400, 10800, 135}, {0x2082, 0x400, 10800, 135}, {0x0081, 0, 10800, 0}, {0x0082, 0, 10800, 0}, {0x2081, 0x400, 10800, 7}, {0x2082, 0x400, 10800, 7}, {0x0081, 0, 10800, 15}, {0x0082, 0, 10800, 15}, {0x2081, 0x400, 10800, 22}, {0x2082, 0x400, 10800, 22}, {0x0081, 0, 10800, 30}, {0x0082, 0, 10800, 30}, {0x2081, 0x400, 10800, 37}, {0x2082, 0x400, 10800, 37}, {0x0081, 0, 10800, 45}, {0x0082, 0, 10800, 45}, {0x2081, 0x400, 10800, 52}, {0x2082, 0x400, 10800, 52}, {0x0081, 0, 10800, 60}, {0x0082, 0, 10800, 60}, {0x2081, 0x400, 10800, 67}, {0x2082, 0x400, 10800, 67}, {0x0081, 0, 10800, 75}, {0x0082, 0, 10800, 75}, {0x2081, 0x400, 10800, 82}, {0x2082, 0x400, 10800, 82}, {0x0081, 0, 10800, 90}, {0x0082, 0, 10800, 90}, {0x2081, 0x400, 10800, 97}, {0x2082, 0x400, 10800, 97}, {0x0081, 0, 10800, 105}, {0x0082, 0, 10800, 105}, {0x2081, 0x400, 10800, 112}, {0x2082, 0x400, 10800, 112}, {0x0081, 0, 10800, 120}, {0x0082, 0, 10800, 120}, {0x2081, 0x400, 10800, 127}, {0x2082, 0x400, 10800, 127}, {0x0081, 0, 10800, 135}, {0x0082, 0, 10800, 135}, {0x2081, 0x400, 10800, 142}, {0x2082, 0x400, 10800, 142}, {0x0081, 0, 10800, 150}, {0x0082, 0, 10800, 150}, {0x2081, 0x400, 10800, 157}, {0x2082, 0x400, 10800, 157}, {0x0081, 0, 10800, 165}, {0x0082, 0, 10800, 165}, {0x2081, 0x400, 10800, 172}, {0x2082, 0x400, 10800, 172}, {0x0081, 0, 10800, 180}, {0x0082, 0, 10800, 180}, {0x2081, 0x400, 10800, 187}, {0x2082, 0x400, 10800, 187}, {0x0081, 0, 10800, 195}, {0x0082, 0, 10800, 195}, {0x2081, 0x400, 10800, 202}, {0x2082, 0x400, 10800, 202}, {0x0081, 0, 10800, 210}, {0x0082, 0, 10800, 210}, {0x2081, 0x400, 10800, 217}, {0x2082, 0x400, 10800, 217}, {0x0081, 0, 10800, 225}, {0x0082, 0, 10800, 225}, {0x2081, 0x400, 10800, 232}, {0x2082, 0x400, 10800, 232}, {0x0081, 0, 10800, 240}, {0x0082, 0, 10800, 240}, {0x2081, 0x400, 10800, 247}, {0x2082, 0x400, 10800, 247}, {0x0081, 0, 10800, 255}, {0x0082, 0, 10800, 255}, {0x2081, 0x400, 10800, 262}, {0x2082, 0x400, 10800, 262}, {0x0081, 0, 10800, 270}, {0x0082, 0, 10800, 270}, {0x2081, 0x400, 10800, 277}, {0x2082, 0x400, 10800, 277}, {0x0081, 0, 10800, 285}, {0x0082, 0, 10800, 285}, {0x2081, 0x400, 10800, 292}, {0x2082, 0x400, 10800, 292}, {0x0081, 0, 10800, 300}, {0x0082, 0, 10800, 300}, {0x2081, 0x400, 10800, 307}, {0x2082, 0x400, 10800, 307}, {0x0081, 0, 10800, 315}, {0x0082, 0, 10800, 315}, {0x2081, 0x400, 10800, 322}, {0x2082, 0x400, 10800, 322}, {0x0081, 0, 10800, 330}, {0x0082, 0, 10800, 330}, {0x2081, 0x400, 10800, 337}, {0x2082, 0x400, 10800, 337}, {0x0081, 0, 10800, 345}, {0x0082, 0, 10800, 345}, {0x2081, 0x400, 10800, 352}, {0x2082, 0x400, 10800, 352}
};

const TextRectangle SEAL_24_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int SEAL_24_DEFAULT_ADJUST[] =
{
  2500
};

const CustomShape CS_SEAL_24(
  SEAL_24_VERTICES, sizeof(SEAL_24_VERTICES) / sizeof(Vertex),
  NULL, 0,
  SEAL_24_CALC, sizeof(SEAL_24_CALC) / sizeof(Calculation),
  SEAL_24_DEFAULT_ADJUST, sizeof(SEAL_24_DEFAULT_ADJUST) / sizeof(int),
  SEAL_24_TRS, sizeof(SEAL_24_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex BENT_ARROW_VERTICES[] =
{
  {0, 21600}, {0, 12160}, {12427, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0), 0}, {21600, 6079}, {CALCULATED_VALUE(0), 12158}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}, {12427, CALCULATED_VALUE(2)}, {CALCULATED_VALUE(4), 12160}, {CALCULATED_VALUE(4), 21600}
};

const unsigned short BENT_ARROW_SEGMENTS[] =
{
  0x4000, 0x0001, 0xa801, 0x0006, 0xa701, 0x0001, 0x6001, 0x8000
};

const Calculation BENT_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x8000, 12158, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 6079, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x2001, 0x0403, 2, 1}
};

const TextRectangle BENT_ARROW_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int BENT_ARROW_DEFAULT_ADJUST[] =
{
  15100, 2900
};

const CustomShape CS_BENT_ARROW(
  BENT_ARROW_VERTICES, sizeof(BENT_ARROW_VERTICES) / sizeof(Vertex),
  BENT_ARROW_SEGMENTS, sizeof(BENT_ARROW_SEGMENTS) / sizeof(unsigned short),
  BENT_ARROW_CALC, sizeof(BENT_ARROW_CALC) / sizeof(Calculation),
  BENT_ARROW_DEFAULT_ADJUST, sizeof(BENT_ARROW_DEFAULT_ADJUST) / sizeof(int),
  BENT_ARROW_TRS, sizeof(BENT_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex BENT_UP_ARROW_VERTICES[] =
{
  {0, CALCULATED_VALUE(8)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(5), 0}, {21600, CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), 21600}, {0, 21600}
};

const unsigned short BENT_UP_ARROW_SEGMENTS[] =
{
  0x4000, 0x0008, 0x6001, 0x8000
};

const Calculation BENT_UP_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0403, 1, 2}, {0x6000, PROP_ADJUST_VAL_FIRST, 0x0404, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x6000, PROP_ADJUST_VAL_FIRST, 0x0406, 0}, {0x6000, 0x0407, 0x0406, 0}, {0x8000, 21600, 0, 0x406}, {0xa000, 0x409, 0, 0x406}
};

const TextRectangle BENT_UP_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(2), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(1)} }, { {CALCULATED_VALUE(7), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(1)} }
};

const int BENT_UP_ARROW_DEFAULT_ADJUST[] =
{
  9340, 18500, 7200
};

const CustomShape CS_BENT_UP_ARROW(
  BENT_UP_ARROW_VERTICES, sizeof(BENT_UP_ARROW_VERTICES) / sizeof(Vertex),
  BENT_UP_ARROW_SEGMENTS, sizeof(BENT_UP_ARROW_SEGMENTS) / sizeof(unsigned short),
  BENT_UP_ARROW_CALC, sizeof(BENT_UP_ARROW_CALC) / sizeof(Calculation),
  BENT_UP_ARROW_DEFAULT_ADJUST, sizeof(BENT_UP_ARROW_DEFAULT_ADJUST) / sizeof(int),
  BENT_UP_ARROW_TRS, sizeof(BENT_UP_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex DOWN_ARROW_VERTICES[] =
{
  {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {0, CALCULATED_VALUE(1)}, {10800, 21600}, {21600, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), 0}
};

const unsigned short DOWN_ARROW_SEGMENTS[] =
{
  0x4000, 0x0006, 0x6001, 0x8000
};

const Calculation DOWN_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 21600, 0, 0x401}, {0x6001, 0x403, 0x400, 10800}, {0x6000, 0x401, 0x404, 0}, {0x6001, 0x401, 0x400, 10800}, {0xa000, 0x401, 0, 0x406}
};

const TextRectangle DOWN_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(2), CALCULATED_VALUE(5)} }
};

const int DOWN_ARROW_DEFAULT_ADJUST[] =
{
  16200, 5400
};

const CustomShape CS_DOWN_ARROW(
  DOWN_ARROW_VERTICES, sizeof(DOWN_ARROW_VERTICES) / sizeof(Vertex),
  DOWN_ARROW_SEGMENTS, sizeof(DOWN_ARROW_SEGMENTS) / sizeof(unsigned short),
  DOWN_ARROW_CALC, sizeof(DOWN_ARROW_CALC) / sizeof(Calculation),
  DOWN_ARROW_DEFAULT_ADJUST, sizeof(DOWN_ARROW_DEFAULT_ADJUST) / sizeof(int),
  DOWN_ARROW_TRS, sizeof(DOWN_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex UP_ARROW_VERTICES[] =
{
  {CALCULATED_VALUE(0), 21600}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {0, CALCULATED_VALUE(1)}, {10800, 0}, {21600, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), 21600}
};

const unsigned short UP_ARROW_SEGMENTS[] =
{
  0x4000, 0x0006, 0x6001, 0x8000
};

const Calculation UP_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 21600, 0, 0x401}, {0x6001, 0x403, 0x400, 10800}, {0x6000, 0x401, 0x404, 0}, {0x6001, 0x401, 0x400, 10800}, {0xa000, 0x401, 0, 0x406}
};

const TextRectangle UP_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(0), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(2), 21600} }
};

const int UP_ARROW_DEFAULT_ADJUST[] =
{
  5400, 5400
};

const CustomShape CS_UP_ARROW(
  UP_ARROW_VERTICES, sizeof(UP_ARROW_VERTICES) / sizeof(Vertex),
  UP_ARROW_SEGMENTS, sizeof(UP_ARROW_SEGMENTS) / sizeof(unsigned short),
  UP_ARROW_CALC, sizeof(UP_ARROW_CALC) / sizeof(Calculation),
  UP_ARROW_DEFAULT_ADJUST, sizeof(UP_ARROW_DEFAULT_ADJUST) / sizeof(int),
  UP_ARROW_TRS, sizeof(UP_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex LEFT_RIGHT_ARROW_VERTICES[] =
{
  {0, 10800}, {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), 0}, {21600, 10800}, {CALCULATED_VALUE(2), 21600}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(0), 21600}
};

const unsigned short LEFT_RIGHT_ARROW_SEGMENTS[] =
{
  0x4000, 0x0009, 0x6001, 0x8000
};

const Calculation LEFT_RIGHT_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x6001, PROP_ADJUST_VAL_FIRST, 0x404, 10800}, {0x8000, 21600, 0, 0x405}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x6001, PROP_ADJUST_VAL_FIRST + 1, 0x407, 10800}, {0x8000, 21600, 0, 0x408}
};

const TextRectangle LEFT_RIGHT_ARROW_TRS[] =
{
  { {CALCULATED_VALUE(5), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(6), CALCULATED_VALUE(3)} }
};

const int LEFT_RIGHT_ARROW_DEFAULT_ADJUST[] =
{
  4300, 5400
};

const CustomShape CS_LEFT_RIGHT_ARROW(
  LEFT_RIGHT_ARROW_VERTICES, sizeof(LEFT_RIGHT_ARROW_VERTICES) / sizeof(Vertex),
  LEFT_RIGHT_ARROW_SEGMENTS, sizeof(LEFT_RIGHT_ARROW_SEGMENTS) / sizeof(unsigned short),
  LEFT_RIGHT_ARROW_CALC, sizeof(LEFT_RIGHT_ARROW_CALC) / sizeof(Calculation),
  LEFT_RIGHT_ARROW_DEFAULT_ADJUST, sizeof(LEFT_RIGHT_ARROW_DEFAULT_ADJUST) / sizeof(int),
  LEFT_RIGHT_ARROW_TRS, sizeof(LEFT_RIGHT_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex SEAL_32_VERTICES[] =
{
  {CALCULATED_VALUE(0x05), CALCULATED_VALUE(0x06)}, {CALCULATED_VALUE(0x07), CALCULATED_VALUE(0x08)}, {CALCULATED_VALUE(0x09), CALCULATED_VALUE(0x0a)}, {CALCULATED_VALUE(0x0b), CALCULATED_VALUE(0x0c)}, {CALCULATED_VALUE(0x0d), CALCULATED_VALUE(0x0e)}, {CALCULATED_VALUE(0x0f), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x11), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0x13), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0x15), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0x17), CALCULATED_VALUE(0x18)}, {CALCULATED_VALUE(0x19), CALCULATED_VALUE(0x1a)}, {CALCULATED_VALUE(0x1b), CALCULATED_VALUE(0x1c)}, {CALCULATED_VALUE(0x1d), CALCULATED_VALUE(0x1e)}, {CALCULATED_VALUE(0x1f), CALCULATED_VALUE(0x20)}, {CALCULATED_VALUE(0x21), CALCULATED_VALUE(0x22)}, {CALCULATED_VALUE(0x23), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x25), CALCULATED_VALUE(0x26)}, {CALCULATED_VALUE(0x27), CALCULATED_VALUE(0x28)}, {CALCULATED_VALUE(0x29), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(0x2b), CALCULATED_VALUE(0x2c)}, {CALCULATED_VALUE(0x2d), CALCULATED_VALUE(0x2e)}, {CALCULATED_VALUE(0x2f), CALCULATED_VALUE(0x30)}, {CALCULATED_VALUE(0x31), CALCULATED_VALUE(0x32)}, {CALCULATED_VALUE(0x33), CALCULATED_VALUE(0x34)}, {CALCULATED_VALUE(0x35), CALCULATED_VALUE(0x36)}, {CALCULATED_VALUE(0x37), CALCULATED_VALUE(0x38)}, {CALCULATED_VALUE(0x39), CALCULATED_VALUE(0x3a)}, {CALCULATED_VALUE(0x3b), CALCULATED_VALUE(0x3c)}, {CALCULATED_VALUE(0x3d), CALCULATED_VALUE(0x3e)}, {CALCULATED_VALUE(0x3f), CALCULATED_VALUE(0x40)}, {CALCULATED_VALUE(0x41), CALCULATED_VALUE(0x42)}, {CALCULATED_VALUE(0x43), CALCULATED_VALUE(0x44)}, {CALCULATED_VALUE(0x45), CALCULATED_VALUE(0x46)}, {CALCULATED_VALUE(0x47), CALCULATED_VALUE(0x48)}, {CALCULATED_VALUE(0x49), CALCULATED_VALUE(0x4a)}, {CALCULATED_VALUE(0x4b), CALCULATED_VALUE(0x4c)}, {CALCULATED_VALUE(0x4d), CALCULATED_VALUE(0x4e)}, {CALCULATED_VALUE(0x4f), CALCULATED_VALUE(0x50)}, {CALCULATED_VALUE(0x51), CALCULATED_VALUE(0x52)}, {CALCULATED_VALUE(0x53), CALCULATED_VALUE(0x54)}, {CALCULATED_VALUE(0x55), CALCULATED_VALUE(0x56)}, {CALCULATED_VALUE(0x57), CALCULATED_VALUE(0x58)}, {CALCULATED_VALUE(0x59), CALCULATED_VALUE(0x5a)}, {CALCULATED_VALUE(0x5b), CALCULATED_VALUE(0x5c)}, {CALCULATED_VALUE(0x5d), CALCULATED_VALUE(0x5e)}, {CALCULATED_VALUE(0x5f), CALCULATED_VALUE(0x60)}, {CALCULATED_VALUE(0x61), CALCULATED_VALUE(0x62)}, {CALCULATED_VALUE(0x63), CALCULATED_VALUE(0x64)}, {CALCULATED_VALUE(0x65), CALCULATED_VALUE(0x66)}, {CALCULATED_VALUE(0x67), CALCULATED_VALUE(0x68)}, {CALCULATED_VALUE(0x69), CALCULATED_VALUE(0x6a)}, {CALCULATED_VALUE(0x6b), CALCULATED_VALUE(0x6c)}, {CALCULATED_VALUE(0x6d), CALCULATED_VALUE(0x6e)}, {CALCULATED_VALUE(0x6f), CALCULATED_VALUE(0x70)}, {CALCULATED_VALUE(0x71), CALCULATED_VALUE(0x72)}, {CALCULATED_VALUE(0x73), CALCULATED_VALUE(0x74)}, {CALCULATED_VALUE(0x75), CALCULATED_VALUE(0x76)}, {CALCULATED_VALUE(0x77), CALCULATED_VALUE(0x78)}, {CALCULATED_VALUE(0x79), CALCULATED_VALUE(0x7a)}, {CALCULATED_VALUE(0x7b), CALCULATED_VALUE(0x7c)}, {CALCULATED_VALUE(0x7d), CALCULATED_VALUE(0x7e)}, {CALCULATED_VALUE(0x7f), CALCULATED_VALUE(0x80)}, {CALCULATED_VALUE(0x81), CALCULATED_VALUE(0x82)}, {CALCULATED_VALUE(0x83), CALCULATED_VALUE(0x84)}, {CALCULATED_VALUE(0x05), CALCULATED_VALUE(0x06)}
};

const Calculation SEAL_32_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2081, 0x400, 10800, 315}, {0x2082, 0x400, 10800, 315}, {0x2081, 0x400, 10800, 135}, {0x2082, 0x400, 10800, 135}, {0x0081, 0, 10800, 0}, {0x0082, 0, 10800, 0}, {0x2081, 0x400, 10800, 5}, {0x2082, 0x400, 10800, 5}, {0x0081, 0, 10800, 11}, {0x0082, 0, 10800, 11}, {0x2081, 0x400, 10800, 16}, {0x2082, 0x400, 10800, 16}, {0x0081, 0, 10800, 22}, {0x0082, 0, 10800, 22}, {0x2081, 0x400, 10800, 28}, {0x2082, 0x400, 10800, 28}, {0x0081, 0, 10800, 33}, {0x0082, 0, 10800, 33}, {0x2081, 0x400, 10800, 39}, {0x2082, 0x400, 10800, 39}, {0x0081, 0, 10800, 45}, {0x0082, 0, 10800, 45}, {0x2081, 0x400, 10800, 50}, {0x2082, 0x400, 10800, 50}, {0x0081, 0, 10800, 56}, {0x0082, 0, 10800, 56}, {0x2081, 0x400, 10800, 61}, {0x2082, 0x400, 10800, 61}, {0x0081, 0, 10800, 67}, {0x0082, 0, 10800, 67}, {0x2081, 0x400, 10800, 73}, {0x2082, 0x400, 10800, 73}, {0x0081, 0, 10800, 78}, {0x0082, 0, 10800, 78}, {0x2081, 0x400, 10800, 84}, {0x2082, 0x400, 10800, 84}, {0x0081, 0, 10800, 90}, {0x0082, 0, 10800, 90}, {0x2081, 0x400, 10800, 95}, {0x2082, 0x400, 10800, 95}, {0x0081, 0, 10800, 101}, {0x0082, 0, 10800, 101}, {0x2081, 0x400, 10800, 106}, {0x2082, 0x400, 10800, 106}, {0x0081, 0, 10800, 112}, {0x0082, 0, 10800, 112}, {0x2081, 0x400, 10800, 118}, {0x2082, 0x400, 10800, 118}, {0x0081, 0, 10800, 123}, {0x0082, 0, 10800, 123}, {0x2081, 0x400, 10800, 129}, {0x2082, 0x400, 10800, 129}, {0x0081, 0, 10800, 135}, {0x0082, 0, 10800, 135}, {0x2081, 0x400, 10800, 140}, {0x2082, 0x400, 10800, 140}, {0x0081, 0, 10800, 146}, {0x0082, 0, 10800, 146}, {0x2081, 0x400, 10800, 151}, {0x2082, 0x400, 10800, 151}, {0x0081, 0, 10800, 157}, {0x0082, 0, 10800, 157}, {0x2081, 0x400, 10800, 163}, {0x2082, 0x400, 10800, 163}, {0x0081, 0, 10800, 168}, {0x0082, 0, 10800, 168}, {0x2081, 0x400, 10800, 174}, {0x2082, 0x400, 10800, 174}, {0x0081, 0, 10800, 180}, {0x0082, 0, 10800, 180}, {0x2081, 0x400, 10800, 185}, {0x2082, 0x400, 10800, 185}, {0x0081, 0, 10800, 191}, {0x0082, 0, 10800, 191}, {0x2081, 0x400, 10800, 196}, {0x2082, 0x400, 10800, 196}, {0x0081, 0, 10800, 202}, {0x0082, 0, 10800, 202}, {0x2081, 0x400, 10800, 208}, {0x2082, 0x400, 10800, 208}, {0x0081, 0, 10800, 213}, {0x0082, 0, 10800, 213}, {0x2081, 0x400, 10800, 219}, {0x2082, 0x400, 10800, 219}, {0x0081, 0, 10800, 225}, {0x0082, 0, 10800, 225}, {0x2081, 0x400, 10800, 230}, {0x2082, 0x400, 10800, 230}, {0x0081, 0, 10800, 236}, {0x0082, 0, 10800, 236}, {0x2081, 0x400, 10800, 241}, {0x2082, 0x400, 10800, 241}, {0x0081, 0, 10800, 247}, {0x0082, 0, 10800, 247}, {0x2081, 0x400, 10800, 253}, {0x2082, 0x400, 10800, 253}, {0x0081, 0, 10800, 258}, {0x0082, 0, 10800, 258}, {0x2081, 0x400, 10800, 264}, {0x2082, 0x400, 10800, 264}, {0x0081, 0, 10800, 270}, {0x0082, 0, 10800, 270}, {0x2081, 0x400, 10800, 275}, {0x2082, 0x400, 10800, 275}, {0x0081, 0, 10800, 281}, {0x0082, 0, 10800, 281}, {0x2081, 0x400, 10800, 286}, {0x2082, 0x400, 10800, 286}, {0x0081, 0, 10800, 292}, {0x0082, 0, 10800, 292}, {0x2081, 0x400, 10800, 298}, {0x2082, 0x400, 10800, 298}, {0x0081, 0, 10800, 303}, {0x0082, 0, 10800, 303}, {0x2081, 0x400, 10800, 309}, {0x2082, 0x400, 10800, 309}, {0x0081, 0, 10800, 315}, {0x0082, 0, 10800, 315}, {0x2081, 0x400, 10800, 320}, {0x2082, 0x400, 10800, 320}, {0x0081, 0, 10800, 326}, {0x0082, 0, 10800, 326}, {0x2081, 0x400, 10800, 331}, {0x2082, 0x400, 10800, 331}, {0x0081, 0, 10800, 337}, {0x0082, 0, 10800, 337}, {0x2081, 0x400, 10800, 343}, {0x2082, 0x400, 10800, 343}, {0x0081, 0, 10800, 348}, {0x0082, 0, 10800, 348}, {0x2081, 0x400, 10800, 354}, {0x2082, 0x400, 10800, 354}
};

const TextRectangle SEAL_32_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int SEAL_32_DEFAULT_ADJUST[] =
{
  2500
};

const CustomShape CS_SEAL_32(
  SEAL_32_VERTICES, sizeof(SEAL_32_VERTICES) / sizeof(Vertex),
  NULL, 0,
  SEAL_32_CALC, sizeof(SEAL_32_CALC) / sizeof(Calculation),
  SEAL_32_DEFAULT_ADJUST, sizeof(SEAL_32_DEFAULT_ADJUST) / sizeof(int),
  SEAL_32_TRS, sizeof(SEAL_32_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex SEAL_16_VERTICES[] =
{
  {CALCULATED_VALUE(0x05), CALCULATED_VALUE(0x06)}, {CALCULATED_VALUE(0x07), CALCULATED_VALUE(0x08)}, {CALCULATED_VALUE(0x09), CALCULATED_VALUE(0x0a)}, {CALCULATED_VALUE(0x0b), CALCULATED_VALUE(0x0c)}, {CALCULATED_VALUE(0x0d), CALCULATED_VALUE(0x0e)}, {CALCULATED_VALUE(0x0f), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x11), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0x13), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0x15), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0x17), CALCULATED_VALUE(0x18)}, {CALCULATED_VALUE(0x19), CALCULATED_VALUE(0x1a)}, {CALCULATED_VALUE(0x1b), CALCULATED_VALUE(0x1c)}, {CALCULATED_VALUE(0x1d), CALCULATED_VALUE(0x1e)}, {CALCULATED_VALUE(0x1f), CALCULATED_VALUE(0x20)}, {CALCULATED_VALUE(0x21), CALCULATED_VALUE(0x22)}, {CALCULATED_VALUE(0x23), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x25), CALCULATED_VALUE(0x26)}, {CALCULATED_VALUE(0x27), CALCULATED_VALUE(0x28)}, {CALCULATED_VALUE(0x29), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(0x2b), CALCULATED_VALUE(0x2c)}, {CALCULATED_VALUE(0x2d), CALCULATED_VALUE(0x2e)}, {CALCULATED_VALUE(0x2f), CALCULATED_VALUE(0x30)}, {CALCULATED_VALUE(0x31), CALCULATED_VALUE(0x32)}, {CALCULATED_VALUE(0x33), CALCULATED_VALUE(0x34)}, {CALCULATED_VALUE(0x35), CALCULATED_VALUE(0x36)}, {CALCULATED_VALUE(0x37), CALCULATED_VALUE(0x38)}, {CALCULATED_VALUE(0x39), CALCULATED_VALUE(0x3a)}, {CALCULATED_VALUE(0x3b), CALCULATED_VALUE(0x3c)}, {CALCULATED_VALUE(0x3d), CALCULATED_VALUE(0x3e)}, {CALCULATED_VALUE(0x3f), CALCULATED_VALUE(0x40)}, {CALCULATED_VALUE(0x41), CALCULATED_VALUE(0x42)}, {CALCULATED_VALUE(0x43), CALCULATED_VALUE(0x44)}, {CALCULATED_VALUE(0x05), CALCULATED_VALUE(0x06)}
};

const Calculation SEAL_16_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2081, 0x400, 10800, 315}, {0x2082, 0x400, 10800, 315}, {0x2081, 0x400, 10800, 135}, {0x2082, 0x400, 10800, 135}, {0x0081, 0, 10800, 0}, {0x0082, 0, 10800, 0}, {0x2081, 0x400, 10800, 11}, {0x2082, 0x400, 10800, 11}, {0x0081, 0, 10800, 22}, {0x0082, 0, 10800, 22}, {0x2081, 0x400, 10800, 33}, {0x2082, 0x400, 10800, 33}, {0x0081, 0, 10800, 45}, {0x0082, 0, 10800, 45}, {0x2081, 0x400, 10800, 56}, {0x2082, 0x400, 10800, 56}, {0x0081, 0, 10800, 67}, {0x0082, 0, 10800, 67}, {0x2081, 0x400, 10800, 78}, {0x2082, 0x400, 10800, 78}, {0x0081, 0, 10800, 90}, {0x0082, 0, 10800, 90}, {0x2081, 0x400, 10800, 101}, {0x2082, 0x400, 10800, 101}, {0x0081, 0, 10800, 112}, {0x0082, 0, 10800, 112}, {0x2081, 0x400, 10800, 123}, {0x2082, 0x400, 10800, 123}, {0x0081, 0, 10800, 135}, {0x0082, 0, 10800, 135}, {0x2081, 0x400, 10800, 146}, {0x2082, 0x400, 10800, 146}, {0x0081, 0, 10800, 157}, {0x0082, 0, 10800, 157}, {0x2081, 0x400, 10800, 168}, {0x2082, 0x400, 10800, 168}, {0x0081, 0, 10800, 180}, {0x0082, 0, 10800, 180}, {0x2081, 0x400, 10800, 191}, {0x2082, 0x400, 10800, 191}, {0x0081, 0, 10800, 202}, {0x0082, 0, 10800, 202}, {0x2081, 0x400, 10800, 213}, {0x2082, 0x400, 10800, 213}, {0x0081, 0, 10800, 225}, {0x0082, 0, 10800, 225}, {0x2081, 0x400, 10800, 236}, {0x2082, 0x400, 10800, 236}, {0x0081, 0, 10800, 247}, {0x0082, 0, 10800, 247}, {0x2081, 0x400, 10800, 258}, {0x2082, 0x400, 10800, 258}, {0x0081, 0, 10800, 270}, {0x0082, 0, 10800, 270}, {0x2081, 0x400, 10800, 281}, {0x2082, 0x400, 10800, 281}, {0x0081, 0, 10800, 292}, {0x0082, 0, 10800, 292}, {0x2081, 0x400, 10800, 303}, {0x2082, 0x400, 10800, 303}, {0x0081, 0, 10800, 315}, {0x0082, 0, 10800, 315}, {0x2081, 0x400, 10800, 326}, {0x2082, 0x400, 10800, 326}, {0x0081, 0, 10800, 337}, {0x0082, 0, 10800, 337}, {0x2081, 0x400, 10800, 348}, {0x2082, 0x400, 10800, 348}
};

const TextRectangle SEAL_16_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int SEAL_16_DEFAULT_ADJUST[] =
{
  2500
};

const CustomShape CS_SEAL_16(
  SEAL_16_VERTICES, sizeof(SEAL_16_VERTICES) / sizeof(Vertex),
  NULL, 0,
  SEAL_16_CALC, sizeof(SEAL_16_CALC) / sizeof(Calculation),
  SEAL_16_DEFAULT_ADJUST, sizeof(SEAL_16_DEFAULT_ADJUST) / sizeof(int),
  SEAL_16_TRS, sizeof(SEAL_16_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex NO_SMOKING_VERTICES[] =
{
  {10800, 10800}, {10800, 10800}, {0, 360}, {CALCULATED_VALUE(0), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(9), CALCULATED_VALUE(0xa)}, {CALCULATED_VALUE(0xb), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0xd), CALCULATED_VALUE(0xe)}, {CALCULATED_VALUE(0xf), CALCULATED_VALUE(0x10)}
};

const unsigned short NO_SMOKING_SEGMENTS[] =
{
  0xa203, 0x6000, 0xa404, 0x6000, 0xa404, 0x6000, 0x8000
};

const Calculation NO_SMOKING_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0xa080, 0x403, 0, 0x402}, {0x8000, 10800, 0, 0x403}, {0x4000, 10800, 0x403, 0}, {0x8000, 10800, 0, 0x404}, {0x4000, 10800, 0x404, 0}, {0x6081, 0x405, 0x407, 45}, {0x6082, 0x405, 0x407, 45}, {0x6081, 0x405, 0x408, 45}, {0x6082, 0x405, 0x408, 45}, {0x6081, 0x406, 0x408, 45}, {0x6082, 0x406, 0x408, 45}, {0x6081, 0x406, 0x407, 45}, {0x6082, 0x406, 0x407, 45}
};

const TextRectangle NO_SMOKING_TRS[] =
{
  { {3163, 3163}, {18437, 18437} }
};

const int NO_SMOKING_DEFAULT_ADJUST[] =
{
  2700
};

const Vertex NO_SMOKING_GLUE_POINTS[] =
{
  {10800, 0}, {3163, 3163}, {0, 10800}, {3163, 18437}, {10800, 21600}, {18437, 18437}, {21600, 10800}, {18437, 3163}
};

const CustomShape CS_NO_SMOKING(
  NO_SMOKING_VERTICES, sizeof(NO_SMOKING_VERTICES) / sizeof(Vertex),
  NO_SMOKING_SEGMENTS, sizeof(NO_SMOKING_SEGMENTS) / sizeof(unsigned short),
  NO_SMOKING_CALC, sizeof(NO_SMOKING_CALC) / sizeof(Calculation),
  NO_SMOKING_DEFAULT_ADJUST, sizeof(NO_SMOKING_DEFAULT_ADJUST) / sizeof(int),
  NO_SMOKING_TRS, sizeof(NO_SMOKING_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NO_SMOKING_GLUE_POINTS, sizeof(NO_SMOKING_GLUE_POINTS) / sizeof(Vertex));

const Vertex SEAL_8_VERTICES[] =
{
  {CALCULATED_VALUE(5), CALCULATED_VALUE(6)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(17), CALCULATED_VALUE(18)}, {CALCULATED_VALUE(23), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(29), CALCULATED_VALUE(30)}, {CALCULATED_VALUE(35), CALCULATED_VALUE(36)}, {CALCULATED_VALUE(41), CALCULATED_VALUE(42)}, {CALCULATED_VALUE(47), CALCULATED_VALUE(48)}, {CALCULATED_VALUE(53), CALCULATED_VALUE(54)}, {CALCULATED_VALUE(59), CALCULATED_VALUE(60)}, {CALCULATED_VALUE(65), CALCULATED_VALUE(66)}, {CALCULATED_VALUE(71), CALCULATED_VALUE(72)}, {CALCULATED_VALUE(77), CALCULATED_VALUE(78)}, {CALCULATED_VALUE(83), CALCULATED_VALUE(84)}, {CALCULATED_VALUE(89), CALCULATED_VALUE(90)}, {CALCULATED_VALUE(95), CALCULATED_VALUE(96)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(6)}
};

const Calculation SEAL_8_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2081, 0x400, 10800, 315}, {0x2082, 0x400, 10800, 315}, {0x2081, 0x400, 10800, 135}, {0x2082, 0x400, 10800, 135}, {0x0081, 0, 10800, 0}, {0x0082, 0, 10800, 0}, {0x2081, 0x400, 10800, 7}, {0x2082, 0x400, 10800, 7}, {0x0081, 0, 10800, 15}, {0x0082, 0, 10800, 15}, {0x2081, 0x400, 10800, 22}, {0x2082, 0x400, 10800, 22}, {0x0081, 0, 10800, 30}, {0x0082, 0, 10800, 30}, {0x2081, 0x400, 10800, 37}, {0x2082, 0x400, 10800, 37}, {0x0081, 0, 10800, 45}, {0x0082, 0, 10800, 45}, {0x2081, 0x400, 10800, 52}, {0x2082, 0x400, 10800, 52}, {0x0081, 0, 10800, 60}, {0x0082, 0, 10800, 60}, {0x2081, 0x400, 10800, 67}, {0x2082, 0x400, 10800, 67}, {0x0081, 0, 10800, 75}, {0x0082, 0, 10800, 75}, {0x2081, 0x400, 10800, 82}, {0x2082, 0x400, 10800, 82}, {0x0081, 0, 10800, 90}, {0x0082, 0, 10800, 90}, {0x2081, 0x400, 10800, 97}, {0x2082, 0x400, 10800, 97}, {0x0081, 0, 10800, 105}, {0x0082, 0, 10800, 105}, {0x2081, 0x400, 10800, 112}, {0x2082, 0x400, 10800, 112}, {0x0081, 0, 10800, 120}, {0x0082, 0, 10800, 120}, {0x2081, 0x400, 10800, 127}, {0x2082, 0x400, 10800, 127}, {0x0081, 0, 10800, 135}, {0x0082, 0, 10800, 135}, {0x2081, 0x400, 10800, 142}, {0x2082, 0x400, 10800, 142}, {0x0081, 0, 10800, 150}, {0x0082, 0, 10800, 150}, {0x2081, 0x400, 10800, 157}, {0x2082, 0x400, 10800, 157}, {0x0081, 0, 10800, 165}, {0x0082, 0, 10800, 165}, {0x2081, 0x400, 10800, 172}, {0x2082, 0x400, 10800, 172}, {0x0081, 0, 10800, 180}, {0x0082, 0, 10800, 180}, {0x2081, 0x400, 10800, 187}, {0x2082, 0x400, 10800, 187}, {0x0081, 0, 10800, 195}, {0x0082, 0, 10800, 195}, {0x2081, 0x400, 10800, 202}, {0x2082, 0x400, 10800, 202}, {0x0081, 0, 10800, 210}, {0x0082, 0, 10800, 210}, {0x2081, 0x400, 10800, 217}, {0x2082, 0x400, 10800, 217}, {0x0081, 0, 10800, 225}, {0x0082, 0, 10800, 225}, {0x2081, 0x400, 10800, 232}, {0x2082, 0x400, 10800, 232}, {0x0081, 0, 10800, 240}, {0x0082, 0, 10800, 240}, {0x2081, 0x400, 10800, 247}, {0x2082, 0x400, 10800, 247}, {0x0081, 0, 10800, 255}, {0x0082, 0, 10800, 255}, {0x2081, 0x400, 10800, 262}, {0x2082, 0x400, 10800, 262}, {0x0081, 0, 10800, 270}, {0x0082, 0, 10800, 270}, {0x2081, 0x400, 10800, 277}, {0x2082, 0x400, 10800, 277}, {0x0081, 0, 10800, 285}, {0x0082, 0, 10800, 285}, {0x2081, 0x400, 10800, 292}, {0x2082, 0x400, 10800, 292}, {0x0081, 0, 10800, 300}, {0x0082, 0, 10800, 300}, {0x2081, 0x400, 10800, 307}, {0x2082, 0x400, 10800, 307}, {0x0081, 0, 10800, 315}, {0x0082, 0, 10800, 315}, {0x2081, 0x400, 10800, 322}, {0x2082, 0x400, 10800, 322}, {0x0081, 0, 10800, 330}, {0x0082, 0, 10800, 330}, {0x2081, 0x400, 10800, 337}, {0x2082, 0x400, 10800, 337}, {0x0081, 0, 10800, 345}, {0x0082, 0, 10800, 345}, {0x2081, 0x400, 10800, 352}, {0x2082, 0x400, 10800, 352}
};

const TextRectangle SEAL_8_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int SEAL_8_DEFAULT_ADJUST[] =
{
  2500
};

const CustomShape CS_SEAL_8(
  SEAL_8_VERTICES, sizeof(SEAL_8_VERTICES) / sizeof(Vertex),
  NULL, 0,
  SEAL_8_CALC, sizeof(SEAL_8_CALC) / sizeof(Calculation),
  SEAL_8_DEFAULT_ADJUST, sizeof(SEAL_8_DEFAULT_ADJUST) / sizeof(int),
  SEAL_8_TRS, sizeof(SEAL_8_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex RIBBON_2_VERTICES[] =
{
  {CALCULATED_VALUE(12), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(14)}, {CALCULATED_VALUE(15), 21600}, {CALCULATED_VALUE(16), 21600}, {0, 21600}, {2750, CALCULATED_VALUE(7)}, {0, CALCULATED_VALUE(2)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(10), 0}, {CALCULATED_VALUE(11), 0}, {CALCULATED_VALUE(17), 0}, {CALCULATED_VALUE(18), 0}, {CALCULATED_VALUE(19), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(19), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(19), CALCULATED_VALUE(2)}, {21600, CALCULATED_VALUE(2)}, {18850, CALCULATED_VALUE(7)}, {21600, 21600}, {CALCULATED_VALUE(20), 21600}, {CALCULATED_VALUE(21), 21600}, {CALCULATED_VALUE(22), CALCULATED_VALUE(14)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(23)}, {CALCULATED_VALUE(15), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(10), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(25)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(27)}, {CALCULATED_VALUE(10), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(22), CALCULATED_VALUE(23)}, {CALCULATED_VALUE(21), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(20), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(17), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(18), CALCULATED_VALUE(24)}, {CALCULATED_VALUE(19), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(19), CALCULATED_VALUE(25)}, {CALCULATED_VALUE(19), CALCULATED_VALUE(27)}, {CALCULATED_VALUE(18), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(17), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(25)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(19), CALCULATED_VALUE(25)}, {CALCULATED_VALUE(19), CALCULATED_VALUE(2)}
};

const unsigned short RIBBON_2_SEGMENTS[] =
{
  0x4000, 0x0001, 0x2001, 0x0005, 0x2001, 0x0001, 0x2001, 0x0005, 0x2001, 0x0001, 0x6001, 0x8000, 0x4000, 0x0001, 0x2001, 0x0001, 0x2002, 0x6001, 0x8000, 0x4000, 0x0001, 0x2001, 0x0001, 0x2002, 0x6001, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation RIBBON_2_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x8000, 21600, 0, 0x401}, {0x2001, 0x402, 1, 2}, {0x2001, 0x403, 1, 2}, {0x2001, 0x404, 1, 2}, {0x2001, 0x401, 1, 2}, {0x8000, 21600, 0, 0x406}, {0x0000, 420, 0, 0}, {0x2001, 0x408, 2, 1}, {0x6000, 0x400, 0x408, 0}, {0x6000, 0x400, 0x409, 0}, {0x2000, 0x400, 2700, 0}, {0x8000, 21600, 0, 0x404}, {0x8000, 21600, 0, 0x405}, {0xa000, 0x40c, 0, 0x408}, {0xa000, 0x40c, 0, 0x409}, {0x8000, 21600, 0, 0x40b}, {0x8000, 21600, 0, 0x40a}, {0x8000, 21600, 0, 0x400}, {0x8000, 21600, 0, 0x410}, {0x8000, 21600, 0, 0x40f}, {0x8000, 21600, 0, 0x40c}, {0xa000, 0x40d, 0, 0x405}, {0x6000, 0x401, 0x403, 0}, {0x6000, 0x401, 0x404, 0}, {0x6000, 0x419, 0x405, 0}, {0xa000, 0x419, 0, 0x405}
};

const TextRectangle RIBBON_2_TRS[] =
{
  { {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(19), CALCULATED_VALUE(1)} }
};

const int RIBBON_2_DEFAULT_ADJUST[] =
{
  5400, 18900
};

const CustomShape CS_RIBBON_2(
  RIBBON_2_VERTICES, sizeof(RIBBON_2_VERTICES) / sizeof(Vertex),
  RIBBON_2_SEGMENTS, sizeof(RIBBON_2_SEGMENTS) / sizeof(unsigned short),
  RIBBON_2_CALC, sizeof(RIBBON_2_CALC) / sizeof(Calculation),
  RIBBON_2_DEFAULT_ADJUST, sizeof(RIBBON_2_DEFAULT_ADJUST) / sizeof(int),
  RIBBON_2_TRS, sizeof(RIBBON_2_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex CHEVRON_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(0), 0}, {21600, 10800}, {CALCULATED_VALUE(0), 21600}, {0, 21600}, {CALCULATED_VALUE(1), 10800}
};

const unsigned short CHEVRON_SEGMENTS[] =
{
  0x4000, 0x0005, 0x6001, 0x8000
};

const Calculation CHEVRON_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, 0x0400}
};

const TextRectangle CHEVRON_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int CHEVRON_DEFAULT_ADJUST[] =
{
  16200
};

const CustomShape CS_CHEVRON(
  CHEVRON_VERTICES, sizeof(CHEVRON_VERTICES) / sizeof(Vertex),
  CHEVRON_SEGMENTS, sizeof(CHEVRON_SEGMENTS) / sizeof(unsigned short),
  CHEVRON_CALC, sizeof(CHEVRON_CALC) / sizeof(Calculation),
  CHEVRON_DEFAULT_ADJUST, sizeof(CHEVRON_DEFAULT_ADJUST) / sizeof(int),
  CHEVRON_TRS, sizeof(CHEVRON_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex PENTAGON_VERTICES[] =
{
  {10800, 0}, {0, 8260}, {4230, 21600}, {17370, 21600}, {21600, 8260}, {10800, 0}
};

const TextRectangle PENTAGON_TRS[] =
{
  { {4230, 5080}, {17370, 21600} }
};

const Vertex PENTAGON_GLUE_POINTS[] =
{
  {10800, 0}, {0, 8260}, {4230, 21600}, {10800, 21600}, {17370, 21600}, {21600, 8260}
};

const CustomShape CS_PENTAGON(
  PENTAGON_VERTICES, sizeof(PENTAGON_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  PENTAGON_TRS, sizeof(PENTAGON_TRS) / sizeof(TextRectangle),
  21600, 21600,
  PENTAGON_GLUE_POINTS, sizeof(PENTAGON_GLUE_POINTS) / sizeof(Vertex));

const Vertex RIBBON_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(3), 0}, {CALCULATED_VALUE(4), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(6), 0}, {21600, 0}, {CALCULATED_VALUE(18), CALCULATED_VALUE(14)}, {21600, CALCULATED_VALUE(15)}, {CALCULATED_VALUE(9), CALCULATED_VALUE(15)}, {CALCULATED_VALUE(9), CALCULATED_VALUE(16)}, {CALCULATED_VALUE(8), 21600}, {CALCULATED_VALUE(1), 21600}, {CALCULATED_VALUE(0), CALCULATED_VALUE(16)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(15)}, {0, CALCULATED_VALUE(15)}, {2700, CALCULATED_VALUE(14)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(6), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(9), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(15)}, {CALCULATED_VALUE(9), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(9), CALCULATED_VALUE(15)}
};

const unsigned short RIBBON_SEGMENTS[] =
{
  0x4000, 0x0001, 0xa701, 0x0003, 0xa801, 0x0005, 0xa801, 0x0001, 0xa701, 0x0003, 0x6000, 0x8000, 0x4000, 0xaa00, 0xa801, 0x0001, 0xa702, 0x0001, 0x8000, 0x4000, 0xaa00, 0xa801, 0x0001, 0xa702, 0x0001, 0x8000, 0x4000, 0xaa00, 0x0001, 0x8000, 0x4000, 0xaa00, 0x0001, 0x8000
};

const Calculation RIBBON_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, 0x400, 675, 0}, {0x2000, 0x401, 675, 0}, {0x2000, 0x402, 675, 0}, {0x2000, 0x403, 675, 0}, {0x8000, 21600, 0, 0x404}, {0x8000, 21600, 0, 0x403}, {0x8000, 21600, 0, 0x402}, {0x8000, 21600, 0, 0x401}, {0x8000, 21600, 0, 0x400}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2001, 0x40a, 1, 4}, {0x2001, 0x40b, 2, 1}, {0x2001, 0x40b, 3, 1}, {0x8000, 10800, 0, 0x40c}, {0x8000, 21600, 0, 0x40a}, {0x8000, 21600, 0, 0x40b}, {0x0001, 21600, 1, 2}, {0x0000, 21600, 0, 2700}, {0x2000, 0x411, 0, 2700}
};

const TextRectangle RIBBON_TRS[] =
{
  { {CALCULATED_VALUE(0), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(9), 21600} }
};

const int RIBBON_DEFAULT_ADJUST[] =
{
  5400, 2700
};

const Vertex RIBBON_GLUE_POINTS[] =
{
  {CALCULATED_VALUE(17), CALCULATED_VALUE(10)}, {2700, CALCULATED_VALUE(14)}, {CALCULATED_VALUE(17), 21600}, {CALCULATED_VALUE(18), CALCULATED_VALUE(14)}
};

const CustomShape CS_RIBBON(
  RIBBON_VERTICES, sizeof(RIBBON_VERTICES) / sizeof(Vertex),
  RIBBON_SEGMENTS, sizeof(RIBBON_SEGMENTS) / sizeof(unsigned short),
  RIBBON_CALC, sizeof(RIBBON_CALC) / sizeof(Calculation),
  RIBBON_DEFAULT_ADJUST, sizeof(RIBBON_DEFAULT_ADJUST) / sizeof(int),
  RIBBON_TRS, sizeof(RIBBON_TRS) / sizeof(TextRectangle),
  21600, 21600,
  RIBBON_GLUE_POINTS, sizeof(RIBBON_GLUE_POINTS) / sizeof(Vertex));

const Vertex CALLOUT_2_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(5)}
};

const unsigned short CALLOUT_2_SEGMENTS[] =
{
  0x4000, 0xab00, 0x0003, 0x6000, 0x8000, // NO STROKE
  0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation CALLOUT_2_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 3, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 4, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 5, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 6, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 7, 0, 0}
};

const int CALLOUT_2_DEFAULT_ADJUST[] =
{
  -10000, 24500, -3600, 4000, -1800, 4000
};

const CustomShape CS_CALLOUT_2(
  CALLOUT_2_VERTICES, sizeof(CALLOUT_2_VERTICES) / sizeof(Vertex),
  CALLOUT_2_SEGMENTS, sizeof(CALLOUT_2_SEGMENTS) / sizeof(unsigned short),
  CALLOUT_2_CALC, sizeof(CALLOUT_2_CALC) / sizeof(Calculation),
  CALLOUT_2_DEFAULT_ADJUST, sizeof(CALLOUT_2_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex CALLOUT_3_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(6), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}
};

const unsigned short CALLOUT_3_SEGMENTS[] =
{
  0x4000, 0xab00, 0x0003, 0x6000, 0x8000, // NO STROKE
  0x4000, 0xaa00, 0x0003, 0x8000 // NO FILL
};

const Calculation CALLOUT_3_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 3, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 4, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 5, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 6, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 7, 0, 0}
};

const int CALLOUT_3_DEFAULT_ADJUST[] =
{
  23400, 24500, 25200, 21600, 25200, 4000, 23400, 4000
};

const CustomShape CS_CALLOUT_3(
  CALLOUT_3_VERTICES, sizeof(CALLOUT_3_VERTICES) / sizeof(Vertex),
  CALLOUT_3_SEGMENTS, sizeof(CALLOUT_3_SEGMENTS) / sizeof(unsigned short),
  CALLOUT_3_CALC, sizeof(CALLOUT_3_CALC) / sizeof(Calculation),
  CALLOUT_3_DEFAULT_ADJUST, sizeof(CALLOUT_3_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex CALLOUT_1_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}
};

const unsigned short CALLOUT_1_SEGMENTS[] =
{
  0x4000, 0xab00, 0x0003, 0x6000, 0x8000, // NO STROKE
  0x4000, 0x0001, 0x8000
};

const Calculation CALLOUT_1_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 3, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 4, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 5, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 6, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 7, 0, 0}
};

const int CALLOUT_1_DEFAULT_ADJUST[] =
{
  -8300, 24500, -1800, 4000
};

const CustomShape CS_CALLOUT_1(
  CALLOUT_1_VERTICES, sizeof(CALLOUT_1_VERTICES) / sizeof(Vertex),
  CALLOUT_1_SEGMENTS, sizeof(CALLOUT_1_SEGMENTS) / sizeof(unsigned short),
  CALLOUT_1_CALC, sizeof(CALLOUT_1_CALC) / sizeof(Calculation),
  CALLOUT_1_DEFAULT_ADJUST, sizeof(CALLOUT_1_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex CURVED_CONNECTOR_5_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(21), 0}, {CALCULATED_VALUE(0), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(14)}, {CALCULATED_VALUE(6), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(18)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(16)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(20)}, {CALCULATED_VALUE(10), 21600}, {21600, 21600}
};

const unsigned short CURVED_CONNECTOR_5_SEGMENTS[] =
{
  0x4000, 0x2004, 0x8000
};

const Calculation CURVED_CONNECTOR_5_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0x6000, 0x400, 0x401, 0}, {0x2001, 0x402, 1, 2}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x6000, 0x400, 0x403, 0}, {0x2001, 0x405, 1, 2}, {0x6000, 0x401, 0x403, 0}, {0x2001, 0x407, 1, 2}, {0x2000, 0x401, 21600, 0}, {0x2001, 0x409, 1, 2}, {0x2001, 0x404, 1, 2}, {0x2001, 0x40b, 1, 2}, {0x6000, 0x404, 0x40b, 0}, {0x2001, 0x40d, 1, 2}, {0x2000, 0x404, 21600, 0}, {0x2001, 0x40f, 1, 2}, {0x6000, 0x404, 0x410, 0}, {0x2001, 0x411, 1, 2}, {0x2000, 0x410, 21600, 0}, {0x2001, 0x413, 1, 2}, {0x2001, 0x400, 1, 2}
};

const int CURVED_CONNECTOR_5_DEFAULT_ADJUST[] =
{
  10800, 10800, 10800
};

const CustomShape CS_CURVED_CONNECTOR_5(
  CURVED_CONNECTOR_5_VERTICES, sizeof(CURVED_CONNECTOR_5_VERTICES) / sizeof(Vertex),
  CURVED_CONNECTOR_5_SEGMENTS, sizeof(CURVED_CONNECTOR_5_SEGMENTS) / sizeof(unsigned short),
  CURVED_CONNECTOR_5_CALC, sizeof(CURVED_CONNECTOR_5_CALC) / sizeof(Calculation),
  CURVED_CONNECTOR_5_DEFAULT_ADJUST, sizeof(CURVED_CONNECTOR_5_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex CURVED_CONNECTOR_4_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(1), 0}, {CALCULATED_VALUE(0), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(8)}, {21600, CALCULATED_VALUE(14)}, {21600, 21600}
};

const unsigned short CURVED_CONNECTOR_4_SEGMENTS[] =
{
  0x4000, 0x2003, 0x8000
};

const Calculation CURVED_CONNECTOR_4_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2001, 0x400, 1, 2}, {0x4000, 21600, 0x400, 0}, {0x2001, 0x402, 1, 2}, {0x6000, 0x400, 0x403, 0}, {0x2001, 0x404, 1, 2}, {0x2000, 0x403, 21600, 0}, {0x2001, 0x406, 1, 2}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2001, PROP_ADJUST_VAL_FIRST + 1, 1, 2}, {0x2001, PROP_ADJUST_VAL_FIRST + 1, 1, 4}, {0x6000, 0x408, 0x409, 0}, {0x2001, 0x40b, 1, 2}, {0x2000, 0x408, 21600, 0}, {0x2001, 0x40d, 1, 2}
};

const int CURVED_CONNECTOR_4_DEFAULT_ADJUST[] =
{
  10800, 10800
};

const CustomShape CS_CURVED_CONNECTOR_4(
  CURVED_CONNECTOR_4_VERTICES, sizeof(CURVED_CONNECTOR_4_VERTICES) / sizeof(Vertex),
  CURVED_CONNECTOR_4_SEGMENTS, sizeof(CURVED_CONNECTOR_4_SEGMENTS) / sizeof(unsigned short),
  CURVED_CONNECTOR_4_CALC, sizeof(CURVED_CONNECTOR_4_CALC) / sizeof(Calculation),
  CURVED_CONNECTOR_4_DEFAULT_ADJUST, sizeof(CURVED_CONNECTOR_4_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex CURVED_CONNECTOR_3_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(1), 0}, {CALCULATED_VALUE(0), 5400}, {CALCULATED_VALUE(0), 10800}, {CALCULATED_VALUE(0), 16200}, {CALCULATED_VALUE(3), 21600}, {21600, 21600}
};

const unsigned short CURVED_CONNECTOR_3_SEGMENTS[] =
{
  0x4000, 0x2002, 0x8000
};

const Calculation CURVED_CONNECTOR_3_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2001, 0x400, 1, 2}, {0x2000, 0x400, 21600, 0}, {0x2001, 0x402, 1, 2}
};

const int CURVED_CONNECTOR_3_DEFAULT_ADJUST[] =
{
  10800
};

const CustomShape CS_CURVED_CONNECTOR_3(
  CURVED_CONNECTOR_3_VERTICES, sizeof(CURVED_CONNECTOR_3_VERTICES) / sizeof(Vertex),
  CURVED_CONNECTOR_3_SEGMENTS, sizeof(CURVED_CONNECTOR_3_SEGMENTS) / sizeof(unsigned short),
  CURVED_CONNECTOR_3_CALC, sizeof(CURVED_CONNECTOR_3_CALC) / sizeof(Calculation),
  CURVED_CONNECTOR_3_DEFAULT_ADJUST, sizeof(CURVED_CONNECTOR_3_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  NULL, 0);


const Vertex BENT_CONNECTOR_5_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(0), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(1), 21600}, {21600, 21600}
};

const unsigned short BENT_CONNECTOR_5_SEGMENTS[] =
{
  0x4000, 0x0005, 0x8000
};

const Calculation BENT_CONNECTOR_5_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 2, 0, 0}, {0x6000, 0x400, 0x401, 0}, {0x2001, 0x402, 1, 2}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2001, 0x404, 1, 2}, {0x4000, 21600, 0x404, 0}, {0x2001, 0x406, 1, 2}
};

const int BENT_CONNECTOR_5_DEFAULT_ADJUST[] =
{
  10800, 10800, 10800
};

const CustomShape CS_BENT_CONNECTOR_5(
  BENT_CONNECTOR_5_VERTICES, sizeof(BENT_CONNECTOR_5_VERTICES) / sizeof(Vertex),
  BENT_CONNECTOR_5_SEGMENTS, sizeof(BENT_CONNECTOR_5_SEGMENTS) / sizeof(unsigned short),
  BENT_CONNECTOR_5_CALC, sizeof(BENT_CONNECTOR_5_CALC) / sizeof(Calculation),
  BENT_CONNECTOR_5_DEFAULT_ADJUST, sizeof(BENT_CONNECTOR_5_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex CURVED_CONNECTOR_2_VERTICES[] =
{
  {0, 0}, {10800, 0}, {21600, 10800}, {21600, 21600}
};

const unsigned short CURVED_CONNECTOR_2_SEGMENTS[] =
{
  0x4000, 0x2001, 0x8000
};

const CustomShape CS_CURVED_CONNECTOR_2(
  CURVED_CONNECTOR_2_VERTICES, sizeof(CURVED_CONNECTOR_2_VERTICES) / sizeof(Vertex),
  CURVED_CONNECTOR_2_SEGMENTS, sizeof(CURVED_CONNECTOR_2_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex BENT_CONNECTOR_4_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {21600, CALCULATED_VALUE(1)}, {21600, 21600}
};

const unsigned short BENT_CONNECTOR_4_SEGMENTS[] =
{
  0x4000, 0x0004, 0x8000
};

const Calculation BENT_CONNECTOR_4_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, 0x400, 21600, 0}, {0x2001, 0x402, 1, 2}, {0x2001, 0x401, 1, 2}
};

const int BENT_CONNECTOR_4_DEFAULT_ADJUST[] =
{
  10800, 10800
};

const CustomShape CS_BENT_CONNECTOR_4(
  BENT_CONNECTOR_4_VERTICES, sizeof(BENT_CONNECTOR_4_VERTICES) / sizeof(Vertex),
  BENT_CONNECTOR_4_SEGMENTS, sizeof(BENT_CONNECTOR_4_SEGMENTS) / sizeof(unsigned short),
  BENT_CONNECTOR_4_CALC, sizeof(BENT_CONNECTOR_4_CALC) / sizeof(Calculation),
  BENT_CONNECTOR_4_DEFAULT_ADJUST, sizeof(BENT_CONNECTOR_4_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex BENT_CONNECTOR_3_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(0), 21600}, {21600, 21600}
};

const unsigned short BENT_CONNECTOR_3_SEGMENTS[] =
{
  0x4000, 0x0003, 0x8000
};

const Calculation BENT_CONNECTOR_3_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}
};

const int BENT_CONNECTOR_3_DEFAULT_ADJUST[] =
{
  10800
};

const CustomShape CS_BENT_CONNECTOR_3(
  BENT_CONNECTOR_3_VERTICES, sizeof(BENT_CONNECTOR_3_VERTICES) / sizeof(Vertex),
  BENT_CONNECTOR_3_SEGMENTS, sizeof(BENT_CONNECTOR_3_SEGMENTS) / sizeof(unsigned short),
  BENT_CONNECTOR_3_CALC, sizeof(BENT_CONNECTOR_3_CALC) / sizeof(Calculation),
  BENT_CONNECTOR_3_DEFAULT_ADJUST, sizeof(BENT_CONNECTOR_3_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex BENT_CONNECTOR_2_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}
};

const unsigned short BENT_CONNECTOR_2_SEGMENTS[] =
{
  0x4000, 0x0002, 0x8000
};

const CustomShape CS_BENT_CONNECTOR_2(
  BENT_CONNECTOR_2_VERTICES, sizeof(BENT_CONNECTOR_2_VERTICES) / sizeof(Vertex),
  BENT_CONNECTOR_2_SEGMENTS, sizeof(BENT_CONNECTOR_2_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex STRAIGHT_CONNECTOR_1_VERTICES[] =
{
  {0, 0}, {21600, 21600}
};

const unsigned short STRAIGHT_CONNECTOR_1_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000
};

const CustomShape CS_STRAIGHT_CONNECTOR_1(
  STRAIGHT_CONNECTOR_1_VERTICES, sizeof(STRAIGHT_CONNECTOR_1_VERTICES) / sizeof(Vertex),
  STRAIGHT_CONNECTOR_1_SEGMENTS, sizeof(STRAIGHT_CONNECTOR_1_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex TEXT_SIMPLE_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}
};

const CustomShape CS_TEXT_SIMPLE(
  TEXT_SIMPLE_VERTICES, sizeof(TEXT_SIMPLE_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex DONUT_VERTICES[] =
{
  {10800, 10800}, {10800, 10800}, {0, 360}, {10800, 10800}, {CALCULATED_VALUE(1), CALCULATED_VALUE(1)}, {0, 360}
};

const unsigned short DONUT_SEGMENTS[] =
{
  0xa203, 0x6000, 0xa203, 0x8000
};

const Calculation DONUT_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle DONUT_TRS[] =
{
  { {3163, 3163}, {18437, 18437} }
};

const int DONUT_DEFAULT_ADJUST[] =
{
  5400
};

const Vertex DONUT_GLUE_POINTS[] =
{
  {10800, 0}, {3163, 3163}, {0, 10800}, {3163, 18437}, {10800, 21600}, {18437, 18437}, {21600, 10800}, {18437, 3163}
};

const CustomShape CS_DONUT(
  DONUT_VERTICES, sizeof(DONUT_VERTICES) / sizeof(Vertex),
  DONUT_SEGMENTS, sizeof(DONUT_SEGMENTS) / sizeof(unsigned short),
  DONUT_CALC, sizeof(DONUT_CALC) / sizeof(Calculation),
  DONUT_DEFAULT_ADJUST, sizeof(DONUT_DEFAULT_ADJUST) / sizeof(int),
  DONUT_TRS, sizeof(DONUT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  DONUT_GLUE_POINTS, sizeof(DONUT_GLUE_POINTS) / sizeof(Vertex));

const Vertex CAN_VERTICES[] =
{
  {44, 0}, {20, 0}, {0, CALCULATED_VALUE(2)}, {0, CALCULATED_VALUE(0)}, {0, CALCULATED_VALUE(3)}, {0, CALCULATED_VALUE(4)}, {20, 21600}, {44, 21600}, {68, 21600}, {88, CALCULATED_VALUE(4)}, {88, CALCULATED_VALUE(3)}, {88, CALCULATED_VALUE(0)}, {88, CALCULATED_VALUE(2)}, {68, 0}, {44, 0}, {44, 0}, {20, 0}, {0, CALCULATED_VALUE(2)}, {0, CALCULATED_VALUE(0)}, {0, CALCULATED_VALUE(5)}, {20, CALCULATED_VALUE(6)}, {44, CALCULATED_VALUE(6)}, {68, CALCULATED_VALUE(6)}, {88, CALCULATED_VALUE(5)}, {88, CALCULATED_VALUE(0)}, {88, CALCULATED_VALUE(2)}, {68, 0}, {44, 0}
};

const unsigned short CAN_SEGMENTS[] =
{
  0x4000, 0x2001, 0x0001, 0x2002, 0x0001, 0x2001, 0x6001, 0x8000, 0x4000, 0x2004, 0x6001, 0x8000
};

const Calculation CAN_CALC[] =
{
  {0x2001, PROP_ADJUST_VAL_FIRST, 2, 4}, {0x2001, OTHER_CALC_VAL, 6, 11}, {0xA000, OTHER_CALC_VAL, 0, OTHER_CALC_VAL | 0x1}, {0x8000, 21600, 0, OTHER_CALC_VAL}, {0x6000, OTHER_CALC_VAL | 0x3, OTHER_CALC_VAL | 0x1, 0}, {0x6000, OTHER_CALC_VAL, OTHER_CALC_VAL | 0x1, 0}, {0x2001, PROP_ADJUST_VAL_FIRST, 2, 2}, {0x0000, 44, 0, 0}
};

const TextRectangle CAN_TRS[] =
{
  { {0, CALCULATED_VALUE(6)}, {88, CALCULATED_VALUE(3)} }
};

const int CAN_DEFAULT_ADJUST[] =
{
  5400
};

const Vertex CAN_GLUE_POINTS[] =
{
  {44, CALCULATED_VALUE(6)}, {44, 0}, {0, 10800}, {44, 21600}, {88, 10800}
};

const CustomShape CS_CAN(
  CAN_VERTICES, sizeof(CAN_VERTICES) / sizeof(Vertex),
  CAN_SEGMENTS, sizeof(CAN_SEGMENTS) / sizeof(unsigned short),
  CAN_CALC, sizeof(CAN_CALC) / sizeof(Calculation),
  CAN_DEFAULT_ADJUST, sizeof(CAN_DEFAULT_ADJUST) / sizeof(int),
  CAN_TRS, sizeof(CAN_TRS) / sizeof(TextRectangle),
  88, 21600,
  CAN_GLUE_POINTS, sizeof(CAN_GLUE_POINTS) / sizeof(Vertex));

const Vertex PLAQUE_VERTICES[] =
{
  {CALCULATED_VALUE(0), 0}, {0, CALCULATED_VALUE(1)}, {0, CALCULATED_VALUE(2)}, {CALCULATED_VALUE(0), 21600}, {CALCULATED_VALUE(3), 21600}, {21600, CALCULATED_VALUE(2)}, {21600, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(3), 0}
};

const unsigned short PLAQUE_SEGMENTS[] =
{
  0x4000, 0xA801, 0x0001, 0xA701, 0x0001, 0xA801, 0x0001, 0xA701, 0x6000, 0x8000
};

const Calculation PLAQUE_CALC[] =
{
  {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xA000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0xA000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0x2082, PROP_ADJUST_VAL_FIRST, 0, 45}, {0x2000, OTHER_CALC_VAL | 0x4, 0, 10800}, {0x8000, 0, 0, PROP_ADJUST_VAL_FIRST}, {0xA000, OTHER_CALC_VAL | 0x6, 0, OTHER_CALC_VAL | 0x5}, {0xA000, PROP_GEO_LEFT, 0, OTHER_CALC_VAL | 0x7}, {0xA000, PROP_GEO_TOP, 0, OTHER_CALC_VAL | 0x7}, {0x6000, PROP_GEO_RIGHT, OTHER_CALC_VAL | 0x7, 0}, {0x6000, PROP_GEO_BOTTOM, OTHER_CALC_VAL | 0x7, 0}, {0xA000, PROP_GEO_LEFT, 0, OTHER_CALC_VAL | 0x5}, {0xA000, PROP_GEO_TOP, 0, OTHER_CALC_VAL | 0x5}, {0x6000, PROP_GEO_RIGHT, OTHER_CALC_VAL | 0x5, 0}, {0x6000, PROP_GEO_BOTTOM, OTHER_CALC_VAL | 0x5, 0}
};

const TextRectangle PLAQUE_TRS[] =
{
  { {CALCULATED_VALUE(0xC), CALCULATED_VALUE(0xD)}, {CALCULATED_VALUE(0xE), CALCULATED_VALUE(0xF)} }
};

const int PLAQUE_DEFAULT_ADJUST[] =
{
  3600
};

const Vertex PLAQUE_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_PLAQUE(
  PLAQUE_VERTICES, sizeof(PLAQUE_VERTICES) / sizeof(Vertex),
  PLAQUE_SEGMENTS, sizeof(PLAQUE_SEGMENTS) / sizeof(unsigned short),
  PLAQUE_CALC, sizeof(PLAQUE_CALC) / sizeof(Calculation),
  PLAQUE_DEFAULT_ADJUST, sizeof(PLAQUE_DEFAULT_ADJUST) / sizeof(int),
  PLAQUE_TRS, sizeof(PLAQUE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  PLAQUE_GLUE_POINTS, sizeof(PLAQUE_GLUE_POINTS) / sizeof(Vertex));


const Vertex BALLOON_VERTICES[] =
{
  {3590, 0}, {0, 3590}, {0, 14460}, {3590, 18050}, {CALCULATED_VALUE(40), 21600}, {5420, 18050}, {18010, 18050}, {21600, 14460}, {21600, 3590}, {18010, 0}
};

const unsigned short BALLOON_SEGMENTS[] =
{
  0x4000, 0xA701, 0x0001, 0xA801, 0x0003, 0xA701, 0x0001, 0xA801, 0x6001, 0x8000
};

const Calculation BALLOON_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 10800}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 10800}, {0x6006, OTHER_CALC_VAL | 0x12, PROP_ADJUST_VAL_FIRST, 0}, {0x6006, OTHER_CALC_VAL | 0x12, PROP_ADJUST_VAL_FIRST + 1, 6280}, {OTHER_CALC_VAL | 0x17, PROP_ADJUST_VAL_FIRST, 0, 0x6006}, {0x6006, OTHER_CALC_VAL | 0x17, PROP_ADJUST_VAL_FIRST + 1, 15320}, {0x6006, OTHER_CALC_VAL | 0x1A, PROP_ADJUST_VAL_FIRST, 6280}, {0x6006, OTHER_CALC_VAL | 0x1A, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0x6006, OTHER_CALC_VAL | 0x1D, PROP_ADJUST_VAL_FIRST, 15320}, {0x6006, OTHER_CALC_VAL | 0x1D, PROP_ADJUST_VAL_FIRST + 1, 21600}, {0x6006, OTHER_CALC_VAL | 0x20, PROP_ADJUST_VAL_FIRST, 21600}, {0x6006, OTHER_CALC_VAL | 0x20, PROP_ADJUST_VAL_FIRST + 1, 15320}, {0x6006, OTHER_CALC_VAL | 0x22, PROP_ADJUST_VAL_FIRST, 21600}, {0x6006, OTHER_CALC_VAL | 0x22, PROP_ADJUST_VAL_FIRST + 1, 6280}, {0x6006, OTHER_CALC_VAL | 0x24, PROP_ADJUST_VAL_FIRST, 15320}, {0x6006, OTHER_CALC_VAL | 0x24, PROP_ADJUST_VAL_FIRST + 1, 0}, {0x6006, OTHER_CALC_VAL | 0x26, PROP_ADJUST_VAL_FIRST, 6280}, {0x6006, OTHER_CALC_VAL | 0x26, PROP_ADJUST_VAL_FIRST + 1, 0}, {0xA006, PROP_ADJUST_VAL_FIRST, -1, OTHER_CALC_VAL | 0x13}, {0xA006, OTHER_CALC_VAL | 0x1, -1, OTHER_CALC_VAL | 0x16}, {0x2003, OTHER_CALC_VAL, 0, 0}, {0x2003, OTHER_CALC_VAL | 0x1, 0, 0}, {0xA000, OTHER_CALC_VAL | 0x14, 0, OTHER_CALC_VAL | 0x15}, {0xA006, PROP_ADJUST_VAL_FIRST, -1, OTHER_CALC_VAL | 0x18}, {0x6006, OTHER_CALC_VAL | 0x1, OTHER_CALC_VAL | 0x16, -1}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 21600}, {0x6006, OTHER_CALC_VAL | 0x19, OTHER_CALC_VAL | 0x1B, -1}, {0xA006, OTHER_CALC_VAL, -1, OTHER_CALC_VAL | 0x1C}, {0xA000, OTHER_CALC_VAL | 0x15, 0, OTHER_CALC_VAL | 0x14}, {0x6006, OTHER_CALC_VAL | 0x19, OTHER_CALC_VAL | 0x1E, -1}, {0x6006, OTHER_CALC_VAL, OTHER_CALC_VAL | 0x1C, -1}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 21600}, {0x6006, OTHER_CALC_VAL | 0x1F, OTHER_CALC_VAL | 0x21, -1}, {0x6006, OTHER_CALC_VAL | 0x1, OTHER_CALC_VAL | 0x16, -1}, {0x6006, OTHER_CALC_VAL | 0x1F, OTHER_CALC_VAL | 0x23, -1}, {0xA006, OTHER_CALC_VAL | 0x1, -1, OTHER_CALC_VAL | 0x16}, {0xA006, PROP_ADJUST_VAL_FIRST + 1, -1, OTHER_CALC_VAL | 0x25}, {0x6006, OTHER_CALC_VAL, OTHER_CALC_VAL | 0x1C, -1}, {0xA006, PROP_ADJUST_VAL_FIRST + 1, -1, OTHER_CALC_VAL | 0x27}, {0xA006, OTHER_CALC_VAL, -1, OTHER_CALC_VAL | 0x1C}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}
};

const TextRectangle BALLOON_TRS[] =
{
  { {800, 800}, {20800, 17250} }
};

const int BALLOON_DEFAULT_ADJUST[] =
{
  1400, 25920
};

const Vertex ARC_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(5)}, {10800, 10800}, {0, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(5)}
};

const unsigned short ARC_SEGMENTS[] =
{
  0xa504, 0xab00, 0x0001, 0x6001, 0x8000, 0xa504, 0xaa00, 0x8000
};

const Calculation ARC_CALC[] =
{
  {0x4009, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x400, 10800, 0}, {0x400a, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x402, 10800, 0}, {0x4009, 10800, PROP_ADJUST_VAL_FIRST + 1, 0}, {0x2000, 0x404, 10800, 0}, {0x400a, 10800, PROP_ADJUST_VAL_FIRST + 1, 0}, {0x2000, 0x406, 10800, 0}
};

const int ARC_DEFAULT_ADJUST[] =
{
  270 << 16, 0
};

const Vertex ARC_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_ARC(
  ARC_VERTICES, sizeof(ARC_VERTICES) / sizeof(Vertex),
  ARC_SEGMENTS, sizeof(ARC_SEGMENTS) / sizeof(unsigned short),
  ARC_CALC, sizeof(ARC_CALC) / sizeof(Calculation),
  ARC_DEFAULT_ADJUST, sizeof(ARC_DEFAULT_ADJUST) / sizeof(int),
  NULL, 0,
  21600, 21600,
  ARC_GLUE_POINTS, sizeof(ARC_GLUE_POINTS) / sizeof(Vertex), 2 | 1);

const CustomShape CS_BALLOON(
  BALLOON_VERTICES, sizeof(BALLOON_VERTICES) / sizeof(Vertex),
  BALLOON_SEGMENTS, sizeof(BALLOON_SEGMENTS) / sizeof(unsigned short),
  BALLOON_CALC, sizeof(BALLOON_CALC) / sizeof(Calculation),
  BALLOON_DEFAULT_ADJUST, sizeof(BALLOON_DEFAULT_ADJUST) / sizeof(int),
  BALLOON_TRS, sizeof(BALLOON_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex CUBE_VERTICES[] =
{
  {0, CALCULATED_VALUE(12)}, {0, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), 0}, {CALCULATED_VALUE(11), 0}, {CALCULATED_VALUE(11), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(12)}, {0, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), 0}, {CALCULATED_VALUE(11), 0}, {CALCULATED_VALUE(4), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(11), 0}, {CALCULATED_VALUE(11), CALCULATED_VALUE(3)}
};

const unsigned short CUBE_SEGMENTS[] =
{
  0x4000, 0x0005, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000
};

const Calculation CUBE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_TOP, OTHER_CALC_VAL, 0}, {0x6000, PROP_GEO_LEFT, OTHER_CALC_VAL, 0}, {0xA000, PROP_GEO_BOTTOM, 0, OTHER_CALC_VAL}, {0xA000, PROP_GEO_RIGHT, 0, OTHER_CALC_VAL}, {0xA000, PROP_GEO_RIGHT, 0, OTHER_CALC_VAL | 2}, {0x2001, OTHER_CALC_VAL | 5, 1, 2}, {0x6000, OTHER_CALC_VAL | 2, OTHER_CALC_VAL | 6, 0}, {0xA000, PROP_GEO_BOTTOM, 0, OTHER_CALC_VAL | 1}, {0x2001, OTHER_CALC_VAL | 8, 1, 2}, {0x6000, OTHER_CALC_VAL | 1, OTHER_CALC_VAL | 9, 0}, {0x2000, PROP_GEO_RIGHT, 0, 0}, {0x2000, PROP_GEO_BOTTOM, 0, 0}
};

const TextRectangle CUBE_TRS[] =
{
  { {0, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(12)} }
};

const int CUBE_DEFAULT_ADJUST[] =
{
  5400
};

const Vertex CUBE_GLUE_POINTS[] =
{
  {CALCULATED_VALUE(7), 0}, {CALCULATED_VALUE(6), CALCULATED_VALUE(1)}, {0, CALCULATED_VALUE(10)}, {CALCULATED_VALUE(6), 21600}, {CALCULATED_VALUE(4), CALCULATED_VALUE(10)}, {21600, CALCULATED_VALUE(9)}
};

const CustomShape CS_CUBE(
  CUBE_VERTICES, sizeof(CUBE_VERTICES) / sizeof(Vertex),
  CUBE_SEGMENTS, sizeof(CUBE_SEGMENTS) / sizeof(unsigned short),
  CUBE_CALC, sizeof(CUBE_CALC) / sizeof(Calculation),
  CUBE_DEFAULT_ADJUST, sizeof(CUBE_DEFAULT_ADJUST) / sizeof(int),
  CUBE_TRS, sizeof(CUBE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  CUBE_GLUE_POINTS, sizeof(CUBE_GLUE_POINTS) / sizeof(Vertex));

const Vertex HOME_PLATE_VERTICES[] =
{
  {0, 0}, {CALCULATED_VALUE(0), 0}, {21600, 10800}, {CALCULATED_VALUE(0), 21600}, {0, 21600}
};

const unsigned short HOME_PLATE_SEGMENTS[] =
{
  0x4000, 0x0004, 0x6001, 0x8000
};

const Calculation HOME_PLATE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}
};

const TextRectangle HOME_PLATE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int HOME_PLATE_DEFAULT_ADJUST[] =
{
  16200
};

const CustomShape CS_HOME_PLATE(
  HOME_PLATE_VERTICES, sizeof(HOME_PLATE_VERTICES) / sizeof(Vertex),
  HOME_PLATE_SEGMENTS, sizeof(HOME_PLATE_SEGMENTS) / sizeof(unsigned short),
  HOME_PLATE_CALC, sizeof(HOME_PLATE_CALC) / sizeof(Calculation),
  HOME_PLATE_DEFAULT_ADJUST, sizeof(HOME_PLATE_DEFAULT_ADJUST) / sizeof(int),
  HOME_PLATE_TRS, sizeof(HOME_PLATE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ARROW_VERTICES[] =
{
  {0, CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(0) }, {CALCULATED_VALUE(1) , 0}, {21600, 10800}, {CALCULATED_VALUE(1) , 21600}, {CALCULATED_VALUE(1) , CALCULATED_VALUE(2) }, {0, CALCULATED_VALUE(2) }
};

const unsigned short ARROW_SEGMENTS[] =
{
  0x4000, 0x0006, 0x6001, 0x8000
};

const Calculation ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 21600, 0, OTHER_CALC_VAL  | 1}, {0x6001, OTHER_CALC_VAL | 3, OTHER_CALC_VAL, 10800}, {0x6000, OTHER_CALC_VAL | 1, OTHER_CALC_VAL | 4, 0}, {0x6001, OTHER_CALC_VAL | 1, OTHER_CALC_VAL, 10800}, {0xA000, OTHER_CALC_VAL | 1, 0, OTHER_CALC_VAL | 6}
};

const TextRectangle ARROW_TRS[] =
{
  { {0, CALCULATED_VALUE(0)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(2)} }
};

const int ARROW_DEFAULT_ADJUST[] =
{
  16200, 5400
};

const CustomShape CS_ARROW(
  ARROW_VERTICES, sizeof(ARROW_VERTICES) / sizeof(Vertex),
  ARROW_SEGMENTS, sizeof(ARROW_SEGMENTS) / sizeof(unsigned short),
  ARROW_CALC, sizeof(ARROW_CALC) / sizeof(Calculation),
  ARROW_DEFAULT_ADJUST, sizeof(ARROW_DEFAULT_ADJUST) / sizeof(int),
  ARROW_TRS, sizeof(ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex OCTAGON_VERTICES[] =
{
  {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(2), 0}, {21600, CALCULATED_VALUE(1)}, {21600, CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), 21600}, {CALCULATED_VALUE(0), 21600}, {0, CALCULATED_VALUE(3)}, {0, CALCULATED_VALUE(1)}
};

const unsigned short OCTAGON_SEGMENTS[] =
{
  0x4000, 0x0007, 0x6001, 0x8000
};

const Calculation OCTAGON_CALC[] =
{
  {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xA000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xA000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x6000, PROP_GEO_LEFT, OTHER_CALC_VAL | 4, 0}, {0x6000, PROP_GEO_TOP, OTHER_CALC_VAL | 4, 0}, {0xA000, PROP_GEO_RIGHT, 0, OTHER_CALC_VAL | 4}, {0xA000, PROP_GEO_BOTTOM, 0, OTHER_CALC_VAL | 4}
};

const TextRectangle OCTAGON_TRS[] =
{
  { {CALCULATED_VALUE(5), CALCULATED_VALUE(6)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(8)} }
};

const int OCTAGON_DEFAULT_ADJUST[] =
{
  5000
};

const Vertex OCTAGON_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_OCTAGON(
  OCTAGON_VERTICES, sizeof(OCTAGON_VERTICES) / sizeof(Vertex),
  OCTAGON_SEGMENTS, sizeof(OCTAGON_SEGMENTS) / sizeof(unsigned short),
  OCTAGON_CALC, sizeof(OCTAGON_CALC) / sizeof(Calculation),
  OCTAGON_DEFAULT_ADJUST, sizeof(OCTAGON_DEFAULT_ADJUST) / sizeof(int),
  OCTAGON_TRS, sizeof(OCTAGON_TRS) / sizeof(TextRectangle),
  21600, 21600,
  OCTAGON_GLUE_POINTS, sizeof(OCTAGON_GLUE_POINTS) / sizeof(Vertex));

const Vertex ROUND_RECTANGLE_VERTICES[] =
{
  {CALCULATED_VALUE(7), 0},
  {0, CALCULATED_VALUE(8)},
  {0, CALCULATED_VALUE(9)},
  {CALCULATED_VALUE(7), 21600},
  {CALCULATED_VALUE(10), 21600},
  {21600, CALCULATED_VALUE(9)},
  {21600, CALCULATED_VALUE(8)},
  {CALCULATED_VALUE(10), 0}
};

const unsigned short ROUND_RECTANGLE_SEGMENTS[] =
{
  0x4000, 0xA701, 0x0001, 0xA801, 0x0001, 0xA701, 0x0001, 0xA801, 0x6000, 0x8000
};

const Calculation ROUND_RECTANGLE_CALC[] =
{
  {0x000E, 0, 45, 0},                                  // 0
  {0x6009, PROP_ADJUST_VAL_FIRST, OTHER_CALC_VAL, 0},  // 1
  {0x2001, OTHER_CALC_VAL | 1, 3163, 7636},            // 2
  {0x6000, PROP_GEO_LEFT, OTHER_CALC_VAL | 2, 0},      // 3
  {0x6000, PROP_GEO_TOP, OTHER_CALC_VAL | 2, 0},       // 4
  {0xA000, PROP_GEO_RIGHT, 0, OTHER_CALC_VAL | 2},     // 5
  {0xA000, PROP_GEO_BOTTOM, 0, OTHER_CALC_VAL | 2},    // 6
  {0x6000, PROP_GEO_LEFT, OTHER_CALC_VAL | 13, 0},   // 7
  {0x6000, PROP_GEO_TOP, OTHER_CALC_VAL | 14, 0},    // 8
  {0xA000, PROP_GEO_BOTTOM, 0, OTHER_CALC_VAL | 14}, // 9
  {0xA000, PROP_GEO_RIGHT, 0, OTHER_CALC_VAL | 13},  // 10
  {0x2005, ASPECT_RATIO, 1, 0},                           // 11
  {0x2004, ASPECT_RATIO, 1, 0},                           // 12
  {0xA001, PROP_ADJUST_VAL_FIRST, 1, OTHER_CALC_VAL | 11}, // 13
  {0x6001, PROP_ADJUST_VAL_FIRST, OTHER_CALC_VAL | 12, 1} // 14
};

const TextRectangle ROUND_RECTANGLE_TRS[] =
{
  { {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(6)} }
};

const int ROUND_RECTANGLE_DEFAULT_ADJUST[] =
{
  3600
};

const CustomShape CS_ROUND_RECTANGLE(
  ROUND_RECTANGLE_VERTICES, sizeof(ROUND_RECTANGLE_VERTICES) / sizeof(Vertex),
  ROUND_RECTANGLE_SEGMENTS, sizeof(ROUND_RECTANGLE_SEGMENTS) / sizeof(unsigned short),
  ROUND_RECTANGLE_CALC, sizeof(ROUND_RECTANGLE_CALC) / sizeof(Calculation),
  ROUND_RECTANGLE_DEFAULT_ADJUST, sizeof(ROUND_RECTANGLE_DEFAULT_ADJUST) / sizeof(int),
  ROUND_RECTANGLE_TRS, sizeof(ROUND_RECTANGLE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex STAR_VERTICES[] =
{
  {10797, 0}, {8278, 8256}, {0, 8256}, {6722, 13405}, {4198, 21600}, {10797, 16580}, {17401, 21600}, {14878, 13405}, {21600, 8256}, {13321, 8256}, {10797, 0}
};

const TextRectangle STAR_TRS[] =
{
  { {6722, 8256}, {14878, 15460} }
};

const CustomShape CS_STAR(
  STAR_VERTICES, sizeof(STAR_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  STAR_TRS, sizeof(STAR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex PLUS_VERTICES[] =
{
  {CALCULATED_VALUE(1), 0}, {CALCULATED_VALUE(2), 0}, {CALCULATED_VALUE(2), CALCULATED_VALUE(1)}, {21600, CALCULATED_VALUE(1)}, {21600, CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), 21600}, {CALCULATED_VALUE(1), 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(3)}, {0, CALCULATED_VALUE(3)}, {0, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(1), 0}
};

const Calculation PLUS_CALC[] =
{
  {0x2001, PROP_ADJUST_VAL_FIRST, 10799, 10800}, {0x2000, OTHER_CALC_VAL, 0, 0}, {0xA000, PROP_GEO_RIGHT, 0, OTHER_CALC_VAL}, {0xA000, PROP_GEO_BOTTOM, 0, OTHER_CALC_VAL}
};

const TextRectangle PLUS_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)} }
};

const int PLUS_DEFAULT_ADJUST[] =
{
  5400
};

const Vertex PLUS_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_PLUS(
  PLUS_VERTICES, sizeof(PLUS_VERTICES) / sizeof(Vertex),
  NULL, 0,
  PLUS_CALC, sizeof(PLUS_CALC) / sizeof(Calculation),
  PLUS_DEFAULT_ADJUST, sizeof(PLUS_DEFAULT_ADJUST) / sizeof(int),
  PLUS_TRS, sizeof(PLUS_TRS) / sizeof(TextRectangle),
  21600, 21600,
  PLUS_GLUE_POINTS, sizeof(PLUS_GLUE_POINTS) / sizeof(Vertex));


const Vertex TRAPEZOID_VERTICES[] =
{
  {0, 0}, {21600, 0}, {CALCULATED_VALUE(0), 21600}, {CALCULATED_VALUE(1), 21600}
};

const unsigned short TRAPEZOID_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000
};

const Calculation TRAPEZOID_CALC[] =
{
  {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2001, PROP_ADJUST_VAL_FIRST, 10, 18}, {0x2000, OTHER_CALC_VAL | 2, 1750, 0}, {0x8000, 21600, 0, OTHER_CALC_VAL | 3}, {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x8000, 21600, 0, OTHER_CALC_VAL | 5}
};

const TextRectangle TRAPEZOID_TRS[] =
{
  { {CALCULATED_VALUE(3), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(4)} }
};

const int TRAPEZOID_DEFAULT_ADJUST[] =
{
  5400
};

const Vertex TRAPEZOID_GLUE_POINTS[] =
{
  {CALCULATED_VALUE(6), 10800}, {10800, 21600}, {CALCULATED_VALUE(5), 10800}, {10800, 0}
};

const CustomShape CS_TRAPEZOID(
  TRAPEZOID_VERTICES, sizeof(TRAPEZOID_VERTICES) / sizeof(Vertex),
  TRAPEZOID_SEGMENTS, sizeof(TRAPEZOID_SEGMENTS) / sizeof(unsigned short),
  TRAPEZOID_CALC, sizeof(TRAPEZOID_CALC) / sizeof(Calculation),
  TRAPEZOID_DEFAULT_ADJUST, sizeof(TRAPEZOID_DEFAULT_ADJUST) / sizeof(int),
  TRAPEZOID_TRS, sizeof(TRAPEZOID_TRS) / sizeof(TextRectangle),
  21600, 21600,
  TRAPEZOID_GLUE_POINTS, sizeof(TRAPEZOID_GLUE_POINTS) / sizeof(Vertex));

const Vertex DIAMOND_VERTICES[] =
{
  {10800, 0}, {21600, 10800}, {10800, 21600}, {0, 10800}, {10800, 0}
};

const TextRectangle DIAMOND_TRS[] =
{
  { {5400, 5400}, {16200, 16200} }
};

const Vertex DIAMOND_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_DIAMOND(
  DIAMOND_VERTICES, sizeof(DIAMOND_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  DIAMOND_TRS, sizeof(DIAMOND_TRS) / sizeof(TextRectangle),
  21600, 21600,
  DIAMOND_GLUE_POINTS, sizeof(DIAMOND_GLUE_POINTS) / sizeof(Vertex));

const Vertex RIGHT_TRIANGLE_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {0, 21600}, {0, 0}
};

const TextRectangle RIGHT_TRIANGLE_TRS[] =
{
  { {1900, 12700}, {12700, 19700} }
};

const Vertex RIGHT_TRIANGLE_GLUE_POINTS[] =
{
  {10800, 0}, {5400, 10800}, {0, 21600}, {10800, 21600}, {21600, 21600}, {16200, 10800}
};

const CustomShape CS_RIGHT_TRIANGLE(
  RIGHT_TRIANGLE_VERTICES, sizeof(RIGHT_TRIANGLE_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  RIGHT_TRIANGLE_TRS, sizeof(RIGHT_TRIANGLE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  RIGHT_TRIANGLE_GLUE_POINTS, sizeof(RIGHT_TRIANGLE_GLUE_POINTS) / sizeof(Vertex));


const Vertex RECTANGLE_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}
};

const CustomShape CS_RECTANGLE(
  RECTANGLE_VERTICES, sizeof(RECTANGLE_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  NULL, 0,
  21600, 21600,
  NULL, 0);

const Vertex ELLIPSE_VERTICES[] =
{
  {10800, 10800}, {10800, 10800}, {0, 360}
};

const unsigned short ELLIPSE_SEGMENTS[] =
{
  0xA203, 0x6000, 0x8000
};

const TextRectangle ELLIPSE_TRS[] =
{
  { {3163, 3163}, {18437, 18437} }
};

const Vertex ELLIPSE_GLUE_PTS[] =
{
  {10800, 0}, {3163, 3163}, {0, 10800}, {3163, 18437}, {10800, 21600},
  {18437, 18437}, {21600, 10800}, {18437, 3163}
};

const CustomShape CS_ELLIPSE(
  ELLIPSE_VERTICES, sizeof(ELLIPSE_VERTICES) / sizeof(Vertex),
  ELLIPSE_SEGMENTS, sizeof(ELLIPSE_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  ELLIPSE_TRS, sizeof(ELLIPSE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  ELLIPSE_GLUE_PTS, sizeof(ELLIPSE_GLUE_PTS) / sizeof(Vertex));

const Vertex SEAL_4_VERTICES[] =
{
  {0, 10800}, {CALCULATED_VALUE(4), CALCULATED_VALUE(4)},
  {10800, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)},
  {21600, 10800}, {CALCULATED_VALUE(3), CALCULATED_VALUE(3)},
  {10800, 21600}, {CALCULATED_VALUE(4), CALCULATED_VALUE(3)},
  {0, 10800}
};

const Calculation SEAL_4_CALC[] =
{
  {0x0000, 7600, 0, 0},
  {0x6001, OTHER_CALC_VAL, PROP_ADJUST_VAL_FIRST, 10800},
  {0xA000, OTHER_CALC_VAL, 0, OTHER_CALC_VAL | 1},
  {0x4000, 10800, OTHER_CALC_VAL | 2, 0},
  {0x8000, 10800, 0, OTHER_CALC_VAL | 2}
};

const TextRectangle SEAL_4_TRS[] =
{
  { {CALCULATED_VALUE(4), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(3)} }
};

const int SEAL_4_DEFAULT_ADJUST[] =
{
  8100
};

const CustomShape CS_SEAL_4(
  SEAL_4_VERTICES, sizeof(SEAL_4_VERTICES) / sizeof(Vertex),
  NULL, 0,
  SEAL_4_CALC, sizeof(SEAL_4_CALC) / sizeof(Calculation),
  SEAL_4_DEFAULT_ADJUST, sizeof(SEAL_4_DEFAULT_ADJUST) / sizeof(int),
  SEAL_4_TRS, sizeof(SEAL_4_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ISOCELES_TRIANGLE_VERTICES[] =
{
  {CALCULATED_VALUE(0), 0}, {21600, 21600}, {0, 21600}
};

const unsigned short ISOCELES_TRIANGLE_SEGMENTS[] =
{
  0x4000, 0x0002, 0x6001, 0x8000
};

const Calculation ISOCELES_TRIANGLE_CALC[] =
{
  {0x4000, 0, PROP_ADJUST_VAL_FIRST, 0},
  {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2},
  {0x2000, OTHER_CALC_VAL | 1, 10800, 0},
  {0x2001, PROP_ADJUST_VAL_FIRST, 2, 3},
  {0x2000, OTHER_CALC_VAL | 3, 7200, 0},
  {0x8000, 21600, 0, OTHER_CALC_VAL},
  {0x2001, OTHER_CALC_VAL | 5, 1, 2},
  {0x8000, 21600, 0, OTHER_CALC_VAL | 6}
};

const TextRectangle ISOCELES_TRIANGLE_TRS[] =
{
  { {CALCULATED_VALUE(1), 10800}, {CALCULATED_VALUE(2), 18000} },
  { {CALCULATED_VALUE(3), 7200}, {CALCULATED_VALUE(4), 21600} }
};

const Vertex ISOCELES_TRIANGLE_GLUE_POINTS[] =
{
  {10800, 0}, {CALCULATED_VALUE(1), 10800},
  {0, 21600}, {10800, 21600},
  {21600, 21600}, {CALCULATED_VALUE(7), 10800}
};

const int ISOCELES_TRIANGLE_DEFAULT_ADJUST[] =
{
  10800
};

const CustomShape CS_ISOCELES_TRIANGLE(
  ISOCELES_TRIANGLE_VERTICES, sizeof(ISOCELES_TRIANGLE_VERTICES) / sizeof(Vertex),
  ISOCELES_TRIANGLE_SEGMENTS, sizeof(ISOCELES_TRIANGLE_SEGMENTS) / sizeof(unsigned short),
  ISOCELES_TRIANGLE_CALC, sizeof(ISOCELES_TRIANGLE_CALC) / sizeof(Calculation),
  ISOCELES_TRIANGLE_DEFAULT_ADJUST, sizeof(ISOCELES_TRIANGLE_DEFAULT_ADJUST) / sizeof(int),
  ISOCELES_TRIANGLE_TRS, sizeof(ISOCELES_TRIANGLE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  ISOCELES_TRIANGLE_GLUE_POINTS, sizeof(ISOCELES_TRIANGLE_GLUE_POINTS) / sizeof(Vertex));

const Vertex PARALLELOGRAM_VERTICES[] =
{
  {CALCULATED_VALUE(0), 0}, {21600, 0}, {CALCULATED_VALUE(1), 21600}, {0, 21600}
};

const unsigned short PARALLELOGRAM_SEGMENTS[] =
{
  0x4000, 0x003, 0x6001, 0x8000
};

const Calculation PARALLELOGRAM_CALC[] =
{
  {0x4000, 0, PROP_ADJUST_VAL_FIRST, 0}, {0x8000, 0, 21600, PROP_ADJUST_VAL_FIRST}, {0x2001, PROP_ADJUST_VAL_FIRST, 10, 24}, {0x2000, OTHER_CALC_VAL | 2, 1750, 0}, {0x8000, 21600, 0, OTHER_CALC_VAL | 3}, {0x2001, OTHER_CALC_VAL, 1, 2}, {0x4000, 10800, OTHER_CALC_VAL | 5, 0}, {0x2000, OTHER_CALC_VAL, 0, 10800}, {0x6006, OTHER_CALC_VAL | 7, OTHER_CALC_VAL | 0xC, 21600}, {0x8000, 21600, 0, OTHER_CALC_VAL | 5}, {0x8001, 21600, 10800, OTHER_CALC_VAL}, {0x8000, 21600, 0, OTHER_CALC_VAL | 0xC}
};

const TextRectangle PARALLELOGRAM_TRS[] =
{
  { {CALCULATED_VALUE(3), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(4)} }
};

const int PARALLELOGRAM_DEFAULT_ADJUST[] =
{
  5400
};

const Vertex PARALLELOGRAM_GLUE_POINTS[] =
{
  {CALCULATED_VALUE(6), 0}, {10800, CALCULATED_VALUE(8)}, {CALCULATED_VALUE(11), 10800}, {CALCULATED_VALUE(9), 21600}, {10800, CALCULATED_VALUE(10)}, {CALCULATED_VALUE(5), 10800}
};

const CustomShape CS_PARALLELOGRAM(
  PARALLELOGRAM_VERTICES, sizeof(PARALLELOGRAM_VERTICES) / sizeof(Vertex),
  PARALLELOGRAM_SEGMENTS, sizeof(PARALLELOGRAM_SEGMENTS) / sizeof(unsigned short),
  PARALLELOGRAM_CALC, sizeof(PARALLELOGRAM_CALC) / sizeof(Calculation),
  PARALLELOGRAM_DEFAULT_ADJUST, sizeof(PARALLELOGRAM_DEFAULT_ADJUST) / sizeof(int),
  PARALLELOGRAM_TRS, sizeof(PARALLELOGRAM_TRS) / sizeof(TextRectangle),
  21600, 21600,
  PARALLELOGRAM_GLUE_POINTS, sizeof(PARALLELOGRAM_GLUE_POINTS) / sizeof(Vertex));

const Vertex HEXAGON_VERTICES[] =
{
  {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(1), 0}, {21600, 10800}, {CALCULATED_VALUE(1), 21600}, {CALCULATED_VALUE(0), 21600}, {0, 10800}
};

const unsigned short HEXAGON_SEGMENTS[] =
{
  0x4000, 0x0005, 0x6001, 0x8000
};

const Calculation HEXAGON_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, PROP_ADJUST_VAL_FIRST, 100, 234}, {0x2000, OTHER_CALC_VAL | 2, 1700, 0}, {0x8000, 21600, 0, OTHER_CALC_VAL | 3}
};

const TextRectangle HEXAGON_TRS[] =
{
  { {CALCULATED_VALUE(3), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(4)} }
};

const int HEXAGON_DEFAULT_ADJUST[] =
{
  5400
};

const Vertex HEXAGON_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_HEXAGON(
  HEXAGON_VERTICES, sizeof(HEXAGON_VERTICES) / sizeof(Vertex),
  HEXAGON_SEGMENTS, sizeof(HEXAGON_SEGMENTS) / sizeof(unsigned short),
  HEXAGON_CALC, sizeof(HEXAGON_CALC) / sizeof(Calculation),
  HEXAGON_DEFAULT_ADJUST, sizeof(HEXAGON_DEFAULT_ADJUST) / sizeof(int),
  HEXAGON_TRS, sizeof(HEXAGON_TRS) / sizeof(TextRectangle),
  21600, 21600,
  HEXAGON_GLUE_POINTS, sizeof(HEXAGON_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_SUMMING_JUNCTION_VERTICES[] =
{
  {10800, 10800}, {10800, 10800}, {0, 360}, {3100, 3100}, {18500, 18500}, {3100, 18500}, {18500, 3100}
};

const unsigned short FLOW_CHART_SUMMING_JUNCTION_SEGMENTS[] =
{
  0xa203, 0x6000, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const TextRectangle FLOW_CHART_SUMMING_JUNCTION_TRS[] =
{
  { {3100, 3100}, {18500, 18500} }
};

const Vertex FLOW_CHART_SUMMING_JUNCTION_GLUE_POINTS[] =
{
  {10800, 0}, {3163, 3163}, {0, 10800}, {3163, 18437}, {10800, 21600}, {18437, 18437}, {21600, 10800}, {18437, 3163}
};

const CustomShape CS_FLOW_CHART_SUMMING_JUNCTION(
  FLOW_CHART_SUMMING_JUNCTION_VERTICES, sizeof(FLOW_CHART_SUMMING_JUNCTION_VERTICES) / sizeof(Vertex),
  FLOW_CHART_SUMMING_JUNCTION_SEGMENTS, sizeof(FLOW_CHART_SUMMING_JUNCTION_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_SUMMING_JUNCTION_TRS, sizeof(FLOW_CHART_SUMMING_JUNCTION_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_SUMMING_JUNCTION_GLUE_POINTS, sizeof(FLOW_CHART_SUMMING_JUNCTION_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_PREPARATION_VERTICES[] =
{
  {4350, 0}, {17250, 0}, {21600, 10800}, {17250, 21600}, {4350, 21600}, {0, 10800}, {4350, 0}
};

const TextRectangle FLOW_CHART_PREPARATION_TRS[] =
{
  { {4350, 0}, {17250, 21600} }
};

const Vertex FLOW_CHART_PREPARATION_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_PREPARATION(
  FLOW_CHART_PREPARATION_VERTICES, sizeof(FLOW_CHART_PREPARATION_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  FLOW_CHART_PREPARATION_TRS, sizeof(FLOW_CHART_PREPARATION_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_PREPARATION_GLUE_POINTS, sizeof(FLOW_CHART_PREPARATION_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_PUNCHED_TAPE_VERTICES[] =
{
  {0, 2230}, {820, 3990}, {3410, 3980}, {5370, 4360}, {7430, 4030}, {10110, 3890}, {10690, 2270}, {11440, 300}, {14200, 160}, {16150, 0}, {18670, 170}, {20690, 390}, {21600, 2230}, {21600, 19420}, {20640, 17510}, {18320, 17490}, {16140, 17240}, {14710, 17370}, {11310, 17510}, {10770, 19430}, {10150, 21150}, {7380, 21290}, {5290, 21600}, {3220, 21250}, {610, 21130}, {0, 19420}
};

const unsigned short FLOW_CHART_PUNCHED_TAPE_SEGMENTS[] =
{
  0x4000, 0x2004, 0x0001, 0x2004, 0x6000, 0x8000
};

const TextRectangle FLOW_CHART_PUNCHED_TAPE_TRS[] =
{
  { {0, 4360}, {21600, 17240} }
};

const Vertex FLOW_CHART_PUNCHED_TAPE_GLUE_POINTS[] =
{
  {10800, 2020}, {0, 10800}, {10800, 19320}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_PUNCHED_TAPE(
  FLOW_CHART_PUNCHED_TAPE_VERTICES, sizeof(FLOW_CHART_PUNCHED_TAPE_VERTICES) / sizeof(Vertex),
  FLOW_CHART_PUNCHED_TAPE_SEGMENTS, sizeof(FLOW_CHART_PUNCHED_TAPE_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_PUNCHED_TAPE_TRS, sizeof(FLOW_CHART_PUNCHED_TAPE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_PUNCHED_TAPE_GLUE_POINTS, sizeof(FLOW_CHART_PUNCHED_TAPE_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_PUNCHED_CARD_VERTICES[] =
{
  {4300, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 4300}, {4300, 0}
};

const TextRectangle FLOW_CHART_PUNCHED_CARD_TRS[] =
{
  { {0, 4300}, {21600, 21600} }
};

const Vertex FLOW_CHART_PUNCHED_CARD_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_PUNCHED_CARD(
  FLOW_CHART_PUNCHED_CARD_VERTICES, sizeof(FLOW_CHART_PUNCHED_CARD_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  FLOW_CHART_PUNCHED_CARD_TRS, sizeof(FLOW_CHART_PUNCHED_CARD_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_PUNCHED_CARD_GLUE_POINTS, sizeof(FLOW_CHART_PUNCHED_CARD_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_CONNECTOR_VERTICES[] =
{
  {10800, 10800}, {10800, 10800}, {0, 360}
};

const unsigned short FLOW_CHART_CONNECTOR_SEGMENTS[] =
{
  0xa203, 0x6000, 0x8000
};

const TextRectangle FLOW_CHART_CONNECTOR_TRS[] =
{
  { {3180, 3180}, {18420, 18420} }
};

const Vertex FLOW_CHART_CONNECTOR_GLUE_POINTS[] =
{
  {10800, 0}, {3163, 3163}, {0, 10800}, {3163, 18437}, {10800, 21600}, {18437, 18437}, {21600, 10800}, {18437, 3163}
};

const CustomShape CS_FLOW_CHART_CONNECTOR(
  FLOW_CHART_CONNECTOR_VERTICES, sizeof(FLOW_CHART_CONNECTOR_VERTICES) / sizeof(Vertex),
  FLOW_CHART_CONNECTOR_SEGMENTS, sizeof(FLOW_CHART_CONNECTOR_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_CONNECTOR_TRS, sizeof(FLOW_CHART_CONNECTOR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_CONNECTOR_GLUE_POINTS, sizeof(FLOW_CHART_CONNECTOR_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_MANUAL_OPERATION_VERTICES[] =
{
  {0, 0}, {21600, 0}, {17250, 21600}, {4350, 21600}, {0, 0}
};

const TextRectangle FLOW_CHART_MANUAL_OPERATION_TRS[] =
{
  { {4350, 0}, {17250, 21600} }
};

const Vertex FLOW_CHART_MANUAL_OPERATION_GLUE_POINTS[] =
{
  {10800, 0}, {2160, 10800}, {10800, 21600}, {19440, 10800}
};

const CustomShape CS_FLOW_CHART_MANUAL_OPERATION(
  FLOW_CHART_MANUAL_OPERATION_VERTICES, sizeof(FLOW_CHART_MANUAL_OPERATION_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  FLOW_CHART_MANUAL_OPERATION_TRS, sizeof(FLOW_CHART_MANUAL_OPERATION_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_MANUAL_OPERATION_GLUE_POINTS, sizeof(FLOW_CHART_MANUAL_OPERATION_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_MANUAL_INPUT_VERTICES[] =
{
  {0, 4300}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 4300}
};

const TextRectangle FLOW_CHART_MANUAL_INPUT_TRS[] =
{
  { {0, 4300}, {21600, 21600} }
};

const Vertex FLOW_CHART_MANUAL_INPUT_GLUE_POINTS[] =
{
  {10800, 2150}, {0, 10800}, {10800, 19890}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_MANUAL_INPUT(
  FLOW_CHART_MANUAL_INPUT_VERTICES, sizeof(FLOW_CHART_MANUAL_INPUT_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  FLOW_CHART_MANUAL_INPUT_TRS, sizeof(FLOW_CHART_MANUAL_INPUT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_MANUAL_INPUT_GLUE_POINTS, sizeof(FLOW_CHART_MANUAL_INPUT_GLUE_POINTS) / sizeof(Vertex));


const Vertex FLOW_CHART_OR_VERTICES[] =
{
  {10800, 10800}, {10800, 10800}, {0, 360}, {0, 10800}, {21600, 10800}, {10800, 0}, {10800, 21600}
};

const unsigned short FLOW_CHART_OR_SEGMENTS[] =
{
  0xa203, 0x6000, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const TextRectangle FLOW_CHART_OR_TRS[] =
{
  { {3100, 3100}, {18500, 18500} }
};

const Vertex FLOW_CHART_OR_GLUE_POINTS[] =
{
  {10800, 0}, {3163, 3163}, {0, 10800}, {3163, 18437}, {10800, 21600}, {18437, 18437}, {21600, 10800}, {18437, 3163}
};

const CustomShape CS_FLOW_CHART_OR(
  FLOW_CHART_OR_VERTICES, sizeof(FLOW_CHART_OR_VERTICES) / sizeof(Vertex),
  FLOW_CHART_OR_SEGMENTS, sizeof(FLOW_CHART_OR_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_OR_TRS, sizeof(FLOW_CHART_OR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_OR_GLUE_POINTS, sizeof(FLOW_CHART_OR_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_COLLATE_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {0, 21600}, {21600, 0}, {0, 0}
};

const TextRectangle FLOW_CHART_COLLATE_TRS[] =
{
  { {5400, 5400}, {16200, 16200} }
};

const Vertex FLOW_CHART_COLLATE_GLUE_POINTS[] =
{
  {10800, 0}, {10800, 10800}, {10800, 21600}
};

const CustomShape CS_FLOW_CHART_COLLATE(
  FLOW_CHART_COLLATE_VERTICES, sizeof(FLOW_CHART_COLLATE_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  FLOW_CHART_COLLATE_TRS, sizeof(FLOW_CHART_COLLATE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_COLLATE_GLUE_POINTS, sizeof(FLOW_CHART_COLLATE_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_SORT_VERTICES[] =
{
  {0, 10800}, {10800, 0}, {21600, 10800}, {10800, 21600}, {0, 10800}, {21600, 10800}
};

const unsigned short FLOW_CHART_SORT_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6000, 0x8000, 0x4000, 0x0001, 0x8000
};

const TextRectangle FLOW_CHART_SORT_TRS[] =
{
  { {5400, 5400}, {16200, 16200} }
};

const CustomShape CS_FLOW_CHART_SORT(
  FLOW_CHART_SORT_VERTICES, sizeof(FLOW_CHART_SORT_VERTICES) / sizeof(Vertex),
  FLOW_CHART_SORT_SEGMENTS, sizeof(FLOW_CHART_SORT_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_SORT_TRS, sizeof(FLOW_CHART_SORT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex FLOW_CHART_EXTRACT_VERTICES[] =
{
  {10800, 0}, {21600, 21600}, {0, 21600}, {10800, 0}
};

const TextRectangle FLOW_CHART_EXTRACT_TRS[] =
{
  { {5400, 10800}, {16200, 21600} }
};

const Vertex FLOW_CHART_EXTRACT_GLUE_POINTS[] =
{
  {10800, 0}, {5400, 10800}, {10800, 21600}, {16200, 10800}
};

const CustomShape CS_FLOW_CHART_EXTRACT(
  FLOW_CHART_EXTRACT_VERTICES, sizeof(FLOW_CHART_EXTRACT_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  FLOW_CHART_EXTRACT_TRS, sizeof(FLOW_CHART_EXTRACT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_EXTRACT_GLUE_POINTS, sizeof(FLOW_CHART_EXTRACT_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_MERGE_VERTICES[] =
{
  {0, 0}, {21600, 0}, {10800, 21600}, {0, 0}
};

const TextRectangle FLOW_CHART_MERGE_TRS[] =
{
  { {5400, 0}, {16200, 10800} }
};

const Vertex FLOW_CHART_MERGE_GLUE_POINTS[] =
{
  {10800, 0}, {5400, 10800}, {10800, 21600}, {16200, 10800}
};

const CustomShape CS_FLOW_CHART_MERGE(
  FLOW_CHART_MERGE_VERTICES, sizeof(FLOW_CHART_MERGE_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  FLOW_CHART_MERGE_TRS, sizeof(FLOW_CHART_MERGE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_MERGE_GLUE_POINTS, sizeof(FLOW_CHART_MERGE_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_ONLINE_STORAGE_VERTICES[] =
{
  {3600, 21600}, {0, 10800}, {3600, 0}, {21600, 0}, {18000, 10800}, {21600, 21600}
};

const unsigned short FLOW_CHART_ONLINE_STORAGE_SEGMENTS[] =
{
  0x4000, 0xa702, 0x0001, 0xa702, 0x6000, 0x8000
};

const TextRectangle FLOW_CHART_ONLINE_STORAGE_TRS[] =
{
  { {3600, 0}, {18000, 21600} }
};

const Vertex FLOW_CHART_ONLINE_STORAGE_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {18000, 10800}
};

const CustomShape CS_FLOW_CHART_ONLINE_STORAGE(
  FLOW_CHART_ONLINE_STORAGE_VERTICES, sizeof(FLOW_CHART_ONLINE_STORAGE_VERTICES) / sizeof(Vertex),
  FLOW_CHART_ONLINE_STORAGE_SEGMENTS, sizeof(FLOW_CHART_ONLINE_STORAGE_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_ONLINE_STORAGE_TRS, sizeof(FLOW_CHART_ONLINE_STORAGE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_ONLINE_STORAGE_GLUE_POINTS, sizeof(FLOW_CHART_ONLINE_STORAGE_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_MAGNETIC_TAPE_VERTICES[] =
{
  {20980, 18150}, {20980, 21600}, {10670, 21600}, {4770, 21540}, {0, 16720}, {0, 10800}, {0, 4840}, {4840, 0}, {10800, 0}, {16740, 0}, {21600, 4840}, {21600, 10800}, {21600, 13520}, {20550, 16160}, {18670, 18170}
};

const unsigned short FLOW_CHART_MAGNETIC_TAPE_SEGMENTS[] =
{
  0x4000, 0x0002, 0x2004, 0x6000, 0x8000
};

const TextRectangle FLOW_CHART_MAGNETIC_TAPE_TRS[] =
{
  { {3100, 3100}, {18500, 18500} }
};

const Vertex FLOW_CHART_MAGNETIC_TAPE_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_MAGNETIC_TAPE(
  FLOW_CHART_MAGNETIC_TAPE_VERTICES, sizeof(FLOW_CHART_MAGNETIC_TAPE_VERTICES) / sizeof(Vertex),
  FLOW_CHART_MAGNETIC_TAPE_SEGMENTS, sizeof(FLOW_CHART_MAGNETIC_TAPE_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_MAGNETIC_TAPE_TRS, sizeof(FLOW_CHART_MAGNETIC_TAPE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_MAGNETIC_TAPE_GLUE_POINTS, sizeof(FLOW_CHART_MAGNETIC_TAPE_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_MAGNETIC_DISK_VERTICES[] =
{
  {0, 3400}, {10800, 0}, {21600, 3400}, {21600, 18200}, {10800, 21600}, {0, 18200}, {0, 3400}, {10800, 6800}, {21600, 3400}
};

const unsigned short FLOW_CHART_MAGNETIC_DISK_SEGMENTS[] =
{
  0x4000, 0xa802, 0x0001, 0xa802, 0x6000, 0x8000, 0x4000, 0xa802, 0x8000
};

const TextRectangle FLOW_CHART_MAGNETIC_DISK_TRS[] =
{
  { {0, 6800}, {21600, 18200} }
};

const Vertex FLOW_CHART_MAGNETIC_DISK_GLUE_POINTS[] =
{
  {10800, 6800}, {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_MAGNETIC_DISK(
  FLOW_CHART_MAGNETIC_DISK_VERTICES, sizeof(FLOW_CHART_MAGNETIC_DISK_VERTICES) / sizeof(Vertex),
  FLOW_CHART_MAGNETIC_DISK_SEGMENTS, sizeof(FLOW_CHART_MAGNETIC_DISK_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_MAGNETIC_DISK_TRS, sizeof(FLOW_CHART_MAGNETIC_DISK_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_MAGNETIC_DISK_GLUE_POINTS, sizeof(FLOW_CHART_MAGNETIC_DISK_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_MAGNETIC_DRUM_VERTICES[] =
{
  {18200, 0}, {21600, 10800}, {18200, 21600}, {3400, 21600}, {0, 10800}, {3400, 0}, {18200, 0}, {14800, 10800}, {18200, 21600}
};

const unsigned short FLOW_CHART_MAGNETIC_DRUM_SEGMENTS[] =
{
  0x4000, 0xa702, 0x0001, 0xa702, 0x6000, 0x8000, 0x4000, 0xa702, 0x8000
};

const TextRectangle FLOW_CHART_MAGNETIC_DRUM_TRS[] =
{
  { {3400, 0}, {14800, 21600} }
};

const Vertex FLOW_CHART_MAGNETIC_DRUM_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {14800, 10800}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_MAGNETIC_DRUM(
  FLOW_CHART_MAGNETIC_DRUM_VERTICES, sizeof(FLOW_CHART_MAGNETIC_DRUM_VERTICES) / sizeof(Vertex),
  FLOW_CHART_MAGNETIC_DRUM_SEGMENTS, sizeof(FLOW_CHART_MAGNETIC_DRUM_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_MAGNETIC_DRUM_TRS, sizeof(FLOW_CHART_MAGNETIC_DRUM_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_MAGNETIC_DRUM_GLUE_POINTS, sizeof(FLOW_CHART_MAGNETIC_DRUM_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_DIPSLAY_VERTICES[] =
{
  {3600, 0}, {17800, 0}, {21600, 10800}, {17800, 21600}, {3600, 21600}, {0, 10800}
};

const unsigned short FLOW_CHART_DIPSLAY_SEGMENTS[] =
{
  0x4000, 0x0001, 0xa702, 0x0002, 0x6000, 0x8000
};

const TextRectangle FLOW_CHART_DIPSLAY_TRS[] =
{
  { {3600, 0}, {17800, 21600} }
};

const Vertex FLOW_CHART_DIPSLAY_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_DIPSLAY(
  FLOW_CHART_DIPSLAY_VERTICES, sizeof(FLOW_CHART_DIPSLAY_VERTICES) / sizeof(Vertex),
  FLOW_CHART_DIPSLAY_SEGMENTS, sizeof(FLOW_CHART_DIPSLAY_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_DIPSLAY_TRS, sizeof(FLOW_CHART_DIPSLAY_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_DIPSLAY_GLUE_POINTS, sizeof(FLOW_CHART_DIPSLAY_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_DELAY_VERTICES[] =
{
  {10800, 0}, {21600, 10800}, {10800, 21600}, {0, 21600}, {0, 0}
};

const unsigned short FLOW_CHART_DELAY_SEGMENTS[] =
{
  0x4000, 0xa702, 0x0002, 0x6000, 0x8000
};

const TextRectangle FLOW_CHART_DELAY_TRS[] =
{
  { {0, 3100}, {18500, 18500} }
};

const Vertex FLOW_CHART_DELAY_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_DELAY(
  FLOW_CHART_DELAY_VERTICES, sizeof(FLOW_CHART_DELAY_VERTICES) / sizeof(Vertex),
  FLOW_CHART_DELAY_SEGMENTS, sizeof(FLOW_CHART_DELAY_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_DELAY_TRS, sizeof(FLOW_CHART_DELAY_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_DELAY_GLUE_POINTS, sizeof(FLOW_CHART_DELAY_GLUE_POINTS) / sizeof(Vertex));

const Vertex TEXT_PLAIN_TEXT_VERTICES[] =
{
  {CALCULATED_VALUE(3), 0}, {CALCULATED_VALUE(5), 0}, {CALCULATED_VALUE(6), 21600}, {CALCULATED_VALUE(7), 21600}
};

const unsigned short TEXT_PLAIN_TEXT_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_PLAIN_TEXT_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 10800}, {0x2001, 0x400, 2, 1}, {0x2003, 0x401, 0, 0}, {0xa006, 0x401, 0, 0x402}, {0x8000, 21600, 0, 0x402}, {0x6006, 0x401, 0x404, 21600}, {0x6006, 0x401, 0x402, 0}, {0xa006, 0x401, 21600, 0x404}
};

const TextRectangle TEXT_PLAIN_TEXT_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_PLAIN_TEXT_DEFAULT_ADJUST[] =
{
  10800
};

const CustomShape CS_TEXT_PLAIN_TEXT(
  TEXT_PLAIN_TEXT_VERTICES, sizeof(TEXT_PLAIN_TEXT_VERTICES) / sizeof(Vertex),
  TEXT_PLAIN_TEXT_SEGMENTS, sizeof(TEXT_PLAIN_TEXT_SEGMENTS) / sizeof(unsigned short),
  TEXT_PLAIN_TEXT_CALC, sizeof(TEXT_PLAIN_TEXT_CALC) / sizeof(Calculation),
  TEXT_PLAIN_TEXT_DEFAULT_ADJUST, sizeof(TEXT_PLAIN_TEXT_DEFAULT_ADJUST) / sizeof(int),
  TEXT_PLAIN_TEXT_TRS, sizeof(TEXT_PLAIN_TEXT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_STOP_VERTICES[] =
{
  {0, CALCULATED_VALUE(0)}, {7200, 0}, {14400, 0}, {21600, CALCULATED_VALUE(0)}, {0, CALCULATED_VALUE(1)}, {7200, 21600}, {14400, 21600}, {21600, CALCULATED_VALUE(1)}
};

const unsigned short TEXT_STOP_SEGMENTS[] =
{
  0x4000, 0x0003, 0x8000, 0x4000, 0x0003, 0x8000
};

const Calculation TEXT_STOP_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle TEXT_STOP_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_STOP_DEFAULT_ADJUST[] =
{
  2700
};

const CustomShape CS_TEXT_STOP(
  TEXT_STOP_VERTICES, sizeof(TEXT_STOP_VERTICES) / sizeof(Vertex),
  TEXT_STOP_SEGMENTS, sizeof(TEXT_STOP_SEGMENTS) / sizeof(unsigned short),
  TEXT_STOP_CALC, sizeof(TEXT_STOP_CALC) / sizeof(Calculation),
  TEXT_STOP_DEFAULT_ADJUST, sizeof(TEXT_STOP_DEFAULT_ADJUST) / sizeof(int),
  TEXT_STOP_TRS, sizeof(TEXT_STOP_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_TRIANGLE_VERTICES[] =
{
  {0, CALCULATED_VALUE(0)}, {10800, 0}, {21600, CALCULATED_VALUE(0)}, {0, 21600}, {21600, 21600}
};

const unsigned short TEXT_TRIANGLE_SEGMENTS[] =
{
  0x4000, 0x0002, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_TRIANGLE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}
};

const TextRectangle TEXT_TRIANGLE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_TRIANGLE_DEFAULT_ADJUST[] =
{
  10800
};

const CustomShape CS_TEXT_TRIANGLE(
  TEXT_TRIANGLE_VERTICES, sizeof(TEXT_TRIANGLE_VERTICES) / sizeof(Vertex),
  TEXT_TRIANGLE_SEGMENTS, sizeof(TEXT_TRIANGLE_SEGMENTS) / sizeof(unsigned short),
  TEXT_TRIANGLE_CALC, sizeof(TEXT_TRIANGLE_CALC) / sizeof(Calculation),
  TEXT_TRIANGLE_DEFAULT_ADJUST, sizeof(TEXT_TRIANGLE_DEFAULT_ADJUST) / sizeof(int),
  TEXT_TRIANGLE_TRS, sizeof(TEXT_TRIANGLE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_TRIANGLE_INVERTED_VERTICES[] =
{
  {0, 0}, {21600, 0}, {0, CALCULATED_VALUE(0)}, {10800, 21600}, {21600, CALCULATED_VALUE(0)}
};

const unsigned short TEXT_TRIANGLE_INVERTED_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x0002, 0x8000
};

const Calculation TEXT_TRIANGLE_INVERTED_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}
};

const TextRectangle TEXT_TRIANGLE_INVERTED_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_TRIANGLE_INVERTED_DEFAULT_ADJUST[] =
{
  10800
};

const CustomShape CS_TEXT_TRIANGLE_INVERTED(
  TEXT_TRIANGLE_INVERTED_VERTICES, sizeof(TEXT_TRIANGLE_INVERTED_VERTICES) / sizeof(Vertex),
  TEXT_TRIANGLE_INVERTED_SEGMENTS, sizeof(TEXT_TRIANGLE_INVERTED_SEGMENTS) / sizeof(unsigned short),
  TEXT_TRIANGLE_INVERTED_CALC, sizeof(TEXT_TRIANGLE_INVERTED_CALC) / sizeof(Calculation),
  TEXT_TRIANGLE_INVERTED_DEFAULT_ADJUST, sizeof(TEXT_TRIANGLE_INVERTED_DEFAULT_ADJUST) / sizeof(int),
  TEXT_TRIANGLE_INVERTED_TRS, sizeof(TEXT_TRIANGLE_INVERTED_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex FLOW_CHART_DISPLAY_VERTICES[] =
{
  {3600, 0}, {17800, 0}, {21600, 10800}, {17800, 21600}, {3600, 21600}, {0, 10800}
};

const unsigned short FLOW_CHART_DISPLAY_SEGMENTS[] =
{
  0x4000, 0x0001, 0xa702, 0x0002, 0x6000, 0x8000
};

const TextRectangle FLOW_CHART_DISPLAY_TRS[] =
{
  { {3600, 0}, {17800, 21600} }
};

const Vertex FLOW_CHART_DISPLAY_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_DISPLAY(
  FLOW_CHART_DISPLAY_VERTICES, sizeof(FLOW_CHART_DISPLAY_VERTICES) / sizeof(Vertex),
  FLOW_CHART_DISPLAY_SEGMENTS, sizeof(FLOW_CHART_DISPLAY_SEGMENTS) / sizeof(unsigned short),
  NULL, 0,
  NULL, 0,
  FLOW_CHART_DISPLAY_TRS, sizeof(FLOW_CHART_DISPLAY_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_DISPLAY_GLUE_POINTS, sizeof(FLOW_CHART_DISPLAY_GLUE_POINTS) / sizeof(Vertex));

const Vertex TEXT_CHEVRON_VERTICES[] =
{
  {0, CALCULATED_VALUE(0)}, {10800, 0}, {21600, CALCULATED_VALUE(0)}, {0, 21600}, {10800, CALCULATED_VALUE(1)}, {21600, 21600}
};

const unsigned short TEXT_CHEVRON_SEGMENTS[] =
{
  0x4000, 0x0002, 0x8000, 0x4000, 0x0002, 0x8000
};

const Calculation TEXT_CHEVRON_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle TEXT_CHEVRON_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_CHEVRON_DEFAULT_ADJUST[] =
{
  5400
};

const CustomShape CS_TEXT_CHEVRON(
  TEXT_CHEVRON_VERTICES, sizeof(TEXT_CHEVRON_VERTICES) / sizeof(Vertex),
  TEXT_CHEVRON_SEGMENTS, sizeof(TEXT_CHEVRON_SEGMENTS) / sizeof(unsigned short),
  TEXT_CHEVRON_CALC, sizeof(TEXT_CHEVRON_CALC) / sizeof(Calculation),
  TEXT_CHEVRON_DEFAULT_ADJUST, sizeof(TEXT_CHEVRON_DEFAULT_ADJUST) / sizeof(int),
  TEXT_CHEVRON_TRS, sizeof(TEXT_CHEVRON_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_CHEVRON_INVERTED_VERTICES[] =
{
  {0, 0}, {10800, CALCULATED_VALUE(1)}, {21600, 0}, {0, CALCULATED_VALUE(0)}, {10800, 21600}, {21600, CALCULATED_VALUE(0)}
};

const unsigned short TEXT_CHEVRON_INVERTED_SEGMENTS[] =
{
  0x4000, 0x0002, 0x8000, 0x4000, 0x0002, 0x8000
};

const Calculation TEXT_CHEVRON_INVERTED_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle TEXT_CHEVRON_INVERTED_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_CHEVRON_INVERTED_DEFAULT_ADJUST[] =
{
  16200
};

const Vertex TEXT_CHEVRON_INVERTED_GLUE_POINTS[] =
{
  {0, 0}, {21600, 21600}
};

const CustomShape CS_TEXT_CHEVRON_INVERTED(
  TEXT_CHEVRON_INVERTED_VERTICES, sizeof(TEXT_CHEVRON_INVERTED_VERTICES) / sizeof(Vertex),
  TEXT_CHEVRON_INVERTED_SEGMENTS, sizeof(TEXT_CHEVRON_INVERTED_SEGMENTS) / sizeof(unsigned short),
  TEXT_CHEVRON_INVERTED_CALC, sizeof(TEXT_CHEVRON_INVERTED_CALC) / sizeof(Calculation),
  TEXT_CHEVRON_INVERTED_DEFAULT_ADJUST, sizeof(TEXT_CHEVRON_INVERTED_DEFAULT_ADJUST) / sizeof(int),
  TEXT_CHEVRON_INVERTED_TRS, sizeof(TEXT_CHEVRON_INVERTED_TRS) / sizeof(TextRectangle),
  21600, 21600,
  TEXT_CHEVRON_INVERTED_GLUE_POINTS, sizeof(TEXT_CHEVRON_INVERTED_GLUE_POINTS) / sizeof(Vertex));

const Vertex TEXT_RING_OUTSIDE_VERTICES[] =
{
  {10800, CALCULATED_VALUE(0)}, {10800, CALCULATED_VALUE(0)}, {180, 359}, {10800, CALCULATED_VALUE(1)}, {10800, CALCULATED_VALUE(0)}, {180, 359}
};

const unsigned short TEXT_RING_OUTSIDE_SEGMENTS[] =
{
  0xA203, 0x8000, 0xA203, 0x8000
};

const Calculation TEXT_RING_OUTSIDE_CALC[] =
{
  {0x2001, PROP_ADJUST_VAL_FIRST, 1, 2}, {0x8000, 21600, 0, 0x400}
};

const TextRectangle TEXT_RING_OUTSIDE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_RING_OUTSIDE_DEFAULT_ADJUST[] =
{
  16200
};

const CustomShape CS_TEXT_RING_OUTSIDE(
  TEXT_RING_OUTSIDE_VERTICES, sizeof(TEXT_RING_OUTSIDE_VERTICES) / sizeof(Vertex),
  TEXT_RING_OUTSIDE_SEGMENTS, sizeof(TEXT_RING_OUTSIDE_SEGMENTS) / sizeof(unsigned short),
  TEXT_RING_OUTSIDE_CALC, sizeof(TEXT_RING_OUTSIDE_CALC) / sizeof(Calculation),
  TEXT_RING_OUTSIDE_DEFAULT_ADJUST, sizeof(TEXT_RING_OUTSIDE_DEFAULT_ADJUST) / sizeof(int),
  TEXT_RING_OUTSIDE_TRS, sizeof(TEXT_RING_OUTSIDE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_ARCH_UP_CURVE_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(3)}
};

const unsigned short TEXT_ARCH_UP_CURVE_SEGMENTS[] =
{
  0xA504, 0x8000
};

const Calculation TEXT_ARCH_UP_CURVE_CALC[] =
{
  {0x400a, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x4009, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x400, 10800, 0}, {0x2000, 0x401, 10800, 0}, {0x8000, 21600, 0, 0x402}
};

const TextRectangle TEXT_ARCH_UP_CURVE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_ARCH_UP_CURVE_DEFAULT_ADJUST[] =
{
  180
};

const CustomShape CS_TEXT_ARCH_UP_CURVE(
  TEXT_ARCH_UP_CURVE_VERTICES, sizeof(TEXT_ARCH_UP_CURVE_VERTICES) / sizeof(Vertex),
  TEXT_ARCH_UP_CURVE_SEGMENTS, sizeof(TEXT_ARCH_UP_CURVE_SEGMENTS) / sizeof(unsigned short),
  TEXT_ARCH_UP_CURVE_CALC, sizeof(TEXT_ARCH_UP_CURVE_CALC) / sizeof(Calculation),
  TEXT_ARCH_UP_CURVE_DEFAULT_ADJUST, sizeof(TEXT_ARCH_UP_CURVE_DEFAULT_ADJUST) / sizeof(int),
  TEXT_ARCH_UP_CURVE_TRS, sizeof(TEXT_ARCH_UP_CURVE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_ARCH_UP_POUR_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(9)}
};

const unsigned short TEXT_ARCH_UP_POUR_SEGMENTS[] =
{
  0xA504, 0x8000, 0xA504, 0x8000
};

const Calculation TEXT_ARCH_UP_POUR_CALC[] =
{
  {0x400a, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x4009, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x400, 10800, 0}, {0x2000, 0x401, 10800, 0}, {0x8000, 21600, 0, 0x402}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x600a, 0x405, PROP_ADJUST_VAL_FIRST, 0}, {0x6009, 0x405, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x406, 10800, 0}, {0x2000, 0x407, 10800, 0}, {0x8000, 21600, 0, 0x408}, {0x8000, 21600, 0, 0x405}
};

const TextRectangle TEXT_ARCH_UP_POUR_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_ARCH_UP_POUR_DEFAULT_ADJUST[] =
{
  180, 5400
};

const CustomShape CS_TEXT_ARCH_UP_POUR(
  TEXT_ARCH_UP_POUR_VERTICES, sizeof(TEXT_ARCH_UP_POUR_VERTICES) / sizeof(Vertex),
  TEXT_ARCH_UP_POUR_SEGMENTS, sizeof(TEXT_ARCH_UP_POUR_SEGMENTS) / sizeof(unsigned short),
  TEXT_ARCH_UP_POUR_CALC, sizeof(TEXT_ARCH_UP_POUR_CALC) / sizeof(Calculation),
  TEXT_ARCH_UP_POUR_DEFAULT_ADJUST, sizeof(TEXT_ARCH_UP_POUR_DEFAULT_ADJUST) / sizeof(int),
  TEXT_ARCH_UP_POUR_TRS, sizeof(TEXT_ARCH_UP_POUR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_ARCH_DOWN_CURVE_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {CALCULATED_VALUE(4), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}
};

const unsigned short TEXT_ARCH_DOWN_CURVE_SEGMENTS[] =
{
  0xA304, 0x8000
};

const Calculation TEXT_ARCH_DOWN_CURVE_CALC[] =
{
  {0x400a, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x4009, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x400, 10800, 0}, {0x2000, 0x401, 10800, 0}, {0x8000, 21600, 0, 0x402}
};

const TextRectangle TEXT_ARCH_DOWN_CURVE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_ARCH_DOWN_CURVE_DEFAULT_ADJUST[] =
{
  0
};

const CustomShape CS_TEXT_ARCH_DOWN_CURVE(
  TEXT_ARCH_DOWN_CURVE_VERTICES, sizeof(TEXT_ARCH_DOWN_CURVE_VERTICES) / sizeof(Vertex),
  TEXT_ARCH_DOWN_CURVE_SEGMENTS, sizeof(TEXT_ARCH_DOWN_CURVE_SEGMENTS) / sizeof(unsigned short),
  TEXT_ARCH_DOWN_CURVE_CALC, sizeof(TEXT_ARCH_DOWN_CURVE_CALC) / sizeof(Calculation),
  TEXT_ARCH_DOWN_CURVE_DEFAULT_ADJUST, sizeof(TEXT_ARCH_DOWN_CURVE_DEFAULT_ADJUST) / sizeof(int),
  TEXT_ARCH_DOWN_CURVE_TRS, sizeof(TEXT_ARCH_DOWN_CURVE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_CIRCLE_CURVE_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(4)}
};

const unsigned short TEXT_CIRCLE_CURVE_SEGMENTS[] =
{
  0xA504, 0x8000
};

const Calculation TEXT_CIRCLE_CURVE_CALC[] =
{
  {0x400a, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x4009, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x400, 10800, 0}, {0x2000, 0x401, 10800, 0}, {0x8000, 21600, 0, 0x403}
};

const TextRectangle TEXT_CIRCLE_CURVE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_CIRCLE_CURVE_DEFAULT_ADJUST[] =
{
  -179
};

const CustomShape CS_TEXT_CIRCLE_CURVE(
  TEXT_CIRCLE_CURVE_VERTICES, sizeof(TEXT_CIRCLE_CURVE_VERTICES) / sizeof(Vertex),
  TEXT_CIRCLE_CURVE_SEGMENTS, sizeof(TEXT_CIRCLE_CURVE_SEGMENTS) / sizeof(unsigned short),
  TEXT_CIRCLE_CURVE_CALC, sizeof(TEXT_CIRCLE_CURVE_CALC) / sizeof(Calculation),
  TEXT_CIRCLE_CURVE_DEFAULT_ADJUST, sizeof(TEXT_CIRCLE_CURVE_DEFAULT_ADJUST) / sizeof(int),
  TEXT_CIRCLE_CURVE_TRS, sizeof(TEXT_CIRCLE_CURVE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_BUTTON_CURVE_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(3)}, {0, 10800}, {21600, 10800}, {0, 0}, {21600, 21600}, {CALCULATED_VALUE(2), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(5)}
};

const unsigned short TEXT_BUTTON_CURVE_SEGMENTS[] =
{
  0xA504, 0x8000, 0x4000, 0x0001, 0x8000, 0xA304, 0x8000
};

const Calculation TEXT_BUTTON_CURVE_CALC[] =
{
  {0x400a, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x4009, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x400, 10800, 0}, {0x2000, 0x401, 10800, 0}, {0x8000, 21600, 0, 0x402}, {0x8000, 21600, 0, 0x403}
};

const TextRectangle TEXT_BUTTON_CURVE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_BUTTON_CURVE_DEFAULT_ADJUST[] =
{
  180
};

const CustomShape CS_TEXT_BUTTON_CURVE(
  TEXT_BUTTON_CURVE_VERTICES, sizeof(TEXT_BUTTON_CURVE_VERTICES) / sizeof(Vertex),
  TEXT_BUTTON_CURVE_SEGMENTS, sizeof(TEXT_BUTTON_CURVE_SEGMENTS) / sizeof(unsigned short),
  TEXT_BUTTON_CURVE_CALC, sizeof(TEXT_BUTTON_CURVE_CALC) / sizeof(Calculation),
  TEXT_BUTTON_CURVE_DEFAULT_ADJUST, sizeof(TEXT_BUTTON_CURVE_DEFAULT_ADJUST) / sizeof(int),
  TEXT_BUTTON_CURVE_TRS, sizeof(TEXT_BUTTON_CURVE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_ARCH_DOWN_POUR_VERTICES[] =
{
  {CALCULATED_VALUE(5), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(9)}, {0, 0}, {21600, 21600}, {CALCULATED_VALUE(4), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}
};

const unsigned short TEXT_ARCH_DOWN_POUR_SEGMENTS[] =
{
  0xA304, 0x8000, 0xA304, 0x8000
};

const Calculation TEXT_ARCH_DOWN_POUR_CALC[] =
{
  {0x400a, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x4009, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x400, 10800, 0}, {0x2000, 0x401, 10800, 0}, {0x8000, 21600, 0, 0x402}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x600a, 0x405, PROP_ADJUST_VAL_FIRST, 0}, {0x6009, 0x405, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x406, 10800, 0}, {0x2000, 0x407, 10800, 0}, {0x8000, 21600, 0, 0x408}, {0x8000, 21600, 0, 0x405}
};

const TextRectangle TEXT_ARCH_DOWN_POUR_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_ARCH_DOWN_POUR_DEFAULT_ADJUST[] =
{
  0, 5400
};

const CustomShape CS_TEXT_ARCH_DOWN_POUR(
  TEXT_ARCH_DOWN_POUR_VERTICES, sizeof(TEXT_ARCH_DOWN_POUR_VERTICES) / sizeof(Vertex),
  TEXT_ARCH_DOWN_POUR_SEGMENTS, sizeof(TEXT_ARCH_DOWN_POUR_SEGMENTS) / sizeof(unsigned short),
  TEXT_ARCH_DOWN_POUR_CALC, sizeof(TEXT_ARCH_DOWN_POUR_CALC) / sizeof(Calculation),
  TEXT_ARCH_DOWN_POUR_DEFAULT_ADJUST, sizeof(TEXT_ARCH_DOWN_POUR_DEFAULT_ADJUST) / sizeof(int),
  TEXT_ARCH_DOWN_POUR_TRS, sizeof(TEXT_ARCH_DOWN_POUR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_CIRCLE_POUR_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(8), CALCULATED_VALUE(0xa)}
};

const unsigned short TEXT_CIRCLE_POUR_SEGMENTS[] =
{
  0xA504, 0x8000, 0xA504, 0x8000
};

const Calculation TEXT_CIRCLE_POUR_CALC[] =
{
  {0x400a, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x4009, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x400, 10800, 0}, {0x2000, 0x401, 10800, 0}, {0x8000, 21600, 0, 0x403}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x600a, 0x405, PROP_ADJUST_VAL_FIRST, 0}, {0x6009, 0x405, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x406, 10800, 0}, {0x2000, 0x407, 10800, 0}, {0x8000, 21600, 0, 0x409}, {0x8000, 21600, 0, 0x405}, {0x000, 21600, 0, 0}
};

const TextRectangle TEXT_CIRCLE_POUR_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_CIRCLE_POUR_DEFAULT_ADJUST[] =
{
  -179, 5400
};

const CustomShape CS_TEXT_CIRCLE_POUR(
  TEXT_CIRCLE_POUR_VERTICES, sizeof(TEXT_CIRCLE_POUR_VERTICES) / sizeof(Vertex),
  TEXT_CIRCLE_POUR_SEGMENTS, sizeof(TEXT_CIRCLE_POUR_SEGMENTS) / sizeof(unsigned short),
  TEXT_CIRCLE_POUR_CALC, sizeof(TEXT_CIRCLE_POUR_CALC) / sizeof(Calculation),
  TEXT_CIRCLE_POUR_DEFAULT_ADJUST, sizeof(TEXT_CIRCLE_POUR_DEFAULT_ADJUST) / sizeof(int),
  TEXT_CIRCLE_POUR_TRS, sizeof(TEXT_CIRCLE_POUR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_BUTTON_POUR_VERTICES[] =
{
  {0, 0}, {21600, 21600}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(6), CALCULATED_VALUE(6)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(10), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(11)}, {CALCULATED_VALUE(0x16), CALCULATED_VALUE(16)}, {CALCULATED_VALUE(0x15), CALCULATED_VALUE(16)}, {CALCULATED_VALUE(0x16), CALCULATED_VALUE(15)}, {CALCULATED_VALUE(0x15), CALCULATED_VALUE(15)}, {CALCULATED_VALUE(6), CALCULATED_VALUE(6)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(10), CALCULATED_VALUE(13)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(13)}, {0, 0}, {21600, 21600}, {CALCULATED_VALUE(2), CALCULATED_VALUE(5)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(5)}
};

const unsigned short TEXT_BUTTON_POUR_SEGMENTS[] =
{
  0xA504, 0x8000, 0xA504, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000, 0xA304, 0x8000, 0xA304, 0x8000
};

const Calculation TEXT_BUTTON_POUR_CALC[] =
{
  {0x400a, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x4009, 10800, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x400, 10800, 0}, {0x2000, 0x401, 10800, 0}, {0x8000, 21600, 0, 0x402}, {0x8000, 21600, 0, 0x403}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 21600, 0, 0x406}, {0x600a, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST, 0}, {0x6009, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST, 0}, {0x2000, 0x408, 10800, 0}, {0x2000, 0x409, 10800, 0}, {0x8000, 21600, 0, 0x40a}, {0x8000, 21600, 0, 0x40b}, {0x2001, 0x406, 1, 2}, {0x4000, 10800, 0x40e, 0}, {0x8000, 10800, 0, 0x40e}, {0x6001, 0x40e, 0x40e, 1}, {0x6001, PROP_ADJUST_VAL_FIRST + 1, PROP_ADJUST_VAL_FIRST + 1, 1}, {0xA000, 0x412, 0, 0x411}, {0x200d, 0x413, 0, 0}, {0x4000, 10800, 0x414, 0}, {0x8000, 10800, 0, 0x414}
};

const TextRectangle TEXT_BUTTON_POUR_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_BUTTON_POUR_DEFAULT_ADJUST[] =
{
  180, 5400
};

const CustomShape CS_TEXT_BUTTON_POUR(
  TEXT_BUTTON_POUR_VERTICES, sizeof(TEXT_BUTTON_POUR_VERTICES) / sizeof(Vertex),
  TEXT_BUTTON_POUR_SEGMENTS, sizeof(TEXT_BUTTON_POUR_SEGMENTS) / sizeof(unsigned short),
  TEXT_BUTTON_POUR_CALC, sizeof(TEXT_BUTTON_POUR_CALC) / sizeof(Calculation),
  TEXT_BUTTON_POUR_DEFAULT_ADJUST, sizeof(TEXT_BUTTON_POUR_DEFAULT_ADJUST) / sizeof(int),
  TEXT_BUTTON_POUR_TRS, sizeof(TEXT_BUTTON_POUR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_CURVE_UP_VERTICES[] =
{
  {0, CALCULATED_VALUE(0)}, {4900, CALCULATED_VALUE(1) /*12170->0 14250 ->0*/}, {11640, CALCULATED_VALUE(2) /*12170->0 12800 ->0*/}, {21600, 0}, {0, CALCULATED_VALUE(4) /*12170->0 17220 ->21600*/}, {3700, 21600}, {8500, 21600}, {10100, 21600}, {14110, 21600}, {15910, 21600}, {21600, CALCULATED_VALUE(4) /*12170->0 17220 ->21600*/}
};

const unsigned short TEXT_CURVE_UP_SEGMENTS[] =
{
  0x4000, 0x2001, 0x8000, 0x4000, 0x2002, 0x8000
};

const Calculation TEXT_CURVE_UP_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x4001, 14250, 0x400, 12170}, {0x4001, 12800, 0x400, 12170}, {0x4001, 6380, 0x400, 12170}, {0x8000, 21600, 0, 0x403}
};

const TextRectangle TEXT_CURVE_UP_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_CURVE_UP_DEFAULT_ADJUST[] =
{
  9900
};

const CustomShape CS_TEXT_CURVE_UP(
  TEXT_CURVE_UP_VERTICES, sizeof(TEXT_CURVE_UP_VERTICES) / sizeof(Vertex),
  TEXT_CURVE_UP_SEGMENTS, sizeof(TEXT_CURVE_UP_SEGMENTS) / sizeof(unsigned short),
  TEXT_CURVE_UP_CALC, sizeof(TEXT_CURVE_UP_CALC) / sizeof(Calculation),
  TEXT_CURVE_UP_DEFAULT_ADJUST, sizeof(TEXT_CURVE_UP_DEFAULT_ADJUST) / sizeof(int),
  TEXT_CURVE_UP_TRS, sizeof(TEXT_CURVE_UP_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_CURVE_DOWN_VERTICES[] =
{
  {0, 0}, {9960, CALCULATED_VALUE(2)}, {16700, CALCULATED_VALUE(1)}, {21600, CALCULATED_VALUE(0)}, {0, CALCULATED_VALUE(4)}, {5690, 21600}, {7490, 21600}, {11500, 21600}, {13100, 21600}, {17900, 21600}, {21600, CALCULATED_VALUE(4)}
};

const unsigned short TEXT_CURVE_DOWN_SEGMENTS[] =
{
  0x4000, 0x2001, 0x8000, 0x4000, 0x2002, 0x8000
};

const Calculation TEXT_CURVE_DOWN_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x4001, 14250, 0x400, 12170}, {0x4001, 12800, 0x400, 12170}, {0x4001, 6380, 0x400, 12170}, {0x8000, 21600, 0, 0x403}
};

const TextRectangle TEXT_CURVE_DOWN_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_CURVE_DOWN_DEFAULT_ADJUST[] =
{
  9900
};

const CustomShape CS_TEXT_CURVE_DOWN(
  TEXT_CURVE_DOWN_VERTICES, sizeof(TEXT_CURVE_DOWN_VERTICES) / sizeof(Vertex),
  TEXT_CURVE_DOWN_SEGMENTS, sizeof(TEXT_CURVE_DOWN_SEGMENTS) / sizeof(unsigned short),
  TEXT_CURVE_DOWN_CALC, sizeof(TEXT_CURVE_DOWN_CALC) / sizeof(Calculation),
  TEXT_CURVE_DOWN_DEFAULT_ADJUST, sizeof(TEXT_CURVE_DOWN_DEFAULT_ADJUST) / sizeof(int),
  TEXT_CURVE_DOWN_TRS, sizeof(TEXT_CURVE_DOWN_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_CASCADE_UP_VERTICES[] =
{
  {0, CALCULATED_VALUE(2)}, {21600, 0}, {0, 21600}, {21600, CALCULATED_VALUE(0)}
};

const unsigned short TEXT_CASCADE_UP_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_CASCADE_UP_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x401, 1, 4}
};

const TextRectangle TEXT_CASCADE_UP_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_CASCADE_UP_DEFAULT_ADJUST[] =
{
  9600
};

const CustomShape CS_TEXT_CASCADE_UP(
  TEXT_CASCADE_UP_VERTICES, sizeof(TEXT_CASCADE_UP_VERTICES) / sizeof(Vertex),
  TEXT_CASCADE_UP_SEGMENTS, sizeof(TEXT_CASCADE_UP_SEGMENTS) / sizeof(unsigned short),
  TEXT_CASCADE_UP_CALC, sizeof(TEXT_CASCADE_UP_CALC) / sizeof(Calculation),
  TEXT_CASCADE_UP_DEFAULT_ADJUST, sizeof(TEXT_CASCADE_UP_DEFAULT_ADJUST) / sizeof(int),
  TEXT_CASCADE_UP_TRS, sizeof(TEXT_CASCADE_UP_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_CASCADE_DOWN_VERTICES[] =
{
  {0, 0}, {21600, CALCULATED_VALUE(2)}, {0, CALCULATED_VALUE(0)}, {21600, 21600}
};

const unsigned short TEXT_CASCADE_DOWN_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_CASCADE_DOWN_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x401, 1, 4}
};

const TextRectangle TEXT_CASCADE_DOWN_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_CASCADE_DOWN_DEFAULT_ADJUST[] =
{
  9600
};

const CustomShape CS_TEXT_CASCADE_DOWN(
  TEXT_CASCADE_DOWN_VERTICES, sizeof(TEXT_CASCADE_DOWN_VERTICES) / sizeof(Vertex),
  TEXT_CASCADE_DOWN_SEGMENTS, sizeof(TEXT_CASCADE_DOWN_SEGMENTS) / sizeof(unsigned short),
  TEXT_CASCADE_DOWN_CALC, sizeof(TEXT_CASCADE_DOWN_CALC) / sizeof(Calculation),
  TEXT_CASCADE_DOWN_DEFAULT_ADJUST, sizeof(TEXT_CASCADE_DOWN_DEFAULT_ADJUST) / sizeof(int),
  TEXT_CASCADE_DOWN_TRS, sizeof(TEXT_CASCADE_DOWN_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_WAVE_1_VERTICES[] =
{
  {CALCULATED_VALUE(7), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(15), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(29), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(27), CALCULATED_VALUE(28)}, {CALCULATED_VALUE(25), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(24), CALCULATED_VALUE(1)}
};

const unsigned short TEXT_WAVE_1_SEGMENTS[] =
{
  0x4000, 0x2001, 0x8000, 0x4000, 0x2001, 0x8000
};

const Calculation TEXT_WAVE_1_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, 0x400}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, 0x402, 0, 10800}, {0x2001, 0x403, 2, 1}, {0x2003, 0x404, 0, 0}, {0x8000, 4320, 0, 0x405}, {0xa006, 0x403, 0, 0x405}, {0x4001, 15800, 0x400, 4460}, {0xa000, 0x400, 0, 0x408}, {0x6000, 0x400, 0x408, 0}, {0x8000, 21600, 0, 0x404}, {0x6006, 0x403, 0x40b, 21600}, {0xa000, 0x40c, 0, 0x407}, {0x2001, 0x405, 1, 2}, {0xa000, 0x407, 7200, 0x40e}, {0x6000, 0x40c, 0x40e, 7200}, {0x2001, 0x40d, 1, 2}, {0x6000, 0x407, 0x411, 0}, {0x8000, 21600, 0, 0x412}, {0x2001, 0x405, 1, 2}, {0x8000, 21600, 0, 0x414}, {0x2001, 0x400, 2, 1}, {0x8000, 21600, 0, 0x416}, {0x8000, 21600, 0, 0x407}, {0x8000, 21600, 0, 0x40f}, {0x6000, 0x401, 0x408, 0}, {0x8000, 21600, 0, 0x410}, {0xa000, 0x401, 0, 0x408}, {0x8000, 21600, 0, 0x40c}
};

const TextRectangle TEXT_WAVE_1_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_WAVE_1_DEFAULT_ADJUST[] =
{
  1400, 10800
};

const CustomShape CS_TEXT_WAVE_1(
  TEXT_WAVE_1_VERTICES, sizeof(TEXT_WAVE_1_VERTICES) / sizeof(Vertex),
  TEXT_WAVE_1_SEGMENTS, sizeof(TEXT_WAVE_1_SEGMENTS) / sizeof(unsigned short),
  TEXT_WAVE_1_CALC, sizeof(TEXT_WAVE_1_CALC) / sizeof(Calculation),
  TEXT_WAVE_1_DEFAULT_ADJUST, sizeof(TEXT_WAVE_1_DEFAULT_ADJUST) / sizeof(int),
  TEXT_WAVE_1_TRS, sizeof(TEXT_WAVE_1_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_WAVE_2_VERTICES[] =
{
  {CALCULATED_VALUE(7), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(15), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(29), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(27), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(25), CALCULATED_VALUE(28)}, {CALCULATED_VALUE(24), CALCULATED_VALUE(1)}
};

const unsigned short TEXT_WAVE_2_SEGMENTS[] =
{
  0x4000, 0x2001, 0x8000, 0x4000, 0x2001, 0x8000
};

const Calculation TEXT_WAVE_2_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, 0x400}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, 0x402, 0, 10800}, {0x2001, 0x403, 2, 1}, {0x2003, 0x404, 0, 0}, {0x8000, 4320, 0, 0x405}, {0xa006, 0x403, 0, 0x405}, {0x4001, 15800, 0x400, 4460}, {0xa000, 0x400, 0, 0x408}, {0x6000, 0x400, 0x408, 0}, {0x8000, 21600, 0, 0x404}, {0x6006, 0x403, 0x40b, 21600}, {0xa000, 0x40c, 0, 0x407}, {0x2001, 0x405, 1, 2}, {0xa000, 0x407, 7200, 0x40e}, {0x6000, 0x40c, 0x40e, 7200}, {0x2001, 0x40d, 1, 2}, {0x6000, 0x407, 0x411, 0}, {0x8000, 21600, 0, 0x412}, {0x2001, 0x405, 1, 2}, {0x8000, 21600, 0, 0x414}, {0x2001, 0x400, 2, 1}, {0x8000, 21600, 0, 0x416}, {0x8000, 21600, 0, 0x407}, {0x8000, 21600, 0, 0x40f}, {0x6000, 0x401, 0x408, 0}, {0x8000, 21600, 0, 0x410}, {0xa000, 0x401, 0, 0x408}, {0x8000, 21600, 0, 0x40c}
};

const TextRectangle TEXT_WAVE_2_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_WAVE_2_DEFAULT_ADJUST[] =
{
  1400, 10800
};

const CustomShape CS_TEXT_WAVE_2(
  TEXT_WAVE_2_VERTICES, sizeof(TEXT_WAVE_2_VERTICES) / sizeof(Vertex),
  TEXT_WAVE_2_SEGMENTS, sizeof(TEXT_WAVE_2_SEGMENTS) / sizeof(unsigned short),
  TEXT_WAVE_2_CALC, sizeof(TEXT_WAVE_2_CALC) / sizeof(Calculation),
  TEXT_WAVE_2_DEFAULT_ADJUST, sizeof(TEXT_WAVE_2_DEFAULT_ADJUST) / sizeof(int),
  TEXT_WAVE_2_TRS, sizeof(TEXT_WAVE_2_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_WAVE_3_VERTICES[] =
{
  {CALCULATED_VALUE(7), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(15), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0x1f), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(29), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(27), CALCULATED_VALUE(28)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(0x13), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0x21), CALCULATED_VALUE(28)}, {CALCULATED_VALUE(25), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(24), CALCULATED_VALUE(1)}
};

const unsigned short TEXT_WAVE_3_SEGMENTS[] =
{
  0x4000, 0x2002, 0x8000, 0x4000, 0x2002, 0x8000
};

const Calculation TEXT_WAVE_3_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, 0x400}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, 0x402, 0, 10800}, {0x2001, 0x403, 2, 1}, {0x2003, 0x404, 0, 0}, {0x8000, 4320, 0, 0x405}, {0xa006, 0x403, 0, 0x405}, {0x4001, 7900, 0x400, 2230}, {0xa000, 0x400, 0, 0x408}, {0x6000, 0x400, 0x408, 0}, {0x8000, 21600, 0, 0x404}, {0x6006, 0x403, 0x40b, 21600}, {0xa000, 0x40c, 0, 0x407}, {0x2001, 0x405, 1, 2}, {0xa000, 0x407, 3600, 0x40e}, {0x6000, 0x40c, 0x40e, 3600}, {0x2001, 0x40d, 1, 2}, {0x6000, 0x407, 0x411, 0}, {0x8000, 21600, 0, 0x412}, {0x2001, 0x405, 1, 2}, {0x8000, 21600, 0, 0x414}, {0x2001, 0x400, 2, 1}, {0x8000, 21600, 0, 0x416}, {0x8000, 21600, 0, 0x407}, {0x8000, 21600, 0, 0x40f}, {0x6000, 0x401, 0x408, 0}, {0x8000, 21600, 0, 0x410}, {0xa000, 0x401, 0, 0x408}, {0x8000, 21600, 0, 0x40c}, {0xa000, 0x412, 0, 0x40e}, {0x6000, 0x412, 0x40e, 0}, {0xa000, 0x413, 0, 0x40e}, {0x6000, 0x413, 0x40e, 0}
};

const TextRectangle TEXT_WAVE_3_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_WAVE_3_DEFAULT_ADJUST[] =
{
  1400, 10800
};

const CustomShape CS_TEXT_WAVE_3(
  TEXT_WAVE_3_VERTICES, sizeof(TEXT_WAVE_3_VERTICES) / sizeof(Vertex),
  TEXT_WAVE_3_SEGMENTS, sizeof(TEXT_WAVE_3_SEGMENTS) / sizeof(unsigned short),
  TEXT_WAVE_3_CALC, sizeof(TEXT_WAVE_3_CALC) / sizeof(Calculation),
  TEXT_WAVE_3_DEFAULT_ADJUST, sizeof(TEXT_WAVE_3_DEFAULT_ADJUST) / sizeof(int),
  TEXT_WAVE_3_TRS, sizeof(TEXT_WAVE_3_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_WAVE_4_VERTICES[] =
{
  {CALCULATED_VALUE(7), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(15), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0x1f), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(29), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(27), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(28)}, {CALCULATED_VALUE(0x13), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0x21), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(25), CALCULATED_VALUE(28)}, {CALCULATED_VALUE(24), CALCULATED_VALUE(1)}
};

const unsigned short TEXT_WAVE_4_SEGMENTS[] =
{
  0x4000, 0x2002, 0x8000, 0x4000, 0x2002, 0x8000
};

const Calculation TEXT_WAVE_4_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, 0x400}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, 0x402, 0, 10800}, {0x2001, 0x403, 2, 1}, {0x2003, 0x404, 0, 0}, {0x8000, 4320, 0, 0x405}, {0xa006, 0x403, 0, 0x405}, {0x4001, 7900, 0x400, 2230}, {0xa000, 0x400, 0, 0x408}, {0x6000, 0x400, 0x408, 0}, {0x8000, 21600, 0, 0x404}, {0x6006, 0x403, 0x40b, 21600}, {0xa000, 0x40c, 0, 0x407}, {0x2001, 0x405, 1, 2}, {0xa000, 0x407, 3600, 0x40e}, {0x6000, 0x40c, 0x40e, 3600}, {0x2001, 0x40d, 1, 2}, {0x6000, 0x407, 0x411, 0}, {0x8000, 21600, 0, 0x412}, {0x2001, 0x405, 1, 2}, {0x8000, 21600, 0, 0x414}, {0x2001, 0x400, 2, 1}, {0x8000, 21600, 0, 0x416}, {0x8000, 21600, 0, 0x407}, {0x8000, 21600, 0, 0x40f}, {0x6000, 0x401, 0x408, 0}, {0x8000, 21600, 0, 0x410}, {0xa000, 0x401, 0, 0x408}, {0x8000, 21600, 0, 0x40c}, {0xa000, 0x412, 0, 0x40e}, {0x6000, 0x412, 0x40e, 0}, {0xa000, 0x413, 0, 0x40e}, {0x6000, 0x413, 0x40e, 0}
};

const TextRectangle TEXT_WAVE_4_TRS[] =
{
  { {CALCULATED_VALUE(5), CALCULATED_VALUE(22)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(23)} }
};

const int TEXT_WAVE_4_DEFAULT_ADJUST[] =
{
  1400, 10800
};

const Vertex TEXT_WAVE_4_GLUE_POINTS[] =
{
  {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0x14), 10800}, {CALCULATED_VALUE(0x13), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0x15), 10800}
};

const CustomShape CS_TEXT_WAVE_4(
  TEXT_WAVE_4_VERTICES, sizeof(TEXT_WAVE_4_VERTICES) / sizeof(Vertex),
  TEXT_WAVE_4_SEGMENTS, sizeof(TEXT_WAVE_4_SEGMENTS) / sizeof(unsigned short),
  TEXT_WAVE_4_CALC, sizeof(TEXT_WAVE_4_CALC) / sizeof(Calculation),
  TEXT_WAVE_4_DEFAULT_ADJUST, sizeof(TEXT_WAVE_4_DEFAULT_ADJUST) / sizeof(int),
  TEXT_WAVE_4_TRS, sizeof(TEXT_WAVE_4_TRS) / sizeof(TextRectangle),
  21600, 21600,
  TEXT_WAVE_4_GLUE_POINTS, sizeof(TEXT_WAVE_4_GLUE_POINTS) / sizeof(Vertex));

const Vertex TEXT_INFLATE_VERTICES[] =
{
  {0, CALCULATED_VALUE(0)}, {4100, CALCULATED_VALUE(1)}, {7300, 0}, {10800, 0}, {14300, 0}, {17500, CALCULATED_VALUE(1)}, {21600, CALCULATED_VALUE(0)}, {0, CALCULATED_VALUE(2)}, {4100, CALCULATED_VALUE(3)}, {7300, 21600}, {10800, 21600}, {14300, 21600}, {17500, CALCULATED_VALUE(3)}, {21600, CALCULATED_VALUE(2)}
};

const unsigned short TEXT_INFLATE_SEGMENTS[] =
{
  0x4000, 0x2002, 0x8000, 0x4000, 0x2002, 0x8000
};

const Calculation TEXT_INFLATE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x4001, 1530, 0x400, 4650}, {0x8000, 21600, 0, 0x400}, {0x8000, 21600, 0, 0x401}
};

const TextRectangle TEXT_INFLATE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_INFLATE_DEFAULT_ADJUST[] =
{
  2950
};

const CustomShape CS_TEXT_INFLATE(
  TEXT_INFLATE_VERTICES, sizeof(TEXT_INFLATE_VERTICES) / sizeof(Vertex),
  TEXT_INFLATE_SEGMENTS, sizeof(TEXT_INFLATE_SEGMENTS) / sizeof(unsigned short),
  TEXT_INFLATE_CALC, sizeof(TEXT_INFLATE_CALC) / sizeof(Calculation),
  TEXT_INFLATE_DEFAULT_ADJUST, sizeof(TEXT_INFLATE_DEFAULT_ADJUST) / sizeof(int),
  TEXT_INFLATE_TRS, sizeof(TEXT_INFLATE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_DEFLATE_VERTICES[] =
{
  {0, 0}, {3500, CALCULATED_VALUE(1)}, {7100, CALCULATED_VALUE(0)}, {10800, CALCULATED_VALUE(0)}, {14500, CALCULATED_VALUE(0)}, {18100, CALCULATED_VALUE(1)}, {21600, 0}, {0, 21600}, {3500, CALCULATED_VALUE(3)}, {7100, CALCULATED_VALUE(2)}, {10800, CALCULATED_VALUE(2)}, {14500, CALCULATED_VALUE(2)}, {18100, CALCULATED_VALUE(3)}, {21600, 21600}
};

const unsigned short TEXT_DEFLATE_SEGMENTS[] =
{
  0x4000, 0x2002, 0x8000, 0x4000, 0x2002, 0x8000
};

const Calculation TEXT_DEFLATE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2001, 0x400, 5320, 7100}, {0x8000, 21600, 0, 0x400}, {0x8000, 21600, 0, 0x401}
};

const TextRectangle TEXT_DEFLATE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_DEFLATE_DEFAULT_ADJUST[] =
{
  8100
};

const CustomShape CS_TEXT_DEFLATE(
  TEXT_DEFLATE_VERTICES, sizeof(TEXT_DEFLATE_VERTICES) / sizeof(Vertex),
  TEXT_DEFLATE_SEGMENTS, sizeof(TEXT_DEFLATE_SEGMENTS) / sizeof(unsigned short),
  TEXT_DEFLATE_CALC, sizeof(TEXT_DEFLATE_CALC) / sizeof(Calculation),
  TEXT_DEFLATE_DEFAULT_ADJUST, sizeof(TEXT_DEFLATE_DEFAULT_ADJUST) / sizeof(int),
  TEXT_DEFLATE_TRS, sizeof(TEXT_DEFLATE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_INFLATE_BOTTOM_VERTICES[] =
{
  {0, 0}, {21600, 0}, {0, CALCULATED_VALUE(0)}, {3500, CALCULATED_VALUE(3)}, {7300, 21600}, {10800, 21600}, {14300, 21600}, {18100, CALCULATED_VALUE(3)}, {21600, CALCULATED_VALUE(0)}
};

const unsigned short TEXT_INFLATE_BOTTOM_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x2002, 0x8000
};

const Calculation TEXT_INFLATE_BOTTOM_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, 0x400, 0, 11150}, {0x2001, 0x401, 3900, 10450}, {0x2000, 0x402, 17700, 0}
};

const TextRectangle TEXT_INFLATE_BOTTOM_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_INFLATE_BOTTOM_DEFAULT_ADJUST[] =
{
  14700
};

const CustomShape CS_TEXT_INFLATE_BOTTOM(
  TEXT_INFLATE_BOTTOM_VERTICES, sizeof(TEXT_INFLATE_BOTTOM_VERTICES) / sizeof(Vertex),
  TEXT_INFLATE_BOTTOM_SEGMENTS, sizeof(TEXT_INFLATE_BOTTOM_SEGMENTS) / sizeof(unsigned short),
  TEXT_INFLATE_BOTTOM_CALC, sizeof(TEXT_INFLATE_BOTTOM_CALC) / sizeof(Calculation),
  TEXT_INFLATE_BOTTOM_DEFAULT_ADJUST, sizeof(TEXT_INFLATE_BOTTOM_DEFAULT_ADJUST) / sizeof(int),
  TEXT_INFLATE_BOTTOM_TRS, sizeof(TEXT_INFLATE_BOTTOM_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_DEFLATE_BOTTOM_VERTICES[] =
{
  {0, 0}, {21600, 0}, {0, 21600}, {2900, CALCULATED_VALUE(3)}, {7200, CALCULATED_VALUE(0)}, {10800, CALCULATED_VALUE(0)}, {14400, CALCULATED_VALUE(0)}, {18700, CALCULATED_VALUE(3)}, {21600, 21600}
};

const unsigned short TEXT_DEFLATE_BOTTOM_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x2002, 0x8000
};

const Calculation TEXT_DEFLATE_BOTTOM_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, 0x400, 0, 1350}, {0x2001, 0x401, 12070, 20250}, {0x2000, 0x402, 9530, 0}
};

const TextRectangle TEXT_DEFLATE_BOTTOM_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_DEFLATE_BOTTOM_DEFAULT_ADJUST[] =
{
  11500
};

const CustomShape CS_TEXT_DEFLATE_BOTTOM(
  TEXT_DEFLATE_BOTTOM_VERTICES, sizeof(TEXT_DEFLATE_BOTTOM_VERTICES) / sizeof(Vertex),
  TEXT_DEFLATE_BOTTOM_SEGMENTS, sizeof(TEXT_DEFLATE_BOTTOM_SEGMENTS) / sizeof(unsigned short),
  TEXT_DEFLATE_BOTTOM_CALC, sizeof(TEXT_DEFLATE_BOTTOM_CALC) / sizeof(Calculation),
  TEXT_DEFLATE_BOTTOM_DEFAULT_ADJUST, sizeof(TEXT_DEFLATE_BOTTOM_DEFAULT_ADJUST) / sizeof(int),
  TEXT_DEFLATE_BOTTOM_TRS, sizeof(TEXT_DEFLATE_BOTTOM_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_INFLATE_TOP_VERTICES[] =
{
  {0, CALCULATED_VALUE(0)}, {3500, CALCULATED_VALUE(1)}, {7300, 0}, {10800, 0}, {14300, 0}, {18100, CALCULATED_VALUE(1)}, {21600, CALCULATED_VALUE(0)}, {0, 21600}, {21600, 21600}
};

const unsigned short TEXT_INFLATE_TOP_SEGMENTS[] =
{
  0x4000, 0x2002, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_INFLATE_TOP_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2001, 0x400, 3900, 10450}
};

const TextRectangle TEXT_INFLATE_TOP_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_INFLATE_TOP_DEFAULT_ADJUST[] =
{
  6900
};

const CustomShape CS_TEXT_INFLATE_TOP(
  TEXT_INFLATE_TOP_VERTICES, sizeof(TEXT_INFLATE_TOP_VERTICES) / sizeof(Vertex),
  TEXT_INFLATE_TOP_SEGMENTS, sizeof(TEXT_INFLATE_TOP_SEGMENTS) / sizeof(unsigned short),
  TEXT_INFLATE_TOP_CALC, sizeof(TEXT_INFLATE_TOP_CALC) / sizeof(Calculation),
  TEXT_INFLATE_TOP_DEFAULT_ADJUST, sizeof(TEXT_INFLATE_TOP_DEFAULT_ADJUST) / sizeof(int),
  TEXT_INFLATE_TOP_TRS, sizeof(TEXT_INFLATE_TOP_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_DEFLATE_TOP_VERTICES[] =
{
  {0, 0}, {2900, CALCULATED_VALUE(1)}, {7200, CALCULATED_VALUE(0)}, {10800, CALCULATED_VALUE(0)}, {14400, CALCULATED_VALUE(0)}, {18700, CALCULATED_VALUE(1)}, {21600, 0}, {0, 21600}, {21600, 21600}
};

const unsigned short TEXT_DEFLATE_TOP_SEGMENTS[] =
{
  0x4000, 0x2002, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_DEFLATE_TOP_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2001, 0x400, 12070, 20250}
};

const TextRectangle TEXT_DEFLATE_TOP_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_DEFLATE_TOP_DEFAULT_ADJUST[] =
{
  10100
};

const CustomShape CS_TEXT_DEFLATE_TOP(
  TEXT_DEFLATE_TOP_VERTICES, sizeof(TEXT_DEFLATE_TOP_VERTICES) / sizeof(Vertex),
  TEXT_DEFLATE_TOP_SEGMENTS, sizeof(TEXT_DEFLATE_TOP_SEGMENTS) / sizeof(unsigned short),
  TEXT_DEFLATE_TOP_CALC, sizeof(TEXT_DEFLATE_TOP_CALC) / sizeof(Calculation),
  TEXT_DEFLATE_TOP_DEFAULT_ADJUST, sizeof(TEXT_DEFLATE_TOP_DEFAULT_ADJUST) / sizeof(int),
  TEXT_DEFLATE_TOP_TRS, sizeof(TEXT_DEFLATE_TOP_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_DEFLATE_INFLATE_VERTICES[] =
{
  {0, 0}, {21600, 0}, {0, 10100}, {3300, CALCULATED_VALUE(3)}, {7100, CALCULATED_VALUE(5)}, {10800, CALCULATED_VALUE(5)}, {14500, CALCULATED_VALUE(5)}, {18300, CALCULATED_VALUE(3)}, {21600, 10100}, {0, 11500}, {3300, CALCULATED_VALUE(4)}, {7100, CALCULATED_VALUE(6)}, {10800, CALCULATED_VALUE(6)}, {14500, CALCULATED_VALUE(6)}, {18300, CALCULATED_VALUE(4)}, {21600, 11500}, {0, 21600}, {21600, 21600}
};

const unsigned short TEXT_DEFLATE_INFLATE_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x2002, 0x8000, 0x4000, 0x2002, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_DEFLATE_INFLATE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 10800, 0, 0x400}, {0x2001, 0x401, 5770, 9500}, {0x8000, 10100, 0, 0x402}, {0x8000, 11500, 0, 0x402}, {0x2000, 0x400, 0, 700}, {0x2000, 0x400, 700, 0}
};

const TextRectangle TEXT_DEFLATE_INFLATE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_DEFLATE_INFLATE_DEFAULT_ADJUST[] =
{
  6500
};

const CustomShape CS_TEXT_DEFLATE_INFLATE(
  TEXT_DEFLATE_INFLATE_VERTICES, sizeof(TEXT_DEFLATE_INFLATE_VERTICES) / sizeof(Vertex),
  TEXT_DEFLATE_INFLATE_SEGMENTS, sizeof(TEXT_DEFLATE_INFLATE_SEGMENTS) / sizeof(unsigned short),
  TEXT_DEFLATE_INFLATE_CALC, sizeof(TEXT_DEFLATE_INFLATE_CALC) / sizeof(Calculation),
  TEXT_DEFLATE_INFLATE_DEFAULT_ADJUST, sizeof(TEXT_DEFLATE_INFLATE_DEFAULT_ADJUST) / sizeof(int),
  TEXT_DEFLATE_INFLATE_TRS, sizeof(TEXT_DEFLATE_INFLATE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_DEFLATE_INFLATE_DEFLATE_VERTICES[] =
{
  {0, 0}, {21600, 0}, {0, 6600}, {3600, CALCULATED_VALUE(3)}, {7250, CALCULATED_VALUE(4)}, {10800, CALCULATED_VALUE(4)}, {14350, CALCULATED_VALUE(4)}, {18000, CALCULATED_VALUE(3)}, {21600, 6600}, {0, 7500}, {3600, CALCULATED_VALUE(5)}, {7250, CALCULATED_VALUE(6)}, {10800, CALCULATED_VALUE(6)}, {14350, CALCULATED_VALUE(6)}, {18000, CALCULATED_VALUE(5)}, {21600, 7500}, {0, 14100}, {3600, CALCULATED_VALUE(9)}, {7250, CALCULATED_VALUE(10)}, {10800, CALCULATED_VALUE(10)}, {14350, CALCULATED_VALUE(10)}, {18000, CALCULATED_VALUE(9)}, {21600, 14100}, {0, 15000}, {3600, CALCULATED_VALUE(7)}, {7250, CALCULATED_VALUE(8)}, {10800, CALCULATED_VALUE(8)}, {14350, CALCULATED_VALUE(8)}, {18000, CALCULATED_VALUE(7)}, {21600, 15000}, {0, 21600}, {21600, 21600}
};

const unsigned short TEXT_DEFLATE_INFLATE_DEFLATE_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x2002, 0x8000, 0x4000, 0x2002, 0x8000, 0x4000, 0x2002, 0x8000, 0x4000, 0x2002, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_DEFLATE_INFLATE_DEFLATE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 850}, {0x2001, 0x400, 6120, 8700}, {0x2000, 0x401, 0, 4280}, {0x4000, 6600, 0x402, 0}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 450}, {0x2000, 0x403, 900, 0}, {0x2000, 0x404, 900, 0}, {0x8000, 21600, 0, 0x403}, {0x8000, 21600, 0, 0x404}, {0x8000, 21600, 0, 0x405}, {0x8000, 21600, 0, 0x406}
};

const TextRectangle TEXT_DEFLATE_INFLATE_DEFLATE_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_DEFLATE_INFLATE_DEFLATE_DEFAULT_ADJUST[] =
{
  6050
};

const CustomShape CS_TEXT_DEFLATE_INFLATE_DEFLATE(
  TEXT_DEFLATE_INFLATE_DEFLATE_VERTICES, sizeof(TEXT_DEFLATE_INFLATE_DEFLATE_VERTICES) / sizeof(Vertex),
  TEXT_DEFLATE_INFLATE_DEFLATE_SEGMENTS, sizeof(TEXT_DEFLATE_INFLATE_DEFLATE_SEGMENTS) / sizeof(unsigned short),
  TEXT_DEFLATE_INFLATE_DEFLATE_CALC, sizeof(TEXT_DEFLATE_INFLATE_DEFLATE_CALC) / sizeof(Calculation),
  TEXT_DEFLATE_INFLATE_DEFLATE_DEFAULT_ADJUST, sizeof(TEXT_DEFLATE_INFLATE_DEFLATE_DEFAULT_ADJUST) / sizeof(int),
  TEXT_DEFLATE_INFLATE_DEFLATE_TRS, sizeof(TEXT_DEFLATE_INFLATE_DEFLATE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_FADE_RIGHT_VERTICES[] =
{
  {0, 0}, {21600, CALCULATED_VALUE(0)}, {0, 21600}, {21600, CALCULATED_VALUE(1)}
};

const unsigned short TEXT_FADE_RIGHT_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_FADE_RIGHT_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle TEXT_FADE_RIGHT_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_FADE_RIGHT_DEFAULT_ADJUST[] =
{
  7200
};

const CustomShape CS_TEXT_FADE_RIGHT(
  TEXT_FADE_RIGHT_VERTICES, sizeof(TEXT_FADE_RIGHT_VERTICES) / sizeof(Vertex),
  TEXT_FADE_RIGHT_SEGMENTS, sizeof(TEXT_FADE_RIGHT_SEGMENTS) / sizeof(unsigned short),
  TEXT_FADE_RIGHT_CALC, sizeof(TEXT_FADE_RIGHT_CALC) / sizeof(Calculation),
  TEXT_FADE_RIGHT_DEFAULT_ADJUST, sizeof(TEXT_FADE_RIGHT_DEFAULT_ADJUST) / sizeof(int),
  TEXT_FADE_RIGHT_TRS, sizeof(TEXT_FADE_RIGHT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_FADE_LEFT_VERTICES[] =
{
  {0, CALCULATED_VALUE(0)}, {21600, 0}, {0, CALCULATED_VALUE(1)}, {21600, 21600}
};

const unsigned short TEXT_FADE_LEFT_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_FADE_LEFT_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle TEXT_FADE_LEFT_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_FADE_LEFT_DEFAULT_ADJUST[] =
{
  7200
};

const CustomShape CS_TEXT_FADE_LEFT(
  TEXT_FADE_LEFT_VERTICES, sizeof(TEXT_FADE_LEFT_VERTICES) / sizeof(Vertex),
  TEXT_FADE_LEFT_SEGMENTS, sizeof(TEXT_FADE_LEFT_SEGMENTS) / sizeof(unsigned short),
  TEXT_FADE_LEFT_CALC, sizeof(TEXT_FADE_LEFT_CALC) / sizeof(Calculation),
  TEXT_FADE_LEFT_DEFAULT_ADJUST, sizeof(TEXT_FADE_LEFT_DEFAULT_ADJUST) / sizeof(int),
  TEXT_FADE_LEFT_TRS, sizeof(TEXT_FADE_LEFT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_FADE_UP_VERTICES[] =
{
  {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(1), 0}, {0, 21600}, {21600, 21600}
};

const unsigned short TEXT_FADE_UP_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_FADE_UP_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle TEXT_FADE_UP_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_FADE_UP_DEFAULT_ADJUST[] =
{
  7200
};

const CustomShape CS_TEXT_FADE_UP(
  TEXT_FADE_UP_VERTICES, sizeof(TEXT_FADE_UP_VERTICES) / sizeof(Vertex),
  TEXT_FADE_UP_SEGMENTS, sizeof(TEXT_FADE_UP_SEGMENTS) / sizeof(unsigned short),
  TEXT_FADE_UP_CALC, sizeof(TEXT_FADE_UP_CALC) / sizeof(Calculation),
  TEXT_FADE_UP_DEFAULT_ADJUST, sizeof(TEXT_FADE_UP_DEFAULT_ADJUST) / sizeof(int),
  TEXT_FADE_UP_TRS, sizeof(TEXT_FADE_UP_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_FADE_DOWN_VERTICES[] =
{
  {0, 0}, {21600, 0}, {CALCULATED_VALUE(0), 21600}, {CALCULATED_VALUE(1), 21600}
};

const unsigned short TEXT_FADE_DOWN_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_FADE_DOWN_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle TEXT_FADE_DOWN_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_FADE_DOWN_DEFAULT_ADJUST[] =
{
  7200
};

const CustomShape CS_TEXT_FADE_DOWN(
  TEXT_FADE_DOWN_VERTICES, sizeof(TEXT_FADE_DOWN_VERTICES) / sizeof(Vertex),
  TEXT_FADE_DOWN_SEGMENTS, sizeof(TEXT_FADE_DOWN_SEGMENTS) / sizeof(unsigned short),
  TEXT_FADE_DOWN_CALC, sizeof(TEXT_FADE_DOWN_CALC) / sizeof(Calculation),
  TEXT_FADE_DOWN_DEFAULT_ADJUST, sizeof(TEXT_FADE_DOWN_DEFAULT_ADJUST) / sizeof(int),
  TEXT_FADE_DOWN_TRS, sizeof(TEXT_FADE_DOWN_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_SLANT_UP_VERTICES[] =
{
  {0, CALCULATED_VALUE(0)}, {21600, 0}, {0, 21600}, {21600, CALCULATED_VALUE(1)}
};

const unsigned short TEXT_SLANT_UP_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_SLANT_UP_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle TEXT_SLANT_UP_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_SLANT_UP_DEFAULT_ADJUST[] =
{
  12000
};

const CustomShape CS_TEXT_SLANT_UP(
  TEXT_SLANT_UP_VERTICES, sizeof(TEXT_SLANT_UP_VERTICES) / sizeof(Vertex),
  TEXT_SLANT_UP_SEGMENTS, sizeof(TEXT_SLANT_UP_SEGMENTS) / sizeof(unsigned short),
  TEXT_SLANT_UP_CALC, sizeof(TEXT_SLANT_UP_CALC) / sizeof(Calculation),
  TEXT_SLANT_UP_DEFAULT_ADJUST, sizeof(TEXT_SLANT_UP_DEFAULT_ADJUST) / sizeof(int),
  TEXT_SLANT_UP_TRS, sizeof(TEXT_SLANT_UP_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_SLANT_DOWN_VERTICES[] =
{
  {0, 0}, {21600, CALCULATED_VALUE(1)}, {0, CALCULATED_VALUE(0)}, {21600, 21600}
};

const unsigned short TEXT_SLANT_DOWN_SEGMENTS[] =
{
  0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation TEXT_SLANT_DOWN_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle TEXT_SLANT_DOWN_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_SLANT_DOWN_DEFAULT_ADJUST[] =
{
  12000
};

const CustomShape CS_TEXT_SLANT_DOWN(
  TEXT_SLANT_DOWN_VERTICES, sizeof(TEXT_SLANT_DOWN_VERTICES) / sizeof(Vertex),
  TEXT_SLANT_DOWN_SEGMENTS, sizeof(TEXT_SLANT_DOWN_SEGMENTS) / sizeof(unsigned short),
  TEXT_SLANT_DOWN_CALC, sizeof(TEXT_SLANT_DOWN_CALC) / sizeof(Calculation),
  TEXT_SLANT_DOWN_DEFAULT_ADJUST, sizeof(TEXT_SLANT_DOWN_DEFAULT_ADJUST) / sizeof(int),
  TEXT_SLANT_DOWN_TRS, sizeof(TEXT_SLANT_DOWN_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_CAN_UP_VERTICES[] =
{
  {0, CALCULATED_VALUE(1)}, {900, 0}, {7100, 0}, {10800, 0}, {14500, 0}, {20700, 0}, {21600, CALCULATED_VALUE(1)}, {0, 21600}, {900, CALCULATED_VALUE(4)}, {7100, CALCULATED_VALUE(0)}, {10800, CALCULATED_VALUE(0)}, {14500, CALCULATED_VALUE(0)}, {20700, CALCULATED_VALUE(4)}, {21600, 21600}
};

const unsigned short TEXT_CAN_UP_SEGMENTS[] =
{
  0x4000, 0x2002, 0x8000, 0x4000, 0x2002, 0x8000
};

const Calculation TEXT_CAN_UP_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 14400}, {0x4001, 5470, 0x402, 7200}, {0x4000, 16130, 0x403, 0}
};

const TextRectangle TEXT_CAN_UP_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_CAN_UP_DEFAULT_ADJUST[] =
{
  18500
};

const CustomShape CS_TEXT_CAN_UP(
  TEXT_CAN_UP_VERTICES, sizeof(TEXT_CAN_UP_VERTICES) / sizeof(Vertex),
  TEXT_CAN_UP_SEGMENTS, sizeof(TEXT_CAN_UP_SEGMENTS) / sizeof(unsigned short),
  TEXT_CAN_UP_CALC, sizeof(TEXT_CAN_UP_CALC) / sizeof(Calculation),
  TEXT_CAN_UP_DEFAULT_ADJUST, sizeof(TEXT_CAN_UP_DEFAULT_ADJUST) / sizeof(int),
  TEXT_CAN_UP_TRS, sizeof(TEXT_CAN_UP_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex TEXT_CAN_DOWN_VERTICES[] =
{
  {0, 0}, {900, CALCULATED_VALUE(2)}, {7100, CALCULATED_VALUE(0)}, {10800, CALCULATED_VALUE(0)}, {14500, CALCULATED_VALUE(0)}, {20700, CALCULATED_VALUE(2)}, {21600, 0}, {0, CALCULATED_VALUE(1)}, {900, 21600}, {7100, 21600}, {10800, 21600}, {14500, 21600}, {20700, 21600}, {21600, CALCULATED_VALUE(1)}
};

const unsigned short TEXT_CAN_DOWN_SEGMENTS[] =
{
  0x4000, 0x2002, 0x8000, 0x4000, 0x2002, 0x8000
};

const Calculation TEXT_CAN_DOWN_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x4001, 5470, 0x400, 7200}
};

const TextRectangle TEXT_CAN_DOWN_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int TEXT_CAN_DOWN_DEFAULT_ADJUST[] =
{
  3100
};

const CustomShape CS_TEXT_CAN_DOWN(
  TEXT_CAN_DOWN_VERTICES, sizeof(TEXT_CAN_DOWN_VERTICES) / sizeof(Vertex),
  TEXT_CAN_DOWN_SEGMENTS, sizeof(TEXT_CAN_DOWN_SEGMENTS) / sizeof(unsigned short),
  TEXT_CAN_DOWN_CALC, sizeof(TEXT_CAN_DOWN_CALC) / sizeof(Calculation),
  TEXT_CAN_DOWN_DEFAULT_ADJUST, sizeof(TEXT_CAN_DOWN_DEFAULT_ADJUST) / sizeof(int),
  TEXT_CAN_DOWN_TRS, sizeof(TEXT_CAN_DOWN_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex FLOW_CHART_ALTERNATE_PROCESS_VERTICES[] =
{
  {0, CALCULATED_VALUE(2)}, {CALCULATED_VALUE(0), 0}, {CALCULATED_VALUE(1), 0}, {21600, CALCULATED_VALUE(2)}, {21600, CALCULATED_VALUE(3)}, {CALCULATED_VALUE(1), 21600}, {CALCULATED_VALUE(0), 21600}, {0, CALCULATED_VALUE(3)}
};

const unsigned short FLOW_CHART_ALTERNATE_PROCESS_SEGMENTS[] =
{
  0x4000, 0xa801, 0x0001, 0xa701, 0x0001, 0xa801, 0x0001, 0xa701, 0x6000, 0x8000
};

const Calculation FLOW_CHART_ALTERNATE_PROCESS_CALC[] =
{
  {0x2000, PROP_GEO_LEFT, 2540, 0}, {0x2000, PROP_GEO_RIGHT, 0, 2540}, {0x2000, PROP_GEO_TOP, 2540, 0}, {0x2000, PROP_GEO_BOTTOM, 0, 2540}, {0x2000, PROP_GEO_LEFT, 800, 0}, {0x2000, PROP_GEO_RIGHT, 0, 800}, {0x2000, PROP_GEO_TOP, 800, 0}, {0x2000, PROP_GEO_BOTTOM, 0, 800}
};

const TextRectangle FLOW_CHART_ALTERNATE_PROCESS_TRS[] =
{
  { {CALCULATED_VALUE(4), CALCULATED_VALUE(6)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(7)} }
};

const Vertex FLOW_CHART_ALTERNATE_PROCESS_GLUE_POINTS[] =
{
  {0, 10800}, {10800, 0}, {21600, 10800}, {10800, 21600}
};

const CustomShape CS_FLOW_CHART_ALTERNATE_PROCESS(
  FLOW_CHART_ALTERNATE_PROCESS_VERTICES, sizeof(FLOW_CHART_ALTERNATE_PROCESS_VERTICES) / sizeof(Vertex),
  FLOW_CHART_ALTERNATE_PROCESS_SEGMENTS, sizeof(FLOW_CHART_ALTERNATE_PROCESS_SEGMENTS) / sizeof(unsigned short),
  FLOW_CHART_ALTERNATE_PROCESS_CALC, sizeof(FLOW_CHART_ALTERNATE_PROCESS_CALC) / sizeof(Calculation),
  NULL, 0,
  FLOW_CHART_ALTERNATE_PROCESS_TRS, sizeof(FLOW_CHART_ALTERNATE_PROCESS_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_ALTERNATE_PROCESS_GLUE_POINTS, sizeof(FLOW_CHART_ALTERNATE_PROCESS_GLUE_POINTS) / sizeof(Vertex));

const Vertex FLOW_CHART_OFFPAGE_CONNECTOR_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 17150}, {10800, 21600}, {0, 17150}, {0, 0}
};

const TextRectangle FLOW_CHART_OFFPAGE_CONNECTOR_TRS[] =
{
  { {0, 0}, {21600, 17150} }
};

const Vertex FLOW_CHART_OFFPAGE_CONNECTOR_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_FLOW_CHART_OFFPAGE_CONNECTOR(
  FLOW_CHART_OFFPAGE_CONNECTOR_VERTICES, sizeof(FLOW_CHART_OFFPAGE_CONNECTOR_VERTICES) / sizeof(Vertex),
  NULL, 0,
  NULL, 0,
  NULL, 0,
  FLOW_CHART_OFFPAGE_CONNECTOR_TRS, sizeof(FLOW_CHART_OFFPAGE_CONNECTOR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  FLOW_CHART_OFFPAGE_CONNECTOR_GLUE_POINTS, sizeof(FLOW_CHART_OFFPAGE_CONNECTOR_GLUE_POINTS) / sizeof(Vertex));

const Vertex LEFT_RIGHT_UP_ARROW_VERTICES[] =
{
  {10800, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(0)}, {21600, 10800}, {CALCULATED_VALUE(5), CALCULATED_VALUE(3)}, {CALCULATED_VALUE(5), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(3)}, {0, 10800}, {CALCULATED_VALUE(2), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(2), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}
};

const unsigned short LEFT_RIGHT_UP_ARROW_SEGMENTS[] =
{
  0x4000, 0x0010, 0x6001, 0x8000
};

const Calculation LEFT_RIGHT_UP_ARROW_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x6001, 0x0403, PROP_ADJUST_VAL_FIRST + 2, 21600}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST + 1}, {0x8000, 21600, 0, 0x0402}
};

const TextRectangle LEFT_RIGHT_UP_ARROW_TRS[] =
{
  { {0, 0}, {21600, 21600} }
};

const int LEFT_RIGHT_UP_ARROW_DEFAULT_ADJUST[] =
{
  6500, 8600, 6200
};

const CustomShape CS_LEFT_RIGHT_UP_ARROW(
  LEFT_RIGHT_UP_ARROW_VERTICES, sizeof(LEFT_RIGHT_UP_ARROW_VERTICES) / sizeof(Vertex),
  LEFT_RIGHT_UP_ARROW_SEGMENTS, sizeof(LEFT_RIGHT_UP_ARROW_SEGMENTS) / sizeof(unsigned short),
  LEFT_RIGHT_UP_ARROW_CALC, sizeof(LEFT_RIGHT_UP_ARROW_CALC) / sizeof(Calculation),
  LEFT_RIGHT_UP_ARROW_DEFAULT_ADJUST, sizeof(LEFT_RIGHT_UP_ARROW_DEFAULT_ADJUST) / sizeof(int),
  LEFT_RIGHT_UP_ARROW_TRS, sizeof(LEFT_RIGHT_UP_ARROW_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex SUN_VERTICES[] =
{
  {0, 10800}, {CALCULATED_VALUE(4), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(4), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(0x0a), CALCULATED_VALUE(0x0b)}, {CALCULATED_VALUE(0x0c), CALCULATED_VALUE(0x0d)}, {CALCULATED_VALUE(0x0e), CALCULATED_VALUE(0x0f)}, {CALCULATED_VALUE(0x10), CALCULATED_VALUE(0x11)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x13)}, {CALCULATED_VALUE(0x14), CALCULATED_VALUE(0x15)}, {CALCULATED_VALUE(0x16), CALCULATED_VALUE(0x17)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(0x19)}, {CALCULATED_VALUE(0x1a), CALCULATED_VALUE(0x1b)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0x1d)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(0x1f)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(0x21)}, {CALCULATED_VALUE(0x22), CALCULATED_VALUE(0x23)}, {CALCULATED_VALUE(0x24), CALCULATED_VALUE(0x25)}, {CALCULATED_VALUE(0x26), CALCULATED_VALUE(0x27)}, {CALCULATED_VALUE(0x28), CALCULATED_VALUE(0x29)}, {CALCULATED_VALUE(0x2a), CALCULATED_VALUE(0x2b)}, {CALCULATED_VALUE(0x2c), CALCULATED_VALUE(0x2d)}, {CALCULATED_VALUE(0x2e), CALCULATED_VALUE(0x2f)}, {CALCULATED_VALUE(0x30), CALCULATED_VALUE(0x31)}, {CALCULATED_VALUE(0x32), CALCULATED_VALUE(0x33)}, {10800, 10800}, {CALCULATED_VALUE(0x36), CALCULATED_VALUE(0x36)}, {0, 360}
};

const unsigned short SUN_SEGMENTS[] =
{
  0x4000, 0x0002, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000, 0xa203, 0x6000, 0x8000
};

const Calculation SUN_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2000, PROP_ADJUST_VAL_FIRST, 0, 2700}, {0x2001, 0x402, 5080, 7425}, {0x2000, 0x403, 2540, 0}, {0x8000, 10125, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x405, 2120, 7425}, {0x2000, 0x406, 210, 0}, {0x4000, 10800, 0x407, 0}, {0x8000, 10800, 0, 0x407}, {0x0081, 0, 10800, 45}, {0x0082, 0, 10800, 45}, {0x6081, 0x404, 0x408, 45}, {0x6082, 0x404, 0x408, 45}, {0x6081, 0x404, 0x409, 45}, {0x6082, 0x404, 0x409, 45}, {0x0081, 0, 10800, 90}, {0x0082, 0, 10800, 90}, {0x6081, 0x404, 0x408, 90}, {0x6082, 0x404, 0x408, 90}, {0x6081, 0x404, 0x409, 90}, {0x6082, 0x404, 0x409, 90}, {0x0081, 0, 10800, 135}, {0x0082, 0, 10800, 135}, {0x6081, 0x404, 0x408, 135}, {0x6082, 0x404, 0x408, 135}, {0x6081, 0x404, 0x409, 135}, {0x6082, 0x404, 0x409, 135}, {0x0081, 0, 10800, 180}, {0x0082, 0, 10800, 180}, {0x6081, 0x404, 0x408, 180}, {0x6082, 0x404, 0x408, 180}, {0x6081, 0x404, 0x409, 180}, {0x6082, 0x404, 0x409, 180}, {0x0081, 0, 10800, 225}, {0x0082, 0, 10800, 225}, {0x6081, 0x404, 0x408, 225}, {0x6082, 0x404, 0x408, 225}, {0x6081, 0x404, 0x409, 225}, {0x6082, 0x404, 0x409, 225}, {0x0081, 0, 10800, 270}, {0x0082, 0, 10800, 270}, {0x6081, 0x404, 0x408, 270}, {0x6082, 0x404, 0x408, 270}, {0x6081, 0x404, 0x409, 270}, {0x6082, 0x404, 0x409, 270}, {0x0081, 0, 10800, 315}, {0x0082, 0, 10800, 315}, {0x6081, 0x404, 0x408, 315}, {0x6082, 0x404, 0x408, 315}, {0x6081, 0x404, 0x409, 315}, {0x6082, 0x404, 0x409, 315}, {0x2081, PROP_ADJUST_VAL_FIRST, 10800, 45}, {0x2081, PROP_ADJUST_VAL_FIRST, 10800, 225}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}
};

const TextRectangle SUN_TRS[] =
{
  { {CALCULATED_VALUE(0x34), CALCULATED_VALUE(0x34)}, {CALCULATED_VALUE(0x35), CALCULATED_VALUE(0x35)} }
};

const int SUN_DEFAULT_ADJUST[] =
{
  5400
};

const Vertex SUN_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_SUN(
  SUN_VERTICES, sizeof(SUN_VERTICES) / sizeof(Vertex),
  SUN_SEGMENTS, sizeof(SUN_SEGMENTS) / sizeof(unsigned short),
  SUN_CALC, sizeof(SUN_CALC) / sizeof(Calculation),
  SUN_DEFAULT_ADJUST, sizeof(SUN_DEFAULT_ADJUST) / sizeof(int),
  SUN_TRS, sizeof(SUN_TRS) / sizeof(TextRectangle),
  21600, 21600,
  SUN_GLUE_POINTS, sizeof(SUN_GLUE_POINTS) / sizeof(Vertex));

const Vertex MOON_VERTICES[] =
{
  {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0), 5080}, {CALCULATED_VALUE(0), 10800}, {CALCULATED_VALUE(0), 16520}, {CALCULATED_VALUE(3), CALCULATED_VALUE(5)}, {21600, 21600}, {9740, 21600}, {0, 16730}, {0, 10800}, {0, 4870}, {9740, 0}, {21600, 0}
};

const unsigned short MOON_SEGMENTS[] =
{
  0x4000, 0x2004, 0x6000, 0x8000
};

const Calculation MOON_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x401, 1, 2}, {0x6000, 0x402, PROP_ADJUST_VAL_FIRST, 0}, {0x2001, PROP_ADJUST_VAL_FIRST, 1794, 10000}, {0x8000, 21600, 0, 0x0404}, {0x2001, PROP_ADJUST_VAL_FIRST, 400, 18900}, {0x8081, 0, 10800, 0x406}, {0x8082, 0, 10800, 0x406}, {0x6000, 0x407, 0x407, 0}, {0x8000, 21600, 0, 0x408}
};

const TextRectangle MOON_TRS[] =
{
  { {CALCULATED_VALUE(9), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(10)} }
};

const int MOON_DEFAULT_ADJUST[] =
{
  10800
};

const Vertex MOON_GLUE_POINTS[] =
{
  {21600, 0}, {0, 10800}, {21600, 21600}, {CALCULATED_VALUE(0), 10800}
};

const CustomShape CS_MOON(
  MOON_VERTICES, sizeof(MOON_VERTICES) / sizeof(Vertex),
  MOON_SEGMENTS, sizeof(MOON_SEGMENTS) / sizeof(unsigned short),
  MOON_CALC, sizeof(MOON_CALC) / sizeof(Calculation),
  MOON_DEFAULT_ADJUST, sizeof(MOON_DEFAULT_ADJUST) / sizeof(int),
  MOON_TRS, sizeof(MOON_TRS) / sizeof(TextRectangle),
  21600, 21600,
  MOON_GLUE_POINTS, sizeof(MOON_GLUE_POINTS) / sizeof(Vertex));

const Vertex BRACKET_PAIR_VERTICES[] =
{
  {CALCULATED_VALUE(0), 0}, {0, CALCULATED_VALUE(1)}, {0, CALCULATED_VALUE(2)}, {CALCULATED_VALUE(0), 21600}, {CALCULATED_VALUE(3), 21600}, {21600, CALCULATED_VALUE(2)}, {21600, CALCULATED_VALUE(1)}, {CALCULATED_VALUE(3), 0}
};

const unsigned short BRACKET_PAIR_SEGMENTS[] =
{
  0x4000, 0xa701, 0x0001, 0xa801, 0x8000, 0x4000, 0xa701, 0x0001, 0xa801, 0x8000
};

const Calculation BRACKET_PAIR_CALC[] =
{
  {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0x2082, PROP_ADJUST_VAL_FIRST, 0, 45}, {0x2000, 0x404, 0, 10800}, {0x8000, 0, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, 0x406, 0, 0x405}, {0xa000, PROP_GEO_LEFT, 0, 0x407}, {0xa000, PROP_GEO_TOP, 0, 0x407}, {0x6000, PROP_GEO_RIGHT, 0x407, 0}, {0x6000, PROP_GEO_BOTTOM, 0x407, 0}, {0xa000, PROP_GEO_LEFT, 0, 0x405}, {0xa000, PROP_GEO_TOP, 0, 0x405}, {0x6000, PROP_GEO_RIGHT, 0x405, 0}, {0x6000, PROP_GEO_BOTTOM, 0x405, 0}
};

const TextRectangle BRACKET_PAIR_TRS[] =
{
  { {CALCULATED_VALUE(8), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(10), CALCULATED_VALUE(11)} }
};

const int BRACKET_PAIR_DEFAULT_ADJUST[] =
{
  3700
};

const Vertex BRACKET_PAIR_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_BRACKET_PAIR(
  BRACKET_PAIR_VERTICES, sizeof(BRACKET_PAIR_VERTICES) / sizeof(Vertex),
  BRACKET_PAIR_SEGMENTS, sizeof(BRACKET_PAIR_SEGMENTS) / sizeof(unsigned short),
  BRACKET_PAIR_CALC, sizeof(BRACKET_PAIR_CALC) / sizeof(Calculation),
  BRACKET_PAIR_DEFAULT_ADJUST, sizeof(BRACKET_PAIR_DEFAULT_ADJUST) / sizeof(int),
  BRACKET_PAIR_TRS, sizeof(BRACKET_PAIR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  BRACKET_PAIR_GLUE_POINTS, sizeof(BRACKET_PAIR_GLUE_POINTS) / sizeof(Vertex));

const Vertex BRACE_PAIR_VERTICES[] =
{
  {CALCULATED_VALUE(4), 0}, {CALCULATED_VALUE(0), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(6)}, {0, 10800}, {CALCULATED_VALUE(0), CALCULATED_VALUE(7)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(4), 21600}, {CALCULATED_VALUE(8), 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(7)}, {21600, 10800}, {CALCULATED_VALUE(3), CALCULATED_VALUE(6)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(8), 0}
};

const unsigned short BRACE_PAIR_SEGMENTS[] =
{
  0x4000, 0xa701, 0x0001, 0xa801, 0xa701, 0x0001, 0xa801, 0x8000, 0x4000, 0xa701, 0x0001, 0xa801, 0xa701, 0x0001, 0xa801, 0x8000
};

const Calculation BRACE_PAIR_CALC[] =
{
  {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x400, 2, 1}, {0x2001, PROP_ADJUST_VAL_FIRST, 2, 1}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 21600, 0, 0x406}, {0xa000, PROP_GEO_RIGHT, 0, 0x405}, {0x2001, PROP_ADJUST_VAL_FIRST, 1, 3}, {0x6000, 0x409, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_LEFT, 0x40a, 0}, {0x6000, PROP_GEO_TOP, 0x409, 0}, {0xa000, PROP_GEO_RIGHT, 0, 0x40a}, {0xa000, PROP_GEO_BOTTOM, 0, 0x409}
};

const TextRectangle BRACE_PAIR_TRS[] =
{
  { {CALCULATED_VALUE(11), CALCULATED_VALUE(12)}, {CALCULATED_VALUE(13), CALCULATED_VALUE(14)} }
};

const int BRACE_PAIR_DEFAULT_ADJUST[] =
{
  1800
};

const Vertex BRACE_PAIR_GLUE_POINTS[] =
{
  {10800, 0}, {0, 10800}, {10800, 21600}, {21600, 10800}
};

const CustomShape CS_BRACE_PAIR(
  BRACE_PAIR_VERTICES, sizeof(BRACE_PAIR_VERTICES) / sizeof(Vertex),
  BRACE_PAIR_SEGMENTS, sizeof(BRACE_PAIR_SEGMENTS) / sizeof(unsigned short),
  BRACE_PAIR_CALC, sizeof(BRACE_PAIR_CALC) / sizeof(Calculation),
  BRACE_PAIR_DEFAULT_ADJUST, sizeof(BRACE_PAIR_DEFAULT_ADJUST) / sizeof(int),
  BRACE_PAIR_TRS, sizeof(BRACE_PAIR_TRS) / sizeof(TextRectangle),
  21600, 21600,
  BRACE_PAIR_GLUE_POINTS, sizeof(BRACE_PAIR_GLUE_POINTS) / sizeof(Vertex));

const Vertex DOUBLE_WAVE_VERTICES[] =
{
  {CALCULATED_VALUE(7), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(15), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0x1f), CALCULATED_VALUE(9)}, {CALCULATED_VALUE(16), CALCULATED_VALUE(10)}, {CALCULATED_VALUE(12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(24), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(25), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(0x21), CALCULATED_VALUE(28)}, {CALCULATED_VALUE(0x13), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(26)}, {CALCULATED_VALUE(27), CALCULATED_VALUE(28)}, {CALCULATED_VALUE(29), CALCULATED_VALUE(1)}
};

const unsigned short DOUBLE_WAVE_SEGMENTS[] =
{
  0x4000, 0x2002, 0x0001, 0x2002, 0x6000, 0x8000
};

const Calculation DOUBLE_WAVE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x8000, 21600, 0, 0x400}, {0x2000, PROP_ADJUST_VAL_FIRST + 1, 0, 0}, {0x2000, 0x402, 0, 10800}, {0x2001, 0x403, 2, 1}, {0x2003, 0x404, 0, 0}, {0x8000, 4320, 0, 0x405}, {0xa006, 0x403, 0, 0x405}, {0x4001, 7900, 0x400, 2230}, {0xa000, 0x400, 0, 0x408}, {0x6000, 0x400, 0x408, 0}, {0x8000, 21600, 0, 0x404}, {0x6006, 0x403, 0x40b, 21600}, {0xa000, 0x40c, 0, 0x407}, {0x2001, 0x405, 1, 2}, {0xa000, 0x407, 3600, 0x40e}, {0x6000, 0x40c, 0x40e, 3600}, {0x2001, 0x40d, 1, 2}, {0x6000, 0x407, 0x411, 0}, {0x8000, 21600, 0, 0x412}, {0x2001, 0x405, 1, 2}, {0x8000, 21600, 0, 0x414}, {0x2001, 0x400, 2, 1}, {0x8000, 21600, 0, 0x416}, {0x8000, 21600, 0, 0x407}, {0x8000, 21600, 0, 0x40f}, {0x6000, 0x401, 0x408, 0}, {0x8000, 21600, 0, 0x410}, {0xa000, 0x401, 0, 0x408}, {0x8000, 21600, 0, 0x40c}, {0xa000, 0x412, 0, 0x40e}, {0x6000, 0x412, 0x40e, 0}, {0xa000, 0x413, 0, 0x40e}, {0x6000, 0x413, 0x40e, 0}
};

const TextRectangle DOUBLE_WAVE_TRS[] =
{
  { {CALCULATED_VALUE(5), CALCULATED_VALUE(22)}, {CALCULATED_VALUE(11), CALCULATED_VALUE(23)} }
};

const int DOUBLE_WAVE_DEFAULT_ADJUST[] =
{
  1400, 10800
};

const Vertex DOUBLE_WAVE_GLUE_POINTS[] =
{
  {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0x14), 10800}, {CALCULATED_VALUE(0x13), CALCULATED_VALUE(1)}, {CALCULATED_VALUE(0x15), 10800}
};

const CustomShape CS_DOUBLE_WAVE(
  DOUBLE_WAVE_VERTICES, sizeof(DOUBLE_WAVE_VERTICES) / sizeof(Vertex),
  DOUBLE_WAVE_SEGMENTS, sizeof(DOUBLE_WAVE_SEGMENTS) / sizeof(unsigned short),
  DOUBLE_WAVE_CALC, sizeof(DOUBLE_WAVE_CALC) / sizeof(Calculation),
  DOUBLE_WAVE_DEFAULT_ADJUST, sizeof(DOUBLE_WAVE_DEFAULT_ADJUST) / sizeof(int),
  DOUBLE_WAVE_TRS, sizeof(DOUBLE_WAVE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  DOUBLE_WAVE_GLUE_POINTS, sizeof(DOUBLE_WAVE_GLUE_POINTS) / sizeof(Vertex));

const Vertex ACTION_BUTTON_BLANK_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(0)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(0)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(0), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(0), CALCULATED_VALUE(2)}
};

const unsigned short ACTION_BUTTON_BLANK_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_BLANK_CALC[] =
{
  {0x2001, PROP_ADJUST_VAL_FIRST, 21599, 21600}, {0xa000, PROP_GEO_RIGHT, 0, 0x400}, {0xa000, PROP_GEO_BOTTOM, 0, 0x400}
};

const TextRectangle ACTION_BUTTON_BLANK_TRS[] =
{
  { {CALCULATED_VALUE(0), CALCULATED_VALUE(0)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)} }
};

const int ACTION_BUTTON_BLANK_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_BLANK(
  ACTION_BUTTON_BLANK_VERTICES, sizeof(ACTION_BUTTON_BLANK_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_BLANK_SEGMENTS, sizeof(ACTION_BUTTON_BLANK_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_BLANK_CALC, sizeof(ACTION_BUTTON_BLANK_CALC) / sizeof(Calculation),
  ACTION_BUTTON_BLANK_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_BLANK_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_BLANK_TRS, sizeof(ACTION_BUTTON_BLANK_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_HOME_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(0xa)}, {CALCULATED_VALUE(0xc), CALCULATED_VALUE(0xe)}, {CALCULATED_VALUE(0xc), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0x16), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(0x1a)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0x1a)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0xc), CALCULATED_VALUE(0xe)}, {CALCULATED_VALUE(0xc), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x22), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x22), CALCULATED_VALUE(0x1a)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(0x1a)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0x1a)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(0x1a)}
};

const unsigned short ACTION_BUTTON_HOME_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x000a, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0007, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_HOME_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -8000, 0x0406, 1}, {0x6000, 0x0409, 0x0408, 0}, {0x4001, 2960, 0x0406, 1}, {0x6000, 0x040b, 0x0407, 0}, {0x4001, -5000, 0x0406, 1}, {0x6000, 0x040d, 0x0408, 0}, {0x4001, -7000, 0x0406, 1}, {0x6000, 0x040f, 0x0408, 0}, {0x4001, 5000, 0x0406, 1}, {0x6000, 0x0411, 0x0407, 0}, {0x4001, -2960, 0x0406, 1}, {0x6000, 0x0413, 0x0408, 0}, {0x4001, 8000, 0x0406, 1}, {0x6000, 0x0415, 0x0407, 0}, {0x4001, 6100, 0x0406, 1}, {0x6000, 0x0417, 0x0407, 0}, {0x4001, 8260, 0x0406, 1}, {0x6000, 0x0419, 0x0408, 0}, {0x4001, -6100, 0x0406, 1}, {0x6000, 0x041b, 0x0407, 0}, {0x4001, -8000, 0x0406, 1}, {0x6000, 0x041d, 0x0407, 0}, {0x4001, -1060, 0x0406, 1}, {0x6000, 0x041f, 0x0407, 0}, {0x4001, 1060, 0x0406, 1}, {0x6000, 0x0421, 0x0407, 0}, {0x4001, 4020, 0x0406, 1}, {0x6000, 0x0423, 0x0408, 0}
};

const TextRectangle ACTION_BUTTON_HOME_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_HOME_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_HOME(
  ACTION_BUTTON_HOME_VERTICES, sizeof(ACTION_BUTTON_HOME_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_HOME_SEGMENTS, sizeof(ACTION_BUTTON_HOME_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_HOME_CALC, sizeof(ACTION_BUTTON_HOME_CALC) / sizeof(Calculation),
  ACTION_BUTTON_HOME_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_HOME_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_HOME_TRS, sizeof(ACTION_BUTTON_HOME_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_HELP_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0x3e)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0x3e)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x18)}, {CALCULATED_VALUE(0x1a), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(0x22)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(0x26)}, {CALCULATED_VALUE(0x28), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(0x2c), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(0x2e), CALCULATED_VALUE(0x26)}, {CALCULATED_VALUE(0x2e), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x30), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x30), CALCULATED_VALUE(0x32)}, {CALCULATED_VALUE(0x34), CALCULATED_VALUE(0x36)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(0x36)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x36)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0x32)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0x38)}, {CALCULATED_VALUE(0x3a), CALCULATED_VALUE(0x3c)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x3c)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(0x3c)}, {CALCULATED_VALUE(0x34), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x34), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0x34), CALCULATED_VALUE(0x14)}
};

const unsigned short ACTION_BUTTON_HELP_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0xa704, 0x6000, 0x8000, 0x4000, 0x0001, 0x2004, 0x0001, 0x2004, 0x0001, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_HELP_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -1690, 0x0406, 1}, {0x6000, 0x0409, 0x0407, 0}, {0x4001, 4600, 0x0406, 1}, {0x6000, 0x040b, 0x0408, 0}, {0x4001, 1690, 0x0406, 1}, {0x6000, 0x040d, 0x0407, 0}, {0x4001, 7980, 0x0406, 1}, {0x6000, 0x040f, 0x0408, 0}, {0x4001, 1270, 0x0406, 1}, {0x6000, 0x0411, 0x0407, 0}, {0x4001, 4000, 0x0406, 1}, {0x6000, 0x0413, 0x0408, 0}, {0x4001, 1750, 0x0406, 1}, {0x6000, 0x0415, 0x0408, 0}, {0x4001, 800, 0x0406, 1}, {0x6000, 0x0417, 0x0408, 0}, {0x4001, 1650, 0x0406, 1}, {0x6000, 0x0419, 0x0407, 0}, {0x4001, 2340, 0x0406, 1}, {0x6000, 0x041b, 0x0407, 0}, {0x4001, 3640, 0x0406, 1}, {0x6000, 0x041d, 0x0407, 0}, {0x4001, 4670, 0x0406, 1}, {0x6000, 0x041f, 0x0407, 0}, {0x4001, -1570, 0x0406, 1}, {0x6000, 0x0421, 0x0408, 0}, {0x4001, -3390, 0x0406, 1}, {0x6000, 0x0423, 0x0408, 0}, {0x4001, -6050, 0x0406, 1}, {0x6000, 0x0425, 0x0408, 0}, {0x4001, 2540, 0x0406, 1}, {0x6000, 0x0427, 0x0407, 0}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x0429, 0x0408, 0}, {0x4001, -2540, 0x0406, 1}, {0x6000, 0x042b, 0x0407, 0}, {0x4001, -4460, 0x0406, 1}, {0x6000, 0x042d, 0x0407, 0}, {0x4001, -2330, 0x0406, 1}, {0x6000, 0x042f, 0x0407, 0}, {0x4001, -4700, 0x0406, 1}, {0x6000, 0x0431, 0x0408, 0}, {0x4001, -1270, 0x0406, 1}, {0x6000, 0x0433, 0x0407, 0}, {0x4001, -5720, 0x0406, 1}, {0x6000, 0x0435, 0x0408, 0}, {0x4001, -2540, 0x0406, 1}, {0x6000, 0x0437, 0x0408, 0}, {0x4001, 1800, 0x0406, 1}, {0x6000, 0x0439, 0x0407, 0}, {0x4001, -1700, 0x0406, 1}, {0x6000, 0x043b, 0x0408, 0}, {0x4001, 6290, 0x0406, 1}, {0x6000, 0x043d, 0x0408, 0}
};

const TextRectangle ACTION_BUTTON_HELP_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_HELP_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_HELP(
  ACTION_BUTTON_HELP_VERTICES, sizeof(ACTION_BUTTON_HELP_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_HELP_SEGMENTS, sizeof(ACTION_BUTTON_HELP_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_HELP_CALC, sizeof(ACTION_BUTTON_HELP_CALC) / sizeof(Calculation),
  ACTION_BUTTON_HELP_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_HELP_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_HELP_TRS, sizeof(ACTION_BUTTON_HELP_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_INFORMATION_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0x7), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0x8)}, {CALCULATED_VALUE(0x7), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x7), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x7), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(0x7), CALCULATED_VALUE(0x18)}, {CALCULATED_VALUE(0x16), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(0x7), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0x1a), CALCULATED_VALUE(0x1c)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(0x1c)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(0x20)}, {CALCULATED_VALUE(0x22), CALCULATED_VALUE(0x20)}, {CALCULATED_VALUE(0x22), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x1a), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x1a), CALCULATED_VALUE(0x20)}, {CALCULATED_VALUE(0x26), CALCULATED_VALUE(0x20)}, {CALCULATED_VALUE(0x26), CALCULATED_VALUE(0x28)}, {CALCULATED_VALUE(0x1a), CALCULATED_VALUE(0x28)}
};

const unsigned short ACTION_BUTTON_INFORMATION_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0xa704, 0x6000, 0x8000, 0x4000, 0xa704, 0x6000, 0x8000, 0x4000, 0x0009, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_INFORMATION_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x0409, 0x0407, 0}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x040b, 0x0408, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x040d, 0x0407, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x040f, 0x0408, 0}, {0x4001, -2060, 0x0406, 1}, {0x6000, 0x0411, 0x0407, 0}, {0x4001, -7620, 0x0406, 1}, {0x6000, 0x0413, 0x0408, 0}, {0x4001, 2060, 0x0406, 1}, {0x6000, 0x0415, 0x0407, 0}, {0x4001, -3500, 0x0406, 1}, {0x6000, 0x0417, 0x0408, 0}, {0x4001, -2960, 0x0406, 1}, {0x6000, 0x0419, 0x0407, 0}, {0x4001, -2960, 0x0406, 1}, {0x6000, 0x041b, 0x0408, 0}, {0x4001, 1480, 0x0406, 1}, {0x6000, 0x041d, 0x0407, 0}, {0x4001, 5080, 0x0406, 1}, {0x6000, 0x041f, 0x0408, 0}, {0x4001, 2960, 0x0406, 1}, {0x6000, 0x0421, 0x0407, 0}, {0x4001, 6140, 0x0406, 1}, {0x6000, 0x0423, 0x0408, 0}, {0x4001, -1480, 0x0406, 1}, {0x6000, 0x0425, 0x0407, 0}, {0x4001, -1920, 0x0406, 1}, {0x6000, 0x0427, 0x0408, 0}, {0x4001, -5560, 0x0406, 1}, {0x6000, 0x0429, 0x0408, 0}
};

const TextRectangle ACTION_BUTTON_INFORMATION_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_INFORMATION_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_INFORMATION(
  ACTION_BUTTON_INFORMATION_VERTICES, sizeof(ACTION_BUTTON_INFORMATION_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_INFORMATION_SEGMENTS, sizeof(ACTION_BUTTON_INFORMATION_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_INFORMATION_CALC, sizeof(ACTION_BUTTON_INFORMATION_CALC) / sizeof(Calculation),
  ACTION_BUTTON_INFORMATION_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_INFORMATION_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_INFORMATION_TRS, sizeof(ACTION_BUTTON_INFORMATION_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_FORWARD_NEXT_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0x10)}
};

const unsigned short ACTION_BUTTON_FORWARD_NEXT_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_FORWARD_NEXT_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x0409, 0x0407, 0}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x040b, 0x0408, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x040d, 0x0407, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x040f, 0x0408, 0}
};

const TextRectangle ACTION_BUTTON_FORWARD_NEXT_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_FORWARD_NEXT_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_FORWARD_NEXT(
  ACTION_BUTTON_FORWARD_NEXT_VERTICES, sizeof(ACTION_BUTTON_FORWARD_NEXT_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_FORWARD_NEXT_SEGMENTS, sizeof(ACTION_BUTTON_FORWARD_NEXT_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_FORWARD_NEXT_CALC, sizeof(ACTION_BUTTON_FORWARD_NEXT_CALC) / sizeof(Calculation),
  ACTION_BUTTON_FORWARD_NEXT_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_FORWARD_NEXT_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_FORWARD_NEXT_TRS, sizeof(ACTION_BUTTON_FORWARD_NEXT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_BACK_PREVIOUS_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0x10)}
};

const unsigned short ACTION_BUTTON_BACK_PREVIOUS_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_BACK_PREVIOUS_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x0409, 0x0407, 0}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x040b, 0x0408, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x040d, 0x0407, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x040f, 0x0408, 0}
};

const TextRectangle ACTION_BUTTON_BACK_PREVIOUS_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_BACK_PREVIOUS_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_BACK_PREVIOUS(
  ACTION_BUTTON_BACK_PREVIOUS_VERTICES, sizeof(ACTION_BUTTON_BACK_PREVIOUS_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_BACK_PREVIOUS_SEGMENTS, sizeof(ACTION_BUTTON_BACK_PREVIOUS_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_BACK_PREVIOUS_CALC, sizeof(ACTION_BUTTON_BACK_PREVIOUS_CALC) / sizeof(Calculation),
  ACTION_BUTTON_BACK_PREVIOUS_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_BACK_PREVIOUS_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_BACK_PREVIOUS_TRS, sizeof(ACTION_BUTTON_BACK_PREVIOUS_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_END_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0x16), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0xc)}
};

const unsigned short ACTION_BUTTON_END_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_END_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -4020, 0x0406, 1}, {0x6000, 0x0409, 0x0407, 0}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x040b, 0x0408, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x040d, 0x0407, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x040f, 0x0408, 0}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x0411, 0x0407, 0}, {0x4001, -6140, 0x0406, 1}, {0x6000, 0x0413, 0x0407, 0}, {0x4001, 4020, 0x0406, 1}, {0x6000, 0x0415, 0x0407, 0}, {0x4001, 6140, 0x0406, 1}, {0x6000, 0x0417, 0x0407, 0}
};

const TextRectangle ACTION_BUTTON_END_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_END_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_END(
  ACTION_BUTTON_END_VERTICES, sizeof(ACTION_BUTTON_END_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_END_SEGMENTS, sizeof(ACTION_BUTTON_END_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_END_CALC, sizeof(ACTION_BUTTON_END_CALC) / sizeof(Calculation),
  ACTION_BUTTON_END_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_END_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_END_TRS, sizeof(ACTION_BUTTON_END_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_BEGINNING_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x14), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x14), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x12), CALCULATED_VALUE(0x10)}
};

const unsigned short ACTION_BUTTON_BEGINNING_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_BEGINNING_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -4020, 0x0406, 1}, {0x6000, 0x0409, 0x0407, 0}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x040b, 0x0408, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x040d, 0x0407, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x040f, 0x0408, 0}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x0411, 0x0407, 0}, {0x4001, -6140, 0x0406, 1}, {0x6000, 0x0413, 0x0407, 0}, {0x4001, 4020, 0x0406, 1}, {0x6000, 0x0415, 0x0407, 0}, {0x4001, 6140, 0x0406, 1}, {0x6000, 0x0417, 0x0407, 0}
};

const TextRectangle ACTION_BUTTON_BEGINNING_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_BEGINNING_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_BEGINNING(
  ACTION_BUTTON_BEGINNING_VERTICES, sizeof(ACTION_BUTTON_BEGINNING_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_BEGINNING_SEGMENTS, sizeof(ACTION_BUTTON_BEGINNING_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_BEGINNING_CALC, sizeof(ACTION_BUTTON_BEGINNING_CALC) / sizeof(Calculation),
  ACTION_BUTTON_BEGINNING_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_BEGINNING_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_BEGINNING_TRS, sizeof(ACTION_BUTTON_BEGINNING_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_RETURN_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0x14), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0x1a), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(0x20)}, {CALCULATED_VALUE(0x22), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x24), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x24), CALCULATED_VALUE(0x10)}, {CALCULATED_VALUE(0x24), CALCULATED_VALUE(0x26)}, {CALCULATED_VALUE(0x28), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(7), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(0x2c), CALCULATED_VALUE(0x2a)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0x26)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0x10)}
};

const unsigned short ACTION_BUTTON_RETURN_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0002, 0x2001, 0x0001, 0x2001, 0x0006, 0x2001, 0x0001, 0x2001, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_RETURN_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x0409, 0x0407, 0}, {0x4001, -3800, 0x0406, 1}, {0x6000, 0x040b, 0x0408, 0}, {0x4001, -4020, 0x0406, 1}, {0x6000, 0x040d, 0x0407, 0}, {0x4001, 2330, 0x0406, 1}, {0x6000, 0x040f, 0x0408, 0}, {0x4001, 3390, 0x0406, 1}, {0x6000, 0x0411, 0x0408, 0}, {0x4001, -3100, 0x0406, 1}, {0x6000, 0x0413, 0x0407, 0}, {0x4001, 4230, 0x0406, 1}, {0x6000, 0x0415, 0x0408, 0}, {0x4001, -1910, 0x0406, 1}, {0x6000, 0x0417, 0x0407, 0}, {0x4001, 1190, 0x0406, 1}, {0x6000, 0x0419, 0x0407, 0}, {0x4001, 2110, 0x0406, 1}, {0x6000, 0x041b, 0x0407, 0}, {0x4001, 4030, 0x0406, 1}, {0x6000, 0x041d, 0x0407, 0}, {0x4001, -7830, 0x0406, 1}, {0x6000, 0x041f, 0x0408, 0}, {0x4001, 8250, 0x0406, 1}, {0x6000, 0x0421, 0x0407, 0}, {0x4001, 6140, 0x0406, 1}, {0x6000, 0x0423, 0x0407, 0}, {0x4001, 5510, 0x0406, 1}, {0x6000, 0x0425, 0x0408, 0}, {0x4001, 3180, 0x0406, 1}, {0x6000, 0x0427, 0x0407, 0}, {0x4001, 8450, 0x0406, 1}, {0x6000, 0x0429, 0x0408, 0}, {0x4001, -5090, 0x0406, 1}, {0x6000, 0x042b, 0x0407, 0}
};

const TextRectangle ACTION_BUTTON_RETURN_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_RETURN_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_RETURN(
  ACTION_BUTTON_RETURN_VERTICES, sizeof(ACTION_BUTTON_RETURN_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_RETURN_SEGMENTS, sizeof(ACTION_BUTTON_RETURN_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_RETURN_CALC, sizeof(ACTION_BUTTON_RETURN_CALC) / sizeof(Calculation),
  ACTION_BUTTON_RETURN_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_RETURN_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_RETURN_TRS, sizeof(ACTION_BUTTON_RETURN_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_DOCUMENT_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x10), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0x10), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x10), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0x12)}
};

const unsigned short ACTION_BUTTON_DOCUMENT_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0004, 0x6001, 0x8000, 0x4000, 0x0002, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_DOCUMENT_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -6350, 0x0406, 1}, {0x6000, 0x0409, 0x0407, 0}, {0x4001, -7830, 0x0406, 1}, {0x6000, 0x040b, 0x0408, 0}, {0x4001, 1690, 0x0406, 1}, {0x6000, 0x040d, 0x0407, 0}, {0x4001, 6350, 0x0406, 1}, {0x6000, 0x040f, 0x0407, 0}, {0x4001, -3810, 0x0406, 1}, {0x6000, 0x0411, 0x0408, 0}, {0x4001, 7830, 0x0406, 1}, {0x6000, 0x0413, 0x0408, 0}
};

const TextRectangle ACTION_BUTTON_DOCUMENT_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_DOCUMENT_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_DOCUMENT(
  ACTION_BUTTON_DOCUMENT_VERTICES, sizeof(ACTION_BUTTON_DOCUMENT_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_DOCUMENT_SEGMENTS, sizeof(ACTION_BUTTON_DOCUMENT_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_DOCUMENT_CALC, sizeof(ACTION_BUTTON_DOCUMENT_CALC) / sizeof(Calculation),
  ACTION_BUTTON_DOCUMENT_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_DOCUMENT_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_DOCUMENT_TRS, sizeof(ACTION_BUTTON_DOCUMENT_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_SOUND_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x10), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0x10), CALCULATED_VALUE(0x14)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x1a), CALCULATED_VALUE(8)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x1a), CALCULATED_VALUE(0x1c)}, {CALCULATED_VALUE(0x18), CALCULATED_VALUE(0x16)}, {CALCULATED_VALUE(0x1a), CALCULATED_VALUE(0x1e)}
};

const unsigned short ACTION_BUTTON_SOUND_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0005, 0x6001, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000, 0x4000, 0x0001, 0x8000
};

const Calculation ACTION_BUTTON_SOUND_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x0409, 0x0407, 0}, {0x4001, -2750, 0x0406, 1}, {0x6000, 0x040b, 0x0408, 0}, {0x4001, -2960, 0x0406, 1}, {0x6000, 0x040d, 0x0407, 0}, {0x4001, 2120, 0x0406, 1}, {0x6000, 0x040f, 0x0407, 0}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x0411, 0x0408, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x0413, 0x0408, 0}, {0x4001, 2750, 0x0406, 1}, {0x6000, 0x0415, 0x0408, 0}, {0x4001, 4020, 0x0406, 1}, {0x6000, 0x0417, 0x0407, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x0419, 0x0407, 0}, {0x4001, -5930, 0x0406, 1}, {0x6000, 0x041b, 0x0408, 0}, {0x4001, 5930, 0x0406, 1}, {0x6000, 0x041d, 0x0408, 0}
};

const TextRectangle ACTION_BUTTON_SOUND_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_SOUND_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_SOUND(
  ACTION_BUTTON_SOUND_VERTICES, sizeof(ACTION_BUTTON_SOUND_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_SOUND_SEGMENTS, sizeof(ACTION_BUTTON_SOUND_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_SOUND_CALC, sizeof(ACTION_BUTTON_SOUND_CALC) / sizeof(Calculation),
  ACTION_BUTTON_SOUND_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_SOUND_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_SOUND_TRS, sizeof(ACTION_BUTTON_SOUND_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const Vertex ACTION_BUTTON_MOVIE_VERTICES[] =
{
  {0, 0}, {21600, 0}, {21600, 21600}, {0, 21600}, {0, 0}, {21600, 0}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {21600, 0}, {21600, 21600}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(2)}, {21600, 21600}, {0, 21600}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)}, {0, 21600}, {0, 0}, {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(1), CALCULATED_VALUE(4)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0xc)}, {CALCULATED_VALUE(0x10), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0x14), CALCULATED_VALUE(0x12)}, {CALCULATED_VALUE(0x16), CALCULATED_VALUE(0x18)}, {CALCULATED_VALUE(0x16), CALCULATED_VALUE(0x1a)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0x1a)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(0x18)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(0x18)}, {CALCULATED_VALUE(0x20), CALCULATED_VALUE(0x22)}, {CALCULATED_VALUE(0x1e), CALCULATED_VALUE(0x22)}, {CALCULATED_VALUE(0x1c), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x16), CALCULATED_VALUE(0x24)}, {CALCULATED_VALUE(0x16), CALCULATED_VALUE(0x26)}, {CALCULATED_VALUE(0x2a), CALCULATED_VALUE(0x26)}, {CALCULATED_VALUE(0x2a), CALCULATED_VALUE(0x28)}, {CALCULATED_VALUE(0x10), CALCULATED_VALUE(0x28)}, {CALCULATED_VALUE(0xe), CALCULATED_VALUE(0x2c)}, {CALCULATED_VALUE(0xa), CALCULATED_VALUE(0x2c)}
};

const unsigned short ACTION_BUTTON_MOVIE_SEGMENTS[] =
{
  0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0003, 0x6001, 0x8000, 0x4000, 0x0012, 0x6001, 0x8000
};

const Calculation ACTION_BUTTON_MOVIE_CALC[] =
{
  {0x2000, PROP_ADJUST_VAL_FIRST, 0, 0}, {0x6000, PROP_GEO_LEFT, PROP_ADJUST_VAL_FIRST, 0}, {0x6000, PROP_GEO_TOP, PROP_ADJUST_VAL_FIRST, 0}, {0xa000, PROP_GEO_RIGHT, 0, PROP_ADJUST_VAL_FIRST}, {0xa000, PROP_GEO_BOTTOM, 0, PROP_ADJUST_VAL_FIRST}, {0x8000, 10800, 0, PROP_ADJUST_VAL_FIRST}, {0x2001, 0x0405, 1, 10800}, {0x2001, PROP_GEO_RIGHT, 1, 2}, {0x2001, PROP_GEO_BOTTOM, 1, 2}, {0x4001, -8050, 0x0406, 1}, {0x6000, 0x0409, 0x0407, 0}, {0x4001, -4020, 0x0406, 1}, {0x6000, 0x040b, 0x0408, 0}, {0x4001, -7000, 0x0406, 1}, {0x6000, 0x040d, 0x0407, 0}, {0x4001, -6560, 0x0406, 1}, {0x6000, 0x040f, 0x0407, 0}, {0x4001, -3600, 0x0406, 1}, {0x6000, 0x0411, 0x0408, 0}, {0x4001, 4020, 0x0406, 1}, {0x6000, 0x0413, 0x0407, 0}, {0x4001, 4660, 0x0406, 1}, {0x6000, 0x0415, 0x0407, 0}, {0x4001, -2960, 0x0406, 1}, {0x6000, 0x0417, 0x0408, 0}, {0x4001, -2330, 0x0406, 1}, {0x6000, 0x0419, 0x0408, 0}, {0x4001, 6780, 0x0406, 1}, {0x6000, 0x041b, 0x0407, 0}, {0x4001, 7200, 0x0406, 1}, {0x6000, 0x041d, 0x0407, 0}, {0x4001, 8050, 0x0406, 1}, {0x6000, 0x041f, 0x0407, 0}, {0x4001, 2960, 0x0406, 1}, {0x6000, 0x0421, 0x0408, 0}, {0x4001, 2330, 0x0406, 1}, {0x6000, 0x0423, 0x0408, 0}, {0x4001, 3800, 0x0406, 1}, {0x6000, 0x0425, 0x0408, 0}, {0x4001, -1060, 0x0406, 1}, {0x6000, 0x0427, 0x0408, 0}, {0x4001, -6350, 0x0406, 1}, {0x6000, 0x0429, 0x0407, 0}, {0x4001, -640, 0x0406, 1}, {0x6000, 0x042b, 0x0408, 0}
};

const TextRectangle ACTION_BUTTON_MOVIE_TRS[] =
{
  { {CALCULATED_VALUE(1), CALCULATED_VALUE(2)}, {CALCULATED_VALUE(3), CALCULATED_VALUE(4)} }
};

const int ACTION_BUTTON_MOVIE_DEFAULT_ADJUST[] =
{
  1400
};

const CustomShape CS_ACTION_BUTTON_MOVIE(
  ACTION_BUTTON_MOVIE_VERTICES, sizeof(ACTION_BUTTON_MOVIE_VERTICES) / sizeof(Vertex),
  ACTION_BUTTON_MOVIE_SEGMENTS, sizeof(ACTION_BUTTON_MOVIE_SEGMENTS) / sizeof(unsigned short),
  ACTION_BUTTON_MOVIE_CALC, sizeof(ACTION_BUTTON_MOVIE_CALC) / sizeof(Calculation),
  ACTION_BUTTON_MOVIE_DEFAULT_ADJUST, sizeof(ACTION_BUTTON_MOVIE_DEFAULT_ADJUST) / sizeof(int),
  ACTION_BUTTON_MOVIE_TRS, sizeof(ACTION_BUTTON_MOVIE_TRS) / sizeof(TextRectangle),
  21600, 21600,
  NULL, 0);

const CustomShape *libmspub::getCustomShape(ShapeType type)
{
  switch(type)
  {
  case RECTANGLE:
    return &CS_RECTANGLE;
  case ELLIPSE:
    return &CS_ELLIPSE;
  case ISOCELES_TRIANGLE:
    return &CS_ISOCELES_TRIANGLE;
  case SEAL_4:
    return &CS_SEAL_4;
  case PARALLELOGRAM:
    return &CS_PARALLELOGRAM;
  case RIGHT_TRIANGLE:
    return &CS_RIGHT_TRIANGLE;
  case DIAMOND:
    return &CS_DIAMOND;
  case TRAPEZOID:
    return &CS_TRAPEZOID;
  case HEXAGON:
    return &CS_HEXAGON;
  case STAR:
    return &CS_STAR;
  case PLUS:
    return &CS_PLUS;
  case ROUND_RECTANGLE:
    return &CS_ROUND_RECTANGLE;
  case OCTAGON:
    return &CS_OCTAGON;
  case ARROW:
    return &CS_ARROW;
  case HOME_PLATE:
    return &CS_HOME_PLATE;
  case CUBE:
    return &CS_CUBE;
  case BALLOON:
    return &CS_BALLOON;
  case ARC_SHAPE:
    return &CS_ARC;
  case PLAQUE:
    return &CS_PLAQUE;
  case CAN:
    return &CS_CAN;
  case DONUT:
    return &CS_DONUT;
  case TEXT_BOX:
  case TEXT_SIMPLE:
    return &CS_TEXT_SIMPLE;
  case STRAIGHT_CONNECTOR_1:
    return &CS_STRAIGHT_CONNECTOR_1;
  case BENT_CONNECTOR_2:
    return &CS_BENT_CONNECTOR_2;
  case BENT_CONNECTOR_3:
    return &CS_BENT_CONNECTOR_3;
  case BENT_CONNECTOR_4:
    return &CS_BENT_CONNECTOR_4;
  case BENT_CONNECTOR_5:
    return &CS_BENT_CONNECTOR_5;
  case CURVED_CONNECTOR_2:
    return &CS_CURVED_CONNECTOR_2;
  case CURVED_CONNECTOR_3:
    return &CS_CURVED_CONNECTOR_3;
  case CURVED_CONNECTOR_4:
    return &CS_CURVED_CONNECTOR_4;
  case CURVED_CONNECTOR_5:
    return &CS_CURVED_CONNECTOR_5;
  case CALLOUT_1:
    return &CS_CALLOUT_1;
  case CALLOUT_2:
    return &CS_CALLOUT_2;
  case CALLOUT_3:
    return &CS_CALLOUT_3;
  case RIBBON:
    return &CS_RIBBON;
  case RIBBON_2:
    return &CS_RIBBON_2;
  case CHEVRON:
    return &CS_CHEVRON;
  case PENTAGON:
    return &CS_PENTAGON;
  case NO_SMOKING:
    return &CS_NO_SMOKING;
  case SEAL_8:
    return &CS_SEAL_8;
  case SEAL_16:
    return &CS_SEAL_16;
  case SEAL_32:
    return &CS_SEAL_32;
  case WAVE:
    return &CS_WAVE;
  case LINE:
    return &CS_LINE;
  case FOLDED_CORNER:
    return &CS_FOLDED_CORNER;
  case LEFT_ARROW:
    return &CS_LEFT_ARROW;
  case DOWN_ARROW:
    return &CS_DOWN_ARROW;
  case UP_ARROW:
    return &CS_UP_ARROW;
  case LEFT_RIGHT_ARROW:
    return &CS_LEFT_RIGHT_ARROW;
  case UP_DOWN_ARROW:
    return &CS_UP_DOWN_ARROW;
  case IRREGULAR_SEAL_1:
    return &CS_IRREGULAR_SEAL_1;
  case IRREGULAR_SEAL_2:
    return &CS_IRREGULAR_SEAL_2;
  case LIGHTNING_BOLT:
    return &CS_LIGHTNING_BOLT;
  case HEART:
    return &CS_HEART;
  case PICTURE_FRAME:
    return NULL; //FIXME
  case QUAD_ARROW:
    return &CS_QUAD_ARROW;
  case BEVEL:
    return &CS_BEVEL;
  case LEFT_BRACKET:
    return &CS_LEFT_BRACKET;
  case RIGHT_BRACKET:
    return &CS_RIGHT_BRACKET;
  case LEFT_BRACE:
    return &CS_LEFT_BRACE;
  case RIGHT_BRACE:
    return &CS_RIGHT_BRACE;
  case LEFT_UP_ARROW:
    return &CS_LEFT_UP_ARROW;
  case BENT_UP_ARROW:
    return &CS_BENT_UP_ARROW;
  case BENT_ARROW:
    return &CS_BENT_ARROW;
  case SEAL_24:
    return &CS_SEAL_24;
  case STRIPED_RIGHT_ARROW:
    return &CS_STRIPED_RIGHT_ARROW;
  case NOTCHED_RIGHT_ARROW:
    return &CS_NOTCHED_RIGHT_ARROW;
  case BLOCK_ARC:
    return &CS_BLOCK_ARC;
  case SMILEY_FACE:
    return &CS_SMILEY_FACE;
  case VERTICAL_SCROLL:
    return &CS_VERTICAL_SCROLL;
  case HORIZONTAL_SCROLL:
    return &CS_HORIZONTAL_SCROLL;
  case CIRCULAR_ARROW:
    return &CS_CIRCULAR_ARROW;
  case U_TURN_ARROW:
    return &CS_U_TURN_ARROW;
  case CURVED_RIGHT_ARROW:
    return &CS_CURVED_RIGHT_ARROW;
  case CURVED_LEFT_ARROW:
    return &CS_CURVED_LEFT_ARROW;
  case CURVED_UP_ARROW:
    return &CS_CURVED_UP_ARROW;
  case CURVED_DOWN_ARROW:
    return &CS_CURVED_DOWN_ARROW;
  case FLOW_CHART_PROCESS:
    return &CS_FLOW_CHART_PROCESS;
  case FLOW_CHART_DECISION:
    return &CS_FLOW_CHART_DECISION;
  case FLOW_CHART_IO:
    return &CS_FLOW_CHART_IO;
  case FLOW_CHART_PREDEFINED_PROCESS:
    return &CS_FLOW_CHART_PREDEFINED_PROCESS;
  case FLOW_CHART_INTERNAL_STORAGE:
    return &CS_FLOW_CHART_INTERNAL_STORAGE;
  case FLOW_CHART_DOCUMENT:
    return &CS_FLOW_CHART_DOCUMENT;
  case FLOW_CHART_MULTI_DOCUMENT:
    return &CS_FLOW_CHART_MULTI_DOCUMENT;
  case FLOW_CHART_TERMINATOR:
    return &CS_FLOW_CHART_TERMINATOR;
  case FLOW_CHART_PREPARATION:
    return &CS_FLOW_CHART_PREPARATION;
  case FLOW_CHART_MANUAL_INPUT:
    return &CS_FLOW_CHART_MANUAL_INPUT;
  case FLOW_CHART_MANUAL_OPERATION:
    return &CS_FLOW_CHART_MANUAL_OPERATION;
  case FLOW_CHART_CONNECTOR:
    return &CS_FLOW_CHART_CONNECTOR;
  case FLOW_CHART_PUNCHED_CARD:
    return &CS_FLOW_CHART_PUNCHED_CARD;
  case FLOW_CHART_PUNCHED_TAPE:
    return &CS_FLOW_CHART_PUNCHED_TAPE;
  case FLOW_CHART_SUMMING_JUNCTION:
    return &CS_FLOW_CHART_SUMMING_JUNCTION;
  case FLOW_CHART_OR:
    return &CS_FLOW_CHART_OR;
  case FLOW_CHART_COLLATE:
    return &CS_FLOW_CHART_COLLATE;
  case FLOW_CHART_SORT:
    return &CS_FLOW_CHART_SORT;
  case FLOW_CHART_EXTRACT:
    return &CS_FLOW_CHART_EXTRACT;
  case FLOW_CHART_MERGE:
    return &CS_FLOW_CHART_MERGE;
  case FLOW_CHART_ONLINE_STORAGE:
    return &CS_FLOW_CHART_ONLINE_STORAGE;
  case FLOW_CHART_MAGNETIC_TAPE:
    return &CS_FLOW_CHART_MAGNETIC_TAPE;
  case FLOW_CHART_MAGNETIC_DISK:
    return &CS_FLOW_CHART_MAGNETIC_DISK;
  case FLOW_CHART_MAGNETIC_DRUM:
    return &CS_FLOW_CHART_MAGNETIC_DRUM;
  case FLOW_CHART_DISPLAY:
    return &CS_FLOW_CHART_DISPLAY;
  case FLOW_CHART_DELAY:
    return &CS_FLOW_CHART_DELAY;
  case TEXT_PLAIN_TEXT:
    return &CS_TEXT_PLAIN_TEXT;
  case TEXT_STOP:
    return &CS_TEXT_STOP;
  case TEXT_TRIANGLE:
    return &CS_TEXT_TRIANGLE;
  case TEXT_TRIANGLE_INVERTED:
    return &CS_TEXT_TRIANGLE_INVERTED;
  case TEXT_CHEVRON:
    return &CS_TEXT_CHEVRON;
  case TEXT_CHEVRON_INVERTED:
    return &CS_TEXT_CHEVRON_INVERTED;
  case TEXT_RING_OUTSIDE:
    return &CS_TEXT_RING_OUTSIDE;
  case TEXT_ARCH_UP_CURVE:
    return &CS_TEXT_ARCH_UP_CURVE;
  case TEXT_ARCH_DOWN_CURVE:
    return &CS_TEXT_ARCH_DOWN_CURVE;
  case TEXT_CIRCLE_CURVE:
    return &CS_TEXT_CIRCLE_CURVE;
  case TEXT_BUTTON_CURVE:
    return &CS_TEXT_BUTTON_CURVE;
  case TEXT_ARCH_UP_POUR:
    return &CS_TEXT_ARCH_UP_POUR;
  case TEXT_ARCH_DOWN_POUR:
    return &CS_TEXT_ARCH_DOWN_POUR;
  case TEXT_CIRCLE_POUR:
    return &CS_TEXT_CIRCLE_POUR;
  case TEXT_BUTTON_POUR:
    return &CS_TEXT_BUTTON_POUR;
  case TEXT_CURVE_UP:
    return &CS_TEXT_CURVE_UP;
  case TEXT_CURVE_DOWN:
    return &CS_TEXT_CURVE_DOWN;
  case TEXT_CASCADE_UP:
    return &CS_TEXT_CASCADE_UP;
  case TEXT_CASCADE_DOWN:
    return &CS_TEXT_CASCADE_DOWN;
  case TEXT_WAVE_1:
    return &CS_TEXT_WAVE_1;
  case TEXT_WAVE_2:
    return &CS_TEXT_WAVE_2;
  case TEXT_WAVE_3:
    return &CS_TEXT_WAVE_3;
  case TEXT_WAVE_4:
    return &CS_TEXT_WAVE_4;
  case TEXT_INFLATE:
    return &CS_TEXT_INFLATE;
  case TEXT_DEFLATE:
    return &CS_TEXT_DEFLATE;
  case TEXT_INFLATE_BOTTOM:
    return &CS_TEXT_INFLATE_BOTTOM;
  case TEXT_DEFLATE_BOTTOM:
    return &CS_TEXT_DEFLATE_BOTTOM;
  case TEXT_INFLATE_TOP:
    return &CS_TEXT_INFLATE_TOP;
  case TEXT_DEFLATE_TOP:
    return &CS_TEXT_DEFLATE_TOP;
  case TEXT_DEFLATE_INFLATE:
    return &CS_TEXT_DEFLATE_INFLATE;
  case TEXT_DEFLATE_INFLATE_DEFLATE: // great name
    return &CS_TEXT_DEFLATE_INFLATE_DEFLATE;
  case TEXT_FADE_RIGHT:
    return &CS_TEXT_FADE_RIGHT;
  case TEXT_FADE_LEFT:
    return &CS_TEXT_FADE_LEFT;
  case TEXT_FADE_UP:
    return &CS_TEXT_FADE_UP;
  case TEXT_FADE_DOWN:
    return &CS_TEXT_FADE_DOWN;
  case TEXT_SLANT_UP:
    return &CS_TEXT_SLANT_UP;
  case TEXT_SLANT_DOWN:
    return &CS_TEXT_SLANT_DOWN;
  case TEXT_CAN_UP:
    return &CS_TEXT_CAN_UP;
  case TEXT_CAN_DOWN:
    return &CS_TEXT_CAN_DOWN;
  case FLOW_CHART_ALTERNATE_PROCESS:
    return &CS_FLOW_CHART_ALTERNATE_PROCESS;
  case FLOW_CHART_OFFPAGE_CONNECTOR:
    return &CS_FLOW_CHART_OFFPAGE_CONNECTOR;
  case LEFT_RIGHT_UP_ARROW:
    return &CS_LEFT_RIGHT_UP_ARROW;
  case SUN:
    return &CS_SUN;
  case MOON:
    return &CS_MOON;
  case BRACKET_PAIR:
    return &CS_BRACKET_PAIR;
  case BRACE_PAIR:
    return &CS_BRACE_PAIR;
  case DOUBLE_WAVE:
    return &CS_DOUBLE_WAVE;
  case ACTION_BUTTON_BLANK:
    return &CS_ACTION_BUTTON_BLANK;
  case ACTION_BUTTON_HOME:
    return &CS_ACTION_BUTTON_HOME;
  case ACTION_BUTTON_HELP:
    return &CS_ACTION_BUTTON_HELP;
  case ACTION_BUTTON_INFORMATION:
    return &CS_ACTION_BUTTON_INFORMATION;
  case ACTION_BUTTON_FORWARD_NEXT:
    return &CS_ACTION_BUTTON_FORWARD_NEXT;
  case ACTION_BUTTON_BACK_PREVIOUS:
    return &CS_ACTION_BUTTON_BACK_PREVIOUS;
  case ACTION_BUTTON_END:
    return &CS_ACTION_BUTTON_END;
  case ACTION_BUTTON_BEGINNING:
    return &CS_ACTION_BUTTON_BEGINNING;
  case ACTION_BUTTON_RETURN:
    return &CS_ACTION_BUTTON_RETURN;
  case ACTION_BUTTON_DOCUMENT:
    return &CS_ACTION_BUTTON_DOCUMENT;
  case ACTION_BUTTON_SOUND:
    return &CS_ACTION_BUTTON_SOUND;
  case ACTION_BUTTON_MOVIE:
    return &CS_ACTION_BUTTON_MOVIE;
  default:
    return NULL;
  }
}

enum Command
{
  MOVETO,
  LINETO,
  CURVETO,
  NOFILL,
  NOSTROKE,
  ANGLEELLIPSE,
  CLOSESUBPATH,
  ARCTO,
  ARC,
  CLOCKWISEARCTO,
  CLOCKWISEARC,
  ENDSUBPATH,
  ELLIPTICALQUADRANTX,
  ELLIPTICALQUADRANTY
};

struct ShapeElementCommand
{
  Command m_command;
  unsigned char m_count;
  ShapeElementCommand(Command command, unsigned char count) : m_command(command), m_count(count) { }
};

ShapeElementCommand getCommandFromBinary(unsigned short binary)
{
  Command cmd;
  unsigned count = 0;
  switch(binary >> 8)
  {
  case 0xAA:
    cmd = NOFILL;
    break;
  case 0xAB:
    cmd = NOSTROKE;
    break;
  case 0xAD:
  case 0xB3:
  case 0x20:
  case 0xAF:
    cmd = CURVETO;
    count = (binary & 0xFF);
    break;
  case 0xA2:
    cmd = ANGLEELLIPSE;
    count = (binary & 0xFF) / 3;
    break;
  case 0xA3:
    cmd = ARCTO;
    count = (binary & 0xFF) / 4;
    break;
  case 0xA4:
    cmd = ARC;
    count = (binary & 0xFF) / 4;
    break;
  case 0xA5:
    cmd = CLOCKWISEARCTO;
    count = (binary & 0xFF) / 4;
    break;
  case 0xA6:
    cmd = CLOCKWISEARC;
    count = (binary & 0xFF) / 4;
    break;
  case 0xA7:
    cmd = ELLIPTICALQUADRANTX;
    count = (binary & 0xFF);
    break;
  case 0xA8:
    cmd = ELLIPTICALQUADRANTY;
    count = (binary & 0xFF);
    break;
  case 0xAC:
  case 0xAE:
  case 0x0:
    cmd = LINETO;
    count = (binary & 0xFF);
    break;
  case 0x40:
    cmd = MOVETO;
    count = (binary & 0xFF);
    count = count ? count : 1;
    break;
  case 0x60:
    cmd = CLOSESUBPATH;
    break;
  case 0x80:
    cmd = ENDSUBPATH;
    break;
  default:
    MSPUB_DEBUG_MSG(("unknown segment command 0x%x\n", binary >> 8));
    cmd = MOVETO;
    count = 1;
    break;
  }
  return ShapeElementCommand(cmd, count);
}

double getSpecialIfNecessary(boost::function<double (unsigned index)> calculator, int val)
{
  bool special = val & 0x80000000;
  return special ? calculator(val ^ 0x80000000) : val;
}

Coordinate libmspub::CustomShape::getTextRectangle(double x, double y, double width, double height, boost::function<double (unsigned index)> calculator) const
{
  double scaleX = width * m_coordWidth;
  double scaleY = height * m_coordHeight;
  if (m_numTextRectangles == 0)
  {
    return Coordinate(x, y, x + width, y + height);
  }
  const Vertex &start = mp_textRectangles[0].first;
  const Vertex &end = mp_textRectangles[0].second;
  double startX = x + scaleX * getSpecialIfNecessary(calculator, start.m_x);
  double startY = y + scaleY * getSpecialIfNecessary(calculator, start.m_y);
  double endX = x + scaleX * getSpecialIfNecessary(calculator, end.m_x);
  double endY = y + scaleY * getSpecialIfNecessary(calculator, end.m_y);
  return Coordinate(startX, startY, endX, endY);
}

struct LineInfo
{
  WPXPropertyListVector m_vertices;
  double m_width;
  WPXString m_color;
  bool m_lineExists;
  LineInfo(WPXPropertyListVector vertices, Line current, std::vector<Color> palette) : m_vertices(vertices),
    m_width((double)(current.m_widthInEmu) / EMUS_IN_INCH),
    m_color(libmspub::MSPUBCollector::getColorString(current.m_color.getFinalColor(palette))),
    m_lineExists(current.m_lineExists) { }
  void output(libwpg::WPGPaintInterface *painter, WPXPropertyList &graphicsProps)
  {
    graphicsProps.insert("draw:stroke", m_lineExists ? "solid" : "none");
    graphicsProps.insert("svg:stroke-width", m_width);
    graphicsProps.insert("svg:stroke-color", m_color);
    painter->setStyle(graphicsProps, WPXPropertyListVector());
    painter->drawPolyline(m_vertices);
  }
private:
};

void drawEmulatedLine(boost::shared_ptr<const CustomShape> shape, ShapeType shapeType, const std::vector<Line> &lines,
                      Vector2D center, VectorTransformation2D transform,
                      double x, double y, double scaleX, double scaleY,
                      bool drawStroke, WPXPropertyList &graphicsProps, libwpg::WPGPaintInterface *painter,
                      boost::function<double (unsigned index)> calculator,
                      const std::vector<Color> &palette)
{
  std::vector<LineInfo> lineInfos;
  unsigned i_line = 0;
  bool rectangle = isShapeTypeRectangle(shapeType) && !lines.empty(); // ugly HACK: special handling for rectangle outlines.
  Vector2D vector(0, 0);
  Vector2D old(0, 0);
  for (unsigned i = 0; i < shape->m_numVertices; ++i)
  {
    WPXPropertyListVector vertices;
    WPXPropertyList vertex;
    if (i > 0)
    {
      WPXPropertyList vertexStart;
      double lineWidth = (double)(lines[i_line].m_widthInEmu) / EMUS_IN_INCH;
      switch (i - 1) // fudge the lines inward by half their width so they are fully inside the shape and hence proper borders
      {
      case 0:
        old.m_y += lineWidth / 2;
        break;
      case 1:
        old.m_x -= lineWidth / 2;
        break;
      case 2:
        old.m_y -= lineWidth / 2;
        break;
      case 3:
        old.m_x += lineWidth / 2;
        break;
      }
      old = transform.transformWithOrigin(old, center);
      vertexStart.insert("svg:x", old.m_x);
      vertexStart.insert("svg:y", old.m_y);
      vertices.append(vertexStart);
    }
    vector.m_x = x + scaleX * getSpecialIfNecessary(calculator, shape->mp_vertices[i].m_x);
    vector.m_y = y + scaleY * getSpecialIfNecessary(calculator, shape->mp_vertices[i].m_y);
    old = vector;
    if (rectangle)
    {
      double lineWidth = (double)(lines[i_line].m_widthInEmu) / EMUS_IN_INCH;
      switch (i) // fudge the lines inward by half their width so they are fully inside the shape and hence proper borders
      {
      case 1:
        vector.m_y += lineWidth / 2;
        break;
      case 2:
        vector.m_x -= lineWidth / 2;
        break;
      case 3:
        vector.m_y -= lineWidth / 2;
        break;
      case 4:
        vector.m_x += lineWidth / 2;
        break;
      }
    }
    vector = transform.transformWithOrigin(vector, center);
    vertex.insert("svg:x", vector.m_x);
    vertex.insert("svg:y", vector.m_y);
    vertices.append(vertex);
    if (i > 0)
    {
      lineInfos.push_back(LineInfo(vertices, lines[i_line], palette));
      if (drawStroke)
      {
        if (i_line + 1 < lines.size()) // continue using the last element if we run out of lines.
        {
          ++i_line;
        }
      }
    }
  }
  if (rectangle)
  {
    LineInfo *top = &lineInfos[0];
    LineInfo *right = (lineInfos.size() > 1) ? &lineInfos[1] : NULL;
    LineInfo *bottom = (lineInfos.size() > 2) ? &lineInfos[2] : NULL;
    LineInfo *left = (lineInfos.size() > 3) ? &lineInfos[3] : NULL;
    if (left)
    {
      left->output(painter, graphicsProps);
    }
    if (right)
    {
      right->output(painter, graphicsProps);
    }
    if (top)
    {
      top->output(painter, graphicsProps);
    }
    if (bottom)
    {
      bottom->output(painter, graphicsProps);
    }
  }
  else
  {
    for (unsigned i = 0; i < lineInfos.size(); ++i)
    {
      lineInfos[i].output(painter, graphicsProps);
    }
  }
}

void getRayEllipseIntersection(double initX, double initY, double rx, double ry, double cx, double cy, double &xOut, double &yOut)
{
  double x = initX - cx;
  double y = initY - cy;
  if (x != 0 && y != 0)
  {
    xOut = rx * ry / sqrt(ry * ry + rx * rx * (y / x) * (y / x));
    if (x < 0)
    {
      xOut *= -1;
    }
    yOut = xOut * y / x;
  }
  else if (y != 0)
  {
    xOut = 0;
    if (y > 0)
    {
      yOut = ry;
    }
    else
    {
      yOut = -ry;
    }
  }
  else if (x != 0)
  {
    yOut = 0;
    if (x > 0)
    {
      xOut = rx;
    }
    else
    {
      xOut = -rx;
    }
  }
  else
  {
    xOut = yOut = 0;
  }
  xOut += cx;
  yOut += cy;
}

void libmspub::writeCustomShape(ShapeType shapeType, WPXPropertyList &graphicsProps, libwpg::WPGPaintInterface *painter, double x, double y, double height, double width, bool closeEverything, VectorTransformation2D transform, std::vector<Line> lines, boost::function<double(unsigned index)> calculator, const std::vector<Color> &palette, boost::shared_ptr<const CustomShape> shape)
{
  MSPUB_DEBUG_MSG(("***STARTING CUSTOM SHAPE***\n"));
  if (!shape)
  {
    return;
  }
  bool drawStroke = !lines.empty();
  bool horizontal = height == 0;
  bool vertical = width == 0;
  if (horizontal && vertical)
  {
    return;
  }
  Vector2D center(x + width / 2, y + height / 2);
  double scaleX = width / shape->m_coordWidth;
  double scaleY = height / shape->m_coordHeight;
  bool allLinesSame = true;
  for (unsigned i = 0; allLinesSame && i + 1< lines.size(); ++i)
  {
    const Line &l1 = lines[i];
    const Line &l2 = lines[i + 1];
    allLinesSame = l1 == l2;
  }
  if (shape->mp_elements == NULL)
  {
    bool shouldDrawShape = true;
    if ((!graphicsProps["draw:fill"]) || (graphicsProps["draw:fill"]->getStr() == "none"))
    {
      if (!allLinesSame)
      {
        drawEmulatedLine(shape, shapeType, lines, center, transform,
                         x, y, scaleX, scaleY, drawStroke, graphicsProps, painter, calculator, palette);
        shouldDrawShape = false;
      }
      else if (drawStroke)
      {
        Line &first = lines[0];
        if (!first.m_lineExists)
        {
          graphicsProps.insert("draw:stroke", "none");
        }
        graphicsProps.insert("svg:stroke-width", (double)(first.m_widthInEmu) / EMUS_IN_INCH);
        graphicsProps.insert("svg:stroke-color", libmspub::MSPUBCollector::getColorString(first.m_color.getFinalColor(palette)));
        painter->setStyle(graphicsProps, WPXPropertyListVector());
      }
    }
    if (shouldDrawShape)
    {
      WPXPropertyListVector vertices;
      for (unsigned i = 0; i < shape->m_numVertices; ++i)
      {
        WPXPropertyList vertex;
        Vector2D vector(x + scaleX * getSpecialIfNecessary(calculator, shape->mp_vertices[i].m_x),
                        y + scaleY * getSpecialIfNecessary(calculator, shape->mp_vertices[i].m_y));
        vector = transform.transformWithOrigin(vector, center);
        vertex.insert("svg:x", vector.m_x);
        vertex.insert("svg:y", vector.m_y);
        vertices.append(vertex);
      }
      painter->drawPolygon(vertices);
    }
  }
  else
  {
    WPXPropertyListVector vertices;
    if (drawStroke)
    {
      // don't bother with different strokes for things defined by segments
      Line &first = lines[0];
      if (!first.m_lineExists)
      {
        graphicsProps.insert("draw:stroke", "none");
      }
      graphicsProps.insert("svg:stroke-width", (double)(first.m_widthInEmu) / EMUS_IN_INCH);
      graphicsProps.insert("svg:stroke-color", libmspub::MSPUBCollector::getColorString(first.m_color.getFinalColor(palette)));
      painter->setStyle(graphicsProps, WPXPropertyListVector());
    }
    unsigned vertexIndex = 0;
    bool hasUnclosedElements = false;
    boost::optional<Vector2D> lastPoint;
    // Escher assigns segments into subpaths somewhat differently than SVG does,
    // so we have to keep track of the following, rather than just adding a 'Z'
    // directive on path close and expecting everything to work.
    boost::optional<Vector2D> pathBegin;
    for (unsigned i = 0; i < shape->m_numElements; ++i)
    {
      ShapeElementCommand cmd = getCommandFromBinary(shape->mp_elements[i]);
      switch (cmd.m_command)
      {
      case ELLIPTICALQUADRANTX:
      case ELLIPTICALQUADRANTY:
      {
        if (cmd.m_command == ELLIPTICALQUADRANTX)
        {
          MSPUB_DEBUG_MSG(("ELLIPTICALQUADRANTX %d\n", cmd.m_count));
        }
        else
        {
          MSPUB_DEBUG_MSG(("ELLIPTICALQUADRANTY %d\n", cmd.m_count));
        }
        bool firstDirection = true;
        for (unsigned j = 0; (j < cmd.m_count) && (vertexIndex < shape->m_numVertices); ++j, ++vertexIndex)
        {
          bool modifier = cmd.m_command == ELLIPTICALQUADRANTX ? true : false;
          const Vertex &curr = shape->mp_vertices[vertexIndex];
          Vector2D curr2D(x + scaleX * getSpecialIfNecessary(calculator, curr.m_x), y + scaleY * getSpecialIfNecessary(calculator, curr.m_y));
          if (lastPoint.is_initialized())
          {
            if (!pathBegin.is_initialized())
            {
              pathBegin = curr2D;
            }
            hasUnclosedElements = true;
            double prevX = lastPoint.get().m_x;
            double prevY = lastPoint.get().m_y;
            double tmpX = curr2D.m_x - prevX;
            double tmpY = curr2D.m_y - prevY;
            if ((tmpX < 0 && tmpY >= 0) || (tmpX >= 0 && tmpY < 0))
            {
              if (j == 0)
              {
                firstDirection = true;
              }
              else if (! firstDirection)
              {
                modifier = !modifier;
              }
            }
            else
            {
              if (j == 0)
              {
                firstDirection = false;
              }
              else if (firstDirection)
              {
                modifier = !modifier;
              }
            }
            if (modifier)
            {
              tmpX = curr2D.m_x;
              tmpY = prevY;
            }
            else
            {
              tmpX = prevX;
              tmpY = curr2D.m_y;
            }
            double vecX = (tmpX - prevX) / 2;
            double vecY = (tmpY - prevY) / 2;
            Vector2D vec1(prevX + vecX, prevY + vecY);
            vecX = (tmpX - curr2D.m_x) / 2;
            vecY = (tmpY - curr2D.m_y) / 2;
            Vector2D vec2(curr2D.m_x + vecX, curr2D.m_y + vecY);
            vec1 = transform.transformWithOrigin(vec1, center);
            vec2 = transform.transformWithOrigin(vec2, center);
            curr2D = transform.transformWithOrigin(curr2D, center);
            WPXPropertyList bezier;
            bezier.insert("libwpg:path-action", "C");
            bezier.insert("svg:x1", vec1.m_x);
            bezier.insert("svg:x2", vec2.m_x);
            bezier.insert("svg:y1", vec1.m_y);
            bezier.insert("svg:y2", vec2.m_y);
            bezier.insert("svg:x", curr2D.m_x);
            bezier.insert("svg:y", curr2D.m_y);
            vertices.append(bezier);
          }
          else
          {
            //something is broken, just move
            if (vertexIndex < shape->m_numVertices)
            {
              WPXPropertyList moveVertex;
              if (hasUnclosedElements && closeEverything)
              {
                WPXPropertyList closeVertex;
                closeVertex.insert("libwpg:path-action", "Z");
                vertices.append(closeVertex);
              }
              hasUnclosedElements = false;
              Vector2D new_(x + scaleX * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_x), y + scaleY * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_y));
              new_ = transform.transformWithOrigin(new_, center);
              moveVertex.insert("svg:x", new_.m_x);
              moveVertex.insert("svg:y", new_.m_y);
              moveVertex.insert("libwpg:path-action", "M");
              vertices.append(moveVertex);
              ++vertexIndex;
            }
          }
        }
      }
      break;
      case CLOCKWISEARCTO:
      case CLOCKWISEARC:
      case ARCTO:
      case ARC:
        switch (cmd.m_command)
        {
        case CLOCKWISEARCTO:
          MSPUB_DEBUG_MSG(("CLOCKWISEARCTO %d\n", cmd.m_count));
          break;
        case CLOCKWISEARC:
          MSPUB_DEBUG_MSG(("CLOCKWISEARC %d\n", cmd.m_count));
          break;
        case ARCTO:
          MSPUB_DEBUG_MSG(("ARCTO %d\n", cmd.m_count));
          break;
        case ARC:
          MSPUB_DEBUG_MSG(("ARC %d\n", cmd.m_count));
          break;
        default:
          break;
        }
        for (unsigned j = 0; (j < cmd.m_count) && (vertexIndex + 3 < shape->m_numVertices); ++j, vertexIndex += 4)
        {
          for (unsigned k = 0; k < 4; ++k)
          {
            MSPUB_DEBUG_MSG(("Calculated vertex x: %f, y: %f\n", getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex + k].m_x), getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex + k].m_y)));
          }
          bool to = cmd.m_command == CLOCKWISEARCTO || cmd.m_command == ARCTO;
          bool clockwise = cmd.m_command == CLOCKWISEARCTO || cmd.m_command == CLOCKWISEARC;
          const Vertex &bound1 = shape->mp_vertices[vertexIndex];
          const Vertex &bound2 = shape->mp_vertices[vertexIndex + 1];
          const Vertex &start  = shape->mp_vertices[vertexIndex + 2];
          const Vertex &end    = shape->mp_vertices[vertexIndex + 3];

          double bound1X = x + scaleX * getSpecialIfNecessary(calculator, bound1.m_x);
          double bound1Y = y + scaleY * getSpecialIfNecessary(calculator, bound1.m_y);
          double bound2X = x + scaleX * getSpecialIfNecessary(calculator, bound2.m_x);
          double bound2Y = y + scaleY * getSpecialIfNecessary(calculator, bound2.m_y);
          double rx = fabs(bound1X - bound2X) / 2;
          double ry = fabs(bound1Y - bound2Y) / 2;
          double cx = (bound1X + bound2X) / 2;
          double cy = (bound1Y + bound2Y) / 2;
          double startX = x + scaleX * getSpecialIfNecessary(calculator, start.m_x);
          double startY = y + scaleY * getSpecialIfNecessary(calculator, start.m_y);
          double endX = x + scaleX * getSpecialIfNecessary(calculator, end.m_x);
          double endY = y + scaleY * getSpecialIfNecessary(calculator, end.m_y);
          getRayEllipseIntersection(startX, startY, rx, ry, cx, cy, startX, startY);
          getRayEllipseIntersection(endX, endY, rx, ry, cx, cy, endX, endY);
          Vector2D start2D(startX, startY);
          if (!pathBegin.is_initialized())
          {
            pathBegin = start2D;
          }
          start2D = transform.transformWithOrigin(start2D, center);
          Vector2D end2D(endX, endY);
          lastPoint = end2D;
          end2D = transform.transformWithOrigin(end2D, center);
          bool clockwiseAfterTransform = clockwise ^ transform.orientationReversing();
          WPXPropertyList startVertex;
          startVertex.insert("svg:x", start2D.m_x);
          startVertex.insert("svg:y", start2D.m_y);
          startVertex.insert("libwpg:path-action", ((to || closeEverything) && hasUnclosedElements) ? "L" : "M");
          vertices.append(startVertex);
          double startAngle = atan2(cy - startY, startX - cx);
          double endAngle = atan2(cy -endY, endX - cx);
          double angleDifference = clockwise ? doubleModulo(startAngle - endAngle, 2 * M_PI)
                                   : doubleModulo(endAngle - startAngle, 2 * M_PI);
          // don't worry about corner cases; the closer an arc gets to pi radians, the
          // less difference there is between the large and small arcs, down to no difference at all
          // for an exact 180-degree arc.
          bool largeArc = angleDifference >= M_PI;
          WPXPropertyList ellipseVertex;
          ellipseVertex.insert("svg:x", end2D.m_x);
          ellipseVertex.insert("svg:y", end2D.m_y);
          // The next two lines won't work if "transform" stretches the shape.
          // Since currently the only transforms are flips and rotations, this isn't a problem now,
          // but keep it in mind if we ever change how this code works, since it breaks abstraction.
          ellipseVertex.insert("svg:rx", rx);
          ellipseVertex.insert("svg:ry", ry);
          ellipseVertex.insert("libwpg:large-arc", largeArc ? 1 : 0);
          ellipseVertex.insert("libwpg:sweep", clockwiseAfterTransform ? 1 : 0);
          ellipseVertex.insert("libwpg:rotate", -transform.getRotation());
          ellipseVertex.insert("libwpg:path-action", "A");
          vertices.append(ellipseVertex);
          hasUnclosedElements = true;
        }
        break;

      case ANGLEELLIPSE:
        MSPUB_DEBUG_MSG(("ANGLEELLIPSE %d\n", cmd.m_count));
        for (unsigned j = 0; (j < cmd.m_count) && (vertexIndex + 2 < shape->m_numVertices); ++j, vertexIndex += 3)
        {
          hasUnclosedElements = true;
          WPXPropertyList vertex;
          double startAngle = getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex + 2].m_x);
          double endAngle = getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex + 2].m_y);
          double cx = x + scaleX * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_x);
          double cy = y + scaleY * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_y);
          double rx = scaleX * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex + 1].m_x);
          double ry = scaleY * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex + 1].m_y);

          // FIXME: Are angles supposed to be the actual angle of the point with the x-axis,
          // or the eccentric anomaly, or something else?
          //
          // assuming eccentric anomaly for now
          WPXPropertyList moveVertex;
          Vector2D start(cx + rx * cos(startAngle * M_PI / 180),
                         cy + ry * sin(startAngle * M_PI / 180));
          if (!pathBegin.is_initialized())
          {
            pathBegin = start;
          }
          start = transform.transformWithOrigin(start, center);
          moveVertex.insert("libwpg:path-action", "M");
          moveVertex.insert("svg:x", start.m_x);
          moveVertex.insert("svg:y", start.m_y);
          vertices.append(moveVertex);
          Vector2D half(cx + rx * cos(endAngle * M_PI / 360),
                        cy + ry * sin(endAngle * M_PI / 360));
          half = transform.transformWithOrigin(half, center);
          WPXPropertyList halfVertex;
          halfVertex.insert("libwpg:path-action", "A");
          halfVertex.insert("svg:x", half.m_x);
          halfVertex.insert("svg:y", half.m_y);
          halfVertex.insert("svg:rx", rx * transform.getHorizontalScaling());
          halfVertex.insert("svg:ry", ry * transform.getVerticalScaling());
          halfVertex.insert("libwpg:rotate", transform.getRotation() * 180 / M_PI);
          vertices.append(halfVertex);
          Vector2D end(cx + rx * cos(endAngle * M_PI / 180),
                       cy + ry * sin(endAngle * M_PI / 180));
          lastPoint = end;
          end = transform.transformWithOrigin(end, center);
          vertex.insert("svg:x", end.m_x);
          vertex.insert("svg:y", end.m_y);
          vertex.insert("svg:rx", rx);
          vertex.insert("svg:ry", ry);
          vertex.insert("libwpg:rotate", transform.getRotation() * 180 / M_PI);
          vertex.insert("libwpg:path-action", "A");
          vertices.append(vertex);
        }
        break;
      case MOVETO:
        MSPUB_DEBUG_MSG(("MOVETO %d\n", cmd.m_count));
        for (unsigned j = 0; (j < cmd.m_count) && (vertexIndex < shape->m_numVertices); ++j, ++vertexIndex)
        {
          MSPUB_DEBUG_MSG(("x: %f, y: %f\n", getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_x), getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_y)));
          if (hasUnclosedElements && closeEverything)
          {
            WPXPropertyList closeVertex;
            closeVertex.insert("libwpg:path-action", "Z");
            vertices.append(closeVertex);
          }
          hasUnclosedElements = false;
          WPXPropertyList moveVertex;
          Vector2D new_(x + scaleX * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_x),
                        y + scaleY * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_y));
          pathBegin = new_;
          lastPoint = new_;
          new_ = transform.transformWithOrigin(new_, center);
          moveVertex.insert("svg:x", new_.m_x);
          moveVertex.insert("svg:y", new_.m_y);
          moveVertex.insert("libwpg:path-action", "M");
          vertices.append(moveVertex);
        }
        break;
      case LINETO:
        MSPUB_DEBUG_MSG(("LINETO %d\n", cmd.m_count));
        for (unsigned j = 0; (j < cmd.m_count) && (vertexIndex < shape->m_numVertices); ++j, ++vertexIndex)
        {
          MSPUB_DEBUG_MSG(("x: %f, y: %f\n", getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_x), getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_y)));
          hasUnclosedElements = true;
          WPXPropertyList vertex;
          Vector2D vector(x + scaleX * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_x),
                          y + scaleY * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_y));
          lastPoint = vector;
          vector = transform.transformWithOrigin(vector, center);
          vertex.insert("svg:x", vector.m_x);
          vertex.insert("svg:y", vector.m_y);
          vertex.insert("libwpg:path-action", "L");
          vertices.append(vertex);
        }
        break;
      case CURVETO:
        MSPUB_DEBUG_MSG(("CURVETO %d\n", cmd.m_count));
        for (unsigned j = 0; (j < cmd.m_count) && (vertexIndex + 2 < shape->m_numVertices); ++j, vertexIndex += 3)
        {
          hasUnclosedElements = true;
          Vector2D firstCtrl(x + scaleX * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_x),
                             y + scaleY * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex].m_y));
          firstCtrl = transform.transformWithOrigin(firstCtrl, center);
          Vector2D secondCtrl(x + scaleX * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex + 1].m_x),
                              y + scaleY * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex + 1].m_y));
          secondCtrl = transform.transformWithOrigin(secondCtrl, center);
          Vector2D end( x + scaleX * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex + 2].m_x),
                        y + scaleY * getSpecialIfNecessary(calculator, shape->mp_vertices[vertexIndex + 2].m_y));
          lastPoint = end;
          end = transform.transformWithOrigin(end, center);
          WPXPropertyList bezier;
          bezier.insert("libwpg:path-action", "C");
          bezier.insert("svg:x1", firstCtrl.m_x);
          bezier.insert("svg:x2", secondCtrl.m_x);
          bezier.insert("svg:y1", firstCtrl.m_y);
          bezier.insert("svg:y2", secondCtrl.m_y);
          bezier.insert("svg:x", end.m_x);
          bezier.insert("svg:y", end.m_y);
          vertices.append(bezier);
        }
        break;
      case CLOSESUBPATH:
      {
        MSPUB_DEBUG_MSG(("CLOSESUBPATH\n"));
        if (!pathBegin.is_initialized())
        {
          MSPUB_DEBUG_MSG(("Tried to close a subpath that hadn't yet begun!\n"));
        }
        else if (closeEverything)
        {
          WPXPropertyList end;
          end.insert("libwpg:path-action", "Z");
          vertices.append(end);
        }
        else
        {
          WPXPropertyList end;
          end.insert("libwpg:path-action", "L");
          Vector2D transformedPathBegin = transform.transformWithOrigin(pathBegin.get(), center);
          end.insert("svg:x", transformedPathBegin.m_x);
          end.insert("svg:y", transformedPathBegin.m_y);
          vertices.append(end);
        }
        hasUnclosedElements = false;
      }
      //intentionally no break
      case ENDSUBPATH:
        MSPUB_DEBUG_MSG(("ENDSUBPATH\n"));
        if (closeEverything && pathBegin.is_initialized())
        {
          WPXPropertyList end;
          end.insert("libwpg:path-action", "Z");
          vertices.append(end);
        }
        pathBegin = boost::optional<Vector2D>();
        break;
      case NOFILL:
        MSPUB_DEBUG_MSG(("NOFILL (ignored)\n"));
        break;
      case NOSTROKE:
        MSPUB_DEBUG_MSG(("NOSTROKE (ignored)\n"));
        break;
      default:
        MSPUB_DEBUG_MSG(("Unknown custom shape command %d\n", cmd.m_command));
        break;
      }
    }
    if (hasUnclosedElements && closeEverything)
    {
      if (pathBegin.is_initialized())
      {
        WPXPropertyList end;
        end.insert("libwpg:path-action", "Z");
        vertices.append(end);
      }
    }
    painter->drawPath(vertices);
  }
}

bool libmspub::isShapeTypeRectangle(ShapeType type)
{
  return type == RECTANGLE || type == TEXT_BOX;
}


boost::shared_ptr<const libmspub::CustomShape> libmspub::getFromDynamicCustomShape(const libmspub::DynamicCustomShape &dcs)
{
  return boost::shared_ptr<const CustomShape>(new CustomShape(
           dcs.m_vertices.empty() ? NULL : &dcs.m_vertices[0],
           dcs.m_vertices.size(),
           dcs.m_elements.empty() ? NULL : &dcs.m_elements[0],
           dcs.m_elements.size(),
           dcs.m_calculations.empty() ? NULL : &dcs.m_calculations[0],
           dcs.m_calculations.size(),
           dcs.m_defaultAdjustValues.empty() ? NULL :
           &dcs.m_defaultAdjustValues[0],
           dcs.m_defaultAdjustValues.size(),
           dcs.m_textRectangles.empty() ? NULL : &dcs.m_textRectangles[0],
           dcs.m_textRectangles.size(),
           dcs.m_coordWidth, dcs.m_coordHeight,
           dcs.m_gluePoints.empty() ? NULL : &dcs.m_gluePoints[0],
           dcs.m_gluePoints.size(),
           dcs.m_adjustShiftMask
         ));
}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
