%define name libmspub
%define version 0.0.3
%define RELEASE 1
%define release     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Name: %{name}
Summary: Library for importing and converting Microsoft Publisher Documents
Version: %{version}
Release: %{release}
Source: %{name}-%{version}.tar.gz
Group: System Environment/Libraries
URL: http://libmspub.sf.net/
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot
BuildRequires: libwpd-devel >= 0.9.0, gcc-c++, libstdc++-devel, pkgconfig >= 0.9.0
License: LGPL
Prefix: %{prefix}

%description
libmspub is a library for reading and converting MSPUB images

%package tools
Requires: libmspub
Summary: Tools to convert MSPUB images into other formats
Group: Applications/Publishing

%description tools
Tools to convert MSPUB images into other formats.
Currently supported: raw svg

%package devel
Requires: %{name} >= %{version}
Requires: libwpd-devel >= 0.9.0
Summary: Files for developing with libmspub.
Group: Development/Libraries

%description devel
Includes and definitions for developing with libmspub.

%if %{!?_without_docs:1}%{?_without_docs:0}
%package docs
Requires: %{name} >= %{version}
BuildRequires: doxygen
Summary: Documentation of libmspub API
Group: Development/Documentation

%description docs
Documentation of libmspub API for developing with libmspub
%endif

%prep
%__rm -rf $RPM_BUILD_ROOT

%setup -q -n %{name}-%{version}

%build
%configure --prefix=%{_prefix} --libdir=%{_libdir} \
        %{?_with_debug:--enable-debug}  \

%__make

%install
umask 022

%__make DESTDIR=$RPM_BUILD_ROOT install
%__rm -rf $RPM_BUILD_ROOT/%{_libdir}/libmspub*.la

%clean
%__rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/file.list.%{name}

%files
%defattr(644,root,root,755)
%{_libdir}/libmspub*.so.*
%doc ChangeLog README COPYING AUTHORS

%files tools
%defattr(755,root,root,755)
%{_bindir}/pub2*

%files devel
%defattr(644,root,root,755)
%{_libdir}/libmspub*.so
%{_libdir}/pkgconfig/libmspub*.pc
%{_includedir}/libmspub-0.0/libmspub

%if %{!?_without_docs:1}%{?_without_docs:0}
%files docs
%{_datadir}/*
%endif

%changelog
* Fri Apr 20 2007 Fridrich Strba <fridrich.strba@bluewin.ch>
- Add documentation packaging
- Make doc and stream optional

* Tue Jan 27 2004 Fridrich Strba <fridrich.strba@bluewin.ch>
- Create rpm spec according to the rpm spec of libwpD
- of Rui M. Seabra
