/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QApplication>
#include <QDeclarativeView>
#include <QDeclarativeContext>

#include "bamf-matcher.h"

int main(int argc, char *argv[])
{
    QApplication application(argc, argv);

    BamfMatcher& matcher = BamfMatcher::get_default();

    QDeclarativeView view;
    view.setSource(QUrl("./test.qml"));
    // Note: at that point, slots in QML seem unable to receive parameters with
    // custom types (such as BamfWindow *), even though they have been
    // registered. According to the documentation
    // (http://wiki.forum.nokia.com/index.php/CS001625_-_Connecting_Qt_signal_to_QML_function),
    // those parameters should be wrapped in QVariants, but this cripples the
    // original API, and additionally forces to expose the constructors and
    // destructor, which we don’t necessarily want.
    // The workaround here is to connect a slot with no parameters, and get the
    // values of the interesting parameters in the slot, e.g. with
    // BamfMatcher.active_window().
    QObject::connect(&matcher, SIGNAL(ActiveWindowChanged(BamfWindow *, BamfWindow *)),
                     (QObject *) view.rootObject(), SLOT(onActiveWindowChanged()));

    return application.exec();
}

