/* entry.c generated by valac 0.11.6, the Vala compiler
 * generated from entry.vala, do not modify */

/*
 * Copyright (C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "gwibber-gtk.h"
#include <stdlib.h>
#include <string.h>
#include <gwibber.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _GwibberGtkEntryPrivate {
	GwibberGtkInputTextView* text_view;
	GwibberGtkAccountTargetBar* target_bar;
};

struct _GwibberGtkSimpleEntryPrivate {
	GwibberGtkInputTextView* text_view;
	GwibberGtkSendBar* send_bar;
};

struct _GwibberGtkInputTextViewPrivate {
	GdkColor base_color;
	GdkColor error_color;
	gboolean last_was_shortened;
};

struct _GwibberGtkAccountToggleButtonPrivate {
	gchar* _color;
};

struct _Block1Data {
	int _ref_count_;
	GwibberGtkAccountTargetBar * self;
	GwibberAccount* account;
	GwibberGtkAccountToggleButton* account_button;
};

struct _GwibberGtkSendBarPrivate {
	GwibberService* _service;
};


static gpointer gwibber_gtk_entry_parent_class = NULL;
static gpointer gwibber_gtk_simple_entry_parent_class = NULL;
static gpointer gwibber_gtk_input_text_view_parent_class = NULL;
static gpointer gwibber_gtk_account_toggle_button_parent_class = NULL;
static gpointer gwibber_gtk_account_target_bar_parent_class = NULL;
static gpointer gwibber_gtk_send_bar_parent_class = NULL;

#define GWIBBER_GTK_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_ENTRY, GwibberGtkEntryPrivate))
enum  {
	GWIBBER_GTK_ENTRY_DUMMY_PROPERTY
};
static void gwibber_gtk_entry_on_send (GwibberGtkEntry* self, const gchar* msg);
static GObject * gwibber_gtk_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda4_ (GwibberGtkInputTextView* source, GwibberGtkEntry* self);
static void __lambda4__gwibber_gtk_input_text_view_submit (GwibberGtkInputTextView* _sender, gpointer self);
static void _lambda5_ (GtkButton* source, GwibberGtkEntry* self);
static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gwibber_gtk_entry_finalize (GObject* obj);
#define GWIBBER_GTK_SIMPLE_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_SIMPLE_ENTRY, GwibberGtkSimpleEntryPrivate))
enum  {
	GWIBBER_GTK_SIMPLE_ENTRY_DUMMY_PROPERTY
};
static void gwibber_gtk_simple_entry_on_send (GwibberGtkSimpleEntry* self, const gchar* msg);
static GObject * gwibber_gtk_simple_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda6_ (GwibberGtkInputTextView* source, GwibberGtkSimpleEntry* self);
static void __lambda6__gwibber_gtk_input_text_view_submit (GwibberGtkInputTextView* _sender, gpointer self);
static void _lambda7_ (GtkButton* source, GwibberGtkSimpleEntry* self);
static void __lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gwibber_gtk_simple_entry_finalize (GObject* obj);
#define GWIBBER_GTK_INPUT_TEXT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_INPUT_TEXT_VIEW, GwibberGtkInputTextViewPrivate))
enum  {
	GWIBBER_GTK_INPUT_TEXT_VIEW_DUMMY_PROPERTY
};
#define GWIBBER_GTK_INPUT_TEXT_VIEW_MAX_MESSAGE_LENGTH 140
static void gwibber_gtk_input_text_view_on_connection_changed (GwibberGtkInputTextView* self, gboolean is_connected);
static void gwibber_gtk_input_text_view_on_text_changed (GwibberGtkInputTextView* self);
static void gwibber_gtk_input_text_view_set_overlay_text (GwibberGtkInputTextView* self, const gchar* text);
static void gwibber_gtk_input_text_view_on_text_inserted (GwibberGtkInputTextView* self, GtkTextIter* iter, const gchar* text, gint len);
static gboolean gwibber_gtk_input_text_view_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static void gwibber_gtk_input_text_view_real_submit (GwibberGtkInputTextView* self);
static GObject * gwibber_gtk_input_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gwibber_gtk_input_text_view_on_text_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void _gwibber_gtk_input_text_view_on_text_inserted_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* text, gint length, gpointer self);
static void _lambda0_ (gboolean source, GwibberGtkInputTextView* self);
static void __lambda0__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self);
static void gwibber_gtk_input_text_view_finalize (GObject* obj);
#define GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_ACCOUNT_TOGGLE_BUTTON, GwibberGtkAccountToggleButtonPrivate))
enum  {
	GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_DUMMY_PROPERTY,
	GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_COLOR
};
static gboolean gwibber_gtk_account_toggle_button_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static GObject * gwibber_gtk_account_toggle_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_gtk_account_toggle_button_finalize (GObject* obj);
static void _vala_gwibber_gtk_account_toggle_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_account_toggle_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	GWIBBER_GTK_ACCOUNT_TARGET_BAR_DUMMY_PROPERTY
};
static void gwibber_gtk_account_target_bar_on_account_toggled (GwibberGtkAccountTargetBar* self, GwibberGtkAccountToggleButton* account_button, const gchar* id);
static void gwibber_gtk_account_target_bar_account_updated (GHashTable* accounts_buttons_table, GwibberAccount* account);
static void gwibber_gtk_account_target_bar_on_connection_changed (GwibberGtkAccountTargetBar* self, gboolean is_connected);
static GObject * gwibber_gtk_account_target_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda1_ (GtkButton* source, Block1Data* _data1_);
static void __lambda1__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda2_ (gboolean source, GwibberGtkAccountTargetBar* self);
static void __lambda2__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self);
static void _lambda3_ (GwibberAccount* source, GwibberGtkAccountTargetBar* self);
static void __lambda3__gwibber_accounts_account_updated (GwibberAccounts* _sender, GwibberAccount* account, gpointer self);
static void _g_list_free__g_object_unref0_ (GList* self);
static void gwibber_gtk_account_target_bar_finalize (GObject* obj);
#define GWIBBER_GTK_SEND_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_SEND_BAR, GwibberGtkSendBarPrivate))
enum  {
	GWIBBER_GTK_SEND_BAR_DUMMY_PROPERTY,
	GWIBBER_GTK_SEND_BAR_SERVICE
};
static GObject * gwibber_gtk_send_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_gtk_send_bar_finalize (GObject* obj);
static void _vala_gwibber_gtk_send_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_send_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GwibberGtkEntry* gwibber_gtk_entry_construct (GType object_type) {
	GwibberGtkEntry * self = NULL;
	self = (GwibberGtkEntry*) g_object_new (object_type, NULL);
	return self;
}


GwibberGtkEntry* gwibber_gtk_entry_new (void) {
	return gwibber_gtk_entry_construct (GWIBBER_GTK_TYPE_ENTRY);
}


static void gwibber_gtk_entry_on_send (GwibberGtkEntry* self, const gchar* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	gwibber_service_send_message (self->service, msg);
	g_debug ("entry.vala:58: Message: %s posted", msg);
	gwibber_gtk_input_text_view_clear (self->priv->text_view);
}


static void _lambda4_ (GwibberGtkInputTextView* source, GwibberGtkEntry* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (source != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->text_view);
	_tmp2_ = (g_object_get (_tmp0_, "text", &_tmp1_, NULL), _tmp1_);
	gwibber_gtk_entry_on_send (self, _tmp2_);
	_g_free0 (_tmp2_);
}


static void __lambda4__gwibber_gtk_input_text_view_submit (GwibberGtkInputTextView* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void _lambda5_ (GtkButton* source, GwibberGtkEntry* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (source != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->text_view);
	_tmp2_ = (g_object_get (_tmp0_, "text", &_tmp1_, NULL), _tmp1_);
	gwibber_gtk_entry_on_send (self, _tmp2_);
	_g_free0 (_tmp2_);
}


static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static GObject * gwibber_gtk_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkEntry * self;
	GwibberService* _tmp0_ = NULL;
	GwibberService* _tmp1_;
	GwibberGtkInputTextView* _tmp2_ = NULL;
	GwibberGtkInputTextView* _tmp3_;
	GwibberGtkAccountTargetBar* _tmp4_ = NULL;
	GwibberGtkAccountTargetBar* _tmp5_;
	GtkHBox* _tmp6_ = NULL;
	GtkHBox* spacer;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_ENTRY (obj);
	_tmp0_ = gwibber_service_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->service);
	self->service = _tmp1_;
	_tmp2_ = gwibber_gtk_input_text_view_new (self->service);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->text_view);
	self->priv->text_view = _tmp3_;
	_tmp4_ = gwibber_gtk_account_target_bar_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->target_bar);
	self->priv->target_bar = _tmp5_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->text_view);
	gtk_container_add_with_properties ((GtkContainer*) self, (GtkWidget*) self->priv->target_bar, "expand", FALSE, NULL);
	gtk_widget_show ((GtkWidget*) self->priv->text_view);
	g_signal_connect_object (self->priv->text_view, "submit", (GCallback) __lambda4__gwibber_gtk_input_text_view_submit, self, 0);
	gtk_widget_show ((GtkWidget*) self->priv->target_bar);
	g_signal_connect_object (self->priv->target_bar->send, "clicked", (GCallback) __lambda5__gtk_button_clicked, self, 0);
	_tmp6_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	spacer = g_object_ref_sink (_tmp6_);
	gtk_container_add_with_properties ((GtkContainer*) self, (GtkWidget*) spacer, "padding", 2, "expand", FALSE, NULL);
	_g_object_unref0 (spacer);
	return obj;
}


static void gwibber_gtk_entry_class_init (GwibberGtkEntryClass * klass) {
	gwibber_gtk_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkEntryPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_entry_finalize;
}


static void gwibber_gtk_entry_instance_init (GwibberGtkEntry * self) {
	self->priv = GWIBBER_GTK_ENTRY_GET_PRIVATE (self);
}


static void gwibber_gtk_entry_finalize (GObject* obj) {
	GwibberGtkEntry * self;
	self = GWIBBER_GTK_ENTRY (obj);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->target_bar);
	G_OBJECT_CLASS (gwibber_gtk_entry_parent_class)->finalize (obj);
}


GType gwibber_gtk_entry_get_type (void) {
	static volatile gsize gwibber_gtk_entry_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkEntry), 0, (GInstanceInitFunc) gwibber_gtk_entry_instance_init, NULL };
		GType gwibber_gtk_entry_type_id;
		gwibber_gtk_entry_type_id = g_type_register_static (GTK_TYPE_VBOX, "GwibberGtkEntry", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_entry_type_id__volatile, gwibber_gtk_entry_type_id);
	}
	return gwibber_gtk_entry_type_id__volatile;
}


GwibberGtkSimpleEntry* gwibber_gtk_simple_entry_construct (GType object_type) {
	GwibberGtkSimpleEntry * self = NULL;
	self = (GwibberGtkSimpleEntry*) g_object_new (object_type, NULL);
	return self;
}


GwibberGtkSimpleEntry* gwibber_gtk_simple_entry_new (void) {
	return gwibber_gtk_simple_entry_construct (GWIBBER_GTK_TYPE_SIMPLE_ENTRY);
}


static void gwibber_gtk_simple_entry_on_send (GwibberGtkSimpleEntry* self, const gchar* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	gwibber_service_send_message (self->service, msg);
	g_debug ("entry.vala:96: Message: %s posted", msg);
	gwibber_gtk_input_text_view_clear (self->priv->text_view);
}


static void _lambda6_ (GwibberGtkInputTextView* source, GwibberGtkSimpleEntry* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (source != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->text_view);
	_tmp2_ = (g_object_get (_tmp0_, "text", &_tmp1_, NULL), _tmp1_);
	gwibber_gtk_simple_entry_on_send (self, _tmp2_);
	_g_free0 (_tmp2_);
}


static void __lambda6__gwibber_gtk_input_text_view_submit (GwibberGtkInputTextView* _sender, gpointer self) {
	_lambda6_ (_sender, self);
}


static void _lambda7_ (GtkButton* source, GwibberGtkSimpleEntry* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (source != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->text_view);
	_tmp2_ = (g_object_get (_tmp0_, "text", &_tmp1_, NULL), _tmp1_);
	gwibber_gtk_simple_entry_on_send (self, _tmp2_);
	_g_free0 (_tmp2_);
}


static void __lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda7_ (_sender, self);
}


static GObject * gwibber_gtk_simple_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkSimpleEntry * self;
	GwibberService* _tmp0_ = NULL;
	GwibberService* _tmp1_;
	GwibberGtkInputTextView* _tmp2_ = NULL;
	GwibberGtkInputTextView* _tmp3_;
	GwibberGtkSendBar* _tmp4_ = NULL;
	GwibberGtkSendBar* _tmp5_;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_simple_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_SIMPLE_ENTRY (obj);
	_tmp0_ = gwibber_service_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->service);
	self->service = _tmp1_;
	_tmp2_ = gwibber_gtk_input_text_view_new (self->service);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->text_view);
	self->priv->text_view = _tmp3_;
	_tmp4_ = gwibber_gtk_send_bar_new (self->service);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->send_bar);
	self->priv->send_bar = _tmp5_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->text_view);
	gtk_container_add_with_properties ((GtkContainer*) self, (GtkWidget*) self->priv->send_bar, "expand", FALSE, NULL);
	gtk_widget_show ((GtkWidget*) self->priv->text_view);
	gtk_widget_show ((GtkWidget*) self->priv->send_bar);
	g_signal_connect_object (self->priv->text_view, "submit", (GCallback) __lambda6__gwibber_gtk_input_text_view_submit, self, 0);
	g_signal_connect_object (self->priv->send_bar->send, "clicked", (GCallback) __lambda7__gtk_button_clicked, self, 0);
	return obj;
}


static void gwibber_gtk_simple_entry_class_init (GwibberGtkSimpleEntryClass * klass) {
	gwibber_gtk_simple_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkSimpleEntryPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_simple_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_simple_entry_finalize;
}


static void gwibber_gtk_simple_entry_instance_init (GwibberGtkSimpleEntry * self) {
	self->priv = GWIBBER_GTK_SIMPLE_ENTRY_GET_PRIVATE (self);
}


static void gwibber_gtk_simple_entry_finalize (GObject* obj) {
	GwibberGtkSimpleEntry * self;
	self = GWIBBER_GTK_SIMPLE_ENTRY (obj);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->send_bar);
	G_OBJECT_CLASS (gwibber_gtk_simple_entry_parent_class)->finalize (obj);
}


GType gwibber_gtk_simple_entry_get_type (void) {
	static volatile gsize gwibber_gtk_simple_entry_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_simple_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkSimpleEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_simple_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkSimpleEntry), 0, (GInstanceInitFunc) gwibber_gtk_simple_entry_instance_init, NULL };
		GType gwibber_gtk_simple_entry_type_id;
		gwibber_gtk_simple_entry_type_id = g_type_register_static (GTK_TYPE_VBOX, "GwibberGtkSimpleEntry", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_simple_entry_type_id__volatile, gwibber_gtk_simple_entry_type_id);
	}
	return gwibber_gtk_simple_entry_type_id__volatile;
}


GwibberGtkInputTextView* gwibber_gtk_input_text_view_construct (GType object_type, GwibberService* service) {
	GwibberGtkInputTextView * self = NULL;
	g_return_val_if_fail (service != NULL, NULL);
	self = (GwibberGtkInputTextView*) g_object_new (object_type, "border-width", 5, "accepts-tab", TRUE, "editable", TRUE, "cursor-visible", TRUE, "wrap-mode", GTK_WRAP_WORD_CHAR, "left-margin", 2, "right-margin", 2, "pixels-above-lines", 2, "pixels-below-lines", 2, NULL);
	return self;
}


GwibberGtkInputTextView* gwibber_gtk_input_text_view_new (GwibberService* service) {
	return gwibber_gtk_input_text_view_construct (GWIBBER_GTK_TYPE_INPUT_TEXT_VIEW, service);
}


void gwibber_gtk_input_text_view_clear (GwibberGtkInputTextView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	gtk_text_buffer_set_text (_tmp0_, "", -1);
}


static void gwibber_gtk_input_text_view_on_connection_changed (GwibberGtkInputTextView* self, gboolean is_connected) {
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self, is_connected);
}


static void gwibber_gtk_input_text_view_on_text_changed (GwibberGtkInputTextView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	gint _tmp1_;
	gint chars;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GdkColor _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = gtk_text_buffer_get_char_count (_tmp0_);
	chars = _tmp1_;
	_tmp2_ = g_strdup_printf ("%i", GWIBBER_GTK_INPUT_TEXT_VIEW_MAX_MESSAGE_LENGTH - chars);
	_tmp3_ = _tmp2_;
	gwibber_gtk_input_text_view_set_overlay_text (self, _tmp3_);
	_g_free0 (_tmp3_);
	if (chars > GWIBBER_GTK_INPUT_TEXT_VIEW_MAX_MESSAGE_LENGTH) {
		_tmp4_ = self->priv->error_color;
	} else {
		_tmp4_ = self->priv->base_color;
	}
	gtk_widget_modify_base ((GtkWidget*) self, GTK_STATE_NORMAL, &_tmp4_);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gwibber_gtk_input_text_view_on_text_inserted (GwibberGtkInputTextView* self, GtkTextIter* iter, const gchar* text, gint len) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->last_was_shortened == FALSE) {
		_tmp2_ = len > 30;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = text != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = string_slice (text, (glong) 0, (glong) 4);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "http") == 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTextBuffer* _tmp5_ = NULL;
		GtkTextBuffer* _tmp6_;
		GtkTextBuffer* buf;
		gchar* _tmp7_ = NULL;
		gchar* shrt;
		_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		buf = _tmp6_;
		g_signal_stop_emission_by_name (buf, "insert-text");
		_tmp7_ = gwibber_url_shorten_shorten (self->urlshorten, text);
		shrt = _tmp7_;
		self->priv->last_was_shortened = TRUE;
		gtk_text_buffer_insert (buf, iter, shrt, -1);
		_g_free0 (shrt);
		_g_object_unref0 (buf);
	} else {
		self->priv->last_was_shortened = FALSE;
	}
}


static gboolean gwibber_gtk_input_text_view_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	GwibberGtkInputTextView * self;
	gboolean result = FALSE;
	GdkGC* _tmp7_ = NULL;
	GdkGC* gc;
	gint ww = 0;
	gint wh = 0;
	gint tw = 0;
	gint th = 0;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	self = (GwibberGtkInputTextView*) base;
	if (self->drawable == NULL) {
		GdkWindow* _tmp0_ = NULL;
		GdkDrawable* _tmp1_;
		GdkDrawable* _tmp2_;
		PangoLayout* _tmp3_ = NULL;
		PangoLayout* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp0_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT);
		_tmp1_ = _g_object_ref0 ((GdkDrawable*) _tmp0_);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (self->drawable);
		self->drawable = _tmp2_;
		_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) self, "");
		_tmp4_ = _tmp3_;
		_g_object_unref0 (self->pango_overlay);
		self->pango_overlay = _tmp4_;
		_tmp5_ = g_strdup_printf ("%i", GWIBBER_GTK_INPUT_TEXT_VIEW_MAX_MESSAGE_LENGTH);
		_tmp6_ = _tmp5_;
		gwibber_gtk_input_text_view_set_overlay_text (self, _tmp6_);
		_g_free0 (_tmp6_);
	}
	_tmp7_ = gdk_gc_new (self->drawable);
	gc = _tmp7_;
	gdk_drawable_get_size (self->drawable, &_tmp8_, &_tmp9_);
	ww = _tmp8_;
	wh = _tmp9_;
	pango_layout_get_pixel_size (self->pango_overlay, &_tmp10_, &_tmp11_);
	tw = _tmp10_;
	th = _tmp11_;
	gdk_draw_layout (self->drawable, gc, (ww - tw) - 2, wh - th, self->pango_overlay);
	result = FALSE;
	_g_object_unref0 (gc);
	return result;
}


static void gwibber_gtk_input_text_view_set_overlay_text (GwibberGtkInputTextView* self, const gchar* text) {
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (self->pango_overlay == NULL) {
		PangoLayout* _tmp0_ = NULL;
		PangoLayout* _tmp1_;
		_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) self, "");
		_tmp1_ = _tmp0_;
		_g_object_unref0 (self->pango_overlay);
		self->pango_overlay = _tmp1_;
	}
	_tmp2_ = g_strdup_printf (self->overlay_text, self->overlay_color, text);
	_tmp3_ = _tmp2_;
	pango_layout_set_markup (self->pango_overlay, _tmp3_, -1);
	_g_free0 (_tmp3_);
}


static void gwibber_gtk_input_text_view_real_submit (GwibberGtkInputTextView* self) {
	g_return_if_fail (self != NULL);
}


static void _gwibber_gtk_input_text_view_on_text_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	gwibber_gtk_input_text_view_on_text_changed (self);
}


static void _gwibber_gtk_input_text_view_on_text_inserted_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* text, gint length, gpointer self) {
	gwibber_gtk_input_text_view_on_text_inserted (self, pos, text, length);
}


static void _lambda0_ (gboolean source, GwibberGtkInputTextView* self) {
	gwibber_gtk_input_text_view_on_connection_changed (self, source);
}


static void __lambda0__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self) {
	_lambda0_ (is_online, self);
}


static GObject * gwibber_gtk_input_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkInputTextView * self;
	GwibberService* _tmp0_ = NULL;
	GwibberService* _tmp1_;
	GwibberConnection* _tmp2_ = NULL;
	GwibberConnection* _tmp3_;
	GwibberURLShorten* _tmp4_ = NULL;
	GwibberURLShorten* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkBindingSet* binding_set = NULL;
	GTypeClass* _tmp10_ = NULL;
	GTypeClass* _tmp11_;
	GtkBindingSet* _tmp12_ = NULL;
	guint _tmp13_;
	guint _tmp14_;
	GtkStyle* _tmp15_ = NULL;
	GdkColor _tmp16_ = {0};
	GtkTextBuffer* _tmp17_ = NULL;
	GtkTextBuffer* _tmp18_ = NULL;
	gboolean _tmp19_;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_input_text_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_INPUT_TEXT_VIEW (obj);
	_tmp0_ = gwibber_service_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->service);
	self->service = _tmp1_;
	_tmp2_ = gwibber_connection_new ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->conn_service);
	self->conn_service = _tmp3_;
	_tmp4_ = gwibber_url_shorten_new ();
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->urlshorten);
	self->urlshorten = _tmp5_;
	_tmp6_ = g_strdup ("#aeab9f");
	_tmp7_ = _tmp6_;
	_g_free0 (self->overlay_color);
	self->overlay_color = _tmp7_;
	_tmp8_ = g_strdup ("<span weight=\"bold\" size=\"xx-large\" foreground=\"%s\">%s</span>");
	_tmp9_ = _tmp8_;
	_g_free0 (self->overlay_text);
	self->overlay_text = _tmp9_;
	_tmp10_ = g_type_class_ref (GWIBBER_GTK_TYPE_INPUT_TEXT_VIEW);
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_binding_set_by_class (_tmp11_);
	binding_set = _tmp12_;
	_g_type_class_unref0 (_tmp11_);
	_tmp13_ = gdk_keyval_from_name ("Return");
	gtk_binding_entry_add_signal (binding_set, _tmp13_, 0, "submit", (guint) 0);
	_tmp14_ = gdk_keyval_from_name ("KP_Enter");
	gtk_binding_entry_add_signal (binding_set, _tmp14_, 0, "submit", (guint) 0);
	_tmp15_ = gtk_widget_get_style ((GtkWidget*) self);
	self->priv->base_color = _tmp15_->base[GTK_STATE_NORMAL];
	gdk_color_parse ("indianred", &_tmp16_);
	self->priv->error_color = _tmp16_;
	_tmp17_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	g_signal_connect_object (_tmp17_, "changed", (GCallback) _gwibber_gtk_input_text_view_on_text_changed_gtk_text_buffer_changed, self, 0);
	_tmp18_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	g_signal_connect_object (_tmp18_, "insert-text", (GCallback) _gwibber_gtk_input_text_view_on_text_inserted_gtk_text_buffer_insert_text, self, 0);
	_tmp19_ = gwibber_connection_is_connected (self->conn_service);
	gtk_widget_set_sensitive ((GtkWidget*) self, _tmp19_);
	g_signal_connect_object (self->conn_service, "connection-changed", (GCallback) __lambda0__gwibber_connection_connection_changed, self, 0);
	return obj;
}


static void gwibber_gtk_input_text_view_class_init (GwibberGtkInputTextViewClass * klass) {
	gwibber_gtk_input_text_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkInputTextViewPrivate));
	GTK_WIDGET_CLASS (klass)->expose_event = gwibber_gtk_input_text_view_real_expose_event;
	GWIBBER_GTK_INPUT_TEXT_VIEW_CLASS (klass)->submit = gwibber_gtk_input_text_view_real_submit;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_input_text_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_input_text_view_finalize;
	g_signal_new ("submit", GWIBBER_GTK_TYPE_INPUT_TEXT_VIEW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GwibberGtkInputTextViewClass, submit), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gwibber_gtk_input_text_view_instance_init (GwibberGtkInputTextView * self) {
	self->priv = GWIBBER_GTK_INPUT_TEXT_VIEW_GET_PRIVATE (self);
	self->priv->last_was_shortened = FALSE;
}


static void gwibber_gtk_input_text_view_finalize (GObject* obj) {
	GwibberGtkInputTextView * self;
	self = GWIBBER_GTK_INPUT_TEXT_VIEW (obj);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->conn_service);
	_g_object_unref0 (self->urlshorten);
	_g_free0 (self->overlay_text);
	_g_free0 (self->overlay_color);
	_g_object_unref0 (self->drawable);
	_g_object_unref0 (self->pango_overlay);
	G_OBJECT_CLASS (gwibber_gtk_input_text_view_parent_class)->finalize (obj);
}


GType gwibber_gtk_input_text_view_get_type (void) {
	static volatile gsize gwibber_gtk_input_text_view_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_input_text_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkInputTextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_input_text_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkInputTextView), 0, (GInstanceInitFunc) gwibber_gtk_input_text_view_instance_init, NULL };
		GType gwibber_gtk_input_text_view_type_id;
		gwibber_gtk_input_text_view_type_id = g_type_register_static (GTK_TYPE_TEXT_VIEW, "GwibberGtkInputTextView", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_input_text_view_type_id__volatile, gwibber_gtk_input_text_view_type_id);
	}
	return gwibber_gtk_input_text_view_type_id__volatile;
}


GwibberGtkAccountToggleButton* gwibber_gtk_account_toggle_button_construct (GType object_type, const gchar* color) {
	GwibberGtkAccountToggleButton * self = NULL;
	g_return_val_if_fail (color != NULL, NULL);
	self = (GwibberGtkAccountToggleButton*) g_object_new (object_type, "color", color, NULL);
	return self;
}


GwibberGtkAccountToggleButton* gwibber_gtk_account_toggle_button_new (const gchar* color) {
	return gwibber_gtk_account_toggle_button_construct (GWIBBER_GTK_TYPE_ACCOUNT_TOGGLE_BUTTON, color);
}


static gboolean gwibber_gtk_account_toggle_button_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	GwibberGtkAccountToggleButton * self;
	gboolean result = FALSE;
	gdouble factor;
	GdkColor gdk_color = {0};
	gboolean _tmp0_;
	GdkWindow* _tmp3_ = NULL;
	cairo_t* _tmp4_ = NULL;
	cairo_t* context;
	GdkColor _tmp5_ = {0};
	gdouble left;
	gdouble top;
	gdouble right;
	gdouble bottom;
	gdouble radius;
	GdkColor _tmp6_ = {0};
	GtkWidget* _tmp7_ = NULL;
	self = (GwibberGtkAccountToggleButton*) base;
	factor = 0.3;
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) self);
	if (_tmp0_) {
		factor = 1.0;
	} else {
		GtkStateType _tmp1_;
		_tmp1_ = gtk_widget_get_state ((GtkWidget*) self);
		if (_tmp1_ == 2) {
			factor = 0.3;
		} else {
			GtkStateType _tmp2_;
			_tmp2_ = gtk_widget_get_state ((GtkWidget*) self);
			if (_tmp2_ == 1) {
				factor = 0.5;
			}
		}
	}
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp4_ = gdk_cairo_create ((GdkDrawable*) _tmp3_);
	context = _tmp4_;
	gdk_color_parse (self->priv->_color, &_tmp5_);
	gdk_color = _tmp5_;
	left = (gdouble) (*event).area.x;
	top = (gdouble) (*event).area.y;
	right = (gdouble) ((*event).area.x + (*event).area.width);
	bottom = (gdouble) ((*event).area.y + (*event).area.height);
	radius = (gdouble) 10;
	cairo_move_to (context, left, top + radius);
	cairo_curve_to (context, left, top, left, top, left + radius, top);
	cairo_line_to (context, right - radius, top);
	cairo_curve_to (context, right, top, right, top, right, top + radius);
	cairo_line_to (context, right, bottom - radius);
	cairo_curve_to (context, right, bottom, right, bottom, right - radius, bottom);
	cairo_line_to (context, left + radius, bottom);
	cairo_curve_to (context, left, bottom, left, bottom, left, bottom - radius);
	cairo_clip (context);
	gdk_color_parse (self->priv->_color, &_tmp6_);
	gdk_color = _tmp6_;
	cairo_set_source_rgba (context, gdk_color.red / 65535.0, gdk_color.green / 65535.0, gdk_color.blue / 65535.0, factor);
	cairo_paint (context);
	_tmp7_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_container_propagate_expose ((GtkContainer*) self, _tmp7_, event);
	result = TRUE;
	_cairo_destroy0 (context);
	return result;
}


const gchar* gwibber_gtk_account_toggle_button_get_color (GwibberGtkAccountToggleButton* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_color;
	return result;
}


static void gwibber_gtk_account_toggle_button_set_color (GwibberGtkAccountToggleButton* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_color);
	self->priv->_color = _tmp1_;
	g_object_notify ((GObject *) self, "color");
}


static GObject * gwibber_gtk_account_toggle_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkAccountToggleButton * self;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_account_toggle_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON (obj);
	return obj;
}


static void gwibber_gtk_account_toggle_button_class_init (GwibberGtkAccountToggleButtonClass * klass) {
	gwibber_gtk_account_toggle_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkAccountToggleButtonPrivate));
	GTK_WIDGET_CLASS (klass)->expose_event = gwibber_gtk_account_toggle_button_real_expose_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_account_toggle_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_account_toggle_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_account_toggle_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_account_toggle_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_COLOR, g_param_spec_string ("color", "color", "color", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gwibber_gtk_account_toggle_button_instance_init (GwibberGtkAccountToggleButton * self) {
	self->priv = GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_GET_PRIVATE (self);
}


static void gwibber_gtk_account_toggle_button_finalize (GObject* obj) {
	GwibberGtkAccountToggleButton * self;
	self = GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON (obj);
	_g_free0 (self->priv->_color);
	G_OBJECT_CLASS (gwibber_gtk_account_toggle_button_parent_class)->finalize (obj);
}


GType gwibber_gtk_account_toggle_button_get_type (void) {
	static volatile gsize gwibber_gtk_account_toggle_button_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_account_toggle_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkAccountToggleButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_account_toggle_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkAccountToggleButton), 0, (GInstanceInitFunc) gwibber_gtk_account_toggle_button_instance_init, NULL };
		GType gwibber_gtk_account_toggle_button_type_id;
		gwibber_gtk_account_toggle_button_type_id = g_type_register_static (GTK_TYPE_TOGGLE_BUTTON, "GwibberGtkAccountToggleButton", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_account_toggle_button_type_id__volatile, gwibber_gtk_account_toggle_button_type_id);
	}
	return gwibber_gtk_account_toggle_button_type_id__volatile;
}


static void _vala_gwibber_gtk_account_toggle_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkAccountToggleButton * self;
	self = GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON (object);
	switch (property_id) {
		case GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_COLOR:
		g_value_set_string (value, gwibber_gtk_account_toggle_button_get_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_account_toggle_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkAccountToggleButton * self;
	self = GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON (object);
	switch (property_id) {
		case GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_COLOR:
		gwibber_gtk_account_toggle_button_set_color (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GwibberGtkAccountTargetBar* gwibber_gtk_account_target_bar_construct (GType object_type) {
	GwibberGtkAccountTargetBar * self = NULL;
	self = (GwibberGtkAccountTargetBar*) g_object_new (object_type, "spacing", 0, NULL);
	return self;
}


GwibberGtkAccountTargetBar* gwibber_gtk_account_target_bar_new (void) {
	return gwibber_gtk_account_target_bar_construct (GWIBBER_GTK_TYPE_ACCOUNT_TARGET_BAR);
}


static void gwibber_gtk_account_target_bar_on_account_toggled (GwibberGtkAccountTargetBar* self, GwibberGtkAccountToggleButton* account_button, const gchar* id) {
	GwibberAccount* _tmp0_ = NULL;
	GwibberAccount* account;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account_button != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = gwibber_accounts_lookup_by_id (self->accounts_service, id);
	account = _tmp0_;
	_tmp2_ = gwibber_account_get_send_enabled (account);
	if (g_strcmp0 (_tmp2_, "1") == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp3_ = gtk_toggle_button_get_active ((GtkToggleButton*) account_button);
	if (_tmp1_ != _tmp3_) {
		gwibber_accounts_send_enabled (self->accounts_service, id);
	}
	_g_object_unref0 (account);
}


static void gwibber_gtk_account_target_bar_account_updated (GHashTable* accounts_buttons_table, GwibberAccount* account) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GwibberGtkAccountToggleButton* _tmp5_;
	GwibberGtkAccountToggleButton* account_button;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_ = NULL;
	gboolean _tmp21_;
	g_return_if_fail (accounts_buttons_table != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = gwibber_account_get_username (account);
	_tmp1_ = gwibber_account_get_service (account);
	_tmp2_ = gwibber_account_get_id (account);
	g_debug ("entry.vala:379: ACCOUNT: %s %s %s", _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = gwibber_account_get_id (account);
	_tmp4_ = g_hash_table_lookup (accounts_buttons_table, _tmp3_);
	_tmp5_ = _g_object_ref0 ((GwibberGtkAccountToggleButton*) _tmp4_);
	account_button = _tmp5_;
	_tmp6_ = gwibber_account_get_send_enabled (account);
	if (g_strcmp0 (_tmp6_, "1") != 0) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp7_ = gwibber_account_get_service (account);
		_tmp8_ = g_strconcat (_tmp7_, " (", NULL);
		_tmp9_ = gwibber_account_get_username (account);
		_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
		_tmp11_ = g_strconcat (_tmp10_, ") - ", NULL);
		_tmp12_ = _ ("Disabled");
		_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
		gtk_widget_set_tooltip_text ((GtkWidget*) account_button, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	} else {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp14_ = gwibber_account_get_service (account);
		_tmp15_ = g_strconcat (_tmp14_, " (", NULL);
		_tmp16_ = gwibber_account_get_username (account);
		_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
		_tmp18_ = g_strconcat (_tmp17_, ")", NULL);
		gtk_widget_set_tooltip_text ((GtkWidget*) account_button, _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
	}
	_tmp20_ = gwibber_account_get_send_enabled (account);
	if (g_strcmp0 (_tmp20_, "1") == 0) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = FALSE;
	}
	_tmp21_ = gtk_toggle_button_get_active ((GtkToggleButton*) account_button);
	if (_tmp19_ != _tmp21_) {
		gboolean _tmp22_ = FALSE;
		const gchar* _tmp23_ = NULL;
		_tmp23_ = gwibber_account_get_send_enabled (account);
		if (g_strcmp0 (_tmp23_, "1") == 0) {
			_tmp22_ = TRUE;
		} else {
			_tmp22_ = FALSE;
		}
		gtk_toggle_button_set_active ((GtkToggleButton*) account_button, _tmp22_);
	}
	_g_object_unref0 (account_button);
}


static void gwibber_gtk_account_target_bar_on_connection_changed (GwibberGtkAccountTargetBar* self, gboolean is_connected) {
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self->send, is_connected);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->account_button);
		_g_object_unref0 (_data1_->account);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda1_ (GtkButton* source, Block1Data* _data1_) {
	GwibberGtkAccountTargetBar * self;
	const gchar* _tmp0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = gwibber_account_get_id (_data1_->account);
	gwibber_gtk_account_target_bar_on_account_toggled (self, _data1_->account_button, _tmp0_);
}


static void __lambda1__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _lambda2_ (gboolean source, GwibberGtkAccountTargetBar* self) {
	gwibber_gtk_account_target_bar_on_connection_changed (self, source);
}


static void __lambda2__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self) {
	_lambda2_ (is_online, self);
}


static void _lambda3_ (GwibberAccount* source, GwibberGtkAccountTargetBar* self) {
	g_return_if_fail (source != NULL);
	gwibber_gtk_account_target_bar_account_updated (self->accounts_buttons_table, source);
}


static void __lambda3__gwibber_accounts_account_updated (GwibberAccounts* _sender, GwibberAccount* account, gpointer self) {
	_lambda3_ (account, self);
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GObject * gwibber_gtk_account_target_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkAccountTargetBar * self;
	GwibberAccounts* _tmp0_ = NULL;
	GwibberAccounts* _tmp1_;
	GwibberConnection* _tmp2_ = NULL;
	GwibberConnection* _tmp3_;
	GtkHBox* _tmp4_ = NULL;
	GtkHBox* box;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* send_with_label;
	gchar* _tmp7_ = NULL;
	gchar* service_icon_path;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GHashTable* _tmp14_ = NULL;
	GHashTable* _tmp15_;
	GList* _tmp16_ = NULL;
	GList* accounts_list;
	const gchar* _tmp46_ = NULL;
	GtkButton* _tmp47_ = NULL;
	GtkButton* _tmp48_;
	gboolean _tmp49_;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_account_target_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_ACCOUNT_TARGET_BAR (obj);
	_tmp0_ = gwibber_accounts_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->accounts_service);
	self->accounts_service = _tmp1_;
	_tmp2_ = gwibber_connection_new ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->conn_service);
	self->conn_service = _tmp3_;
	_tmp4_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	box = g_object_ref_sink (_tmp4_);
	_tmp5_ = _ ("Send with:");
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	send_with_label = g_object_ref_sink (_tmp6_);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) send_with_label, FALSE, FALSE, (guint) 5);
	_tmp7_ = g_build_path (G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S, "usr", "share", "gwibber", "ui", "icons", "breakdance", "22x22", G_DIR_SEPARATOR_S, NULL);
	service_icon_path = _tmp7_;
	_tmp8_ = g_build_path (G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S, "usr", "local", "share", "gwibber", "ui", "icons", "breakdance", "22x22", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
	if ((_tmp11_ = _tmp10_, _g_free0 (_tmp9_), _tmp11_)) {
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp12_ = g_build_path (G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S, "usr", "local", "share", "gwibber", "ui", "icons", "breakdance", "22x22", G_DIR_SEPARATOR_S, NULL);
		_tmp13_ = _tmp12_;
		_g_free0 (service_icon_path);
		service_icon_path = _tmp13_;
	}
	_tmp14_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_tmp15_ = _tmp14_;
	_g_hash_table_unref0 (self->accounts_buttons_table);
	self->accounts_buttons_table = _tmp15_;
	_tmp16_ = gwibber_accounts_list (self->accounts_service);
	accounts_list = _tmp16_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				Block1Data* _data1_;
				guint _tmp18_;
				gconstpointer _tmp19_ = NULL;
				GwibberAccount* _tmp20_;
				const gchar* _tmp21_ = NULL;
				GtkImage* _tmp22_ = NULL;
				GtkImage* icon_service;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				gchar* _tmp25_;
				const gchar* _tmp26_ = NULL;
				GwibberGtkAccountToggleButton* _tmp27_ = NULL;
				gboolean _tmp28_ = FALSE;
				const gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp43_ = NULL;
				gchar* _tmp44_;
				GwibberGtkAccountToggleButton* _tmp45_;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				if (!_tmp17_) {
					i++;
				}
				_tmp17_ = FALSE;
				_tmp18_ = g_list_length (accounts_list);
				if (!(i < _tmp18_)) {
					block1_data_unref (_data1_);
					_data1_ = NULL;
					break;
				}
				_tmp19_ = g_list_nth_data (accounts_list, (guint) i);
				_tmp20_ = _g_object_ref0 ((GwibberAccount*) _tmp19_);
				_data1_->account = _tmp20_;
				if (_data1_->account == NULL) {
					block1_data_unref (_data1_);
					_data1_ = NULL;
					continue;
				}
				_tmp21_ = gwibber_account_get_send_enabled (_data1_->account);
				if (_tmp21_ == NULL) {
					block1_data_unref (_data1_);
					_data1_ = NULL;
					continue;
				}
				_tmp22_ = (GtkImage*) gtk_image_new ();
				icon_service = g_object_ref_sink (_tmp22_);
				_tmp23_ = gwibber_account_get_service (_data1_->account);
				_tmp24_ = g_strconcat (service_icon_path, _tmp23_, NULL);
				_tmp25_ = g_strconcat (_tmp24_, ".png", NULL);
				gtk_image_set_from_file (icon_service, _tmp25_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp24_);
				gtk_widget_show ((GtkWidget*) icon_service);
				_tmp26_ = gwibber_account_get_color (_data1_->account);
				_tmp27_ = gwibber_gtk_account_toggle_button_new (_tmp26_);
				_data1_->account_button = g_object_ref_sink (_tmp27_);
				_tmp29_ = gwibber_account_get_send_enabled (_data1_->account);
				if (g_strcmp0 (_tmp29_, "1") == 0) {
					_tmp28_ = TRUE;
				} else {
					_tmp28_ = FALSE;
				}
				gtk_toggle_button_set_active ((GtkToggleButton*) _data1_->account_button, _tmp28_);
				_tmp30_ = gwibber_account_get_send_enabled (_data1_->account);
				if (g_strcmp0 (_tmp30_, "1") != 0) {
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_;
					const gchar* _tmp33_ = NULL;
					gchar* _tmp34_;
					gchar* _tmp35_;
					const gchar* _tmp36_ = NULL;
					gchar* _tmp37_;
					_tmp31_ = gwibber_account_get_service (_data1_->account);
					_tmp32_ = g_strconcat (_tmp31_, " (", NULL);
					_tmp33_ = gwibber_account_get_username (_data1_->account);
					_tmp34_ = g_strconcat (_tmp32_, _tmp33_, NULL);
					_tmp35_ = g_strconcat (_tmp34_, ") - ", NULL);
					_tmp36_ = _ ("Disabled");
					_tmp37_ = g_strconcat (_tmp35_, _tmp36_, NULL);
					gtk_widget_set_tooltip_text ((GtkWidget*) _data1_->account_button, _tmp37_);
					_g_free0 (_tmp37_);
					_g_free0 (_tmp35_);
					_g_free0 (_tmp34_);
					_g_free0 (_tmp32_);
				} else {
					const gchar* _tmp38_ = NULL;
					gchar* _tmp39_;
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp38_ = gwibber_account_get_service (_data1_->account);
					_tmp39_ = g_strconcat (_tmp38_, " (", NULL);
					_tmp40_ = gwibber_account_get_username (_data1_->account);
					_tmp41_ = g_strconcat (_tmp39_, _tmp40_, NULL);
					_tmp42_ = g_strconcat (_tmp41_, ")", NULL);
					gtk_widget_set_tooltip_text ((GtkWidget*) _data1_->account_button, _tmp42_);
					_g_free0 (_tmp42_);
					_g_free0 (_tmp41_);
					_g_free0 (_tmp39_);
				}
				gtk_button_set_image ((GtkButton*) _data1_->account_button, (GtkWidget*) icon_service);
				g_signal_connect_data ((GtkButton*) _data1_->account_button, "clicked", (GCallback) __lambda1__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
				gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) _data1_->account_button, FALSE, FALSE, (guint) 2);
				_tmp43_ = gwibber_account_get_id (_data1_->account);
				_tmp44_ = g_strdup (_tmp43_);
				_tmp45_ = _g_object_ref0 (_data1_->account_button);
				g_hash_table_insert (self->accounts_buttons_table, _tmp44_, _tmp45_);
				_g_object_unref0 (icon_service);
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
		}
	}
	_tmp46_ = _ ("Send");
	_tmp47_ = (GtkButton*) gtk_button_new_with_label (_tmp46_);
	_tmp48_ = g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->send);
	self->send = _tmp48_;
	gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) self->send, FALSE, FALSE, (guint) 5);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	_tmp49_ = gwibber_connection_is_connected (self->conn_service);
	gtk_widget_set_sensitive ((GtkWidget*) self->send, _tmp49_);
	g_signal_connect_object (self->conn_service, "connection-changed", (GCallback) __lambda2__gwibber_connection_connection_changed, self, 0);
	g_signal_connect_object (self->accounts_service, "account-updated", (GCallback) __lambda3__gwibber_accounts_account_updated, self, 0);
	__g_list_free__g_object_unref0_0 (accounts_list);
	_g_free0 (service_icon_path);
	_g_object_unref0 (send_with_label);
	_g_object_unref0 (box);
	return obj;
}


static void gwibber_gtk_account_target_bar_class_init (GwibberGtkAccountTargetBarClass * klass) {
	gwibber_gtk_account_target_bar_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_account_target_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_account_target_bar_finalize;
}


static void gwibber_gtk_account_target_bar_instance_init (GwibberGtkAccountTargetBar * self) {
}


static void gwibber_gtk_account_target_bar_finalize (GObject* obj) {
	GwibberGtkAccountTargetBar * self;
	self = GWIBBER_GTK_ACCOUNT_TARGET_BAR (obj);
	_g_object_unref0 (self->accounts_service);
	_g_object_unref0 (self->conn_service);
	_g_object_unref0 (self->send);
	_g_hash_table_unref0 (self->accounts_buttons_table);
	G_OBJECT_CLASS (gwibber_gtk_account_target_bar_parent_class)->finalize (obj);
}


GType gwibber_gtk_account_target_bar_get_type (void) {
	static volatile gsize gwibber_gtk_account_target_bar_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_account_target_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkAccountTargetBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_account_target_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkAccountTargetBar), 0, (GInstanceInitFunc) gwibber_gtk_account_target_bar_instance_init, NULL };
		GType gwibber_gtk_account_target_bar_type_id;
		gwibber_gtk_account_target_bar_type_id = g_type_register_static (GTK_TYPE_HBOX, "GwibberGtkAccountTargetBar", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_account_target_bar_type_id__volatile, gwibber_gtk_account_target_bar_type_id);
	}
	return gwibber_gtk_account_target_bar_type_id__volatile;
}


GwibberGtkSendBar* gwibber_gtk_send_bar_construct (GType object_type, GwibberService* service) {
	GwibberGtkSendBar * self = NULL;
	g_return_val_if_fail (service != NULL, NULL);
	self = (GwibberGtkSendBar*) g_object_new (object_type, "service", service, "spacing", 5, NULL);
	return self;
}


GwibberGtkSendBar* gwibber_gtk_send_bar_new (GwibberService* service) {
	return gwibber_gtk_send_bar_construct (GWIBBER_GTK_TYPE_SEND_BAR, service);
}


GwibberService* gwibber_gtk_send_bar_get_service (GwibberGtkSendBar* self) {
	GwibberService* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_service;
	return result;
}


static void gwibber_gtk_send_bar_set_service (GwibberGtkSendBar* self, GwibberService* value) {
	GwibberService* _tmp0_;
	GwibberService* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_service);
	self->priv->_service = _tmp1_;
	g_object_notify ((GObject *) self, "service");
}


static GObject * gwibber_gtk_send_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkSendBar * self;
	GtkHBox* _tmp0_ = NULL;
	GtkHBox* box;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkButton* _tmp3_;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_send_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_SEND_BAR (obj);
	_tmp0_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	box = g_object_ref_sink (_tmp0_);
	_tmp1_ = _ ("Send");
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_tmp1_);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->send);
	self->send = _tmp3_;
	gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) self->send, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	_g_object_unref0 (box);
	return obj;
}


static void gwibber_gtk_send_bar_class_init (GwibberGtkSendBarClass * klass) {
	gwibber_gtk_send_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkSendBarPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_send_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_send_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_send_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_send_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_SEND_BAR_SERVICE, g_param_spec_object ("service", "service", "service", GWIBBER_TYPE_SERVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gwibber_gtk_send_bar_instance_init (GwibberGtkSendBar * self) {
	self->priv = GWIBBER_GTK_SEND_BAR_GET_PRIVATE (self);
}


static void gwibber_gtk_send_bar_finalize (GObject* obj) {
	GwibberGtkSendBar * self;
	self = GWIBBER_GTK_SEND_BAR (obj);
	_g_object_unref0 (self->priv->_service);
	_g_object_unref0 (self->send);
	G_OBJECT_CLASS (gwibber_gtk_send_bar_parent_class)->finalize (obj);
}


GType gwibber_gtk_send_bar_get_type (void) {
	static volatile gsize gwibber_gtk_send_bar_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_send_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkSendBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_send_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkSendBar), 0, (GInstanceInitFunc) gwibber_gtk_send_bar_instance_init, NULL };
		GType gwibber_gtk_send_bar_type_id;
		gwibber_gtk_send_bar_type_id = g_type_register_static (GTK_TYPE_HBOX, "GwibberGtkSendBar", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_send_bar_type_id__volatile, gwibber_gtk_send_bar_type_id);
	}
	return gwibber_gtk_send_bar_type_id__volatile;
}


static void _vala_gwibber_gtk_send_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkSendBar * self;
	self = GWIBBER_GTK_SEND_BAR (object);
	switch (property_id) {
		case GWIBBER_GTK_SEND_BAR_SERVICE:
		g_value_set_object (value, gwibber_gtk_send_bar_get_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_send_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkSendBar * self;
	self = GWIBBER_GTK_SEND_BAR (object);
	switch (property_id) {
		case GWIBBER_GTK_SEND_BAR_SERVICE:
		gwibber_gtk_send_bar_set_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



