package Date::Manip::TZ::aftrip00;
# Copyright (c) 2008-2012 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 30 12:40:01 EST 2012
#    Data version: tzdata2012j
#    Code version: tzcode2012j

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

=pod

=head1 NAME

Date::Manip::TZ::aftrip00 - Support for the Africa/Tripoli time zone

=head1 SYNPOSIS

This module contains data describing a time zone.  Most of the time zone
data comes from the Olsen database, but there are a few exceptions.

This module is not intended to be used directly.  Other Date::Manip modules
will load it as needed.

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.37';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,0,52,44],'+00:52:44',[0,52,44],
          'LMT',0,[1919,12,31,23,7,15],[1919,12,31,23,59,59],
          '0001010200:00:00','0001010200:52:44','1919123123:07:15','1919123123:59:59' ],
     ],
   1919 =>
     [
        [ [1919,12,31,23,7,16],[1920,1,1,0,7,16],'+01:00:00',[1,0,0],
          'CET',0,[1951,10,14,0,59,59],[1951,10,14,1,59,59],
          '1919123123:07:16','1920010100:07:16','1951101400:59:59','1951101401:59:59' ],
     ],
   1951 =>
     [
        [ [1951,10,14,1,0,0],[1951,10,14,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1951,12,31,21,59,59],[1951,12,31,23,59,59],
          '1951101401:00:00','1951101403:00:00','1951123121:59:59','1951123123:59:59' ],
        [ [1951,12,31,22,0,0],[1951,12,31,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1953,10,9,0,59,59],[1953,10,9,1,59,59],
          '1951123122:00:00','1951123123:00:00','1953100900:59:59','1953100901:59:59' ],
     ],
   1953 =>
     [
        [ [1953,10,9,1,0,0],[1953,10,9,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1953,12,31,21,59,59],[1953,12,31,23,59,59],
          '1953100901:00:00','1953100903:00:00','1953123121:59:59','1953123123:59:59' ],
        [ [1953,12,31,22,0,0],[1953,12,31,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1955,9,29,22,59,59],[1955,9,29,23,59,59],
          '1953123122:00:00','1953123123:00:00','1955092922:59:59','1955092923:59:59' ],
     ],
   1955 =>
     [
        [ [1955,9,29,23,0,0],[1955,9,30,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1955,12,31,21,59,59],[1955,12,31,23,59,59],
          '1955092923:00:00','1955093001:00:00','1955123121:59:59','1955123123:59:59' ],
        [ [1955,12,31,22,0,0],[1955,12,31,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1958,12,31,22,59,59],[1958,12,31,23,59,59],
          '1955123122:00:00','1955123123:00:00','1958123122:59:59','1958123123:59:59' ],
     ],
   1958 =>
     [
        [ [1958,12,31,23,0,0],[1959,1,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1981,12,31,21,59,59],[1981,12,31,23,59,59],
          '1958123123:00:00','1959010101:00:00','1981123121:59:59','1981123123:59:59' ],
     ],
   1981 =>
     [
        [ [1981,12,31,22,0,0],[1981,12,31,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1982,3,31,22,59,59],[1982,3,31,23,59,59],
          '1981123122:00:00','1981123123:00:00','1982033122:59:59','1982033123:59:59' ],
     ],
   1982 =>
     [
        [ [1982,3,31,23,0,0],[1982,4,1,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1982,9,30,21,59,59],[1982,9,30,23,59,59],
          '1982033123:00:00','1982040101:00:00','1982093021:59:59','1982093023:59:59' ],
        [ [1982,9,30,22,0,0],[1982,9,30,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1983,3,31,22,59,59],[1983,3,31,23,59,59],
          '1982093022:00:00','1982093023:00:00','1983033122:59:59','1983033123:59:59' ],
     ],
   1983 =>
     [
        [ [1983,3,31,23,0,0],[1983,4,1,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1983,9,30,21,59,59],[1983,9,30,23,59,59],
          '1983033123:00:00','1983040101:00:00','1983093021:59:59','1983093023:59:59' ],
        [ [1983,9,30,22,0,0],[1983,9,30,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1984,3,31,22,59,59],[1984,3,31,23,59,59],
          '1983093022:00:00','1983093023:00:00','1984033122:59:59','1984033123:59:59' ],
     ],
   1984 =>
     [
        [ [1984,3,31,23,0,0],[1984,4,1,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1984,9,30,21,59,59],[1984,9,30,23,59,59],
          '1984033123:00:00','1984040101:00:00','1984093021:59:59','1984093023:59:59' ],
        [ [1984,9,30,22,0,0],[1984,9,30,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1985,4,5,22,59,59],[1985,4,5,23,59,59],
          '1984093022:00:00','1984093023:00:00','1985040522:59:59','1985040523:59:59' ],
     ],
   1985 =>
     [
        [ [1985,4,5,23,0,0],[1985,4,6,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1985,9,30,21,59,59],[1985,9,30,23,59,59],
          '1985040523:00:00','1985040601:00:00','1985093021:59:59','1985093023:59:59' ],
        [ [1985,9,30,22,0,0],[1985,9,30,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1986,4,3,22,59,59],[1986,4,3,23,59,59],
          '1985093022:00:00','1985093023:00:00','1986040322:59:59','1986040323:59:59' ],
     ],
   1986 =>
     [
        [ [1986,4,3,23,0,0],[1986,4,4,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1986,10,2,21,59,59],[1986,10,2,23,59,59],
          '1986040323:00:00','1986040401:00:00','1986100221:59:59','1986100223:59:59' ],
        [ [1986,10,2,22,0,0],[1986,10,2,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1987,3,31,22,59,59],[1987,3,31,23,59,59],
          '1986100222:00:00','1986100223:00:00','1987033122:59:59','1987033123:59:59' ],
     ],
   1987 =>
     [
        [ [1987,3,31,23,0,0],[1987,4,1,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1987,9,30,21,59,59],[1987,9,30,23,59,59],
          '1987033123:00:00','1987040101:00:00','1987093021:59:59','1987093023:59:59' ],
        [ [1987,9,30,22,0,0],[1987,9,30,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1988,3,31,22,59,59],[1988,3,31,23,59,59],
          '1987093022:00:00','1987093023:00:00','1988033122:59:59','1988033123:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,31,23,0,0],[1988,4,1,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1988,9,30,21,59,59],[1988,9,30,23,59,59],
          '1988033123:00:00','1988040101:00:00','1988093021:59:59','1988093023:59:59' ],
        [ [1988,9,30,22,0,0],[1988,9,30,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1989,3,31,22,59,59],[1989,3,31,23,59,59],
          '1988093022:00:00','1988093023:00:00','1989033122:59:59','1989033123:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,31,23,0,0],[1989,4,1,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1989,9,30,21,59,59],[1989,9,30,23,59,59],
          '1989033123:00:00','1989040101:00:00','1989093021:59:59','1989093023:59:59' ],
        [ [1989,9,30,22,0,0],[1989,9,30,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1990,5,3,22,59,59],[1990,5,3,23,59,59],
          '1989093022:00:00','1989093023:00:00','1990050322:59:59','1990050323:59:59' ],
     ],
   1990 =>
     [
        [ [1990,5,3,23,0,0],[1990,5,4,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1996,9,29,21,59,59],[1996,9,29,23,59,59],
          '1990050323:00:00','1990050401:00:00','1996092921:59:59','1996092923:59:59' ],
     ],
   1996 =>
     [
        [ [1996,9,29,22,0,0],[1996,9,29,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1997,4,3,22,59,59],[1997,4,3,23,59,59],
          '1996092922:00:00','1996092923:00:00','1997040322:59:59','1997040323:59:59' ],
     ],
   1997 =>
     [
        [ [1997,4,3,23,0,0],[1997,4,4,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1997,10,3,21,59,59],[1997,10,3,23,59,59],
          '1997040323:00:00','1997040401:00:00','1997100321:59:59','1997100323:59:59' ],
        [ [1997,10,3,22,0,0],[1997,10,4,0,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2012,11,9,23,59,59],[2012,11,10,1,59,59],
          '1997100322:00:00','1997100400:00:00','2012110923:59:59','2012111001:59:59' ],
     ],
   2012 =>
     [
        [ [2012,11,10,0,0,0],[2012,11,10,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2013,3,28,23,59,59],[2013,3,29,0,59,59],
          '2012111000:00:00','2012111001:00:00','2013032823:59:59','2013032900:59:59' ],
     ],
   2013 =>
     [
        [ [2013,3,29,0,0,0],[2013,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2013,10,24,23,59,59],[2013,10,25,1,59,59],
          '2013032900:00:00','2013032902:00:00','2013102423:59:59','2013102501:59:59' ],
        [ [2013,10,25,0,0,0],[2013,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2014,3,27,23,59,59],[2014,3,28,0,59,59],
          '2013102500:00:00','2013102501:00:00','2014032723:59:59','2014032800:59:59' ],
     ],
   2014 =>
     [
        [ [2014,3,28,0,0,0],[2014,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2014,10,30,23,59,59],[2014,10,31,1,59,59],
          '2014032800:00:00','2014032802:00:00','2014103023:59:59','2014103101:59:59' ],
        [ [2014,10,31,0,0,0],[2014,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2015,3,26,23,59,59],[2015,3,27,0,59,59],
          '2014103100:00:00','2014103101:00:00','2015032623:59:59','2015032700:59:59' ],
     ],
   2015 =>
     [
        [ [2015,3,27,0,0,0],[2015,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2015,10,29,23,59,59],[2015,10,30,1,59,59],
          '2015032700:00:00','2015032702:00:00','2015102923:59:59','2015103001:59:59' ],
        [ [2015,10,30,0,0,0],[2015,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2016,3,24,23,59,59],[2016,3,25,0,59,59],
          '2015103000:00:00','2015103001:00:00','2016032423:59:59','2016032500:59:59' ],
     ],
   2016 =>
     [
        [ [2016,3,25,0,0,0],[2016,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2016,10,27,23,59,59],[2016,10,28,1,59,59],
          '2016032500:00:00','2016032502:00:00','2016102723:59:59','2016102801:59:59' ],
        [ [2016,10,28,0,0,0],[2016,10,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2017,3,30,23,59,59],[2017,3,31,0,59,59],
          '2016102800:00:00','2016102801:00:00','2017033023:59:59','2017033100:59:59' ],
     ],
   2017 =>
     [
        [ [2017,3,31,0,0,0],[2017,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2017,10,26,23,59,59],[2017,10,27,1,59,59],
          '2017033100:00:00','2017033102:00:00','2017102623:59:59','2017102701:59:59' ],
        [ [2017,10,27,0,0,0],[2017,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2018,3,29,23,59,59],[2018,3,30,0,59,59],
          '2017102700:00:00','2017102701:00:00','2018032923:59:59','2018033000:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,30,0,0,0],[2018,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2018,10,25,23,59,59],[2018,10,26,1,59,59],
          '2018033000:00:00','2018033002:00:00','2018102523:59:59','2018102601:59:59' ],
        [ [2018,10,26,0,0,0],[2018,10,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2019,3,28,23,59,59],[2019,3,29,0,59,59],
          '2018102600:00:00','2018102601:00:00','2019032823:59:59','2019032900:59:59' ],
     ],
   2019 =>
     [
        [ [2019,3,29,0,0,0],[2019,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2019,10,24,23,59,59],[2019,10,25,1,59,59],
          '2019032900:00:00','2019032902:00:00','2019102423:59:59','2019102501:59:59' ],
        [ [2019,10,25,0,0,0],[2019,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2020,3,26,23,59,59],[2020,3,27,0,59,59],
          '2019102500:00:00','2019102501:00:00','2020032623:59:59','2020032700:59:59' ],
     ],
   2020 =>
     [
        [ [2020,3,27,0,0,0],[2020,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2020,10,29,23,59,59],[2020,10,30,1,59,59],
          '2020032700:00:00','2020032702:00:00','2020102923:59:59','2020103001:59:59' ],
        [ [2020,10,30,0,0,0],[2020,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2021,3,25,23,59,59],[2021,3,26,0,59,59],
          '2020103000:00:00','2020103001:00:00','2021032523:59:59','2021032600:59:59' ],
     ],
   2021 =>
     [
        [ [2021,3,26,0,0,0],[2021,3,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2021,10,28,23,59,59],[2021,10,29,1,59,59],
          '2021032600:00:00','2021032602:00:00','2021102823:59:59','2021102901:59:59' ],
        [ [2021,10,29,0,0,0],[2021,10,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2022,3,24,23,59,59],[2022,3,25,0,59,59],
          '2021102900:00:00','2021102901:00:00','2022032423:59:59','2022032500:59:59' ],
     ],
   2022 =>
     [
        [ [2022,3,25,0,0,0],[2022,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2022,10,27,23,59,59],[2022,10,28,1,59,59],
          '2022032500:00:00','2022032502:00:00','2022102723:59:59','2022102801:59:59' ],
        [ [2022,10,28,0,0,0],[2022,10,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2023,3,30,23,59,59],[2023,3,31,0,59,59],
          '2022102800:00:00','2022102801:00:00','2023033023:59:59','2023033100:59:59' ],
     ],
   2023 =>
     [
        [ [2023,3,31,0,0,0],[2023,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2023,10,26,23,59,59],[2023,10,27,1,59,59],
          '2023033100:00:00','2023033102:00:00','2023102623:59:59','2023102701:59:59' ],
        [ [2023,10,27,0,0,0],[2023,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2024,3,28,23,59,59],[2024,3,29,0,59,59],
          '2023102700:00:00','2023102701:00:00','2024032823:59:59','2024032900:59:59' ],
     ],
   2024 =>
     [
        [ [2024,3,29,0,0,0],[2024,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2024,10,24,23,59,59],[2024,10,25,1,59,59],
          '2024032900:00:00','2024032902:00:00','2024102423:59:59','2024102501:59:59' ],
        [ [2024,10,25,0,0,0],[2024,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2025,3,27,23,59,59],[2025,3,28,0,59,59],
          '2024102500:00:00','2024102501:00:00','2025032723:59:59','2025032800:59:59' ],
     ],
   2025 =>
     [
        [ [2025,3,28,0,0,0],[2025,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2025,10,30,23,59,59],[2025,10,31,1,59,59],
          '2025032800:00:00','2025032802:00:00','2025103023:59:59','2025103101:59:59' ],
        [ [2025,10,31,0,0,0],[2025,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2026,3,26,23,59,59],[2026,3,27,0,59,59],
          '2025103100:00:00','2025103101:00:00','2026032623:59:59','2026032700:59:59' ],
     ],
   2026 =>
     [
        [ [2026,3,27,0,0,0],[2026,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2026,10,29,23,59,59],[2026,10,30,1,59,59],
          '2026032700:00:00','2026032702:00:00','2026102923:59:59','2026103001:59:59' ],
        [ [2026,10,30,0,0,0],[2026,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2027,3,25,23,59,59],[2027,3,26,0,59,59],
          '2026103000:00:00','2026103001:00:00','2027032523:59:59','2027032600:59:59' ],
     ],
   2027 =>
     [
        [ [2027,3,26,0,0,0],[2027,3,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2027,10,28,23,59,59],[2027,10,29,1,59,59],
          '2027032600:00:00','2027032602:00:00','2027102823:59:59','2027102901:59:59' ],
        [ [2027,10,29,0,0,0],[2027,10,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2028,3,30,23,59,59],[2028,3,31,0,59,59],
          '2027102900:00:00','2027102901:00:00','2028033023:59:59','2028033100:59:59' ],
     ],
   2028 =>
     [
        [ [2028,3,31,0,0,0],[2028,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2028,10,26,23,59,59],[2028,10,27,1,59,59],
          '2028033100:00:00','2028033102:00:00','2028102623:59:59','2028102701:59:59' ],
        [ [2028,10,27,0,0,0],[2028,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2029,3,29,23,59,59],[2029,3,30,0,59,59],
          '2028102700:00:00','2028102701:00:00','2029032923:59:59','2029033000:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,30,0,0,0],[2029,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2029,10,25,23,59,59],[2029,10,26,1,59,59],
          '2029033000:00:00','2029033002:00:00','2029102523:59:59','2029102601:59:59' ],
        [ [2029,10,26,0,0,0],[2029,10,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2030,3,28,23,59,59],[2030,3,29,0,59,59],
          '2029102600:00:00','2029102601:00:00','2030032823:59:59','2030032900:59:59' ],
     ],
   2030 =>
     [
        [ [2030,3,29,0,0,0],[2030,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2030,10,24,23,59,59],[2030,10,25,1,59,59],
          '2030032900:00:00','2030032902:00:00','2030102423:59:59','2030102501:59:59' ],
        [ [2030,10,25,0,0,0],[2030,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2031,3,27,23,59,59],[2031,3,28,0,59,59],
          '2030102500:00:00','2030102501:00:00','2031032723:59:59','2031032800:59:59' ],
     ],
   2031 =>
     [
        [ [2031,3,28,0,0,0],[2031,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2031,10,30,23,59,59],[2031,10,31,1,59,59],
          '2031032800:00:00','2031032802:00:00','2031103023:59:59','2031103101:59:59' ],
        [ [2031,10,31,0,0,0],[2031,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2032,3,25,23,59,59],[2032,3,26,0,59,59],
          '2031103100:00:00','2031103101:00:00','2032032523:59:59','2032032600:59:59' ],
     ],
   2032 =>
     [
        [ [2032,3,26,0,0,0],[2032,3,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2032,10,28,23,59,59],[2032,10,29,1,59,59],
          '2032032600:00:00','2032032602:00:00','2032102823:59:59','2032102901:59:59' ],
        [ [2032,10,29,0,0,0],[2032,10,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2033,3,24,23,59,59],[2033,3,25,0,59,59],
          '2032102900:00:00','2032102901:00:00','2033032423:59:59','2033032500:59:59' ],
     ],
   2033 =>
     [
        [ [2033,3,25,0,0,0],[2033,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2033,10,27,23,59,59],[2033,10,28,1,59,59],
          '2033032500:00:00','2033032502:00:00','2033102723:59:59','2033102801:59:59' ],
        [ [2033,10,28,0,0,0],[2033,10,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2034,3,30,23,59,59],[2034,3,31,0,59,59],
          '2033102800:00:00','2033102801:00:00','2034033023:59:59','2034033100:59:59' ],
     ],
   2034 =>
     [
        [ [2034,3,31,0,0,0],[2034,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2034,10,26,23,59,59],[2034,10,27,1,59,59],
          '2034033100:00:00','2034033102:00:00','2034102623:59:59','2034102701:59:59' ],
        [ [2034,10,27,0,0,0],[2034,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2035,3,29,23,59,59],[2035,3,30,0,59,59],
          '2034102700:00:00','2034102701:00:00','2035032923:59:59','2035033000:59:59' ],
     ],
   2035 =>
     [
        [ [2035,3,30,0,0,0],[2035,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2035,10,25,23,59,59],[2035,10,26,1,59,59],
          '2035033000:00:00','2035033002:00:00','2035102523:59:59','2035102601:59:59' ],
        [ [2035,10,26,0,0,0],[2035,10,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2036,3,27,23,59,59],[2036,3,28,0,59,59],
          '2035102600:00:00','2035102601:00:00','2036032723:59:59','2036032800:59:59' ],
     ],
   2036 =>
     [
        [ [2036,3,28,0,0,0],[2036,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2036,10,30,23,59,59],[2036,10,31,1,59,59],
          '2036032800:00:00','2036032802:00:00','2036103023:59:59','2036103101:59:59' ],
        [ [2036,10,31,0,0,0],[2036,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2037,3,26,23,59,59],[2037,3,27,0,59,59],
          '2036103100:00:00','2036103101:00:00','2037032623:59:59','2037032700:59:59' ],
     ],
   2037 =>
     [
        [ [2037,3,27,0,0,0],[2037,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2037,10,29,23,59,59],[2037,10,30,1,59,59],
          '2037032700:00:00','2037032702:00:00','2037102923:59:59','2037103001:59:59' ],
        [ [2037,10,30,0,0,0],[2037,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2038,3,25,23,59,59],[2038,3,26,0,59,59],
          '2037103000:00:00','2037103001:00:00','2038032523:59:59','2038032600:59:59' ],
     ],
   2038 =>
     [
        [ [2038,3,26,0,0,0],[2038,3,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2038,10,28,23,59,59],[2038,10,29,1,59,59],
          '2038032600:00:00','2038032602:00:00','2038102823:59:59','2038102901:59:59' ],
        [ [2038,10,29,0,0,0],[2038,10,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2039,3,24,23,59,59],[2039,3,25,0,59,59],
          '2038102900:00:00','2038102901:00:00','2039032423:59:59','2039032500:59:59' ],
     ],
   2039 =>
     [
        [ [2039,3,25,0,0,0],[2039,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2039,10,27,23,59,59],[2039,10,28,1,59,59],
          '2039032500:00:00','2039032502:00:00','2039102723:59:59','2039102801:59:59' ],
        [ [2039,10,28,0,0,0],[2039,10,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2040,3,29,23,59,59],[2040,3,30,0,59,59],
          '2039102800:00:00','2039102801:00:00','2040032923:59:59','2040033000:59:59' ],
     ],
   2040 =>
     [
        [ [2040,3,30,0,0,0],[2040,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2040,10,25,23,59,59],[2040,10,26,1,59,59],
          '2040033000:00:00','2040033002:00:00','2040102523:59:59','2040102601:59:59' ],
        [ [2040,10,26,0,0,0],[2040,10,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2041,3,28,23,59,59],[2041,3,29,0,59,59],
          '2040102600:00:00','2040102601:00:00','2041032823:59:59','2041032900:59:59' ],
     ],
   2041 =>
     [
        [ [2041,3,29,0,0,0],[2041,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2041,10,24,23,59,59],[2041,10,25,1,59,59],
          '2041032900:00:00','2041032902:00:00','2041102423:59:59','2041102501:59:59' ],
        [ [2041,10,25,0,0,0],[2041,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2042,3,27,23,59,59],[2042,3,28,0,59,59],
          '2041102500:00:00','2041102501:00:00','2042032723:59:59','2042032800:59:59' ],
     ],
   2042 =>
     [
        [ [2042,3,28,0,0,0],[2042,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2042,10,30,23,59,59],[2042,10,31,1,59,59],
          '2042032800:00:00','2042032802:00:00','2042103023:59:59','2042103101:59:59' ],
        [ [2042,10,31,0,0,0],[2042,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2043,3,26,23,59,59],[2043,3,27,0,59,59],
          '2042103100:00:00','2042103101:00:00','2043032623:59:59','2043032700:59:59' ],
     ],
   2043 =>
     [
        [ [2043,3,27,0,0,0],[2043,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2043,10,29,23,59,59],[2043,10,30,1,59,59],
          '2043032700:00:00','2043032702:00:00','2043102923:59:59','2043103001:59:59' ],
        [ [2043,10,30,0,0,0],[2043,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2044,3,24,23,59,59],[2044,3,25,0,59,59],
          '2043103000:00:00','2043103001:00:00','2044032423:59:59','2044032500:59:59' ],
     ],
   2044 =>
     [
        [ [2044,3,25,0,0,0],[2044,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2044,10,27,23,59,59],[2044,10,28,1,59,59],
          '2044032500:00:00','2044032502:00:00','2044102723:59:59','2044102801:59:59' ],
        [ [2044,10,28,0,0,0],[2044,10,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2045,3,30,23,59,59],[2045,3,31,0,59,59],
          '2044102800:00:00','2044102801:00:00','2045033023:59:59','2045033100:59:59' ],
     ],
   2045 =>
     [
        [ [2045,3,31,0,0,0],[2045,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2045,10,26,23,59,59],[2045,10,27,1,59,59],
          '2045033100:00:00','2045033102:00:00','2045102623:59:59','2045102701:59:59' ],
        [ [2045,10,27,0,0,0],[2045,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2046,3,29,23,59,59],[2046,3,30,0,59,59],
          '2045102700:00:00','2045102701:00:00','2046032923:59:59','2046033000:59:59' ],
     ],
   2046 =>
     [
        [ [2046,3,30,0,0,0],[2046,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2046,10,25,23,59,59],[2046,10,26,1,59,59],
          '2046033000:00:00','2046033002:00:00','2046102523:59:59','2046102601:59:59' ],
        [ [2046,10,26,0,0,0],[2046,10,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2047,3,28,23,59,59],[2047,3,29,0,59,59],
          '2046102600:00:00','2046102601:00:00','2047032823:59:59','2047032900:59:59' ],
     ],
   2047 =>
     [
        [ [2047,3,29,0,0,0],[2047,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2047,10,24,23,59,59],[2047,10,25,1,59,59],
          '2047032900:00:00','2047032902:00:00','2047102423:59:59','2047102501:59:59' ],
        [ [2047,10,25,0,0,0],[2047,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2048,3,26,23,59,59],[2048,3,27,0,59,59],
          '2047102500:00:00','2047102501:00:00','2048032623:59:59','2048032700:59:59' ],
     ],
   2048 =>
     [
        [ [2048,3,27,0,0,0],[2048,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2048,10,29,23,59,59],[2048,10,30,1,59,59],
          '2048032700:00:00','2048032702:00:00','2048102923:59:59','2048103001:59:59' ],
        [ [2048,10,30,0,0,0],[2048,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2049,3,25,23,59,59],[2049,3,26,0,59,59],
          '2048103000:00:00','2048103001:00:00','2049032523:59:59','2049032600:59:59' ],
     ],
   2049 =>
     [
        [ [2049,3,26,0,0,0],[2049,3,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2049,10,28,23,59,59],[2049,10,29,1,59,59],
          '2049032600:00:00','2049032602:00:00','2049102823:59:59','2049102901:59:59' ],
        [ [2049,10,29,0,0,0],[2049,10,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2050,3,24,23,59,59],[2050,3,25,0,59,59],
          '2049102900:00:00','2049102901:00:00','2050032423:59:59','2050032500:59:59' ],
     ],
   2050 =>
     [
        [ [2050,3,25,0,0,0],[2050,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2050,10,27,23,59,59],[2050,10,28,1,59,59],
          '2050032500:00:00','2050032502:00:00','2050102723:59:59','2050102801:59:59' ],
        [ [2050,10,28,0,0,0],[2050,10,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2051,3,30,23,59,59],[2051,3,31,0,59,59],
          '2050102800:00:00','2050102801:00:00','2051033023:59:59','2051033100:59:59' ],
     ],
   2051 =>
     [
        [ [2051,3,31,0,0,0],[2051,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2051,10,26,23,59,59],[2051,10,27,1,59,59],
          '2051033100:00:00','2051033102:00:00','2051102623:59:59','2051102701:59:59' ],
        [ [2051,10,27,0,0,0],[2051,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2052,3,28,23,59,59],[2052,3,29,0,59,59],
          '2051102700:00:00','2051102701:00:00','2052032823:59:59','2052032900:59:59' ],
     ],
   2052 =>
     [
        [ [2052,3,29,0,0,0],[2052,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2052,10,24,23,59,59],[2052,10,25,1,59,59],
          '2052032900:00:00','2052032902:00:00','2052102423:59:59','2052102501:59:59' ],
        [ [2052,10,25,0,0,0],[2052,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2053,3,27,23,59,59],[2053,3,28,0,59,59],
          '2052102500:00:00','2052102501:00:00','2053032723:59:59','2053032800:59:59' ],
     ],
   2053 =>
     [
        [ [2053,3,28,0,0,0],[2053,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2053,10,30,23,59,59],[2053,10,31,1,59,59],
          '2053032800:00:00','2053032802:00:00','2053103023:59:59','2053103101:59:59' ],
        [ [2053,10,31,0,0,0],[2053,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2054,3,26,23,59,59],[2054,3,27,0,59,59],
          '2053103100:00:00','2053103101:00:00','2054032623:59:59','2054032700:59:59' ],
     ],
   2054 =>
     [
        [ [2054,3,27,0,0,0],[2054,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2054,10,29,23,59,59],[2054,10,30,1,59,59],
          '2054032700:00:00','2054032702:00:00','2054102923:59:59','2054103001:59:59' ],
        [ [2054,10,30,0,0,0],[2054,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2055,3,25,23,59,59],[2055,3,26,0,59,59],
          '2054103000:00:00','2054103001:00:00','2055032523:59:59','2055032600:59:59' ],
     ],
   2055 =>
     [
        [ [2055,3,26,0,0,0],[2055,3,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2055,10,28,23,59,59],[2055,10,29,1,59,59],
          '2055032600:00:00','2055032602:00:00','2055102823:59:59','2055102901:59:59' ],
        [ [2055,10,29,0,0,0],[2055,10,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2056,3,30,23,59,59],[2056,3,31,0,59,59],
          '2055102900:00:00','2055102901:00:00','2056033023:59:59','2056033100:59:59' ],
     ],
   2056 =>
     [
        [ [2056,3,31,0,0,0],[2056,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2056,10,26,23,59,59],[2056,10,27,1,59,59],
          '2056033100:00:00','2056033102:00:00','2056102623:59:59','2056102701:59:59' ],
        [ [2056,10,27,0,0,0],[2056,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2057,3,29,23,59,59],[2057,3,30,0,59,59],
          '2056102700:00:00','2056102701:00:00','2057032923:59:59','2057033000:59:59' ],
     ],
   2057 =>
     [
        [ [2057,3,30,0,0,0],[2057,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2057,10,25,23,59,59],[2057,10,26,1,59,59],
          '2057033000:00:00','2057033002:00:00','2057102523:59:59','2057102601:59:59' ],
        [ [2057,10,26,0,0,0],[2057,10,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2058,3,28,23,59,59],[2058,3,29,0,59,59],
          '2057102600:00:00','2057102601:00:00','2058032823:59:59','2058032900:59:59' ],
     ],
   2058 =>
     [
        [ [2058,3,29,0,0,0],[2058,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2058,10,24,23,59,59],[2058,10,25,1,59,59],
          '2058032900:00:00','2058032902:00:00','2058102423:59:59','2058102501:59:59' ],
        [ [2058,10,25,0,0,0],[2058,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2059,3,27,23,59,59],[2059,3,28,0,59,59],
          '2058102500:00:00','2058102501:00:00','2059032723:59:59','2059032800:59:59' ],
     ],
   2059 =>
     [
        [ [2059,3,28,0,0,0],[2059,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2059,10,30,23,59,59],[2059,10,31,1,59,59],
          '2059032800:00:00','2059032802:00:00','2059103023:59:59','2059103101:59:59' ],
        [ [2059,10,31,0,0,0],[2059,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2060,3,25,23,59,59],[2060,3,26,0,59,59],
          '2059103100:00:00','2059103101:00:00','2060032523:59:59','2060032600:59:59' ],
     ],
   2060 =>
     [
        [ [2060,3,26,0,0,0],[2060,3,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2060,10,28,23,59,59],[2060,10,29,1,59,59],
          '2060032600:00:00','2060032602:00:00','2060102823:59:59','2060102901:59:59' ],
        [ [2060,10,29,0,0,0],[2060,10,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2061,3,24,23,59,59],[2061,3,25,0,59,59],
          '2060102900:00:00','2060102901:00:00','2061032423:59:59','2061032500:59:59' ],
     ],
   2061 =>
     [
        [ [2061,3,25,0,0,0],[2061,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2061,10,27,23,59,59],[2061,10,28,1,59,59],
          '2061032500:00:00','2061032502:00:00','2061102723:59:59','2061102801:59:59' ],
        [ [2061,10,28,0,0,0],[2061,10,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2062,3,30,23,59,59],[2062,3,31,0,59,59],
          '2061102800:00:00','2061102801:00:00','2062033023:59:59','2062033100:59:59' ],
     ],
   2062 =>
     [
        [ [2062,3,31,0,0,0],[2062,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2062,10,26,23,59,59],[2062,10,27,1,59,59],
          '2062033100:00:00','2062033102:00:00','2062102623:59:59','2062102701:59:59' ],
        [ [2062,10,27,0,0,0],[2062,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2063,3,29,23,59,59],[2063,3,30,0,59,59],
          '2062102700:00:00','2062102701:00:00','2063032923:59:59','2063033000:59:59' ],
     ],
   2063 =>
     [
        [ [2063,3,30,0,0,0],[2063,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2063,10,25,23,59,59],[2063,10,26,1,59,59],
          '2063033000:00:00','2063033002:00:00','2063102523:59:59','2063102601:59:59' ],
        [ [2063,10,26,0,0,0],[2063,10,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2064,3,27,23,59,59],[2064,3,28,0,59,59],
          '2063102600:00:00','2063102601:00:00','2064032723:59:59','2064032800:59:59' ],
     ],
   2064 =>
     [
        [ [2064,3,28,0,0,0],[2064,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2064,10,30,23,59,59],[2064,10,31,1,59,59],
          '2064032800:00:00','2064032802:00:00','2064103023:59:59','2064103101:59:59' ],
        [ [2064,10,31,0,0,0],[2064,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2065,3,26,23,59,59],[2065,3,27,0,59,59],
          '2064103100:00:00','2064103101:00:00','2065032623:59:59','2065032700:59:59' ],
     ],
   2065 =>
     [
        [ [2065,3,27,0,0,0],[2065,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2065,10,29,23,59,59],[2065,10,30,1,59,59],
          '2065032700:00:00','2065032702:00:00','2065102923:59:59','2065103001:59:59' ],
        [ [2065,10,30,0,0,0],[2065,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2066,3,25,23,59,59],[2066,3,26,0,59,59],
          '2065103000:00:00','2065103001:00:00','2066032523:59:59','2066032600:59:59' ],
     ],
   2066 =>
     [
        [ [2066,3,26,0,0,0],[2066,3,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2066,10,28,23,59,59],[2066,10,29,1,59,59],
          '2066032600:00:00','2066032602:00:00','2066102823:59:59','2066102901:59:59' ],
        [ [2066,10,29,0,0,0],[2066,10,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2067,3,24,23,59,59],[2067,3,25,0,59,59],
          '2066102900:00:00','2066102901:00:00','2067032423:59:59','2067032500:59:59' ],
     ],
   2067 =>
     [
        [ [2067,3,25,0,0,0],[2067,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2067,10,27,23,59,59],[2067,10,28,1,59,59],
          '2067032500:00:00','2067032502:00:00','2067102723:59:59','2067102801:59:59' ],
        [ [2067,10,28,0,0,0],[2067,10,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2068,3,29,23,59,59],[2068,3,30,0,59,59],
          '2067102800:00:00','2067102801:00:00','2068032923:59:59','2068033000:59:59' ],
     ],
   2068 =>
     [
        [ [2068,3,30,0,0,0],[2068,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2068,10,25,23,59,59],[2068,10,26,1,59,59],
          '2068033000:00:00','2068033002:00:00','2068102523:59:59','2068102601:59:59' ],
        [ [2068,10,26,0,0,0],[2068,10,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2069,3,28,23,59,59],[2069,3,29,0,59,59],
          '2068102600:00:00','2068102601:00:00','2069032823:59:59','2069032900:59:59' ],
     ],
   2069 =>
     [
        [ [2069,3,29,0,0,0],[2069,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2069,10,24,23,59,59],[2069,10,25,1,59,59],
          '2069032900:00:00','2069032902:00:00','2069102423:59:59','2069102501:59:59' ],
        [ [2069,10,25,0,0,0],[2069,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2070,3,27,23,59,59],[2070,3,28,0,59,59],
          '2069102500:00:00','2069102501:00:00','2070032723:59:59','2070032800:59:59' ],
     ],
   2070 =>
     [
        [ [2070,3,28,0,0,0],[2070,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2070,10,30,23,59,59],[2070,10,31,1,59,59],
          '2070032800:00:00','2070032802:00:00','2070103023:59:59','2070103101:59:59' ],
        [ [2070,10,31,0,0,0],[2070,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2071,3,26,23,59,59],[2071,3,27,0,59,59],
          '2070103100:00:00','2070103101:00:00','2071032623:59:59','2071032700:59:59' ],
     ],
   2071 =>
     [
        [ [2071,3,27,0,0,0],[2071,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2071,10,29,23,59,59],[2071,10,30,1,59,59],
          '2071032700:00:00','2071032702:00:00','2071102923:59:59','2071103001:59:59' ],
        [ [2071,10,30,0,0,0],[2071,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2072,3,24,23,59,59],[2072,3,25,0,59,59],
          '2071103000:00:00','2071103001:00:00','2072032423:59:59','2072032500:59:59' ],
     ],
   2072 =>
     [
        [ [2072,3,25,0,0,0],[2072,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2072,10,27,23,59,59],[2072,10,28,1,59,59],
          '2072032500:00:00','2072032502:00:00','2072102723:59:59','2072102801:59:59' ],
        [ [2072,10,28,0,0,0],[2072,10,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2073,3,30,23,59,59],[2073,3,31,0,59,59],
          '2072102800:00:00','2072102801:00:00','2073033023:59:59','2073033100:59:59' ],
     ],
   2073 =>
     [
        [ [2073,3,31,0,0,0],[2073,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2073,10,26,23,59,59],[2073,10,27,1,59,59],
          '2073033100:00:00','2073033102:00:00','2073102623:59:59','2073102701:59:59' ],
        [ [2073,10,27,0,0,0],[2073,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2074,3,29,23,59,59],[2074,3,30,0,59,59],
          '2073102700:00:00','2073102701:00:00','2074032923:59:59','2074033000:59:59' ],
     ],
   2074 =>
     [
        [ [2074,3,30,0,0,0],[2074,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2074,10,25,23,59,59],[2074,10,26,1,59,59],
          '2074033000:00:00','2074033002:00:00','2074102523:59:59','2074102601:59:59' ],
        [ [2074,10,26,0,0,0],[2074,10,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2075,3,28,23,59,59],[2075,3,29,0,59,59],
          '2074102600:00:00','2074102601:00:00','2075032823:59:59','2075032900:59:59' ],
     ],
   2075 =>
     [
        [ [2075,3,29,0,0,0],[2075,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2075,10,24,23,59,59],[2075,10,25,1,59,59],
          '2075032900:00:00','2075032902:00:00','2075102423:59:59','2075102501:59:59' ],
        [ [2075,10,25,0,0,0],[2075,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2076,3,26,23,59,59],[2076,3,27,0,59,59],
          '2075102500:00:00','2075102501:00:00','2076032623:59:59','2076032700:59:59' ],
     ],
   2076 =>
     [
        [ [2076,3,27,0,0,0],[2076,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2076,10,29,23,59,59],[2076,10,30,1,59,59],
          '2076032700:00:00','2076032702:00:00','2076102923:59:59','2076103001:59:59' ],
        [ [2076,10,30,0,0,0],[2076,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2077,3,25,23,59,59],[2077,3,26,0,59,59],
          '2076103000:00:00','2076103001:00:00','2077032523:59:59','2077032600:59:59' ],
     ],
   2077 =>
     [
        [ [2077,3,26,0,0,0],[2077,3,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2077,10,28,23,59,59],[2077,10,29,1,59,59],
          '2077032600:00:00','2077032602:00:00','2077102823:59:59','2077102901:59:59' ],
        [ [2077,10,29,0,0,0],[2077,10,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2078,3,24,23,59,59],[2078,3,25,0,59,59],
          '2077102900:00:00','2077102901:00:00','2078032423:59:59','2078032500:59:59' ],
     ],
   2078 =>
     [
        [ [2078,3,25,0,0,0],[2078,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2078,10,27,23,59,59],[2078,10,28,1,59,59],
          '2078032500:00:00','2078032502:00:00','2078102723:59:59','2078102801:59:59' ],
        [ [2078,10,28,0,0,0],[2078,10,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2079,3,30,23,59,59],[2079,3,31,0,59,59],
          '2078102800:00:00','2078102801:00:00','2079033023:59:59','2079033100:59:59' ],
     ],
   2079 =>
     [
        [ [2079,3,31,0,0,0],[2079,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2079,10,26,23,59,59],[2079,10,27,1,59,59],
          '2079033100:00:00','2079033102:00:00','2079102623:59:59','2079102701:59:59' ],
        [ [2079,10,27,0,0,0],[2079,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2080,3,28,23,59,59],[2080,3,29,0,59,59],
          '2079102700:00:00','2079102701:00:00','2080032823:59:59','2080032900:59:59' ],
     ],
   2080 =>
     [
        [ [2080,3,29,0,0,0],[2080,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2080,10,24,23,59,59],[2080,10,25,1,59,59],
          '2080032900:00:00','2080032902:00:00','2080102423:59:59','2080102501:59:59' ],
        [ [2080,10,25,0,0,0],[2080,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2081,3,27,23,59,59],[2081,3,28,0,59,59],
          '2080102500:00:00','2080102501:00:00','2081032723:59:59','2081032800:59:59' ],
     ],
   2081 =>
     [
        [ [2081,3,28,0,0,0],[2081,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2081,10,30,23,59,59],[2081,10,31,1,59,59],
          '2081032800:00:00','2081032802:00:00','2081103023:59:59','2081103101:59:59' ],
        [ [2081,10,31,0,0,0],[2081,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2082,3,26,23,59,59],[2082,3,27,0,59,59],
          '2081103100:00:00','2081103101:00:00','2082032623:59:59','2082032700:59:59' ],
     ],
   2082 =>
     [
        [ [2082,3,27,0,0,0],[2082,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2082,10,29,23,59,59],[2082,10,30,1,59,59],
          '2082032700:00:00','2082032702:00:00','2082102923:59:59','2082103001:59:59' ],
        [ [2082,10,30,0,0,0],[2082,10,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2083,3,25,23,59,59],[2083,3,26,0,59,59],
          '2082103000:00:00','2082103001:00:00','2083032523:59:59','2083032600:59:59' ],
     ],
   2083 =>
     [
        [ [2083,3,26,0,0,0],[2083,3,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2083,10,28,23,59,59],[2083,10,29,1,59,59],
          '2083032600:00:00','2083032602:00:00','2083102823:59:59','2083102901:59:59' ],
        [ [2083,10,29,0,0,0],[2083,10,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2084,3,30,23,59,59],[2084,3,31,0,59,59],
          '2083102900:00:00','2083102901:00:00','2084033023:59:59','2084033100:59:59' ],
     ],
   2084 =>
     [
        [ [2084,3,31,0,0,0],[2084,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2084,10,26,23,59,59],[2084,10,27,1,59,59],
          '2084033100:00:00','2084033102:00:00','2084102623:59:59','2084102701:59:59' ],
        [ [2084,10,27,0,0,0],[2084,10,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2085,3,29,23,59,59],[2085,3,30,0,59,59],
          '2084102700:00:00','2084102701:00:00','2085032923:59:59','2085033000:59:59' ],
     ],
   2085 =>
     [
        [ [2085,3,30,0,0,0],[2085,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2085,10,25,23,59,59],[2085,10,26,1,59,59],
          '2085033000:00:00','2085033002:00:00','2085102523:59:59','2085102601:59:59' ],
        [ [2085,10,26,0,0,0],[2085,10,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2086,3,28,23,59,59],[2086,3,29,0,59,59],
          '2085102600:00:00','2085102601:00:00','2086032823:59:59','2086032900:59:59' ],
     ],
   2086 =>
     [
        [ [2086,3,29,0,0,0],[2086,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2086,10,24,23,59,59],[2086,10,25,1,59,59],
          '2086032900:00:00','2086032902:00:00','2086102423:59:59','2086102501:59:59' ],
        [ [2086,10,25,0,0,0],[2086,10,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2087,3,27,23,59,59],[2087,3,28,0,59,59],
          '2086102500:00:00','2086102501:00:00','2087032723:59:59','2087032800:59:59' ],
     ],
   2087 =>
     [
        [ [2087,3,28,0,0,0],[2087,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2087,10,30,23,59,59],[2087,10,31,1,59,59],
          '2087032800:00:00','2087032802:00:00','2087103023:59:59','2087103101:59:59' ],
        [ [2087,10,31,0,0,0],[2087,10,31,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2088,3,25,23,59,59],[2088,3,26,0,59,59],
          '2087103100:00:00','2087103101:00:00','2088032523:59:59','2088032600:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+02:00:00',
                'stdoff' => '+01:00:00',
               },
   'rules'  => {
                '03' => {
                         'flag'    => 'last',
                         'dow'     => '5',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '01:00:00',
                         'isdst'   => '1',
                         'abb'     => 'CEST',
                        },
                '10' => {
                         'flag'    => 'last',
                         'dow'     => '5',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'CET',
                        },
               },
);

1;
