/*
 *  linux/arch/arm/mm/proc-sheeva_pj4bv6.S
 *
 *  Copyright (C) 2001 Deep Blue Solutions Ltd.
 *  Modified by Catalin Marinas for noMMU support
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  This is the "shell" of the ARMv6 processor support.
 */
#include <linux/init.h>
#include <linux/linkage.h>
#include <asm/assembler.h>
#include <asm/asm-offsets.h>
#include <asm/hwcap.h>
#include <asm/pgtable-hwdef.h>
#include <asm/pgtable.h>
#include <mach/armadaxp.h>

#include "proc-macros.S"
#include "sheeva_pj4b-macros.S"

#define D_CACHE_LINE_SIZE	32

#define TTB_C		(1 << 0)
#define TTB_S		(1 << 1)
#define TTB_IMP		(1 << 2)
#define TTB_RGN_NC	(0 << 3)
#define TTB_RGN_WBWA	(1 << 3)
#define TTB_RGN_WT	(2 << 3)
#define TTB_RGN_WB	(3 << 3)

#ifdef CONFIG_AURORA_L2_PT_WALK
#define TTB_FLAGS_OUTER	TTB_RGN_WB
#else
#define TTB_FLAGS_OUTER	0
#endif

#ifndef CONFIG_SMP
#define TTB_FLAGS	TTB_FLAGS_OUTER
#define PMD_FLAGS	PMD_SECT_WB
#else
#define TTB_FLAGS	TTB_FLAGS_OUTER|TTB_S
#define PMD_FLAGS	PMD_SECT_WBWA|PMD_SECT_S
#endif

ENTRY(cpu_sheeva_pj4b_v6_proc_init)
	mov	pc, lr

ENTRY(cpu_sheeva_pj4b_v6_proc_fin)
#ifdef CONFIG_CACHE_AURORA_L2
	mcr	p15, 0, r0, c7, c10, 4		@ Data Synchronization Barrier
	ldr	r0, =0xffff			@ L2C clean all 16 ways
	ldr	r1, =AXP_L2_CLEAN_WAY_REG
	str	r0, [r1]
	mrc	p15, 0, r0, c0, c0, 5		@ Read CPU core number
	and	r0, r0, #0xF
	mov	r1, #0x1
	lsl	r0, r1, r0
1:	ldr	r1, =AXP_L2_MNTNC_STAT_REG	@ Read maintanence status to check done per CPU
	ldr	r1, [r1]
	tst	r0, r1
	bne	1b
	mcr	p15, 0, r0, c7, c10, 4		@ Data Synchronization Barrier
#endif
	mrc	p15, 0, r0, c1, c0, 0		@ ctrl register
	bic	r0, r0, #0x1000			@ ...i............
	bic	r0, r0, #0x0006			@ .............ca.
	mcr	p15, 0, r0, c1, c0, 0		@ disable caches
	ldmfd	sp!, {pc}

/*
 *	cpu_sheeva_pj4b_v6_reset(loc)
 *
 *	Perform a soft reset of the system.  Put the CPU into the
 *	same state as it would be if it had been reset, and branch
 *	to what would be the reset vector.
 *
 *	- loc   - location to jump to for soft reset
 */
	.align	5
ENTRY(cpu_sheeva_pj4b_v6_reset)
	mov	pc, r0
/*
 *	cpu_sheeva_pj4b_v6_do_idle()
 *
 *	Idle the processor (eg, wait for interrupt).
 *
 *	IRQs are already disabled.
 */
ENTRY(cpu_sheeva_pj4b_v6_do_idle)
	mov	r1, #0
	mcr	p15, 0, r1, c7, c10, 4		@ DWB - WFI may enter a low-power mode
#ifndef CONFIG_SHEEVA_ERRATA_ARM_CPU_BTS61
	mcr	p15, 0, r1, c7, c0, 4		@ wait for interrupt
#endif
#ifdef CONFIG_SHEEVA_ERRATA_ARM_CPU_4742
	mcr	p15, 0, r0, c7, c10, 4		@barrier
#endif
	mov	pc, lr
ENTRY(cpu_sheeva_pj4b_v6_dcache_clean_area)
#ifndef TLB_CAN_READ_FROM_L1_CACHE
#if !defined(CONFIG_HAVE_GENERIC_DMA_COHERENT) || defined(CONFIG_SHEEVA_ERRATA_ARM_CPU_4611)
	mrs     r2, cpsr
        orr     r3, r2, #PSR_F_BIT | PSR_I_BIT
        msr     cpsr_c, r3                      @ Disable interrupts
	mcr     p15, 0, r0, c7, c10, 4          @ Data Synchronization Barrier
#endif
1:	mcr	p15, 0, r0, c7, c10, 1		@ clean D entry
#ifndef CONFIG_AURORA_L2_PT_WALK
	mcr     p15, 1, r0, c7, c11, 1		@ clean L2C D entry
#endif
	mcr     p15, 0, r0, c7, c10, 4          @ Data Synchronization Barrier
	add	r0, r0, #D_CACHE_LINE_SIZE
	subs	r1, r1, #D_CACHE_LINE_SIZE
	bhi	1b
#if !defined(CONFIG_HAVE_GENERIC_DMA_COHERENT) || defined(CONFIG_SHEEVA_ERRATA_ARM_CPU_4611)
        msr     cpsr_c, r2                      @ Restore interrupts
	mcr	p15, 0, r0, c7, c10, 4		@ Data Synchronization Barrier
#endif
#endif
	mov	pc, lr
/*
 *	cpu_arm926_switch_mm(pgd_phys, tsk)
 *
 *	Set the translation table base pointer to be pgd_phys
 *
 *	- pgd_phys - physical address of new TTB
 *
 *	It is assumed that:
 *	- we are not using split page tables
 */
ENTRY(cpu_sheeva_pj4b_v6_switch_mm)
#ifdef CONFIG_MMU
	mov	r2, #0
	ldr	r1, [r1, #MM_CONTEXT_ID]	@ get mm->context.id
	ALT_SMP(orr	r0, r0, #TTB_FLAGS_SMP)
	ALT_UP(orr	r0, r0, #TTB_FLAGS_UP)
	mcr	p15, 0, r2, c7, c5, 6		@ flush BTAC/BTB
	mcr	p15, 0, r2, c7, c10, 4		@ drain write buffer
	mcr	p15, 0, r0, c2, c0, 0		@ set TTB 0
	mcr	p15, 0, r0, c7, c10, 4		@ Data Synchronization Barrier
	mcr	p15, 0, r1, c13, c0, 1		@ set context ID
#endif
	mov	pc, lr
/*
 *	cpu_sheeva_pj4b_v6_set_pte_ext(ptep, pte, ext)
 *
 *	Set a level 2 translation table entry.
 *
 *	- ptep  - pointer to level 2 translation table entry
 *		  (hardware version is stored at -1024 bytes)
 *	- pte   - PTE value to store
 *	- ext	- value for extended PTE bits
 */
	armv6_mt_table cpu_v6
ENTRY(cpu_sheeva_pj4b_v6_set_pte_ext)
#ifdef CONFIG_MMU
	armv6_set_pte_ext cpu_v6
#endif
	mov	pc, lr
	.type	cpu_sheeva_pj4b_v6_name, #object
cpu_sheeva_pj4b_v6_name:
	.asciz	"Marvell PJ4Bv6 processor"
	.size	cpu_sheeva_pj4b_v6_name, . - cpu_sheeva_pj4b_v6_name
	.type	cpu_pj4_name, #object
cpu_pj4_name:
	.asciz	"Marvell PJ4 processor"
	.size	cpu_pj4_name, . - cpu_pj4_name
	.align
	__INIT

/*
 *	__pj4bv6_setup
 *
 *	Initialise TLB, Caches, and MMU state ready to switch the MMU
 *	on.  Return in r0 the new CP15 C1 control register setting.
 *
 *	We automatically detect if we have a Harvard cache, and use the
 *	Harvard cache control instructions insead of the unified cache
 *	control instructions.
 *
 *	This should be able to cover all ARMv6 cores.
 *
 *	It is assumed that:
 *	- cache type register is implemented
 */
__pj4bv6_setup:
	sheeva_pj4b_config

#if defined(CONFIG_SMP) || defined (CONFIG_AURORA_IO_CACHE_COHERENCY)
	ALT_SMP(mrc	p15, 0, r0, c1, c0, 1)	@ Enable SMP/nAMP mode
	ALT_UP(nop)
	orr	r0, r0, #0x20
	ALT_SMP(mcr	p15, 0, r0, c1, c0, 1)
	mrc 	p15, 1, r0, c15, c2, 0
	orr	r0, r0, #0x2			@ SMP enable 
	mcr 	p15, 1, r0, c15, c2, 0
	ALT_UP(nop)
#endif
#ifdef CONFIG_CPU_SHEEVA_PJ4B_PMC_ACCESS_IN_USERMODE
	@ Enable performance counters user access
	mrc     p15, 0, r0, c9, c14, 0
	orr     r0, r0, #0x1
	mcr     p15, 0, r0, c9, c14, 0
#endif /* CONFIG_CPU_SHEEVA_PJ4B_PMC_ACCESS_IN_USERMODE */
	mov	r0, #0
	mcr	p15, 0, r0, c7, c10, 4		@ Data Synchronization Barrier
	mcr	p15, 0, r0, c7, c14, 0		@ clean+invalidate D cache
	mcr	p15, 0, r0, c7, c5, 0		@ invalidate I cache
	mcr	p15, 0, r0, c7, c15, 0		@ clean+invalidate cache
	mcr	p15, 0, r0, c7, c10, 4		@ drain write buffer
#ifdef CONFIG_MMU
	mcr	p15, 0, r0, c8, c7, 0		@ invalidate I + D TLBs
	mcr	p15, 0, r0, c2, c0, 2		@ TTB control register
	ALT_SMP(orr	r4, r4, #TTB_FLAGS_SMP)
	ALT_UP(orr	r4, r4, #TTB_FLAGS_UP)
	ALT_SMP(orr	r8, r8, #TTB_FLAGS_SMP)
	ALT_UP(orr	r8, r8, #TTB_FLAGS_UP)
	mcr	p15, 0, r8, c2, c0, 1		@ load TTB1
	mcr	p15, 0, r0, c7, c10, 4		@ Data Synchronization Barrier
#endif /* CONFIG_MMU */
	adr	r5, v6_crval
	ldmia	r5, {r5, r6}
#ifdef CONFIG_CPU_ENDIAN_BE8
	orr	r6, r6, #1 << 25		@ big-endian page tables
#endif
	mrc	p15, 0, r0, c1, c0, 0		@ read control register
	bic	r0, r0, r5			@ clear bits them
	orr	r0, r0, r6			@ set them
	mov	pc, lr				@ return to head.S:__ret

	/*
	 *         V X F   I D LR
	 * .... ...E PUI. .T.T 4RVI ZFRS BLDP WCAM
	 * rrrr rrrx xxx0 0101 xxxx xxxx x111 xxxx < forced
	 *         0 110       0011 1.00 .111 1101 < we want
	 */
	.type	v6_crval, #object
v6_crval:
	crval	clear=0x01e0fb7f, mmuset=0x00c0387d, ucset=0x00c0187c

	__INITDATA
	.type	v6_processor_functions, #object
ENTRY(v6_processor_functions)
	.word	v6_early_abort
	.word	v6_pabort
	.word	cpu_sheeva_pj4b_v6_proc_init
	.word	cpu_sheeva_pj4b_v6_proc_fin
	.word	cpu_sheeva_pj4b_v6_reset
	.word	cpu_sheeva_pj4b_v6_do_idle
	.word	cpu_sheeva_pj4b_v6_dcache_clean_area
	.word	cpu_sheeva_pj4b_v6_switch_mm
	.word	cpu_sheeva_pj4b_v6_set_pte_ext
	.size	v6_processor_functions, . - v6_processor_functions
	.section ".rodata"
	.type	cpu_arch_name, #object
cpu_arch_name:
	.asciz	"armv6"
	.size	cpu_arch_name, . - cpu_arch_name
	.type	cpu_elf_name, #object
cpu_elf_name:
	.asciz	"v6"
	.size	cpu_elf_name, . - cpu_elf_name
	.align
	.section ".proc.info.init", #alloc, #execinstr
	/*
	 * Match any ARMv6 processor core.
	 */
	.type	__pj4bv6_proc_info, #object
__pj4bv6_proc_info:
	.long	0x000f0000
	.long	0x000f0000
	ALT_SMP(.long \
		PMD_TYPE_SECT | \
		PMD_SECT_AP_WRITE | \
		PMD_SECT_AP_READ | \
		PMD_FLAGS_SMP)

	ALT_UP(.long \
		PMD_TYPE_SECT | \
		PMD_SECT_AP_WRITE | \
		PMD_SECT_AP_READ | \
		PMD_FLAGS_UP)
	.long   PMD_TYPE_SECT | \
		PMD_SECT_XN | \
		PMD_SECT_AP_WRITE | \
		PMD_SECT_AP_READ
	b	__pj4bv6_setup
	.long	cpu_arch_name
	.long	cpu_elf_name
	.long	HWCAP_SWP|HWCAP_HALF|HWCAP_THUMB|HWCAP_FAST_MULT|HWCAP_EDSP|HWCAP_JAVA|HWCAP_TLS
	.long	cpu_pj4_name
	.long	v6_processor_functions
	.long	v6wbi_tlb_fns
	.long	v6_user_fns
	.long	v6_cache_fns
	.size	__pj4_v6_proc_info, . - __pj4_v6_proc_info
