#!/usr/bin/env kjscmd

/**
 * Test of QChildEvent handling. This example will not work at the moment
 * because support for these events is disabled. The problem occurs because we
 * reenter the interpreter if the object was created by js.
 */

var top = new QVBox();
var hbox = new QHBox(top, 'button_hbox');
var add = new QPushButton(hbox, 'add_button');
var del = new QPushButton(hbox, 'del_button');

add.text = 'Add';
del.text = 'Delete';

top.childInsertEvent = function(ev)
{
  println( 'Inserted!!!!!' );
}

top.childRemoveEvent = function(ev)
{
  println( 'Removed! ' + ev.className );
}

top.addSlot = function()
{
  l = new QLabel( this, 'demo_label' );
  l.text = 'Hello World';
  l.show();
}

top.delSlot = function()
{
  if ( top.childCount() > 2 ) {
    top.child( top.childCount()-1 ).deleteLater();
  }
}

top.connect( add, 'clicked()', top, 'addSlot' );
top.connect( del, 'clicked()', top, 'delSlot' );

top.show();
application.exec();
