# If you want to build an executable that uses static libraries,
# build your libraries in a separate root directory, and then run
# the rpmbuild using "--define 'ink_static_root /your/static/rootdir'"

# To avoid stripping the binaries, you can also:
#  "--define '__spec_install_post /usr/lib/rpm/brp-compress'"

Name:		inkscape
Summary:	A Vector Drawing Application
Version:	0.48.1
# Use release "0" so that distro-released versions will override ours.
Release:	0
License:	GPL
Group:		Applications/Graphics
Source:		%{name}-%{version}.tar.gz
URL:		http://inkscape.sourceforge.net/
Prefix:		%{_prefix}
Packager:	Automatic
Vendor:		The Inkscape Project
BuildRoot:	%{_tmppath}/%{name}-%{version}-root

# See debian/control for a full list of requirements.  Maybe someone using an
# rpm-based distribution would like to translate some or all of the Debian
# package names given in debian/control to rpm equivalent packages.
BuildRequires:  atk-devel
BuildRequires:  desktop-file-utils
BuildRequires:  freetype-devel
BuildRequires:  gc-devel >= 6.4
BuildRequires:  gettext
BuildRequires:  gtkmm24-devel
BuildRequires:  libart_lgpl-devel >= 2.3.10
BuildRequires:  libgnomeprintui22-devel >= 2.2.0
BuildRequires:  gnome-vfs2-devel
BuildRequires:  libpng-devel
BuildRequires:  libsigc++20-devel
BuildRequires:  libxml2-devel >= 2.4.24
BuildRequires:  libxslt-devel
BuildRequires:  pango-devel
BuildRequires:  perl-XML-Parser
BuildRequires:  pkgconfig
BuildRequires:  python-devel
Requires(post):   desktop-file-utils
Requires(postun): desktop-file-utils

Provides:       perl(SpSVG)
Provides:       perl(SVG)

%description
Inkscape is an SVG-based generic vector-drawing program for Linux/Unix/Windows/Mac.

%prep
%setup

%build
### Needed for snapshot releases.
MYCFLAGS="$RPM_OPT_FLAGS"

# Deal with static builds
if [ ! -z "%{?ink_static_root}" ]; then
	PATH=/extra/static/bin:$PATH
	if [ -z "$PKG_CONFIG_PATH" ]; then
		PKG_CONFIG_PATH=/usr/local/lib/pkgconfig:/usr/lib/pkgconfig
	fi
	PKG_CONFIG_PATH=%{ink_static_root}/lib/pkgconfig:$PKG_CONFIG_PATH
	CPPFLAGS="-I%{ink_static_root}/include $CPPFLAGS"
	LDFLAGS="-L%{ink_static_root}/lib $LDFLAGS"

	export PATH PKG_CONFIG_PATH CPPFLAGS LDFLAGS
fi

if [ ! -x configure ]; then
  CFLAGS="$MYCFLAGS" ./autogen.sh $MYARCH_FLAGS --prefix=%{_prefix} --localstatedir=%{_localstatedir} --sysconfdir=%{_sysconfdir}
else
  %configure 
fi
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%makeinstall

%clean
rm -rf %{buildroot}

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README doc/keys.html
%{_bindir}/inkscape
%{_bindir}/inkview
%{_datadir}/applications/inkscape.desktop
%{_datadir}/locale/*/LC_MESSAGES/inkscape.mo
%{_datadir}/pixmaps/*
%{_datadir}/inkscape/*
%{_mandir}/*/man1/*
%{_mandir}/man1/*

%changelog
* Wed Nov 30 2005 Daniil Ivanov <daniil.ivanov@gmail.com>
- Added BuildRequires and Provides

* Thu Jul  7 2005 Kees Cook <kees@outflux.net>
- Adjusted for plugin relocation

* Wed Nov 24 2004 Kees Cook <kees@outflux.net>
- Added SMP flags so I can build faster
- Added static build capability

* Sat Jul 17 2004 Bryce W. Harrington <bryce@bryceharrington.com>
- Removing _libdir and TODO, updating description

* Thu May 01 2003 Christian Schaller <uraeus@gnome.org>
- Fix up the spec file for current release

* Mon Sep 23 2002 Dag Wieers <dag@wieers.com>
- Update to 0.2.6

* Thu Sep 12 2002 Dag Wieers <dag@wieers.com>
- Update to 0.2.5
- Changed SPEC to benefit from macros
