/** @file
 * @brief Macro for icon names used in Inkscape
 *
 * This file exists for several reasons: firstly, it contains all the icon names
 * in Inkscape, so it can serve as a reference to themers. Secondly, using
 * macros instead of strings avoids typos. Thirdly, we can change names
 * to conform to external icon sets / specifications without changing any code.
 */
/* Authors:
 *   Krzysztof Kosiński <tweenk.pl@gmail.com>
 *
 * Copyright (C) 2009 Authors
 * Released under GNU GPL, read the file 'COPYING' for more information
 */

#ifndef SEEN_INKSCAPE_ICON_NAMES_H
#define SEEN_INKSCAPE_ICON_NAMES_H

#define INKSCAPE_ICON_ALIGN_HORIZONTAL_BASELINE \
    "align-horizontal-baseline"
#define INKSCAPE_ICON_ALIGN_HORIZONTAL_CENTER \
    "align-horizontal-center"
#define INKSCAPE_ICON_ALIGN_HORIZONTAL_LEFT \
    "align-horizontal-left"
#define INKSCAPE_ICON_ALIGN_HORIZONTAL_LEFT_TO_ANCHOR \
    "align-horizontal-left-to-anchor"
#define INKSCAPE_ICON_ALIGN_HORIZONTAL_NODES \
    "align-horizontal-node"
#define INKSCAPE_ICON_ALIGN_HORIZONTAL_RIGHT \
    "align-horizontal-right"
#define INKSCAPE_ICON_ALIGN_HORIZONTAL_RIGHT_TO_ANCHOR \
    "align-horizontal-right-to-anchor"
#define INKSCAPE_ICON_ALIGN_VERTICAL_BASELINE \
    "align-vertical-baseline"
#define INKSCAPE_ICON_ALIGN_VERTICAL_BOTTOM \
    "align-vertical-bottom"
#define INKSCAPE_ICON_ALIGN_VERTICAL_BOTTOM_TO_ANCHOR \
    "align-vertical-bottom-to-anchor"
#define INKSCAPE_ICON_ALIGN_VERTICAL_CENTER \
    "align-vertical-center"
#define INKSCAPE_ICON_ALIGN_VERTICAL_NODES \
    "align-vertical-node"
#define INKSCAPE_ICON_ALIGN_VERTICAL_TOP \
    "align-vertical-top"
#define INKSCAPE_ICON_ALIGN_VERTICAL_TOP_TO_ANCHOR \
    "align-vertical-top-to-anchor"
#define INKSCAPE_ICON_BITMAP_TRACE \
    "bitmap-trace"
#define INKSCAPE_ICON_COLOR_FILL \
    "color-fill"
#define INKSCAPE_ICON_COLOR_GRADIENT \
    "color-gradient"
#define INKSCAPE_ICON_COLOR_MANAGEMENT \
    "color-management"
#define INKSCAPE_ICON_COLOR_PICKER \
    "color-picker"
#define INKSCAPE_ICON_COLOR_REMOVE \
    "color-remove"
#define INKSCAPE_ICON_CONNECTOR_AVOID \
    "connector-avoid"
#define INKSCAPE_ICON_CONNECTOR_IGNORE \
    "connector-ignore"
#define INKSCAPE_ICON_DIALOG_ALIGN_AND_DISTRIBUTE \
    "dialog-align-and-distribute"
#define INKSCAPE_ICON_DIALOG_FILL_AND_STROKE \
    "dialog-fill-and-stroke"
#define INKSCAPE_ICON_DIALOG_ICON_PREVIEW \
    "dialog-icon-preview"
#define INKSCAPE_ICON_DIALOG_INPUT_DEVICES \
    "dialog-input-devices"
#define INKSCAPE_ICON_DIALOG_LAYERS \
    "dialog-layers"
#define INKSCAPE_ICON_DIALOG_MEMORY \
    "dialog-memory"
#define INKSCAPE_ICON_DIALOG_MESSAGES \
    "dialog-messages"
#define INKSCAPE_ICON_DIALOG_OBJECT_PROPERTIES \
    "dialog-object-properties"
#define INKSCAPE_ICON_DIALOG_ROWS_AND_COLUMNS \
    "dialog-rows-and-columns"
#define INKSCAPE_ICON_DIALOG_SCRIPTS \
    "dialog-scripts"
#define INKSCAPE_ICON_DIALOG_TEXT_AND_FONT \
    "dialog-text-and-font"
#define INKSCAPE_ICON_DIALOG_TILE_CLONES \
    "dialog-tile-clones"
#define INKSCAPE_ICON_DIALOG_TRANSFORM \
    "dialog-transform"
#define INKSCAPE_ICON_DIALOG_XML_EDITOR \
    "dialog-xml-editor"
#define INKSCAPE_ICON_DISTRIBUTE_GRAPH \
    "distribute-graph"
#define INKSCAPE_ICON_DISTRIBUTE_GRAPH_DIRECTED \
    "distribute-graph-directed"
#define INKSCAPE_ICON_DISTRIBUTE_HORIZONTAL_BASELINE \
    "distribute-horizontal-baseline"
#define INKSCAPE_ICON_DISTRIBUTE_HORIZONTAL_CENTER \
    "distribute-horizontal-center"
#define INKSCAPE_ICON_DISTRIBUTE_HORIZONTAL_GAPS \
    "distribute-horizontal-gaps"
#define INKSCAPE_ICON_DISTRIBUTE_HORIZONTAL_LEFT \
    "distribute-horizontal-left"
#define INKSCAPE_ICON_DISTRIBUTE_HORIZONTAL_NODE \
    "distribute-horizontal-node"
#define INKSCAPE_ICON_DISTRIBUTE_HORIZONTAL_RIGHT \
    "distribute-horizontal-right"
#define INKSCAPE_ICON_DISTRIBUTE_RANDOMIZE \
    "distribute-randomize"
#define INKSCAPE_ICON_DISTRIBUTE_REMOVE_OVERLAPS \
    "distribute-remove-overlaps"
#define INKSCAPE_ICON_DISTRIBUTE_UNCLUMP \
    "distribute-unclump"
#define INKSCAPE_ICON_DISTRIBUTE_VERTICAL_BASELINE \
    "distribute-vertical-baseline"
#define INKSCAPE_ICON_DISTRIBUTE_VERTICAL_BOTTOM \
    "distribute-vertical-bottom"
#define INKSCAPE_ICON_DISTRIBUTE_VERTICAL_CENTER \
    "distribute-vertical-center"
#define INKSCAPE_ICON_DISTRIBUTE_VERTICAL_GAPS \
    "distribute-vertical-gaps"
#define INKSCAPE_ICON_DISTRIBUTE_VERTICAL_NODE \
    "distribute-vertical-node"
#define INKSCAPE_ICON_DISTRIBUTE_VERTICAL_TOP \
    "distribute-vertical-top"
#define INKSCAPE_ICON_DOCUMENT_CLEANUP \
    "document-cleanup"
#define INKSCAPE_ICON_DOCUMENT_EXPORT \
    "document-export"
#define INKSCAPE_ICON_DOCUMENT_EXPORT_OCAL \
    "document-export-ocal"
#define INKSCAPE_ICON_DOCUMENT_IMPORT \
    "document-import"
#define INKSCAPE_ICON_DOCUMENT_IMPORT_OCAL \
    "document-import-ocal"
#define INKSCAPE_ICON_DOCUMENT_METADATA \
    "document-metadata"
#define INKSCAPE_ICON_DOCUMENT_OPEN_RECENT \
    "document-open-recent"
#define INKSCAPE_ICON_DRAW_CALLIGRAPHIC \
    "draw-calligraphic"
#define INKSCAPE_ICON_DRAW_CONNECTOR \
    "draw-connector"
#define INKSCAPE_ICON_DRAW_CUBOID \
    "draw-cuboid"
#define INKSCAPE_ICON_DRAW_ELLIPSE \
    "draw-ellipse"
#define INKSCAPE_ICON_DRAW_ELLIPSE_ARC \
    "draw-ellipse-arc"
#define INKSCAPE_ICON_DRAW_ELLIPSE_SEGMENT \
    "draw-ellipse-segment"
#define INKSCAPE_ICON_DRAW_ELLIPSE_WHOLE \
    "draw-ellipse-whole"
#define INKSCAPE_ICON_DRAW_ERASER \
    "draw-eraser"
#define INKSCAPE_ICON_DRAW_ERASER_DELETE_OBJECTS \
    "draw-eraser-delete-objects"
#define INKSCAPE_ICON_DRAW_FREEHAND \
    "draw-freehand"
#define INKSCAPE_ICON_DRAW_PATH \
    "draw-path"
#define INKSCAPE_ICON_DRAW_POLYGON \
    "draw-polygon"
#define INKSCAPE_ICON_DRAW_POLYGON_STAR \
    "draw-polygon-star"
#define INKSCAPE_ICON_DRAW_RECTANGLE \
    "draw-rectangle"
#define INKSCAPE_ICON_DRAW_SPIRAL \
    "draw-spiral"
#define INKSCAPE_ICON_DRAW_STAR \
    "draw-star"
#define INKSCAPE_ICON_DRAW_TEXT \
    "draw-text"
#define INKSCAPE_ICON_DRAW_TRACE_BACKGROUND \
    "draw-trace-background"
#define INKSCAPE_ICON_DRAW_USE_PRESSURE \
    "draw-use-pressure"
#define INKSCAPE_ICON_DRAW_USE_TILT \
    "draw-use-tilt"
#define INKSCAPE_ICON_EDIT_CLONE \
    "edit-clone"
#define INKSCAPE_ICON_EDIT_CLONE_UNLINK \
    "edit-clone-unlink"
#define INKSCAPE_ICON_EDIT_DUPLICATE \
    "edit-duplicate"
#define INKSCAPE_ICON_EDIT_PASTE_IN_PLACE \
    "edit-paste-in-place"
#define INKSCAPE_ICON_EDIT_PASTE_STYLE \
    "edit-paste-style"
#define INKSCAPE_ICON_EDIT_SELECT_ALL \
    "edit-select-all"
#define INKSCAPE_ICON_EDIT_SELECT_ALL_LAYERS \
    "edit-select-all-layers"
#define INKSCAPE_ICON_EDIT_SELECT_INVERT \
    "edit-select-invert"
#define INKSCAPE_ICON_EDIT_SELECT_NONE \
    "edit-select-none"
#define INKSCAPE_ICON_EDIT_SELECT_ORIGINAL \
    "edit-select-original"
#define INKSCAPE_ICON_EDIT_UNDO_HISTORY \
    "edit-undo-history"
#define INKSCAPE_ICON_FILL_RULE_EVEN_ODD \
    "fill-rule-even-odd"
#define INKSCAPE_ICON_FILL_RULE_NONZERO \
    "fill-rule-nonzero"
#define INKSCAPE_ICON_FORMAT_TEXT_DIRECTION_HORIZONTAL \
    "format-text-direction-horizontal"
#define INKSCAPE_ICON_FORMAT_TEXT_DIRECTION_VERTICAL \
    "format-text-direction-vertical"
#define INKSCAPE_ICON_GRID_AXONOMETRIC \
    "grid-axonometric"
#define INKSCAPE_ICON_GRID_RECTANGULAR \
    "grid-rectangular"
#define INKSCAPE_ICON_GUIDES \
    "guides"
#define INKSCAPE_ICON_HELP_CONTENTS \
    "help-contents"
#define INKSCAPE_ICON_HELP_KEYBOARD_SHORTCUTS \
    "help-keyboard-shortcuts"
#define INKSCAPE_ICON_IMAGE_FILTER_BLEND \
    "image-filter-blend"
#define INKSCAPE_ICON_IMAGE_FILTER_COLOR_MATRIX \
    "image-filter-color-matrix"
#define INKSCAPE_ICON_IMAGE_FILTER_DIFFUSE_LIGHTING \
    "image-filter-diffuse-lighting"
#define INKSCAPE_ICON_IMAGE_FILTER_DISPLACEMENT_MAP \
    "image-filter-displacement-map"
#define INKSCAPE_ICON_IMAGE_FILTER_FLOOD \
    "image-filter-flood"
#define INKSCAPE_ICON_IMAGE_FILTER_GAUSSIAN_BLUR \
    "image-filter-gaussian-blur"
#define INKSCAPE_ICON_IMAGE_FILTER_MORPHOLOGY \
    "image-filter-morphology"
#define INKSCAPE_ICON_IMAGE_FILTER_OFFSET \
    "image-filter-offset"
#define INKSCAPE_ICON_IMAGE_FILTER_TURBULENCE \
    "image-filter-turbulence"
#define INKSCAPE_ICON_INKSCAPE \
    "inkscape-logo"
#define INKSCAPE_ICON_LAYER_BOTTOM \
    "layer-bottom"
#define INKSCAPE_ICON_LAYER_DELETE \
    "layer-delete"
#define INKSCAPE_ICON_LAYER_LOWER \
    "layer-lower"
#define INKSCAPE_ICON_LAYER_NEW \
    "layer-new"
#define INKSCAPE_ICON_LAYER_NEXT \
    "layer-next"
#define INKSCAPE_ICON_LAYER_PREVIOUS \
    "layer-previous"
#define INKSCAPE_ICON_LAYER_RAISE \
    "layer-raise"
#define INKSCAPE_ICON_LAYER_RENAME \
    "layer-rename"
#define INKSCAPE_ICON_LAYER_TOP \
    "layer-top"
#define INKSCAPE_ICON_NODE_ADD \
    "node-add"
#define INKSCAPE_ICON_NODE_BREAK \
    "node-break"
#define INKSCAPE_ICON_NODE_DELETE \
    "node-delete"
#define INKSCAPE_ICON_NODE_DELETE_SEGMENT \
    "node-delete-segment"
#define INKSCAPE_ICON_NODE_DISTRIBUTE_HORIZONTAL \
    "distribute-horizontal-node"
#define INKSCAPE_ICON_NODE_DISTRIBUTE_VERTICAL \
    "distribute-vertical-node"
#define INKSCAPE_ICON_NODE_JOIN \
    "node-join"
#define INKSCAPE_ICON_NODE_JOIN_SEGMENT \
    "node-join-segment"
#define INKSCAPE_ICON_NODE_SEGMENT_CURVE \
    "node-segment-curve"
#define INKSCAPE_ICON_NODE_SEGMENT_LINE \
    "node-segment-line"
#define INKSCAPE_ICON_NODE_TYPE_AUTO_SMOOTH \
    "node-type-auto-smooth"
#define INKSCAPE_ICON_NODE_TYPE_CUSP \
    "node-type-cusp"
#define INKSCAPE_ICON_NODE_TYPE_SMOOTH \
    "node-type-smooth"
#define INKSCAPE_ICON_NODE_TYPE_SYMMETRIC \
    "node-type-symmetric"
#define INKSCAPE_ICON_OBJECT_COLUMNS \
    "object-columns"
#define INKSCAPE_ICON_OBJECT_FILL \
    "object-fill"
#define INKSCAPE_ICON_OBJECT_FLIP_HORIZONTAL \
    "object-flip-horizontal"
#define INKSCAPE_ICON_OBJECT_FLIP_VERTICAL \
    "object-flip-vertical"
#define INKSCAPE_ICON_OBJECT_GROUP \
    "object-group"
#define INKSCAPE_ICON_OBJECT_HIDDEN \
    "object-hidden"
#define INKSCAPE_ICON_OBJECT_LOCKED \
    "object-locked"
#define INKSCAPE_ICON_OBJECT_ROTATE_LEFT \
    "object-rotate-left"
#define INKSCAPE_ICON_OBJECT_ROTATE_RIGHT \
    "object-rotate-right"
#define INKSCAPE_ICON_OBJECT_ROWS \
    "object-rows"
#define INKSCAPE_ICON_OBJECT_STROKE \
    "object-stroke"
#define INKSCAPE_ICON_OBJECT_STROKE_STYLE \
    "object-stroke-style"
#define INKSCAPE_ICON_OBJECT_TO_PATH \
    "object-to-path"
#define INKSCAPE_ICON_OBJECT_TWEAK_ATTRACT \
    "object-tweak-attract"
#define INKSCAPE_ICON_OBJECT_TWEAK_BLUR \
    "object-tweak-blur"
#define INKSCAPE_ICON_OBJECT_TWEAK_DUPLICATE \
    "object-tweak-duplicate"
#define INKSCAPE_ICON_OBJECT_TWEAK_JITTER_COLOR \
    "object-tweak-jitter-color"
#define INKSCAPE_ICON_OBJECT_TWEAK_PAINT \
    "object-tweak-paint"
#define INKSCAPE_ICON_OBJECT_TWEAK_PUSH \
    "object-tweak-push"
#define INKSCAPE_ICON_OBJECT_TWEAK_RANDOMIZE \
    "object-tweak-randomize"
#define INKSCAPE_ICON_OBJECT_TWEAK_ROTATE \
    "object-tweak-rotate"
#define INKSCAPE_ICON_OBJECT_TWEAK_SHRINK \
    "object-tweak-shrink"
#define INKSCAPE_ICON_OBJECT_UNGROUP \
    "object-ungroup"
#define INKSCAPE_ICON_OBJECT_UNLOCKED \
    "object-unlocked"
#define INKSCAPE_ICON_OBJECT_VISIBLE \
    "object-visible"
#define INKSCAPE_ICON_PAINT_GRADIENT_LINEAR \
    "paint-gradient-linear"
#define INKSCAPE_ICON_PAINT_GRADIENT_RADIAL \
    "paint-gradient-radial"
#define INKSCAPE_ICON_PAINT_NONE \
    "paint-none"
#define INKSCAPE_ICON_PAINT_PATTERN \
    "paint-pattern"
#define INKSCAPE_ICON_PAINT_SOLID \
    "paint-solid"
#define INKSCAPE_ICON_PAINT_UNKNOWN \
    "paint-unknown"
#define INKSCAPE_ICON_PATH_BREAK_APART \
    "path-break-apart"
#define INKSCAPE_ICON_PATH_CLIP_EDIT \
    "path-clip-edit"
#define INKSCAPE_ICON_PATH_COMBINE \
    "path-combine"
#define INKSCAPE_ICON_PATH_CUT \
    "path-cut"
#define INKSCAPE_ICON_PATH_DIFFERENCE \
    "path-difference"
#define INKSCAPE_ICON_PATH_DIVISION \
    "path-division"
#define INKSCAPE_ICON_PATH_EFFECT_PARAMETER_NEXT \
    "path-effect-parameter-next"
#define INKSCAPE_ICON_PATH_EXCLUSION \
    "path-exclusion"
#define INKSCAPE_ICON_PATH_INSET \
    "path-inset"
#define INKSCAPE_ICON_PATH_INTERSECTION \
    "path-intersection"
#define INKSCAPE_ICON_PATH_MASK_EDIT \
    "path-mask-edit"
#define INKSCAPE_ICON_PATH_MODE_BEZIER \
    "path-mode-bezier"
#define INKSCAPE_ICON_PATH_MODE_POLYLINE \
    "path-mode-polyline"
#define INKSCAPE_ICON_PATH_MODE_POLYLINE_PARAXIAL \
    "path-mode-polyline-paraxial"
#define INKSCAPE_ICON_PATH_MODE_SPIRO \
    "path-mode-spiro"
#define INKSCAPE_ICON_PATH_OFFSET_DYNAMIC \
    "path-offset-dynamic"
#define INKSCAPE_ICON_PATH_OFFSET_LINKED \
    "path-offset-linked"
#define INKSCAPE_ICON_PATH_OUTSET \
    "path-outset"
#define INKSCAPE_ICON_PATH_REVERSE \
    "path-reverse"
#define INKSCAPE_ICON_PATH_SIMPLIFY \
    "path-simplify"
#define INKSCAPE_ICON_PATH_TWEAK_ATTRACT \
    "path-tweak-attract"
#define INKSCAPE_ICON_PATH_TWEAK_GROW \
    "path-tweak-grow"
#define INKSCAPE_ICON_PATH_TWEAK_PUSH \
    "path-tweak-push"
#define INKSCAPE_ICON_PATH_TWEAK_ROUGHEN \
    "path-tweak-roughen"
#define INKSCAPE_ICON_PATH_TWEAK_SHRINK \
    "path-tweak-shrink"
#define INKSCAPE_ICON_PATH_UNION \
    "path-union"
#define INKSCAPE_ICON_PERSPECTIVE_PARALLEL \
    "perspective-parallel"
#define INKSCAPE_ICON_RECTANGLE_MAKE_CORNERS_SHARP \
    "rectangle-make-corners-sharp"
#define INKSCAPE_ICON_SELECTION_BOTTOM \
    "selection-bottom"
#define INKSCAPE_ICON_SELECTION_LOWER \
    "selection-lower"
#define INKSCAPE_ICON_SELECTION_MAKE_BITMAP_COPY \
    "selection-make-bitmap-copy"
#define INKSCAPE_ICON_SELECTION_MOVE_TO_LAYER_ABOVE \
    "selection-move-to-layer-above"
#define INKSCAPE_ICON_SELECTION_MOVE_TO_LAYER_BELOW \
    "selection-move-to-layer-below"
#define INKSCAPE_ICON_SELECTION_RAISE \
    "selection-raise"
#define INKSCAPE_ICON_SELECTION_TOP \
    "selection-top"
#define INKSCAPE_ICON_SHOW_DIALOGS \
    "show-dialogs"
#define INKSCAPE_ICON_SHOW_GRID \
    "show-grid"
#define INKSCAPE_ICON_SHOW_GUIDES \
    "show-guides"
#define INKSCAPE_ICON_SHOW_NODE_HANDLES \
    "show-node-handles"
#define INKSCAPE_ICON_SHOW_PATH_OUTLINE \
    "show-path-outline"
#define INKSCAPE_ICON_SNAP \
    "snap"
#define INKSCAPE_ICON_SNAP_BOUNDING_BOX \
    "snap-bounding-box"
#define INKSCAPE_ICON_SNAP_BOUNDING_BOX_CENTER \
    "snap-bounding-box-center"
#define INKSCAPE_ICON_SNAP_BOUNDING_BOX_CORNERS \
    "snap-bounding-box-corners"
#define INKSCAPE_ICON_SNAP_BOUNDING_BOX_EDGES \
    "snap-bounding-box-edges"
#define INKSCAPE_ICON_SNAP_BOUNDING_BOX_MIDPOINTS \
    "snap-bounding-box-midpoints"
#define INKSCAPE_ICON_SNAP_GRID_GUIDE_INTERSECTIONS \
    "snap-grid-guide-intersections"
#define INKSCAPE_ICON_SNAP_NODES \
    "snap-nodes"
#define INKSCAPE_ICON_SNAP_NODES_CENTER \
    "snap-nodes-center"
#define INKSCAPE_ICON_SNAP_NODES_CUSP \
    "snap-nodes-cusp"
#define INKSCAPE_ICON_SNAP_NODES_INTERSECTION \
    "snap-nodes-intersection"
#define INKSCAPE_ICON_SNAP_NODES_MIDPOINT \
    "snap-nodes-midpoint"
#define INKSCAPE_ICON_SNAP_NODES_PATH \
    "snap-nodes-path"
#define INKSCAPE_ICON_SNAP_NODES_ROTATION_CENTER \
    "snap-nodes-rotation-center"
#define INKSCAPE_ICON_SNAP_NODES_SMOOTH \
    "snap-nodes-smooth"
#define INKSCAPE_ICON_SNAP_PAGE \
    "snap-page"
#define INKSCAPE_ICON_STROKE_CAP_BUTT \
    "stroke-cap-butt"
#define INKSCAPE_ICON_STROKE_CAP_ROUND \
    "stroke-cap-round"
#define INKSCAPE_ICON_STROKE_CAP_SQUARE \
    "stroke-cap-square"
#define INKSCAPE_ICON_STROKE_JOIN_BEVEL \
    "stroke-join-bevel"
#define INKSCAPE_ICON_STROKE_JOIN_MITER \
    "stroke-join-miter"
#define INKSCAPE_ICON_STROKE_JOIN_ROUND \
    "stroke-join-round"
#define INKSCAPE_ICON_STROKE_TO_PATH \
    "stroke-to-path"
#define INKSCAPE_ICON_TEXT_CONVERT_TO_REGULAR \
    "text-convert-to-regular"
#define INKSCAPE_ICON_TEXT_FLOW_INTO_FRAME \
    "text-flow-into-frame"
#define INKSCAPE_ICON_TEXT_PUT_ON_PATH \
    "text-put-on-path"
#define INKSCAPE_ICON_TEXT_REMOVE_FROM_PATH \
    "text-remove-from-path"
#define INKSCAPE_ICON_TEXT_UNFLOW \
    "text-unflow"
#define INKSCAPE_ICON_TEXT_UNKERN \
    "text-unkern"
#define INKSCAPE_ICON_TOOL_NODE_EDITOR \
    "tool-node-editor"
#define INKSCAPE_ICON_TOOL_POINTER \
    "tool-pointer"
#define INKSCAPE_ICON_TOOL_TWEAK \
    "tool-tweak"
#define INKSCAPE_ICON_TRANSFORM_AFFECT_GRADIENT \
    "transform-affect-gradient"
#define INKSCAPE_ICON_TRANSFORM_AFFECT_PATTERN \
    "transform-affect-pattern"
#define INKSCAPE_ICON_TRANSFORM_AFFECT_ROUNDED_CORNERS \
    "transform-affect-rounded-corners"
#define INKSCAPE_ICON_TRANSFORM_AFFECT_STROKE \
    "transform-affect-stroke"
#define INKSCAPE_ICON_TRANSFORM_MOVE_HORIZONTAL \
    "transform-move-horizontal"
#define INKSCAPE_ICON_TRANSFORM_MOVE_VERTICAL \
    "transform-move-vertical"
#define INKSCAPE_ICON_TRANSFORM_ROTATE \
    "transform-rotate"
#define INKSCAPE_ICON_TRANSFORM_SCALE_HORIZONTAL \
    "transform-scale-horizontal"
#define INKSCAPE_ICON_TRANSFORM_SCALE_VERTICAL \
    "transform-scale-vertical"
#define INKSCAPE_ICON_TRANSFORM_SKEW_HORIZONTAL \
    "transform-skew-horizontal"
#define INKSCAPE_ICON_TRANSFORM_SKEW_VERTICAL \
    "transform-skew-vertical"
#define INKSCAPE_ICON_VIEW_FULLSCREEN \
    "view-fullscreen"
#define INKSCAPE_ICON_WINDOW_NEW \
    "window-new"
#define INKSCAPE_ICON_WINDOW_NEXT \
    "window-next"
#define INKSCAPE_ICON_WINDOW_PREVIOUS \
    "window-previous"
#define INKSCAPE_ICON_XML_ATTRIBUTE_DELETE \
    "xml-attribute-delete"
#define INKSCAPE_ICON_XML_ELEMENT_NEW \
    "xml-element-new"
#define INKSCAPE_ICON_XML_NODE_DELETE \
    "xml-node-delete"
#define INKSCAPE_ICON_XML_NODE_DUPLICATE \
    "xml-node-duplicate"
#define INKSCAPE_ICON_XML_TEXT_NEW \
    "xml-text-new"
#define INKSCAPE_ICON_ZOOM \
    "zoom"
#define INKSCAPE_ICON_ZOOM_DOUBLE_SIZE \
    "zoom-double-size"
#define INKSCAPE_ICON_ZOOM_FIT_DRAWING \
    "zoom-fit-drawing"
#define INKSCAPE_ICON_ZOOM_FIT_PAGE \
    "zoom-fit-page"
#define INKSCAPE_ICON_ZOOM_FIT_SELECTION \
    "zoom-fit-selection"
#define INKSCAPE_ICON_ZOOM_FIT_WIDTH \
    "zoom-fit-width"
#define INKSCAPE_ICON_ZOOM_HALF_SIZE \
    "zoom-half-size"
#define INKSCAPE_ICON_ZOOM_IN \
    "zoom-in"
#define INKSCAPE_ICON_ZOOM_NEXT \
    "zoom-next"
#define INKSCAPE_ICON_ZOOM_ORIGINAL \
    "zoom-original"
#define INKSCAPE_ICON_ZOOM_OUT \
    "zoom-out"
#define INKSCAPE_ICON_ZOOM_PREVIOUS \
    "zoom-previous"

#endif /* ifdef SEEN_INKSCAPE_ICON_NAMES_H */

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:encoding=utf-8:textwidth=99 :
