/*

Logic to send messages via gwibber

Copyright 2010 Canonical Ltd.

Authors:
    David Barth <david.barth@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __GWIBBER_SERVICE_H__
#define __GWIBBER_SERVICE_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define GWIBBER_SERVICE_TYPE            (gwibber_service_get_type ())
#define GWIBBER_SERVICE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_SERVICE_TYPE, GwibberService))
#define GWIBBER_SERVICE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_SERVICE_TYPE, GwibberServiceClass))
#define IS_GWIBBER_SERVICE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_SERVICE_TYPE))
#define IS_GWIBBER_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_SERVICE_TYPE))
#define GWIBBER_SERVICE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_SERVICE_TYPE, GwibberServiceClass))

typedef enum
{
	GWIBBER_SERVICE_STATUS_NOT_RUNNING,
	/* GWIBBER_SERVICE_STATUS_LOADING_STARTED,
	GWIBBER_SERVICE_STATUS_LOADING_COMPLETE, */
	GWIBBER_SERVICE_STATUS_RUNNING,
	GWIBBER_SERVICE_STATUS_LAST
}
GwibberServiceStatus;

#define GWIBBER_SERVICE_SIGNAL_STATUS_CHANGED     "status-changed"
#define GWIBBER_SERVICE_SIGNAL_STATUS_CHANGED_ID  (g_signal_lookup(GWIBBER_SERVICE_SIGNAL_STATUS_CHANGED, GWIBBER_SERVICE_TYPE))

typedef struct _GwibberServiceClass GwibberServiceClass;
struct _GwibberServiceClass {
	GObjectClass parent_class;

	/* Signals */
	void (*status_changed) (GwibberServiceStatus newstatus);
};

typedef struct _GwibberService      GwibberService;
struct _GwibberService {
	GObject parent;
};

GType gwibber_service_get_type (void) G_GNUC_CONST;
GwibberService * gwibber_service_new (void);
GwibberService * gwibber_service_get (void);
void gwibber_service_send (GwibberService *self, const gchar *msg);
gboolean gwibber_service_has_configured_accounts (GwibberService *self);

/* old API */
void gwibber_send (const gchar *msg);

G_END_DECLS

#endif /* __GWIBBER_SERVICE_H__ */

